<?php
function menuUserDetails($userId) {
    global $pdo;
    
    $table_name = PREFIX . 'users';
    $stmt = $pdo->prepare("SELECT u.*, g.group_name FROM $table_name u LEFT JOIN wp_groups g ON u.group_id = g.id WHERE u.ID = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_OBJ);

    if (!$user) {
        return "User not found.";
    }

    return [
        'email' => $user->user_email,
        'group' => $user->group_name, 
        'group_id' => $user->group_id,
        'is_admin' => $user->is_admin,
        'is_super' => ($user->user_type === 'super'),
        'is_owner' => ($user->user_type === 'admin'),
        'is_mod' => ($user->user_type === 'mod'),
        'first_name' => $user->first_name,
        'last_name' => $user->last_name
    ];
}
?>