<?php
function displayUserSettings($userId) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'users';
    
    $user = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM $table_name WHERE ID = %d",
        $userId
    ));

    if (!$user) {
        echo "User not found.";
        return;
    }

    $group_name = '';
    if ($user->user_group) {
        $group_table = $wpdb->prefix . 'groups';  // Assuming you have a groups table
        $group_name = $wpdb->get_var($wpdb->prepare(
            "SELECT group_name FROM $group_table WHERE group_id = %d",
            $user->user_group
        ));
    }

    ?>
    <div class="user-settings">
        <h2>User Settings</h2>
        <p><strong>Email:</strong> <?php echo esc_html($user->user_email); ?></p>
        <p><strong>Group:</strong> <?php echo esc_html($group_name); ?></p>
        <p><strong>Registered Date:</strong> <?php echo esc_html($user->user_registered); ?></p>
        <p><strong>User Type:</strong> <?php echo esc_html($user->user_type); ?></p>
        <p><strong>Name:</strong> <?php echo esc_html($user->first_name . ' ' . $user->last_name); ?></p>
        <?php if ($user->is_admin == 1): ?>
            <p><strong>Administrator of:</strong> <?php echo esc_html($group_name); ?></p>
        <?php endif; ?>

        <h3>Profile Picture</h3>
        <?php
        if ($user->profile_picture) {
            $picture_url = "/images/profiles/" . $user->unique_id . "/" . $user->profile_picture;
            echo '<img src="' . esc_url($picture_url) . '" alt="Profile Picture">';
        } else {
            echo '<p>No profile picture set.</p>';
        }
        ?>
        <button id="changeProfilePicture">Change Profile Picture</button>
    </div>

    <?php
    // Include the modal HTML here
    include('change_profile.php');
}

// Usage:
// displayUserSettings($current_user->ID);
?>