<?php
function logSessionFailure($reportData) {
    $timestamp = date('Y-m-d H:i:s');
    $userIP = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
    if (strpos($userIP, ',') !== false) {
        $userIP = trim(explode(',', $userIP)[0]);
    }
    
    $logsDir = ROOT_PATH . '/logs';
    $sessionFailuresDir = $logsDir . '/session_failures';
    
    if (!is_dir($logsDir)) {
        mkdir($logsDir, 0755, true);
    }
    if (!is_dir($sessionFailuresDir)) {
        mkdir($sessionFailuresDir, 0755, true);
    }
    
    $year = date('Y');
    $week = date('W');
    $logFileName = "session_failures_{$year}_W{$week}.txt";
    $logFilePath = $sessionFailuresDir . '/' . $logFileName;
    
    $logEntry = "\n" . str_repeat("=", 80) . "\n";
    $logEntry .= "TIMESTAMP: " . $timestamp . "\n";
    $logEntry .= "IP_ADDRESS: " . $userIP . "\n";
    $logEntry .= "USER_ACTIONS: " . ($reportData['actionsBeforeFailure'] ?? 'Not provided') . "\n";
    $logEntry .= "TIME_WORKING: " . ($reportData['timeWorking'] ?? 'Not provided') . "\n";
    $logEntry .= "OS_INFO: " . ($reportData['osInfo'] ?? 'Unknown') . "\n";
    $logEntry .= "BROWSER_INFO: " . ($reportData['browserInfo'] ?? 'Unknown') . "\n";
    $logEntry .= "ADDITIONAL_NOTES: " . ($reportData['additionalNotes'] ?? 'None') . "\n";
    $logEntry .= "USER_AGENT: " . ($reportData['userAgent'] ?? 'Unknown') . "\n";
    $logEntry .= "SCREEN_RESOLUTION: " . ($reportData['screenResolution'] ?? 'Unknown') . "\n";
    $logEntry .= "VIEWPORT_SIZE: " . ($reportData['viewportSize'] ?? 'Unknown') . "\n";
    $logEntry .= "CONNECTION_TYPE: " . ($reportData['connectionType'] ?? 'Unknown') . "\n";
    $logEntry .= "ONLINE_STATUS: " . ($reportData['onlineStatus'] ? 'Online' : 'Offline') . "\n";
    $logEntry .= "COOKIES_ENABLED: " . ($reportData['cookiesEnabled'] ? 'Yes' : 'No') . "\n";
    $logEntry .= "LOCAL_STORAGE: " . ($reportData['localStorageAvailable'] ? 'Available' : 'Not available') . "\n";
    $logEntry .= "SESSION_STORAGE: " . ($reportData['sessionStorageAvailable'] ? 'Available' : 'Not available') . "\n";
    $logEntry .= "PAGE_URL: " . ($reportData['pageUrl'] ?? 'Unknown') . "\n";
    $logEntry .= "REFERRER: " . ($reportData['referrer'] ?? 'None') . "\n";
    $logEntry .= str_repeat("=", 80) . "\n";
    
    error_log($logEntry, 3, $logFilePath);
}
?>