<?php
// Flash message display system
// Include this at the top of pages where users land after saving

function displayFlashMessage() {
    if (isset($_SESSION['flash_message'])) {
        $flash = $_SESSION['flash_message'];
        $type = $flash['type']; // 'success' or 'error'
        $message = htmlspecialchars($flash['message']);
        
        $bgColor = ($type === 'success') ? '#28a745' : '#dc3545';
        
        echo '<div id="flashMessage" style="
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            background: ' . $bgColor . ';
            color: white;
            padding: 15px 30px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.2);
            z-index: 9999;
            font-size: 16px;
            font-weight: 500;
            animation: slideDown 0.3s ease-out, fadeOut 0.5s ease-in 3.5s;
        ">
            ' . $message . '
        </div>
        
        <style>
            @keyframes slideDown {
                from { top: -100px; opacity: 0; }
                to { top: 20px; opacity: 1; }
            }
            @keyframes fadeOut {
                from { opacity: 1; }
                to { opacity: 0; }
            }
        </style>
        
        <script>
            setTimeout(function() {
                var flash = document.getElementById("flashMessage");
                if (flash) flash.remove();
            }, 4000);
        </script>';
        
        // Clear the flash message after displaying
        unset($_SESSION['flash_message']);
    }
}
?>
