<?php
// File: includes/remove_profile_picture.php
require_once 'include_all.inc.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_SESSION['front_user_id'];

    $stmt = $pdo->prepare("SELECT unique_id, profile_picture FROM " . PREFIX . "users WHERE ID = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_OBJ);

    if ($user && $user->profile_picture) {
        $file_path = $_SERVER['DOCUMENT_ROOT'] . "/images/profiles/" . $user->unique_id . "/" . $user->profile_picture;
        if (file_exists($file_path)) {
            unlink($file_path);
        }

        $stmt = $pdo->prepare("UPDATE " . PREFIX . "users SET profile_picture = NULL WHERE ID = ?");
        $stmt->execute([$userId]);

        echo json_encode(["success" => true, "message" => "Profile picture removed successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "No profile picture found"]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request"]);
}
?>