<?php

// Define the root path of your application
if (!defined('ROOT_PATH')) {
    define('ROOT_PATH', realpath(__DIR__ . '/..'));
}

// Function to log messages
if (!function_exists('logMessage2')) {
    function logMessage2($message2) {
        error_log(date('[Y-m-d H:i:s] ') . $message2 . "\n", 3, ROOT_PATH . '/debug_log.txt');
    }
}

logMessage2("Include_all.inc.php started");
logMessage2("ROOT_PATH: " . ROOT_PATH);

// Include configuration files
require_once ROOT_PATH . '/configs/general.config.php';
require_once ROOT_PATH . '/configs/mysql.config.php';

// Load session manager (now can use $pdo for license checks)
require_once __DIR__ . '/session_manager.php';

// Include various required files
require_once 'user_settings_functions.php';
require_once 'admin_functions.php';

if (!defined('TOP_ROW')) {
    define("TOP_ROW", "Hello world.");
}
if (!defined('BOTTOM_ROW')) {
    define("BOTTOM_ROW", "#F5F6CE");
}

// Include all class files
$arr_class_directory = array(
    ROOT_PATH . '/classes/',
    ROOT_PATH . '/classes/users/',
    ROOT_PATH . '/classes/utility/',
    ROOT_PATH . '/classes/group/',
);

foreach ($arr_class_directory as $value) {
    logMessage2("Scanning directory: " . $value);
    foreach (glob($value . "*class.php") as $filename) {
        logMessage2("Including file: " . $filename);
        include_once($filename);
    }
}

// Explicitly include the Users class file
$users_class_file = ROOT_PATH . '/classes/users/Users.class.php';
$groups_class_file = ROOT_PATH . '/classes/group/Group.class.php';

logMessage2("Attempting to include Users class file: " . $users_class_file);
if (file_exists($users_class_file)) {
    require_once $users_class_file;
    logMessage2("Users class file included");
} else {
    logMessage2("Users class file not found");
}

// Check if Users class exists after inclusions
if (class_exists('Users')) {
    logMessage2("Users class found after inclusions");
} else {
    logMessage2("Users class not found after inclusions");
}

$isLoggedIn = isset($_SESSION['front_user_id']);

// MySQL connection
global $pdo;
if (!isset($pdo)) {
    try {
        $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        logMessage2("Database connection successful");
    } catch (PDOException $e) {
        logMessage2("Database connection failed: " . $e->getMessage());
        die("Database connection failed: " . $e->getMessage());
    }
}

logMessage2("Include_all.inc.php completed");

require_once 'debug_mode.php';
require_once 'session_settings.php';
?>