<?php
function generateUniqueId($length = 16) {
    return bin2hex(random_bytes($length / 2));
}

function ensureUniqueId($pdo, $length = 16) {
    $table_name = PREFIX . 'users';
    
    do {
        $unique_id = generateUniqueId($length);
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM $table_name WHERE unique_id = ?");
        $stmt->execute([$unique_id]);
        $exists = $stmt->fetchColumn();
    } while ($exists > 0);

    return $unique_id;
}
?>