<?php
// File: contact_admin.php
/************************************
 * let users contact their own admins.
 * list the admin usernames of their group,
 * but do not list their emails to users.
*************************************/
require_once 'includes/include_all.inc.php';

$userId = $_SESSION['front_user_id'];
$user = getUserDetails($userId); 
$groupAdmins = getGroupAdmins($user['user_group']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $adminId = $_POST['admin_id'];
    $message = $_POST['message'];
    
    if (contactAdmin($userId, $adminId, $message)) {
        $successMessage = "Message sent successfully to admin.";
    } else {
        $errorMessage = "Failed to send message to admin.";
    }
}
?>

<h2>Contact Group Admins</h2>

<form method="POST" action="">
    <label for="admin_id">Select Admin:</label>
    <select id="admin_id" name="admin_id" required>
        <?php foreach ($groupAdmins as $admin): ?>
            <option value="<?php echo $admin['ID']; ?>">
                <?php echo htmlspecialchars($admin['first_name'] . ' ' . $admin['last_name']); ?>
            </option>
        <?php endforeach; ?>
    </select>

    <label for="message">Message:</label>
    <textarea id="message" name="message" required></textarea>

    <button type="submit">Send Message</button>
</form>

<?php
if (isset($successMessage)) {
    echo "<p class='success'>$successMessage</p>";
}
if (isset($errorMessage)) {
    echo "<p class='error'>$errorMessage</p>";
}
?>