<?php
// File: admin_settings.php
/************************************
 * allows for regular admin to set what settings the users in their group 
 * are allowed to toggle for their users.
*************************************/
require_once 'includes/include_all.inc.php';

$userId = $_SESSION['front_user_id'];
$user = getUserDetails($userId); 

if ($user['user_type'] !== 'admin' && $user['user_type'] !== 'super') {
    die("Access denied. You must be an admin to view this page.");
}

$groupId = $user['user_group'];

$settingsToToggle = [
    'change_username' => 'Allow users to change username',
    'change_email' => 'Allow users to change email',
    'change_password' => 'Allow users to change password',
    'change_profile_picture' => 'Allow users to change profile picture',
    'change_display_name' => 'Allow users to change display name',
    'change_user_url' => 'Allow users to change user URL',
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($settingsToToggle as $setting => $label) {
        $allowed = isset($_POST[$setting]) ? 1 : 0;
        if (toggleUserSettingPermission($userId, $groupId, $setting, $allowed)) {
            $successMessage = "Settings updated successfully.";
        } else {
            $errorMessage = "Failed to update settings.";
            break;
        }
    }
}

// Fetch current settings
$currentSettings = [];
foreach (array_keys($settingsToToggle) as $setting) {
    $currentSettings[$setting] = canUserChangeSetting($userId, $setting);
}
?>

<h2>Admin Settings</h2>

<form method="POST" action="">
    <?php foreach ($settingsToToggle as $setting => $label): ?>
        <div>
            <label>
                <input type="checkbox" name="<?php echo $setting; ?>" 
                       <?php echo $currentSettings[$setting] ? 'checked' : ''; ?>>
                <?php echo htmlspecialchars($label); ?>
            </label>
        </div>
    <?php endforeach; ?>

    <button type="submit">Update Settings</button>
</form>

<?php
if (isset($successMessage)) {
    echo "<p class='success'>$successMessage</p>";
}
if (isset($errorMessage)) {
    echo "<p class='error'>$errorMessage</p>";
}
?>