<?php
// File: includes/admin_functions.php

/************************************
 * remember to set this up and configure for use
 * 
*************************************/

/* admin contact */
function getGroupAdmins($groupId) {
    global $pdo;
    $table_name = PREFIX . 'users';
    
    $stmt = $pdo->prepare("SELECT ID, first_name, last_name, user_email FROM $table_name WHERE user_group = ? AND (user_type = 'admin' OR user_type = 'super')");
    $stmt->execute([$groupId]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function contactAdmin($userId, $adminId, $message) {
    global $pdo;
    $table_name = PREFIX . 'users';
    
    $stmt = $pdo->prepare("SELECT user_email FROM $table_name WHERE ID = ?");
    $stmt->execute([$adminId]);
    $adminEmail = $stmt->fetchColumn();

    if ($adminEmail) {
        // Implement email sending logic here
        // Use a library like PHPMailer for this
        require 'path/to/PHPMailer/PHPMailerAutoload.php';
        $mail = new PHPMailer;
        $mail->setFrom('noreply@yoursite.com', 'Your Site');
        $mail->addAddress($adminEmail);
        $mail->Subject = 'Contact from User';
        $mail->Body = $message;
        return $mail->send();
    }
    return false;
}

function toggleUserSettingPermission($adminId, $groupId, $setting, $allowed) {
    global $pdo;
    $table_name = PREFIX . 'group_settings';
    
    $stmt = $pdo->prepare("INSERT INTO $table_name (group_id, setting, allowed, set_by) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE allowed = ?, set_by = ?");
    return $stmt->execute([$groupId, $setting, $allowed, $adminId, $allowed, $adminId]);
}

function canUserChangeSetting($userId, $setting) {
    global $pdo;
    $users_table = PREFIX . 'users';
    $settings_table = PREFIX . 'group_settings';
    
    $stmt = $pdo->prepare("SELECT gs.allowed FROM $users_table u JOIN $settings_table gs ON u.user_group = gs.group_id WHERE u.ID = ? AND gs.setting = ?");
    $stmt->execute([$userId, $setting]);
    return $stmt->fetchColumn();
}

?>