<?php

// Get current user
$current_user = getCurrentUser();


// Define the function to get the current user
function getCurrentUser() {
    if (isset($_SESSION['user_id'])) {
        global $pdo;
        $stmt = $pdo->prepare("SELECT * FROM " . PREFIX . "users WHERE ID = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        return $user ?: null;
    }
    return null;
}

// Redirect to login page if user is not logged in and not on the login page
if (!$current_user && basename($_SERVER['PHP_SELF']) != 'login.php') {
    header('Location: ' . MYSITE_URL . '/login.php');
    exit;
}

// Create User object
$obj_users = new Users();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    // If not logged in and not on the login page, redirect
    if (basename($_SERVER['PHP_SELF']) != 'login.php') {
        header('Location: ' . MYSITE_URL . '/login.php');
        exit;
    }
}

// Debugging: Check session and current user
if (!isset($_SESSION['user_id'])) {
    echo "Session not set.<br>";
} else {
    echo "Session user_id: " . $_SESSION['user_id'] . "<br>";
}

if (!$current_user) {
    echo "User not found.<br>";
} else {
    echo "User found.<br>";
}

// Now you can safely use $current_user
if ($current_user) {
    // Use $current_user as needed
    if (hasProfilePicture($current_user['ID'])) {
        // Profile picture exists, proceed with logic
    } else {
        // Handle cases where profile picture does not exist
    }
} else {
    // If the user is not logged in, they should already have been redirected,
    // so this block shouldn't be reached.
    echo "User not logged in.";
    exit;
}

// Ensure $current_user is not null before accessing its properties
if ($current_user && hasProfilePicture($current_user['ID'])):
    // Profile picture exists, proceed with logic
else:
    // Handle cases where profile picture does not exist
endif;
?>
