<?php
/**
 * File Name :			Format.class.php
 * Class : 				Format
 * Contributor :		Everplex
 * Description :		Revised full file for php 8, the whole thing was deprecated.
 * Date : 				2024-08-18		
 * 
 */

class Format {
    public static function file_size(int $bytes): string {
        if ($bytes < 1024) {
            return $bytes . ' bytes';
        }
        if ($bytes < 102400) {
            return round(($bytes / 1024), 1) . ' kb';
        }
        return round(($bytes / 1024000), 1) . ' mb';
    }

    public static function file_name(string $filename): string {
        $search = ['/ß/', '/ä/', '/Ä/', '/ö/', '/Ö/', '/ü/', '/Ü/', '([^[:alnum:]._])'];
        $replace = ['ss', 'ae', 'Ae', 'oe', 'Oe', 'ue', 'Ue', '_'];
        return preg_replace($search, $replace, $filename);
    }

    public static function phone(string $phone): string {
        $stripped = preg_replace("/[^0-9]/", "", $phone);
        if (strlen($stripped) == 7) {
            return preg_replace("/([0-9]{3})([0-9]{4})/", "$1-$2", $stripped);
        } elseif (strlen($stripped) == 10) {
            return preg_replace("/([0-9]{3})([0-9]{3})([0-9]{4})/", "($1) $2-$3", $stripped);
        } else {
            return $phone;
        }
    }

    public static function truncate(string $string, int $len, bool $hard = false): string {
        if (!$len || $len > strlen($string)) {
            return $string;
        }
        
        $string = substr($string, 0, $len);
        return $hard ? $string : (substr($string, 0, strrpos($string, ' ')) . ' ...');
    }

    public static function strip_slashes($var) {
        return is_array($var) ? array_map([self::class, 'strip_slashes'], $var) : stripslashes($var);
    }

    public static function htmlchars($var) {
        return is_array($var) ? array_map([self::class, 'htmlchars'], $var) : htmlspecialchars($var, ENT_QUOTES);
    }

    public static function input($var) {
        return self::htmlchars($var);
    }

    public static function display(string $text): string {
        global $cfg;

        $text = self::htmlchars($text);
        if ($cfg && $cfg->clickableURLS() && $text) {
            $text = self::clickableurls($text);
        }

        $text = preg_replace_callback('/\w{75,}/', function($matches) {
            return wordwrap($matches[0], 70, "\n", true);
        }, $text);

        return nl2br($text);
    }

    public static function striptags(string $string): string {
        return strip_tags(html_entity_decode($string));
    }

    public static function clickableurls(string $text): string {
        $text = preg_replace('/(((f|ht){1}tp(s?):\/\/)[-a-zA-Z0-9@:%_\+.~#?&;\/\/=]+)/', '<a href="\\1" target="_blank">\\1</a>', $text);
        $text = preg_replace("/(^|[ \\n\\r\\t])(www\.([a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+)(\/[^\/ \\n\\r]*)*)/", '\\1<a href="http://\\2" target="_blank">\\2</a>', $text);
        $text = preg_replace("/(^|[ \\n\\r\\t])([_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4})/", '\\1<a href="mailto:\\2" target="_blank">\\2</a>', $text);
        return $text;
    }

    public static function stripEmptyLines(string $string): string {
        return preg_replace("/\n{3,}/", "\n\n", $string);
    }

    public static function linebreaks(string $string): string {
        return str_replace("\r", " ", $string);
    }
    
    public static function elapsedTime(int $sec): string {
        if (!$sec) {
            return "";
        }

        $days = floor($sec / 86400);
        $hrs = floor(($sec % 86400) / 3600);
        $mins = round(($sec % 3600) / 60);
        $tstring = '';
        if ($days > 0) $tstring .= $days . 'd,';
        if ($hrs > 0) $tstring .= $hrs . 'h,';
        $tstring .= $mins . 'm';

        return $tstring;
    }
    
    public static function db_date(int $time): string {
        global $cfg;
        return self::userdate($cfg->getDateFormat(), $time);
    }

    public static function db_datetime(int $time): string {
        global $cfg;
        return self::userdate($cfg->getDateTimeFormat(), $time);
    }
    
    public static function db_daydatetime(int $time): string {
        global $cfg;
        return self::userdate($cfg->getDayDateTimeFormat(), $time);
    }

    public static function userdate(string $format, int $gmtime): string {
        return self::date($format, $gmtime, $_SESSION['TZ_OFFSET'] ?? 0, $_SESSION['daylight'] ?? false);
    }
    
    public static function date(string $format, int $gmtimestamp, int $offset = 0, bool $daylight = false): string {
        if (!$gmtimestamp) {
            return "";
        }
       
        $offset += $daylight ? date('I', $gmtimestamp) : 0;
        return date($format, ($gmtimestamp + ($offset * 3600)));
    }
    
}
?>
