"use strict";
function RecordDischarge() {
    if (UserSyncedFlag == true) {
        CaseLogStr2 = CaseLogStr2.concat("Sync:" + UserDefibedEnergy + " Joules\n");
    } else {
        CaseLogStr2 = CaseLogStr2.concat("Defib:" + UserDefibedEnergy + " Joules\n");
    }
}
function RecordFluids() {
    var tmpStr = "";
    for (var i = 0; i <= 1; i++) {
        if (IvAdmin.Iv[i].fluidStr != "None" && (IvAdmin.Iv[i].infusionRate > 0 || IvAdmin.Iv[i].bolusAmount > 0)) {
            tmpStr += IvAdmin.Iv[i].fluidStr + " infusion: " + IvAdmin.Iv[i].infusionRate + " mL/hr, bolus: " + IvAdmin.Iv[i].bolusAmount + " mL\n";
        }
    }
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
}
function RecordHeader() {
    var tmpStr;
    tmpStr = "\n" + MakeTimeStr() + "    " + CurrentState.recordMsg + "\n";
	tmpStr = tmpStr.concat("HR " + PddHr.toFixed(0));
	tmpStr = tmpStr.concat(",  BP " + PddAbpS.toFixed(0) + "/" + PddAbpD.toFixed(0));
	tmpStr = tmpStr.concat(",  SpO2 " + PrpSpO2.toFixed(0) + "\n");
		
    if (UserConnectedFlag) {
        tmpStr = tmpStr.concat("RR " + PrpMonRr.toFixed(0) + ",  TV " + PrpMonTv.toFixed(0) + "\n");
        tmpStr = tmpStr.concat("FiO2 " + PrpFiO2.toFixed(0));
        if (PrpMonRr > 0 && PrpMonTv > 0) {
            tmpStr = tmpStr.concat(",  ET-CO2 " + PrpEtCO2.toFixed(0));
            tmpStr = tmpStr.concat(",  ET-" + UserVapStr + " " + PrpFeAgt.toFixed(1) + "\n");
        } else {
            tmpStr = tmpStr.concat("\n");
        }
    }
	tmpStr = tmpStr.concat("ECG: " + CurrentHemoWave.RhythmDescription + "\n"); 
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
	
    if (CurrentState.finalState == 1 && Score > 0.79 * CurrentCase.possiblePoints) {
        tmpStr = "You completed the learning objectives for this case." + "\n";
        $("imgPatient").src = "app/images/heart.jpg";
        GradeStr = "High Pass";
		CaseLogStr2 = CaseLogStr2.concat(tmpStr);
        DisableSideMenu();
		EnableSecondTopBarButtons();
		ShowCaseLogScreen();

    } else if (CurrentState.finalState == 1 && Score < 0.50 * CurrentCase.possiblePoints) {
        tmpStr = "The patient survived but you did not meet the learning objectives for this case. You should review the learning objectives and do this case again.\n";
        $("imgPatient").src = "app/images/brokenHeart.jpg";
        GradeStr = "Fail";
		CaseLogStr2 = CaseLogStr2.concat(tmpStr);
        DisableSideMenu();
		EnableSecondTopBarButtons();
		ShowCaseLogScreen();
		
    } else if (CurrentState.finalState == 1 && Score < 0.81 * CurrentCase.possiblePoints) {
        tmpStr = "The patient survived. You met the learning objectives for this case but could have done better.\n";
        $("imgPatient").src = "app/images/brokenHeart.jpg";
        GradeStr = "Pass";
		CaseLogStr2 = CaseLogStr2.concat(tmpStr);
        DisableSideMenu();
		EnableSecondTopBarButtons();
		ShowCaseLogScreen();
		
    } else if (CurrentState.finalState == -1) {
        tmpStr = "The patient survived but could have done better. You should review the learning objectives and do this case again.\n";
        $("imgPatient").src = "app/images/brokenHeart.jpg";
        GradeStr = "Fail";
		CaseLogStr2 = CaseLogStr2.concat(tmpStr);
        DisableSideMenu();
		EnableSecondTopBarButtons();
		ShowCaseLogScreen();
		
    } else if (CurrentState.finalState == -2) {
        tmpStr = "The patient died. You should do this case again.\n";
        $("imgPatient").src = "app/images/ghost.jpg";
        GradeStr = "Fail";
		CaseLogStr2 = CaseLogStr2.concat(tmpStr);
        DisableSideMenu();
		EnableSecondTopBarButtons();
		ShowCaseLogScreen();
		
    } else if (UserAirwayStr == "crico") {
        tmpStr = "You forced a cricothyroidotomy. You did not complete the learning objectives. You should do this case again.\n";
        $("imgPatient").src = "app/images/brokenHeart.jpg";
        GradeStr = "Fail";
		CaseLogStr2 = CaseLogStr2.concat(tmpStr);
        DisableSideMenu();
		EnableSecondTopBarButtons();
		ShowCaseLogScreen();
    }
}

function RecordMeds(bAmount, iAmount) {
    var tmpStr = DrugInfo.Drugs[UserDrugIndex].nameStr + " ";
    if (bAmount > 0.0) {
        tmpStr = tmpStr.concat(DrugInfo.Drugs[UserDrugIndex].adminBolusAmount + " " + DrugInfo.Drugs[UserDrugIndex].bolusUnit);
        if (iAmount > 0.0) {
            tmpStr = tmpStr.concat(", ");
        } else {
            tmpStr = tmpStr.concat(".\n");
        }
    }
    if (iAmount > 0.0) {
        tmpStr = tmpStr.concat(DrugInfo.Drugs[UserDrugIndex].adminInfusionRate + " " + DrugInfo.Drugs[UserDrugIndex].infusionUnit + ".\n");
    }
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);

    var tmpStr = "";
    if ((DrugInfo.Drugs[UserDrugIndex].adminBolusFlag && DrugInfo.Drugs[UserDrugIndex].adminBolusLevel > 0) || (DrugInfo.Drugs[UserDrugIndex].adminInfusionFlag && DrugInfo.Drugs[UserDrugIndex].adminInfusionRate > 0)) {
        for (var j = 0; j < CurrentCase.badDrugs.length; j++) {
            if (DrugInfo.Drugs[UserDrugIndex].nameStr == CurrentCase.badDrugs[j]) {
                tmpStr = tmpStr.concat("It is not appropriate to administer " + DrugInfo.Drugs[UserDrugIndex].nameStr + " at any time during this case. (-" + CurrentCase.badDrugScore + " points)\n");
                Score += -CurrentCase.badDrugScore;
                DrugInfo.Drugs[UserDrugIndex].adminBolusFlag = false;
                DrugInfo.Drugs[UserDrugIndex].adminInfusionFlag = false;
            }
        }
    }
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
}
function RecordN2OFlow() {
    var tmpStr = "";
    tmpStr = tmpStr.concat("N2O flow set to " + UserN2OFlow + " L/min \n");
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
}	

function RecordAirFlow() {
    var tmpStr = "";
    tmpStr = tmpStr.concat("Air flow set to " + UserAirFlow + " L/min \n");
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
}	

function RecordO2Flow() {
    var tmpStr = "";
    tmpStr = tmpStr.concat("O2 flow set to " + UserO2Flow + " L/min \n");
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
}	

function RecordVapFlow() {
    var tmpStr = "";
    tmpStr = tmpStr.concat(UserVaporizerStr + " set to " + UserVaporizerAmount.toFixed(1) + "% \n");
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
}	

function RecordOverdose() {
    var tmpStr = "";
    tmpStr = tmpStr.concat("You administered an excessively large dose of " + DrugInfo.Drugs[UserDrugIndex].nameStr + ". (-1000 points)\n");
    tmpStr = tmpStr.concat("   End of simulation. You should do this case again.\n");
    $("imgPatient").src = "app/images/ghost.jpg";
    Score -= 1000;
    $("txtScore").textContent = "Score: " + Score + " / " + CurrentCase.possiblePoints;
    GradeStr = "Fail";
    CaseLogStr2 = CaseLogStr2.concat(tmpStr);
	DisableSideMenu();
	EnableSecondTopBarButtons();
	ShowCaseLogScreen();
}
