CaseData[25] = {
    "title": "Case 25 - 34 year old male for multiple dental extractions", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "\nYou must become adept at the differential diagnosis of hypotension under anesthesia. Anaphylactic reaction must be suspected in any patient with refractory hypotension. Other signs of anaphylactic reaction exhibited in this patient include tachycardia, bronchospasm, hypoxia, periorbital edema and cutaneous flushing.\n\nYou must treat aggressively by securing the airway, ventilating with 100% oxygen, rapid administration of intravenous fluids, and appropriate boluses of epinephrine.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 2, 
    "initialSat": 96, 
    "leanBodyMass": 74, 
    "learningObj": "\n34 year old male for multiple dental extractions (78 kg)\n\nThis patient works in a hospital, is allergic to fruit and has required frequent urethral catheterizations for stricture.\n\nLearning Objectives\n1.  Describe the clinical manifestations of latex allergy.\n2.  Describe treatment for anaphylactic reaction due to latex.\n3.  Describe precautions to prevent allergic reaction in patient known to be allergic to latex.\n\nClinical Manifestations of Latex Allergy\n1. Symptoms of latex allergy can vary from rhinitis, asthma, and urticaria to anaphylaxis upon contact with latex products. It is important to distinguish  cutaneous reactions to the plasticizer from true anaphylactic reactions.\n2. Common latex products include gloves, balloons, and condoms.\n3. Those most at risk include patients whose mucous membranes have been extensively exposed to latex, especially frequent catheterization or many previous surgeries. \n4. Allergies to fruits is frequent in patients allergic to latex.\n5. Housewives, hospital workers, and others that frequently contact latex are also at risk.\n6. Skin tests and measurement of IgE using RAST can demonstrate latex allergy and support history.\n\nAnaphylaxis\nThe clinical manifestations of anaphylaxis usually occur immediately after exposure to the triggering agent while latex allergy often occurs after 20 minutes.\n\nHypotension: invariable\nTachycardia: invariable\nBronchospasm: common\nHypoxemia: common\nCardiac dysrhythmias: common\nLaryngeal & periorbital edema: common\nCutaneous flushing: common\nCoagulation defects: occasional\nLeukopenia: occasional\n\nGoals of Treatment\n1. Reverse arterial hypoxemia\n2. Replace intravascular volume\n3. Inhibit further release of vasoactive substances\n\nTreatment\n1. Stop administration of triggering antigen if possible\n2. Maintain airway and administer 100% oxygen\n3. Balanced salt solution or colloid - often rapid infusion of 25-50 mL/kg liters required; may need to be repeated\n4. Epinephrine (5 - 10 mcg IV boluses)\n- Beta-2 adrenergic effect inhibits degranulation and causes bronchodilation\n- Alpha effect causes vasoconstriction\n5. Discontinue anesthetic drugs\n6. Diphenhydramine (initial dose 50 - 100 mg IV) to blunt histamine effects\n7. Albuterol inhaler (initial dose 10 puffs per ETT) for bronchospasm. Ipratropium may be beneficial also.\n8. Corticosteroids - Methylprednisolone (10-15 mg/kg) - may enhance beta effects of Epi, inhibit production of leukotrienes, and reduce reactions due to activation of complement system\n9. Norepinephrine and vasopressin may be helpful for refractory hypotension.\n10. Collect a blood sample for serum mast cell tryptase\n\nManagement of the Patient at Risk of Latex Allergy by Dr. Moss\n1.  First case of day\n2.  Pretreat with prednisone, ranitidine, and diphenhydramine\n3.  Avoid latex containing products (a list is necessary)\na.  Use vinyl gloves\nb.  Use glass syringes\nc.  Use vinyl anesthesia rebreathing bag\nd.  Use can opener to remove rubber cap on multiple dose vials\ne. Wrap rubber blood pressure cuff tubing in Webril\nf.  Avoid latex port on I.V. tubing\ng. Avoid straps on oxygen masks\nh. Avoid Band-Aids \ni.  Instruments should not be sterilized with ethylene oxide\n4.  Monitor closely and prepare to treat anaphylaxis \n\nReferences\n1. Moss, Alessi: Allergic patients. In Ambulatory Anesthesiology, edited by McGoldrick, Williams & Wilkins, Baltimore, 1995; pp. 252-265.\n2. Kokoszka, Nelson: Latex anaphylaxis. Dis Colon Rectum 1993; 36: 868-872\n3. Levy: ASA Refresher Lecture 2023:101. \n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington\nDate of Last Modification: September, 2024\n\n", 
    "possiblePoints": 1600, 
    "preopMsg": "\n34 year old male for multiple dental extractions\n\nHistory of Present Illness\nThis patient is employed as a housekeeper in the hospital. He requires extraction of impacted wisdom teeth and requests general anesthesia.\n\nPast Medical History\nIllnesses - none\nSurgeries - several urethral dilations for stricture\nMeds - none\nHabits - smokes and drinks\nAllergies - bananas, avocados, kiwi\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nThin male\nWeight: 78 kg\nHR 122,  BP 106/60,  RR 24\nAirway - normal\nLungs - clear\nHeart - normal\n\nLabs\nNone ordered\n\nNPO Status\nLast ate 13 hours ago. \n\nPatient and Surgeon Requests\nLast ate 8 hours ago. The oral surgeon states the procedure will take 1 hour and plans to send the patient home this afternoon.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen by mask and a sedative agent.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 23.8, 
            "baseHr": 88, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You administered an intravenous sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered an inhalational anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV1", 
            "whatNextMsg": "Continue induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV2", 
            "whatNextMsg": "Continue induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 4, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "whatNextMsg": "Place the endotracheal tube.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You continued to administer inhalation agent.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWIV", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2IV", 
            "whatNextMsg": "Inform the surgeon that the patient is ready.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDINH", 
            "whatNextMsg": "Continue induction.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 270, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You administered enough intravenous agent to sedate the patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "whatNextMsg": "Place the endotracheal tube.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered intravenous anesthetic agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You should place an endotracheal tube. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWINH", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2INH", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2INH", 
            "whatNextMsg": "Inform the surgeon that the patient is ready.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 210, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TACHYINH", 
                    "comment": "The simulation forced the patient to develop anaphylaxis due to exposure to latex.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPIV", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TACHYIV", 
                    "comment": "The simulation forced the patient to develop anaphylaxis due to exposure to latex.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TACHYIV", 
            "whatNextMsg": "Recheck the blood pressure before treating tachycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ANAPH1", 
                    "comment": "The simulation forced the patient to become more tachycardic and hypotensive.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TACHYINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TACHYINH", 
            "whatNextMsg": "Recheck the blood pressure before treating tachycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 114, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 96, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ANAPH1", 
                    "comment": "The simulation forced the patient to develop anaphylaxis due to exposure to latex.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TACHYIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ANAPH1", 
            "whatNextMsg": "Examine the patient and make the diagnosis.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 62, 
            "baseAbpM": 72, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There are a few scattered wheezes present.", 
            "cardiacOutput": 3, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 8, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become markedly tachycardic and hypotensive.", 
            "rhythm": "Sinus1", 
            "skinMsg": "There is a red rash spreading down the neck to the chest.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ANAPH2", 
                    "comment": "The simulation forced the patient to become more tachycardic and hypotensive.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ANAPH1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ANAPH2", 
            "whatNextMsg": "Examine the patient and make the diagnosis.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 45, 
            "baseAbpM": 52, 
            "baseAbpS": 62, 
            "baseBicarb": 24, 
            "baseHr": 134, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There are scattered wheezes present.", 
            "cardiacOutput": 2.4, 
            "contPip": 36, 
            "contPlateau": 34, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and thready.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become increasingly tachycardic and hypotensive.", 
            "rhythm": "Sinus1", 
            "skinMsg": "There is a red rash spreading down the neck to the chest.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ANAPH3", 
                    "comment": "The simulation forced the patient to beome pulseless.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ANAPH2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "ANAPH3", 
            "whatNextMsg": "Examine the patient and make the diagnosis.", 
 			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become pulseless.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 88, 
            "sat100": 92, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You should have placed an endotracheal tube in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ANAPH3", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HARDVENT", 
            "whatNextMsg": "Examine the patient and make the diagnosis.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 32, 
            "baseAbpS": 48, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 68, 
            "contPlateau": 66, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become pulseless and difficult to ventilate.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now ashen gray", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 72, 
            "sat40": 76, 
            "sat100": 80, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "The patient became severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "EP1", 
            "whatNextMsg": "Now administer a 1000 mL bolus of intravenous fluids.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 52, 
            "baseAbpS": 62, 
            "baseBicarb": 24, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 84, 
            "sat40": 87, 
            "sat100": 90, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1799
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "You administered a second bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP2", 
            "whatNextMsg": "Now administer a 1000 mL bolus of intravenous fluids.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Second dose of epinephrine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 88, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer intravenous fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1799
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "FLUID1", 
            "whatNextMsg": "Now give an epinephrine bolus.", 
 			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 52, 
            "baseAbpS": 62, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 3, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The first fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 86, 
            "sat100": 88, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "FLUID2", 
                    "comment": "You administered a second bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3599
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP1FLUID1", 
            "whatNextMsg": "Now administer a second bolus of epinephrine and fluids.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 58, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 85, 
            "sat40": 88, 
            "sat100": 90, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "You administered a second bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3599
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You administered a second bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP2FLUID1", 
            "whatNextMsg": "Now administer a second 1000 mL bolus of intravenous fluids.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 62, 
            "baseAbpS": 82, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Second dose of epinephrine and first bolus of intravenous fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 84, 
            "sat40": 88, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer intravenous fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP2FLUID2", 
                    "comment": "You administered a second bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 3599
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "FLUID2", 
            "whatNextMsg": "Now give an epinephrine bolus.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 62, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 4, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 9, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The second fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 84, 
            "sat40": 86, 
            "sat100": 88, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP1FLUID2", 
            "whatNextMsg": "Now administer a second bolus of epinephrine.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 82, 
            "baseBicarb": 24, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 3.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 5, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine and second bolus of fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 89, 
            "sat100": 91, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP2FLUID2", 
                    "comment": "You administered a second bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP2FLUID21", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP2FLUID2", 
            "whatNextMsg": "Administer diphenhydramine and albuterol.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 74, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Second bolus of epinephrine and intravenous fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 93, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer diphenhydramine and albuterol faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered diphenhydramine and albuterol appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Diphenhydramine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2FLUID2", 
                    "comment": "You administered an inadequate dose of diphenhydramine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Diphenhydramine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "You successfully resuscitated from anaphylaxis.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 74, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 8, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient is stable.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "VTACH1", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 84, 
            "sat100": 86, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "EP1", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH2", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 24, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 80, 
            "sat40": 83, 
            "sat100": 86, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "EP2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "whatNextMsg": "Now perform laryngoscopy and place the endotracheal intubation.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Asleep and paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 16, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 16, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 16, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATDEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATDEAD", 
            "whatNextMsg": "Notify the family.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 16, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}