CaseData[13] = {
    "title": "Case 13 - 45 year old female for craniotomy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1, 
    "debriefMsg": "\nYou must become adept at the differential diagnosis of hypotension under anesthesia. Think in this order: (1) Preload, (2) Pump, (3) Afterload.  In this case it is the pump (contractility).\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "fsmFlag": false, 
    "helpFlag": true, 
    "imageSet": 5, 
    "initialSat": 96, 
    "leanBodyMass": 60, 
    "learningObj": "\n45 year old female for craniotomy (66 kg)\n\nThis patient has had treatment with adriamycin which can be cardiotoxic. She also has a space occupying intracranial lesion and may have elevated ICP.\n\nLearning Objectives\n1.  List the common toxic side-effects of chemotherapeutic agents.\n2.  Discuss optimal choice of anesthetic agents for patients with congestive heart failure.\n\nAnesthetic Considerations:\nCongestive heart failure secondary to adriamycin\nElevated intracranial pressure\n\nAnesthesia and Congestive Heart Failure:\n1.  Preoperative evaluation\na. Chemotherapy history including agents used and total dose\nb. Symptomatology - past history of congestive heart failure and/or embolization including responses to treatment, as well as current exercise tolerance and severity of symptoms\nc. Medications - past and present, and their effectiveness\nd. Studies - ECG, CXR, Echo, MUGA\n\n2.  Intra-operative management\na. Avoidance of drug-induced myocardial depression\nb. Maintenance of normovolemia - avoid both hypo-  and hypervolemia\nc. Prevention of increases in afterload\n\n3.  Cerebral perfusion pressure may be compromised secondary to decreased mean arterial pressure and increased central venous pressure secondary to poor cardiac function. Monitor for potential cerebral ischemia.\n\n4.  Differential of wheezing under general anesthesia\na. Asthma\nb. Allergy\nc. Anaphylaxis\nd. Light anesthesia\ne. Mechanical - kinked or obstructed tube, secretions, endobronchial intubation\nf.  Cardiac - congestive heart failure\n\n5.  Differential for hypotension under general anesthesia\na. Hypovolemia\nb. Cardiac dysfunction and arrhythmia\nc. Vasodilation from sympathetic block or drugs\nd. Anaphylaxis\ne. Sepsis\nf.  Drug overdose\ng. Electrolyte imbalance - especially hypocalcemia and hypomagnesemia with massive transfusion\nh. Air embolism\n\nDescription of Pathophysiology:\nChemotherapy induced dilated cardiomyopathy is a condition which occurs in roughly 2% of patients treated with adriamycin. It is more likely to occur in patients who are concomitantly treated with cytoxan and/or radiation therapy, and can persist for up to three years after chemotherapy is completed. Though there is no absolute toxic dose, studies have shown that <10% of patients treated with < 450 mg/sq m develop severe cardiomyopathy vs > 20% of patients treated with a total dose >500 mg/sq m.\n\nThe purported mechanism of myocardial injury is not well defined, but is thought to involve inhibition of the Na/Ca exchange pump and alterations in intracellular calcium regulation. Nonspecific changes include a decrease in myocardial fibrils, mitochondrial alterations, and cellular degeneration as seen on electron microscopy.\n\nThe mainstay of treatment is with ACE inhibitors and diuretics.  Digoxin may improve symptoms. Beta-adrenergic blockade may improve hemodynamics and survival in patients with congestive heart failure.\n\nSuggested Anesthetic Plan:\n1.  Monitoring\na. Direct arterial pressure\nb. PA catheter to help guide fluid management and hemodynamics\nc. Trans-Esophageal Echo to assess the effects of pharmacologic interventions\n\n2.  Choice of anesthetic\na. Volatile agents will reduce afterload, but may produce unwanted myocardial depression.\nb. Ketamine may preserve myocardial contractility at the expense of increased afterload.\nc. Narcotics allow hemodynamic stability, but in combination with other agents can cause depressant effects.\nd. Regional anesthesia can be administered safely with the caveat that rapid high sympathetic blockade is inadvisable.\n\n3.  Vasoactive support\na. May be resistant to conventional inotropic support.\nb. Drops in blood pressure are best initially treated with beta-receptor stimulating agents such as ephedrine, dopamine, dobutamine or epinephrine.\nc. Milrinone may improve hemodynamics with its inotropic and vasodilating properties.\nd. Phenylephrine may worsen myocardial function by increasing afterload without increasing contractility.\n\nClinical Points:\nChemotherapy history including agents used, total dose, and an understanding of toxicities is essential to management of oncology patients.\nIn heart failure, the pulmonary artery systolic, diastolic and wedge (occlusion) pressures are all raised. Typically the wedge pressure is one or two mmHg lower than PA diastolic pressure. In cor pulmonale, the pulmonary wedge pressure may be much lower than PA diastolic pressure due to high pulmonary vascular resistance.\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September 2024\n\n", 
    "possiblePoints": 1000, 
    "preopMsg": "\n45 year old female for craniotomy\n\nHistory of Present Illness\nThis patient underwent modified radical mastectomy 3 years prior for breast cancer. She was treated with cytoxan, adriamycin, and 5-FU, and radiation therapy. She now has seizures and 7 cm right brain space-occupying lesion.\n\n\nPast Medical History\nIllnesses - as above\nSurgeries - modified radical mastectomy under general anesthesia without problem\nMeds - dilantin, phenobarbital, decadron\nNo known drug allergies\nHabits - Smoker 30 pack-years\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nAnxious female, short of breath\nWeight: 66 Kg\nHR 92,  BP 136/80, RR 22\nAirway - normal\nLungs - occasional crackles\nHeart - S3, jugulovenous distention, pretibial pitting edema\n\nLabs\nHematocrit 33,  K 4.7;  Glucose, Bun, Cr - normal\nEKG - sinus rhythm, non-specific T-wave changes\nCXR - cardiomegaly, increased lung markings\n\nNPO Status\nLast ate 10 hours ago. \n\nPatient and Surgeon Requests\nRequires a general anesthetic. The surgeon requests mannitol administration to lower the intracranial pressure.\n\n", 
    "volAnDsp": 80,  
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Sedate, preoxygenate and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 86, 
            "baseAbpM": 100, 
            "baseAbpS": 132, 
            "baseBicarb": 23.8, 
            "baseHr": 88, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 10, 
            "papM": 14, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry but has slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": 0.1, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to place the LMA in an unsedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unsedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unsedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unsedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKECOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEHURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 18, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.3, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 14, 
            "papM": 20, 
            "papS": 32, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": 0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATED", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "sat20": 80, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 3, 
            "spontRr": 14, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": 0.1, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "You administered an appropriate dose of propofol. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 89
                        }, 
                        {
                            "drug": "Propofol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 141
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "XSINDUCTION", 
                    "comment": "You administered an excessive dose of propofol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 140
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "Etomidate is no longer recommended. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 8
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "XSINDUCTION", 
                    "comment": "Etomidate is no longer recommended. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 20
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "You administered enough intravenous agent to induce anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPBREATHE", 
                    "comment": "You administered enough inhalation agent to induce anesthesia. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATEDCOUGH", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDCOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEDCOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 102, 
            "baseAbpS": 154, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice, but is coughing.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDHURT", 
            "whatNextMsg": "Induce anesthesia immediately.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 126, 
            "baseAbpS": 196, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is moaning, but the breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is moaning in pain.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 38, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Moaning in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.3, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "The patient stopped moaning.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "whatNextMsg": "Induce anesthesia immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 96, 
            "baseAbpM": 116, 
            "baseAbpS": 176, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is dreaming about calling his lawyer.", 
            "papD": 18, 
            "papM": 26, 
            "papS": 34, 
            "papW": 16, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": 0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "The neuromuscular blocker started wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "You administered sedative agent to this paralyzed patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPAPNEA", 
            "whatNextMsg": "Secure the airway, ensure adequate anesthesia and instruct the surgeon to operate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 76, 
            "baseAbpM": 90, 
            "baseAbpS": 118, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 26, 
            "papW": 10, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized mainly with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAPNEA", 
                    "comment": "You secured the airway with an endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAPNEA", 
                    "comment": "You should have secured the airway with an endotracheal tube for this operation. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPBREATHE", 
            "whatNextMsg": "Secure the airway, ensure adequate anesthesia and instruct the surgeon to operate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 92, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized mainly with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWBREATHE", 
                    "comment": "You secured the airway with an endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWBREATHE", 
                    "comment": "You should have secured the airway with an endotracheal tube for this operation. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSINDUCTION", 
            "whatNextMsg": "Secure the airway and administer pressors.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 64, 
            "baseAbpS": 76, 
            "baseBicarb": 23.8, 
            "baseHr": 98, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 15, 
            "papW": 5, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive induction agent administered.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWDEEP", 
                    "comment": "You secured the airway with an endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWDEEP", 
                    "comment": "You should have secured the airway with an endotracheal tube for this operation. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAPNEA", 
            "whatNextMsg": "Provide adequate anesthesia and inform the surgeon when the patient is ready for surgery.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 90, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 10, 
            "papM": 16, 
            "papS": 26, 
            "papW": 10, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, airway secured, no spontaneous breathing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPAPNEA", 
                    "comment": "You anesthetized the patient adequately for surgery. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.3
                        }, 
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OPLITEAPNEA", 
                    "comment": "You did not provide adequate anesthesia for incision. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 1.4
                        }, 
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWBREATHE", 
            "whatNextMsg": "Provide adequate anesthesia and inform the surgeon when the patient is ready for surgery.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 90, 
            "baseBicarb": 24, 
            "baseHr": 90, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, airway secured, breathing spontaneously.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPBREATHE", 
                    "comment": "You anesthetized the patient adequately for surgery. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.3
                        }, 
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OPLITEBREATHE", 
                    "comment": "You did not provide adequate anesthesia for incision. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 1.4
                        }, 
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWDEEP", 
            "whatNextMsg": "Inform the surgeon when the patient is ready for surgery.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 66, 
            "baseAbpS": 78, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply anesthetized, airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPDEEP", 
                    "comment": "You anesthetized the patient for surgery. (+100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPLITEAPNEA", 
            "whatNextMsg": "Deepen the level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 98, 
            "baseAbpS": 136, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Operation underway, light anesthesia, no spontaneous breathing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You deepened the anesthetic for surgery. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPAPNEA", 
            "whatNextMsg": "Maintain appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Operation underway, no spontaneous breathing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You provided adequate anesthesia for surgery. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPLITEBREATHE", 
            "whatNextMsg": "Deepen the level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 78, 
            "baseAbpS": 104, 
            "baseBicarb": 24, 
            "baseHr": 134, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is grimmacing.", 
            "papD": 14, 
            "papM": 20, 
            "papS": 30, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Operation underway, light anesthesia, breathing spontaneously.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 22, 
            "spontTv": 170, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You deepened the anesthesia for surgery. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPBREATHE", 
            "whatNextMsg": "Maintain appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 72, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 20, 
            "papS": 30, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Operation underway, breathing spontaneously.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 14, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You provided adequate anesthesia for surgery. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPDEEP", 
            "whatNextMsg": "Add inotropic support with dopamine or dobutamine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 68, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 10, 
            "papS": 18, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Operation underway, deeply anesthetized", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You administered ephedrine as an inotropic agent. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered a bolus of epinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of dopamine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of dobutamine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of epinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of norepinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OPHYPO1", 
                    "comment": "You administered a bolus of phenylephrine to this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "OPHYPO1", 
                    "comment": "You administered an infusion of phenylephrine to this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.9
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "OPHYPO1", 
                    "comment": "You waited too long to treat hypotension in this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2", 
            "whatNextMsg": "Maintain appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 70, 
            "baseAbpS": 84, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 20, 
            "papW": 8, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You provided appropriate anesthetic to this patient. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OPDEEP", 
                    "comment": "You provided excessive anesthetic to this patient. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 3.3
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "You satisfied the learning objectives for this case. End of simulation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 62, 
            "baseAbpM": 70, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 10, 
            "papS": 18, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPHYPO1", 
            "whatNextMsg": "Add inotropic support with dopamine or dobutamine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 60, 
            "baseAbpS": 74, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 10, 
            "papM": 14, 
            "papS": 22, 
            "papW": 10, 
            "pulseMsg": "The pulse is weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Hypotensive", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You administered ephedrine as an inotropic agent. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered a bolus of epinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of dopamine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of dobutamine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of epinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of norepinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "OPHYPO2", 
                    "comment": "You administered a bolus of phenylephrine to this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "OPHYPO2", 
                    "comment": "You administered an infusion of phenylephrine to this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.9
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "OPHYPO2", 
                    "comment": "You waited too long to treat hypotension in this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPHYPO2", 
            "whatNextMsg": "Add inotropic support with dopamine or dobutamine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 56, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 2.4, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 24, 
            "papW": 12, 
            "pulseMsg": "The pulse is absent", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Severely hypotensive.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2", 
                    "comment": "You administered ephedrine as an inotropic agent. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Ephedrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered a bolus of epinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 9
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of dopamine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of dobutamine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of epinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "GA2", 
                    "comment": "You administered an infusion of norepinephrine as an inotropic agent. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESATASYST", 
                    "comment": "You waited too long to treat hypotension in this patient with heart failure. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}