CaseData[49] = {
    "title": "Case 108 - 78 year old male with mitral stenosis for exploratory lap", 
    "badDrugs": ["Ketamine", "Pancuronium", "Dantrolene"], 
    "coMin": 1, 
    "debriefMsg": "severe mitral stenosis, RSI, rapid atrial fib based on case 9", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": false, 
    "imageSet": 7, 
    "initialSat": 90, 
    "leanBodyMass": 70, 
    "learningObj": "", 
    "possiblePoints": 2000, 
    "preopMsg": "\n78 year old male with moderate mitral stenosis and pulmonary hypertension for exploratory laparotomy\n\nHistory of Present Illness\nPatient complains of having abdominal pain and distension for 2 days associated with nausea and vomiting.  He has had nothing to eat or drink since the onset of symptoms.  He also complains of paroxysmal palpitation in the last 24 hours with associated dizziness.\n\nPast Medical History\nIllnesses - Mitral stenosis from rheumatic heart disease with multiple hospital admissions for congestive heart failure.  Last admission was six months ago.\nSurgeries - Cataract extractions bilaterally 3 years ago, appendectomy in childhood and an inguinal hernia repair over 50 years ago. No anesthetic complications.\n\nMedications\nAtenolol, Furosemide\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nThin, elderly male in moderate distress.\nWeight: 74kg\nHR 75/min,  BP 102/65,  RR 22, shallow\nAirway - Mallampatti class I, good neck extension, edentulous\nLungs - Clear\nHeart - S1S2, opening snap with mid-diastolic rumbling murmur best heard over the apex\n\nLabs\nHct 45%\nNa-148, K-3.6, Cl-110, HCO3-20, BUN-28, Cr-1.6\n\nEKG - Sinus rhythm at 75/min.  Bifid P waves in lead II\n\nCXR - Cardiomegaly.  Straightening of the left heart border.  Carinal flattening.  Mild pulmonary congestion.\n\nEchocardiography - EF 45%.  Moderate mitral stenosis with valve area of 1.2 cm2.  PASP 48 mmHg\n\nNPO Status\nPatient has had nothing to eat or drink for 2 days\n\nPatient and Surgeon Requests\nThe surgeon states the procedure will take approximately 3 hours.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen and rehydrate. Administer a low dose of anxiolytic agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 65, 
            "baseAbpS": 102, 
            "baseBicarb": 23.8, 
            "baseHr": 85, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 15, 
            "papM": 20, 
            "papS": 35, 
            "papW": 12, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 270, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Midazolam", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Fentanyl", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 100
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKE2", 
                    "comment": "You administered an adequate dose of anxiolytic (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARTHYD", 
                    "comment": "You partially rehydrated the patient prior to induction. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "AWAKEHYD", 
                    "comment": "You rehydrated but you should use smaller fluid boluses. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PREO2", 
                    "comment": "You preoxygenated this anxious patient.  (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "o2Sat", 
                            "value": 95
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARTHYD", 
            "whatNextMsg": "You partially rehydrated the patient. Administer additional IV fluid, oxygen and a low dose of anxiolytic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 70, 
            "baseAbpS": 108, 
            "baseBicarb": 23.8, 
            "baseHr": 80, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 18, 
            "papM": 22, 
            "papS": 36, 
            "papW": 15, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Awake, alert, and partially rehydrated.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Midazolam", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Fentanyl", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 100
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKE2PARTHYD", 
                    "comment": "You administered an adequate dose of anxiolytic (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PREO2PARTHYD", 
                    "comment": "You preoxygenated this anxious patient.  (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "o2Sat", 
                            "value": 95
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEHYD", 
                    "comment": "You rehydrated the patient appropriately prior to induction. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEHYD", 
            "whatNextMsg": "Rehydrated. Now administer oxygen and a low dose of anxiolytic agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 76, 
            "baseAbpS": 112, 
            "baseBicarb": 23.8, 
            "baseHr": 75, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 15, 
            "pulseMsg": "The pulse is stronger.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Rehydrated. Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with improved capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE2HYD", 
                    "comment": "You administered an adequate dose of anxiolytic (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PREO2HYD", 
                    "comment": "You preoxygenated this anxious patient.  (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "o2Sat", 
                            "value": 95
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Midazolam", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Fentanyl", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 100
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "OVERSED", 
                    "comment": "You oversedated the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKE2", 
            "whatNextMsg": "Rehydrate and administer oxygen by mask prior to induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 65, 
            "baseAbpS": 102, 
            "baseBicarb": 23.8, 
            "baseHr": 70, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 15, 
            "papM": 20, 
            "papS": 35, 
            "papW": 12, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Calmly awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 5, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PREO2", 
                    "comment": "You preoxygenated appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "o2Sat", 
                            "value": 95
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKE2PARTHYD", 
                    "comment": "You partially rehydrated the patient prior to induction. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "AWAKE2HYD", 
                    "comment": "You rehydrated but you should use smaller fluid boluses. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 100
                }, 
               {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You induced anesthesia without cricoid pressure and the patient aspirated large quanitites of gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
                        {
                            "type": "doingCricoid", 
                            "value": false
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "AWAKE2PARTHYD", 
            "whatNextMsg": "Continue rehydation. Administer oxygen by mask prior to induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 70, 
            "baseAbpS": 108, 
            "baseBicarb": 23.8, 
            "baseHr": 68, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 18, 
            "papM": 22, 
            "papS": 36, 
            "papW": 18, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Partially rehydrated. Calmly awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with improved capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 5, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PREO2PARTHYD", 
                    "comment": "You preoxygenated appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "o2Sat", 
                            "value": 95
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKE2HYD", 
                    "comment": "You rehydrated the patient appropriately prior to induction. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
               {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You induced anesthesia without cricoid pressure and the patient aspirated large quanitites of gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
                        {
                            "type": "doingCricoid", 
                            "value": false
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "AWAKE2HYD", 
            "whatNextMsg": "Adequately rehydrated. Now administer oxygen by mask prior to induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 75, 
            "baseAbpS": 112, 
            "baseBicarb": 23.8, 
            "baseHr": 66, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Rehydrated. Calmly awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with improved capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 5, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PREO2HYD", 
                    "comment": "You preoxygenated appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "o2Sat", 
                            "value": 95
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.2
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "This patient has not been anesthetized.  It is inappropriate to have recommended an incision at this time.  (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You induced anesthesia without cricoid pressure and the patient aspirated large quanitites of gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
                        {
                            "type": "doingCricoid", 
                            "value": false
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "PREO2", 
            "whatNextMsg": "Rehydrate prior to induction then perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 65, 
            "baseAbpS": 102, 
            "baseBicarb": 23.8, 
            "baseHr": 70, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 15, 
            "papM": 20, 
            "papS": 35, 
            "papW": 12, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Preoxygenated and awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PREO2PARTHYD", 
                    "comment": "You partially rehydrated the patient prior to induction. (+300 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PREO2HYD", 
                    "comment": "You rehydrated but you should use smaller fluid boluses. (+300 points of 500 possible points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "CRICO", 
                    "comment": "You applied cricoid pressure appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You induced anesthesia without cricoid pressure and the patient aspirated large quanitites of gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        },
                        {
                            "type": "doingCricoid", 
                            "value": false
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You allowed the surgeon to make incision without anesthetizing the patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PREO2PARTHYD", 
            "whatNextMsg": "Continue rehydration then perform rapid sequence induction with cricoid pressure.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 75, 
            "baseAbpS": 108, 
            "baseBicarb": 23.8, 
            "baseHr": 68, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 18, 
            "papM": 22, 
            "papS": 36, 
            "papW": 18, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Partially rehydrated. Preoxygenated and awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with improved capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PREO2HYD", 
                    "comment": "You rehydrated adequately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "CRICOPARTHYD", 
                    "comment": "You applied cricoid pressure appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You induced anesthesia without cricoid pressure and the patient aspirated large quanitites of gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You allowed the surgeon to make incision without anesthetizing the patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PREO2HYD", 
            "whatNextMsg": "Adequately rehydrated. Apply cricoid pressure prior to induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 78, 
            "baseAbpS": 114, 
            "baseBicarb": 23.8, 
            "baseHr": 66, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Rehydrated, preoxygenated and awaiting induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "CRICOHYD", 
                    "comment": "You applied cricoid pressure appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingCricoid", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You induced anesthesia without cricoid pressure and the patient aspirated large quanitites of gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You allowed the surgeon to make incision without anesthetizing the patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "CRICO", 
            "whatNextMsg": "Administer oxygen by mask and continue with induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 65, 
            "baseAbpS": 95, 
            "baseBicarb": 23.8, 
            "baseHr": 75, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 20, 
            "papS": 32, 
            "papW": 15, 
            "pulseMsg": "The pulse is palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1, 
            "recordMsg": "Cricoid pressure is being applied to this patient.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "CRICOPARTHYD", 
                    "comment": "You partially rehydrated the patient prior to induction. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }, 
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "CRICOHYD", 
                    "comment": "You rehydrated but you should use smaller fluid boluses. (+300 points of 500 possible points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You administered an appropriate dose of propofol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "drug": "Propofol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 121
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Consider not using etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 5
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You administered an appropriate dose of thiopental. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Thiopental", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 149
                        }, 
                        {
                            "drug": "Thiopental", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced unconsciousness with other than bolus propofol. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You administered an excessive dose of propofol to a dehydrated patient. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 120
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You administered an excessive dose of etomidate to a dehydrated patient. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You administered muscle relaxant before inducing unconsciousness. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "CRICOPARTHYD", 
            "whatNextMsg": "Continue rehydratation then perform rapid sequence induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 75, 
            "baseAbpS": 105, 
            "baseBicarb": 23.8, 
            "baseHr": 70, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 18, 
            "papM": 22, 
            "papS": 36, 
            "papW": 15, 
            "pulseMsg": "The pulse is palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1, 
            "recordMsg": "Partially rehydrated. Cricoid pressure is being applied.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool with improved capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "CRICOHYD", 
                    "comment": "You rehydrated. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You administered an appropriate dose of propofol. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "drug": "Propofol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 121
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "Consider not using etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 5
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You administered an appropriate dose of thiopental. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Thiopental", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 149
                        }, 
                        {
                            "drug": "Thiopental", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You induced unconsciousness with other than bolus propofol, etomidate or thiopental.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You administered an excessive dose of propofol to a partially rehydrated patient. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You administered an excessive dose of etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You administered muscle relaxant before inducing unconsciousness. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-200 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "CRICOHYD", 
            "whatNextMsg": "Adequately rehdrated. Continue with induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 85, 
            "baseAbpS": 115, 
            "baseBicarb": 23.8, 
            "baseHr": 68, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1, 
            "recordMsg": "Adequately rehydrated. Cricoid pressure is being applied.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm with improved capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPHYD", 
                    "comment": "You administered an appropriate dose of propofol. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "drug": "Propofol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 121
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPHYD", 
                    "comment": "Consider not using etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 5
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPHYD", 
                    "comment": "You induced unconsciousness with other than bolus propofol, etomidate or thiopental. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPHYD", 
                    "comment": "You administered an excessive dose of propofol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 120
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You administered an excessive dose of etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 21
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You administered an excessive dose of thiopental. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Thiopental", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 300
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You administered muscle relaxant before inducing unconsciousness. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "COUGH", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEP", 
            "whatNextMsg": "Rehydrate and continue with induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Asleep.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPDRY", 
                    "comment": "You did not adequately rehydrate the patient prior to induction. (-500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "tFluid", 
                            "value": 999
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASLEEPHYD", 
                    "comment": "You appropriately rehydrated the patient prior to induction. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 998
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 10
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to desaturate. (-500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPHYD", 
            "whatNextMsg": "Intubate the patient when adequately paralyzed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 70, 
            "baseAbpS": 105, 
            "baseBicarb": 24, 
            "baseHr": 65, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Continue with induction.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with good capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "Consider avoiding succinylcholine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Succinylcholine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 121
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "You administered an excessive amount of succinylcholine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 120
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "You administered a competitive neuromuscular blocker. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PULMEDEMA", 
                    "comment": "You administered too much fluid to this patient.  (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2000
                        }
                    ], 
                    "points": -200
                }
            ]
        }, 
        {
            "name": "ASLEEPPARA", 
            "whatNextMsg": "Now perform laryngoscopy and place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 70, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Asleep and paralyzed.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASPIRATE", 
                    "comment": "You took too long to intubate and the patient became hypoxic. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "READY", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "READY", 
                    "comment": "You already placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "READY", 
            "whatNextMsg": "Maintenance phase - monitor the patient carefully. Tell the surgeon to get started.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPERATING", 
                    "comment": "The surgeon is operating. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to become hypoxic.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "OPERATING", 
            "whatNextMsg": "Maintenance phase - monitor the patient carefully.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 66, 
            "baseAbpM": 78, 
            "baseAbpS": 118, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 34, 
            "papS": 40, 
            "papW": 22, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The operation is underway.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AFIBRVR", 
                    "comment": "The simulation forced an arrhythmia.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 45
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "AFIBRVR", 
            "whatNextMsg": "Cardiovert to restore sinus rhythm.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 40, 
            "baseAbpS": 60, 
            "baseBicarb": 24, 
            "baseHr": 160, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.8, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 30, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "irregularly irregular.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 30, 
            "papM": 45, 
            "papS": 55, 
            "papW": 35, 
            "pulseMsg": "The pulse is weak and irregular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 0, 
            "recordMsg": "Patient is in atrial fibrillation with a rapid ventricular response.", 
            "rhythm": "Afib6", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 88, 
            "sat100": 90, 
            "spSignal": 2, 
            "spontRr": 6, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.6, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VFIB", 
                    "comment": "You did not treat the arrythmia appropriately. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DONE", 
                    "comment": "You treated the rapid atrial fibrillation with defibrillation rather than syncronized cardioversion. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 49
                        }, 
                        {
                            "op": "LT", 
                            "type": "defib", 
                            "value": 201
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DONE", 
                    "comment": "You treated the rapid atrial fibrillation appropriately with syncronized cardioversion at 50-200 Joules. (+600 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "sync", 
                            "value": 49
                        }, 
                        {
                            "op": "LT", 
                            "type": "sync", 
                            "value": 201
                        }
                    ], 
                    "points": 600
                }, 
                {
                    "nextState": "DONE", 
                    "comment": "You defibrillated the rapid atrial fibrillation with greater than 200 Joules. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 201
                        }
                    ], 
                    "points": -200
                },
                {
                    "nextState": "DONE", 
                    "comment": "You cardioverted the rapid atrial fibrillation with greater than 200 Joules. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "sync", 
                            "value": 201
                        }
                    ], 
                    "points": -100
                }
            ]
        }, 
        {
            "name": "DONE", 
            "whatNextMsg": "Observe closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 66, 
            "baseAbpM": 78, 
            "baseAbpS": 118, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 34, 
            "papS": 40, 
            "papW": 22, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The operation is underway.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9,
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                },
			]	
        }, 
        {
            "name": "FINAL", 
            "whatNextMsg": "You reached the end of the simulation. Review the debriefing.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 66, 
            "baseAbpM": 78, 
            "baseAbpS": 118, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 34, 
            "papS": 40, 
            "papW": 22, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The operation is underway.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "OVERSED", 
            "whatNextMsg": "Do what you think is best.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 35, 
            "baseAbpM": 55, 
            "baseAbpS": 90, 
            "baseBicarb": 23.8, 
            "baseHr": 65, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm, mid-diastolic rumbling murmur over the apex.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is drowsy and lethargic.  Responds to pain. The patient is moving spontaneously.", 
            "papD": 40, 
            "papM": 45, 
            "papS": 60, 
            "papW": 35, 
            "pulseMsg": "The pulse is weak but palpable.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0, 
            "recordMsg": "The patient appears asleep.  Slow and deep respirations.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool and dry with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 80, 
            "sat40": 84, 
            "sat100": 88, 
            "spSignal": 3, 
            "spontRr": 6, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VFIB", 
                    "comment": "The patient is now in V Fib from right heart failure. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "AWAKE2", 
                    "comment": "You administered an adequate dose of reversal for the anxiolytic. (+200 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "The patient aspirated gastric contents. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "ASPIRATE", 
                    "comment": "The patient aspirated gastric contents. (-500 points)",  
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You allowed the surgeon to make incision without anesthetizing the patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 3.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 2.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 30, 
            "papM": 44, 
            "papS": 58, 
            "papW": 30, 
            "pulseMsg": "The pulse is rapid and strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 0.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 89, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VFIB", 
                    "comment": "You did not induce anesthesia in an appropriate manner.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 10
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "HURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 130, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 35, 
            "papM": 45, 
            "papS": 70, 
            "papW": 38, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 6, 
            "rateUo": 0, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 89, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -1.5, 
            "stSegV5": -1, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWAKE2", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 70
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASPIRATE", 
            "whatNextMsg": "Must reverse hypoxia immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 52, 
            "baseAbpS": 78, 
            "baseBicarb": 24, 
            "baseHr": 62, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 1.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 40, 
            "papM": 53, 
            "papS": 67, 
            "papW": 50, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 0, 
            "recordMsg": "The patient aspirated large quantities of acidic gastric contents.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 72, 
            "sat40": 78, 
            "sat100": 84, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESAT", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "COUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 3.8, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 36, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 28, 
            "papM": 40, 
            "papS": 56, 
            "papW": 28, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 4, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 89, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWAKE2", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 70
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPDRY", 
            "whatNextMsg": "Fluid resuscitate the patient with a fluid bolus.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 30, 
            "baseAbpM": 40, 
            "baseAbpS": 70, 
            "baseBicarb": 24, 
            "baseHr": 90, 
            "basePot": 3.6, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 0.5, 
            "recordMsg": "Hypotensive.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cool with slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 89, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPHYD", 
                    "comment": "You administered adequate fluids. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 998
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You did not administer enough fluid. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "ASLEEPPARADRY", 
                    "comment": "You administered an appropriate amount of succinylcholine. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Succinylcholine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 121
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPPARADRY", 
                    "comment": "You administered an excessive amount of succinylcholine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Succinylcholine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 120
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "ASLEEPPARADRY", 
                    "comment": "You administered a competitive neuromuscular blocker. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PULMEDEMA", 
                    "comment": "You administered too much fluid to this patient.  (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 2000
                        }
                    ], 
                    "points": -200
                }
            ]
        }, 
        {
            "name": "ASLEEPPARADRY", 
            "whatNextMsg": "Correct hypovolemia and intubate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 38, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 94, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Asleep and paralyzed.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 85, 
            "sat40": 93, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPPARA", 
                    "comment": "You administered adequate fluids. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 998
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "READYDRY", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "READYDRY", 
                    "comment": "You already placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You did not correct the hypovolemia in a timely fashion. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "READYDRY", 
            "whatNextMsg": "Correct hypovolemia. Tell the surgeon to get started.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 38, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "READY", 
                    "comment": "You administered adequate fluids. (+500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 998
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "OPERATINGDRY", 
                    "comment": "The surgeon is operating. (+200 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You did not correct the hypovolemia in a timely fashion. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESAT", 
                    "comment": "You allowed the patient to become hypoxic.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 80
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "OPERATINGDRY", 
            "whatNextMsg": "Monitor the patient carefully. Correct hypovolemia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 38, 
            "baseAbpS": 66, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 23, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The operation is underway.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPERATING", 
                    "comment": "You administered adequate fluids. (+500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 998
                        }
                    ], 
                    "points": 500
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You did not correct the hypovolemia in a timely fashion. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PULMEDEMA", 
            "whatNextMsg": "Control airway.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 70, 
            "baseAbpS": 105, 
            "baseBicarb": 24, 
            "baseHr": 65, 
            "basePot": 3.6, 
            "breathSoundsMsg": "Crackles bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, rumbling mid-diastolic murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 40, 
            "papM": 55, 
            "papS": 75, 
            "papW": 40, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "You overhydrated this patient and he is in pulmonary edema.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is warm and dry with good capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 74, 
            "sat40": 78, 
            "sat100": 82, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESAT", 
                    "comment": "You are unable to oxygenate the patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "VFIB", 
            "whatNextMsg": "CPR, cardiovert.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 5.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 0, 
            "recordMsg": "Patient is in ventricular fibrillation.", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 71, 
            "sat100": 72, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASYST", 
                    "comment": "The rhythm degenerated to asystole.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 5.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 0, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "You were unable to resuscitate the patient.  (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 6.5, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "DESAT", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 50, 
            "baseAbpS": 80, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 40, 
            "papM": 53, 
            "papS": 67, 
            "papW": 50, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 0, 
            "recordMsg": "Hypoxic.", 
            "rhythm": "Sinus2", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VFIB", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 10
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Do what you think is best.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 92, 
            "baseAbpS": 150, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds are normal.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is brisk.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is awake and alert, and is moving spontaneously.", 
            "papD": 12, 
            "papM": 14, 
            "papS": 28, 
            "papW": 15, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are 2mm and reactive.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm, dry and pink with brisk capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 2, 
            "spontRr": 4, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": 0.4, 
            "stSegV5": 0.3, 
            "temperature": 36.8
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Do what you think is best.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 92, 
            "baseAbpS": 150, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds are normal.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is brisk.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is awake and alert, and is moving spontaneously.", 
            "papD": 12, 
            "papM": 14, 
            "papS": 28, 
            "papW": 15, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are 2mm and reactive.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm, dry and pink with brisk capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 4, 
            "spontTv": 20, 
            "sputumAmount": 0, 
            "stSegII": 0.4, 
            "stSegV5": 0.3, 
            "temperature": 36.8
        }
    ]
}