<?php
// File: /api/toggle_case_visibility.php
require_once '../includes/include_all.inc.php';

if (!isset($_SESSION['front_user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit;
}

try {
    if (empty($_POST['id']) || !isset($_POST['status'])) {
        throw new Exception('Missing required parameters');
    }
    
    $id = $_POST['id'];
    $isHidden = ($_POST['status'] === 'visible') ? 1 : 0;
    
    // Verify case ownership
    $stmt = $pdo->prepare("SELECT user_id FROM wp_groupusers_data WHERE id = ?");
    $stmt->execute([$id]);
    $caseUserId = $stmt->fetchColumn();
    
    if ($caseUserId != $_SESSION['front_user_id']) {
        throw new Exception('Permission denied');
    }
    
    $stmt = $pdo->prepare("UPDATE wp_groupusers_data SET case_hidden = ? WHERE id = ?");
    $result = $stmt->execute([$isHidden, $id]);
    
    header('Content-Type: application/json');
    echo json_encode(['success' => $result]);
    
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>