<?php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
include($_SERVER['DOCUMENT_ROOT'] . '/includes/save_logging.php');

header('Content-Type: application/json');

$userId = $_SESSION['front_user_id'] ?? 0;

// Get user info
try {
    $stmt = $pdo->prepare("SELECT user_login, user_email FROM wp_users WHERE ID = ?");
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    $username = $user['user_login'] ?? 'Unknown';
    $userEmail = $user['user_email'] ?? 'Unknown';
} catch (Exception $e) {
    $username = 'Unknown';
    $userEmail = 'Unknown';
}

try {
    // Force real PDOException by querying non-existent table
    $stmt = $pdo->prepare("SELECT * FROM table_that_does_not_exist");
    $stmt->execute();
    
} catch (PDOException $e) {
    // This should write to saves_log.txt
    logCaseSaveDebug($userId, $username, $userEmail, 'TEST', '0/0', 'FAILED', 'TEST_ERROR', $e->getMessage());
    
    echo json_encode([
        "success" => false,
        "message" => "Test error logged. Check /logs/save_logs/ for current week's file."
    ]);
    exit();
}

echo json_encode(["success" => false, "message" => "No error triggered"]);
?>