<?php
/**
 * API file to sync user passwords with their group passwords
 */
/**
 * Function to sync user passwords with their group passwords
 * This updates both user_pass and user_pass_clear fields
 * 
 * @return string Message indicating result of operation
 */
function sync_user_passwords() {
    global $pdo; // Make sure this matches your database connection variable
    
    // Check if $pdo is available
    if (!isset($pdo) || !$pdo) {
        // Try to get database connection from your system
        if (isset($GLOBALS['pdo'])) {
            $pdo = $GLOBALS['pdo'];
        } else {
            return "Error: Database connection not available";
        }
    }
    
    try {
        // First, get the list of users that will be updated
        $selectQuery = "
            SELECT u.ID, u.user_login, u.user_email, u.group_id
            FROM wp_users u
            JOIN wp_groups g ON u.group_id = g.id
            WHERE u.group_id IS NOT NULL
            AND (u.user_pass != g.group_pass OR u.user_pass_clear != g.group_pass_clear)
        ";
        
        $selectStmt = $pdo->prepare($selectQuery);
        $selectStmt->execute();
        $updatedUsers = $selectStmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Run the password sync query
        $updateQuery = "
            UPDATE wp_users u
            JOIN wp_groups g ON u.group_id = g.id
            SET u.user_pass = g.group_pass,
                u.user_pass_clear = g.group_pass_clear
            WHERE u.group_id IS NOT NULL
            AND (u.user_pass != g.group_pass OR u.user_pass_clear != g.group_pass_clear)
        ";
        
        $updateStmt = $pdo->prepare($updateQuery);
        $result = $updateStmt->execute();
        
        if ($result) {
            $affected = $updateStmt->rowCount();
            
            // Log the updated users to a file
            $logFile = dirname(__FILE__) . '/logs/password_sync_log.txt';
            $timestamp = date('Y-m-d H:i:s');
            
            $logContent = "=== Password Sync Log - $timestamp ===\n";
            $logContent .= "Total users updated: $affected\n\n";
            
            if (count($updatedUsers) > 0) {
                $logContent .= "Updated users:\n";
                foreach ($updatedUsers as $user) {
                    $logContent .= "ID: {$user['ID']}, Login: {$user['user_login']}, Email: {$user['user_email']}, Group ID: {$user['group_id']}\n";
                }
            } else {
                $logContent .= "No users needed to be updated.\n";
            }
            
            $logContent .= "\n";
            
            // Append to log file
            file_put_contents($logFile, $logContent, FILE_APPEND);
            
            return "Password synchronization complete. $affected account(s) updated. Details logged to the log file.";
        } else {
            return "Error: Synchronization failed. " . implode(', ', $pdo->errorInfo());
        }
    } catch (Exception $e) {
        return "Error: " . $e->getMessage();
    }
}
?>