<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php';

function isDemoUser($userId) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT user_type FROM wp_users WHERE ID = ?");
    $stmt->execute([$userId]);
    $userType = $stmt->fetchColumn();
    return $userType === 'demo';
}

function restrictDemoFeatures() {
    // Implement demo restrictions
    // This function will be called when a demo user is detected
    // It should implement the specific restrictions for demo users
    
    // Restrict access to only Case 1
    global $CurrentCase;
    if (isset($CurrentCase) && $CurrentCase['id'] != 1) {
        // Redirect to Case 1 or show an error message
        header("Location: /index.php?case=1");
        exit();
    }
    
    // Add more restrictions as needed
}

function checkAndDeactivateExpiredDemos() {
    global $pdo;
    
    // Get all demo users with an expiration date
    $stmt = $pdo->prepare("SELECT ID, demo_expiration FROM wp_users WHERE user_type = 'demo' AND demo_expiration IS NOT NULL");
    $stmt->execute();
    $demoUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $currentTime = time();
    
    foreach ($demoUsers as $user) {
        $expirationTime = strtotime($user['demo_expiration']);
        if ($currentTime > $expirationTime) {
            // Deactivate the demo account
            $deactivateStmt = $pdo->prepare("UPDATE wp_users SET user_status = 0 WHERE ID = ?");
            $deactivateStmt->execute([$user['ID']]);
            
            // You could also send an email notification here
        }
    }
}

function getDemoAvailableCases() {
    $allCases = getCaseData(); // Assuming this function exists and returns all cases
    $availableCases = [];
    
    foreach ($allCases as $id => $case) {
        $caseInfo = [
            'id' => $id,
            'title' => $case['title'],
            'isPro' => $case['isPro'] ?? false,
            'isAccessible' => ($id == 1)
        ];
        
        if ($id != 1) {
            $caseInfo['title'] .= ' (Upgrade)';
        }
        
        $availableCases[] = $caseInfo;
    }
    
    return $availableCases;
}