<?php
require_once '../includes/include_all.inc.php';

// Only allow super admin access or user ID 3
$userId = $_SESSION['front_user_id'] ?? null;
if (!$userId || (!$_SESSION['user_type'] || $_SESSION['user_type'] !== 'super') && $userId != 3) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit;
}

header('Content-Type: application/json');

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!$data || !isset($data['session_expiry_amount']) || !isset($data['session_expiry_unit'])) {
        throw new Exception('Invalid input data');
    }
    
    $amount = (int)$data['session_expiry_amount'];
    $unit = $data['session_expiry_unit'];
    
    if ($amount <= 0) {
        throw new Exception('Session expiry amount must be greater than 0');
    }
    
    $valid_units = ['seconds', 'minutes', 'hours', 'days', 'months'];
    if (!in_array($unit, $valid_units)) {
        throw new Exception('Invalid session expiry unit');
    }
    
    // Save to database
    $stmt = $pdo->prepare("INSERT INTO wp_settings (setting_key, setting_value, setting_type) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value), updated_at = CURRENT_TIMESTAMP");
    
    $stmt->execute(['session_expiry_amount', $amount, 'integer']);
    $stmt->execute(['session_expiry_unit', $unit, 'string']);
    
    // Update current session expiry immediately
    require_once '../includes/session_manager.php';
    $new_expiry = getSessionExpirySeconds();
    $_SESSION['SESSION_EXPIRES'] = time() + $new_expiry;
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>