<?php
require_once '../includes/include_all.inc.php';

// Only allow super admin access
if (!isset($_SESSION['front_user_id']) || !$_SESSION['user_type'] || $_SESSION['user_type'] !== 'super') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit;
}

header('Content-Type: application/json');

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!$data || !isset($data['enabled'])) {
        throw new Exception('Invalid input data');
    }
    
    $enabled = $data['enabled'] ? 1 : 0;
    
    // Save to database - same pattern as session expiry settings
    $stmt = $pdo->prepare("INSERT INTO wp_settings (setting_key, setting_value, setting_type) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value), updated_at = CURRENT_TIMESTAMP");
    $stmt->execute(['global_session_termination_enabled', $enabled, 'boolean']);
    
    echo json_encode(['success' => true]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>