<?php
error_reporting(0);
ini_set('display_errors', 0);
ob_start();

try {
    require_once '../includes/include_all.inc.php';
} catch (Exception $e) {
    ob_end_clean();
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'System error']);
    exit;
}

ob_end_clean();
header('Content-Type: application/json');

try {
    $fields = array(
        'email' => array('type' => 'email', 'required' => true, 'error' => 'Please enter a valid email address'),
        'pass' => array('type' => 'string', 'required' => true, 'error' => 'Please enter a password')
    );

    $validator = new Validator($fields);
    $errors = array();

    if (!$validator->validate($_POST)) {
        $errors = $validator->errors();
    }

    if (empty($errors)) {
        $email = strtolower(filter_var($_POST['email'], FILTER_SANITIZE_EMAIL));
        $pass = trim($_POST['pass']);
        $salt = sha1(md5($pass));
        $newpassword = md5($pass . $salt);

        // Check credentials directly instead of using doLogin to avoid redirects
        $stmt = $pdo->prepare("SELECT u.*, g.group_name as user_group, 
                              CASE WHEN u.user_type = 'admin' THEN 1 ELSE 0 END as is_admin
                              FROM wp_users u
                              LEFT JOIN wp_groups g ON u.group_id = g.id 
                              WHERE u.user_email = ? AND u.user_pass = ? AND u.user_status = '1'");
        $stmt->execute([$email, $newpassword]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            // Set session variables manually (same as doLogin does)
            $_SESSION['front_user_email'] = $user['user_email'];
            $_SESSION['front_user_id'] = $user['ID'];
            $_SESSION['admin'] = $user['is_admin'];
            $_SESSION['user_type'] = $user['user_type']; 
            $_SESSION['user_group'] = $user['user_group']; 
            $_SESSION['user_logged_in'] = true;
            $_SESSION['clear_cache'] = true;
            
            // Refresh session expiry
            $_SESSION['SESSION_EXPIRES'] = time() + getSessionExpirySeconds();
            
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Email or password do not match']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => implode(', ', $errors)]);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Login failed']);
}
?>