<?php
// File: pro_features.php

function isProFeatureEnabled($featureName) {
    global $pdo;
    
    if (!isset($_SESSION['front_user_id'])) {
        return false;
    }
    
    $userId = $_SESSION['front_user_id'];
    
    // Get both user and group details
    $query = "SELECT u.pro_status as user_pro, 
                     u.user_type,
                     u.pro_expiration_date as user_exp,
                     g.pro_status as group_pro,
                     g.pro_expiration_date as group_exp
              FROM wp_users u 
              LEFT JOIN wp_groups g ON u.group_id = g.id
              WHERE u.ID = ?";
              
    $stmt = $pdo->prepare($query);
    $stmt->execute([$userId]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$result) {
        return false;
    }

    // Block pro access if demo user 
    if ($result['user_type'] === 'demo') {
        return false;
    }

    // Check if either user or their group has valid Pro status
    $isUserPro = $result['user_pro'] === 'Pro' && 
                 (!$result['user_exp'] || $result['user_exp'] >= date('Y-m-d'));
                 
    $isGroupPro = $result['group_pro'] === 'Pro' && 
                  (!$result['group_exp'] || $result['group_exp'] >= date('Y-m-d'));

    return $isUserPro || $isGroupPro;
	
	 // Add debug logging
    error_log("User ID: " . $userId);
    error_log("User Pro Status: " . $result['user_pro']);
    error_log("User Exp Date: " . $result['user_exp']);
    error_log("Group Pro Status: " . $result['group_pro']);
    error_log("Group Exp Date: " . $result['group_exp']);
    error_log("Is User Pro: " . ($isUserPro ? 'true' : 'false'));
    error_log("Is Group Pro: " . ($isGroupPro ? 'true' : 'false'));
    
    return $isUserPro || $isGroupPro;
}

function getProFeatures() {
    return [
        'additional_cases',
        // Add more features here as needed, e.g.:
        // 'advanced_reporting',
        // 'custom_scenarios',
    ];
}

/* without user expiration of pro ****************
function upgradeToProVersion() {
    global $pdo;
    $userId = $_SESSION['front_user_id'] ?? null;
    if (!$userId) return false;

    $stmt = $pdo->prepare("UPDATE wp_groups g JOIN wp_users u ON u.user_group = g.group_name SET g.pro_status = 'Pro', g.pro_upgrade_date = CURDATE(), g.pro_expiration_date = DATE_ADD(CURDATE(), INTERVAL 1 YEAR) WHERE u.id = ?");
    return $stmt->execute([$userId]);
}
*************************************************/
/* added user expiration of pro ****************/
function upgradeToProVersion() {
    global $pdo;
    $userId = $_SESSION['front_user_id'] ?? null;
    if (!$userId) return false;

    // Set the upgrade and expiration dates
    $upgradeDate = date('Y-m-d');
    $expirationDate = date('Y-m-d', strtotime('+1 year'));

    // Update the group
    $stmt = $pdo->prepare("UPDATE wp_groups g 
                            JOIN wp_users u ON u.user_group = g.id 
                            SET g.pro_status = 'Pro', 
                                g.pro_upgrade_date = ?, 
                                g.pro_expiration_date = ? 
                            WHERE u.ID = ?");
    $resultGroup = $stmt->execute([$upgradeDate, $expirationDate, $userId]);

    // Update the user
    $stmtUser = $pdo->prepare("UPDATE wp_users SET pro_status = 'Pro', pro_expiration_date = ? WHERE ID = ?");
    $resultUser = $stmtUser->execute([$expirationDate, $userId]);

    return $resultGroup && $resultUser; // Return true if both updates succeed
}
/* end with user expiration of pro *************/

// Usage:
function applyProFeatures() {
    if (isProFeatureEnabled('additional_cases')) {
        // Logic to unlock additional cases
        $GLOBALS['VersionStr'] = "Pro";
    } else {
        $GLOBALS['VersionStr'] = "No";
    }

    // Add more feature checks and implementations as needed
    // if (isProFeatureEnabled('advanced_reporting')) {
    //     // Logic to enable advanced reporting
    // }
}