<?php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');

header('Content-Type: application/json');

// Get logged in user's ID from session
$response = array();

if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];
    
    // Get user's group
    $stmt = $pdo->prepare(
        "SELECT g.group_name 
         FROM wp_groups g 
         JOIN wp_group_members gm ON g.group_id = gm.group_id 
         WHERE gm.user_id = ?"
    );
    $stmt->execute([$user_id]);
    $group = $stmt->fetchColumn();
    
    $response['isIndividual'] = ($group === 'Individuals');
    $response['group'] = $group;
} else {
    $response['error'] = 'User not logged in';
}

echo json_encode($response);