<?php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');

header('Content-Type: application/json');

if (isset($_GET['id'])) {
    $userId = $_GET['id'];
    
    $stmt = $pdo->prepare("
        SELECT 
            u.*,
            g.group_name,
            pg.group_name as previous_group_name
        FROM wp_users u
        LEFT JOIN wp_groups g ON u.group_id = g.id
        LEFT JOIN wp_groups pg ON u.previous_group = pg.id
        WHERE u.id = ?
    ");
    
    $stmt->execute([$userId]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        echo json_encode($user);
    } else {
        echo json_encode(['error' => 'User not found']);
    }
} else {
    echo json_encode(['error' => 'No user ID provided']);
}