<?php
require_once '../includes/include_all.inc.php';
require_once '../includes/session_manager.php';

header('Content-Type: application/json');

$response = [
    'valid' => false,
    'userId' => null,
    'global_termination' => isGlobalSessionTerminationEnabled(),
    'user_set_preference' => false,
    'expired' => false,
    'reason' => null,
    'debug' => []
];

if (isset($_SESSION['front_user_id'])) {
    $current_time = time();
    
    // Add debug info to response
    $response['debug']['current_time'] = $current_time;
    $response['debug']['session_expires'] = $_SESSION['SESSION_EXPIRES'] ?? 'not set';
    $response['debug']['time_remaining'] = isset($_SESSION['SESSION_EXPIRES']) ? ($_SESSION['SESSION_EXPIRES'] - $current_time) : 'N/A';
    $response['debug']['configured_timeout'] = getSessionExpirySeconds();
    
    // Check if session has expired
    if (isset($_SESSION['SESSION_EXPIRES']) && $current_time > $_SESSION['SESSION_EXPIRES']) {
        $response['debug']['action'] = 'session_expired_triggered';
        $response['expired'] = true;
        $response['reason'] = 'session_expired';
        
        // Clear expired session
        $_SESSION['REDIRECT_URL'] = $_SERVER['HTTP_REFERER'] ?? '/';
        session_unset();
        session_destroy();
    } else {
        $response['valid'] = true;
        $response['userId'] = $_SESSION['front_user_id'];
        
        // Get user's session preference flag
        try {
            $stmt = $pdo->prepare("SELECT session_term_set FROM " . PREFIX . "users WHERE ID = ?");
            $stmt->execute([$_SESSION['front_user_id']]);
            $user_flag = $stmt->fetchColumn();
            $response['user_set_preference'] = (bool)$user_flag;
        } catch (Exception $e) {
            $response['user_set_preference'] = false;
        }
        
        // Check license expiration daily
        if (!isset($_SESSION['LAST_EXPIRATION_CHECK']) || ($current_time - $_SESSION['LAST_EXPIRATION_CHECK'] > 86400)) {
            try {
                $stmt = $pdo->prepare("SELECT g.expiration_date FROM " . PREFIX . "users u LEFT JOIN " . PREFIX . "groups g ON u.group_id = g.id WHERE u.ID = ?");
                $stmt->execute([$_SESSION['front_user_id']]);
                $license = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($license && $license['expiration_date'] && strtotime($license['expiration_date']) < $current_time) {
                    $response['valid'] = false;
                    $response['expired'] = true;
                    $response['reason'] = 'license_expired';
                    
                    $_SESSION['REDIRECT_URL'] = $_SERVER['HTTP_REFERER'] ?? '/';
                    session_unset();
                    session_destroy();
                } else {
                    $_SESSION['LAST_EXPIRATION_CHECK'] = $current_time;
                }
            } catch (Exception $e) {
                error_log("License check error: " . $e->getMessage());
            }
        }
    }
}

echo json_encode($response);
?>