<?php
// users.php
// Administration Bootstrap
chdir('../');
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
/* **************** HEADER FROM MAIN (REQUIRED FOR MENU) **************/
include($_SERVER['DOCUMENT_ROOT'] . '/menu.php');
$userDetails = menuUserDetails($_SESSION['front_user_id']);
/* ***************** END HEADER FROM MAIN *****************************/
include($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/header_logic.inc.php');

// current page variable
$current_page = 'users';
$pass_feature = NULL;

if ($_SESSION['user_type'] == 'admin' && !isset($_SESSION['group_id'])) {
    $stmt = $pdo->prepare("SELECT group_id FROM wp_users WHERE id = ?");
    $stmt->execute([$_SESSION['front_user_id']]);
    $_SESSION['group_id'] = $stmt->fetchColumn();
}

// Define visibility permissions for the current user (define globally)
$currentUserCanToggleVisibility = false;
if ($_SESSION['user_type'] === 'super') {
    $currentUserCanToggleVisibility = true;
} elseif ($_SESSION['user_type'] === 'admin') {
    $currentUserCanToggleVisibility = true; // They can toggle, but only for their group users
}

// visibility status
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'toggle_visibility') {
    header('Content-Type: application/json');
    
    try {
        if (empty($_POST['id']) || empty($_POST['status'])) {
            throw new Exception('Missing required parameters');
        }
        
        $id = $_POST['id'];
        $isHidden = ($_POST['status'] === 'hidden') ? 1 : 0;
        
		// Check permissions
		$canModify = false;
		if ($_SESSION['user_type'] === 'super') {
			$canModify = true;
		} elseif ($_SESSION['user_type'] === 'admin') {
			if (!isset($_SESSION['group_id'])) {
				$stmt = $pdo->prepare("SELECT group_id FROM wp_users WHERE id = ?");
				$stmt->execute([$_SESSION['front_user_id']]);
				$_SESSION['group_id'] = $stmt->fetchColumn();
			}
		}

		// Check permissions for visibility toggle (separate from other modify permissions)
		$canToggleVisibility = false;
		if ($_SESSION['user_type'] === 'super') {
			$canToggleVisibility = true;
		} elseif ($_SESSION['user_type'] === 'admin') {
			// Check if the user being modified belongs to the admin's group
			$stmt = $pdo->prepare("SELECT group_id FROM wp_users WHERE id = ?");
			$stmt->execute([$id]);
			$targetUserGroupId = $stmt->fetchColumn();
			
			if ($targetUserGroupId == $_SESSION['group_id']) {
				$canToggleVisibility = true;
			}
		}

		if (!$canToggleVisibility) {
			throw new Exception('Permission denied');
		}
        
        $stmt = $pdo->prepare("UPDATE wp_users SET is_hidden = ? WHERE id = ?");
        $success = $stmt->execute([$isHidden, $id]);
        
        if (!$success) {
            throw new Exception('Failed to update user visibility');
        }
        
        echo json_encode(['success' => true]);
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    }
    exit;
}

// Pagination settings
$resultsPerPage = 100;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $resultsPerPage;

// Default sorting
$orderBy = "ORDER BY user_email ASC";

// Handle various sorting options
$sortColumns = [
    'email' => 'user_email',
    'fname' => 'first_name',
    'lname' => 'last_name',
    'date' => 'user_registered',
    'group' => 'group_id',
    'role' => 'user_type',
    'pro' => 'pro_status'
];

foreach ($sortColumns as $param => $column) {
    if (isset($_GET["{$param}sort"])) {
        $direction = ($_GET["{$param}sort"] === "asc") ? "ASC" : "DESC";
        $orderBy = "ORDER BY $column $direction";
        ${$param . "SortNext"} = ($_GET["{$param}sort"] === "asc") ? "desc" : "asc";
        ${$param . "Label"} = ($_GET["{$param}sort"] === "asc") ? "▲ Z-A" : "▼ A-Z";
    } else {
        ${$param . "SortNext"} = "asc";
        ${$param . "Label"} = "▼ A-Z";
    }
}

$proStatusSortNext = isset($_GET['prostatussort']) && $_GET['prostatussort'] === 'asc' ? 'desc' : 'asc';
$proStatusLabel = isset($_GET['prostatussort']) && $_GET['prostatussort'] === 'asc' ? '▲ Z-A' : '▼ A-Z';

// Check user type
$userType = $_SESSION['user_type'] ?? '';
$userWhere = "";
$params = array();
if ($userType == 'admin') {
    $userWhere = " WHERE u.group_id = :group_id ";
    $params[':group_id'] = $_SESSION['group_id'];
}

$searchTerm = isset($_GET['search']) ? trim($_GET['search']) : '';
$showHidden = isset($_GET['show_hidden']) ? (bool)$_GET['show_hidden'] : false;

// Main query
$baseQuery = "SELECT
    u.id,
    u.user_login,
    u.first_name,
    u.last_name,
    u.user_email,
    u.user_pass,
    u.user_pass_clear,
    u.group_id,
	u.user_group,
    g.group_name,  
    u.user_type,
    u.user_registered,
    u.pro_status,
    u.is_hidden,
    g.pro_status AS group_pro_status,
    (SELECT COUNT(*) FROM wp_groupusers_data d WHERE d.user_id = u.id) AS numcases
FROM wp_users u
LEFT JOIN wp_groups g ON u.group_id = g.id";

$whereConditions = [];
$params = [];

if ($userType == 'admin') {
    $whereConditions[] = "u.group_id = :group_id";
    $params[':group_id'] = $_SESSION['group_id'];
}

if (!empty($searchTerm)) {
    $whereConditions[] = "u.user_email LIKE :searchTerm";
    $params[':searchTerm'] = '%' . $searchTerm . '%';
}

// Fetch visible users
$visibleQuery = $baseQuery;
if (!empty($whereConditions)) {
    $visibleQuery .= " WHERE " . implode(" AND ", $whereConditions);
    $visibleQuery .= " AND (u.is_hidden = 0 OR u.is_hidden IS NULL)";
} else {
    $visibleQuery .= " WHERE (u.is_hidden = 0 OR u.is_hidden IS NULL)";
}
$visibleQuery .= " $orderBy LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($visibleQuery);
$stmt->bindValue(':limit', $resultsPerPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
foreach ($params as $key => $value) {
    $stmt->bindValue($key, $value);
}
$stmt->execute();
$visibleUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch hidden users
$hiddenUsers = [];
if ($showHidden) {
    $hiddenQuery = $baseQuery;
    if (!empty($whereConditions)) {
        $hiddenQuery .= " WHERE " . implode(" AND ", $whereConditions);
        $hiddenQuery .= " AND u.is_hidden = 1";
    } else {
        $hiddenQuery .= " WHERE u.is_hidden = 1";
    }
    $hiddenQuery .= " $orderBy LIMIT :limit OFFSET :offset";
    
    $stmt = $pdo->prepare($hiddenQuery);
    $stmt->bindValue(':limit', $resultsPerPage, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }
    $stmt->execute();
    $hiddenUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Count total for pagination
$countQuery = $baseQuery;
if (!empty($whereConditions)) {
    $countQuery .= " WHERE " . implode(" AND ", $whereConditions);
    if (!$showHidden) {
        $countQuery .= " AND (u.is_hidden = 0 OR u.is_hidden IS NULL)";
    }
} else if (!$showHidden) {
    $countQuery .= " WHERE (u.is_hidden = 0 OR u.is_hidden IS NULL)";
}

$countStmt = $pdo->prepare("SELECT COUNT(*) FROM ($countQuery) as counted_query");
$countStmt->execute($params);
$totalUsers = $countStmt->fetchColumn();

$totalPages = ceil($totalUsers / $resultsPerPage);
$page = max(1, min($page, $totalPages));

// Pagination URL
function paginationUrl($page) {
    $params = $_GET;
    $params['page'] = $page;
    return '?' . http_build_query($params);
}

include($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Management</title>
    <script type="text/javascript">
        function confirmDeleteGeneric() {
            return confirm("Are You Sure You Want To Delete? There is no undo!");
        }
    </script>
</head>
<body>

	<div id="notification" class="notify-bubble">
		<span class="notification-close">&times;</span>
		<span class="notification-message"></span>
	</div>

<div class="visibility-toggle-container">
    <label class="switch">
        <input type="checkbox" id="showHiddenToggle" <?php echo $showHidden ? 'checked' : ''; ?>>
        <span class="slider round"></span>
    </label>
    <span>Show Hidden Users</span>
</div>
<div class="table-cont">
	
	<?php /* hidden table */ ?>
	<?php if ($showHidden && !empty($hiddenUsers)): ?>
		<h2 class="overview-title">Hidden Users</h3>
		<table class="home-table<?php if ($userType == 'admin'): ?> 55-table<?php endif; ?>">
			<tr>
				<th class="tbl-id">ID</th>
				<th class="tbl-email">Email&nbsp;&nbsp;<a class="sort" href="users.php?emailsort=<?= $emailSortNext ?>&page=<?= $page ?>"><?= $emailLabel ?></a></th>
				<?php if ($_SESSION['user_type'] === 'super' && $pass_feature === 'Active'): ?>
					<th class="tbl-pass">User Pass</th>
					<th class="tbl-custom" alt="Does user have a custom pass or is it the same as group pass?" title="Does user have a custom pass or is it the same as group pass?">Pass</th>
				<?php endif; ?>
				<?php if ($userType === 'nulls'): ?>
					<th style="text-align:center;">First Name&nbsp;&nbsp;<a class="sort" href="users.php?fnamesort=<?= $fnameSortNext ?>&page=<?= $page ?>"><?= $fnameLabel ?></a></th>
					<th style="text-align:center;">Last Name&nbsp;&nbsp;<a class="sort" href="users.php?lnamesort=<?= $lnameSortNext ?>&page=<?= $page ?>"><?= $lnameLabel ?></a></th>
				<?php endif; ?>
				<th width="9%" style="text-align:center;">Added&nbsp;&nbsp;<a class="sort" href="users.php?datesort=<?= $dateSortNext ?>&page=<?= $page ?>"><?= $dateLabel ?></a></th>
				<?php if ($userType === 'super'): ?>
					<th class="tbl-group">Group&nbsp;&nbsp;<a class="sort" href="users.php?groupsort=<?= $groupSortNext ?>&page=<?= $page ?>"><?= $groupLabel ?></a></th>
					<th width="3%" style="text-align:center;">Role&nbsp;&nbsp;<a class="sort" href="users.php?rolesort=<?= $roleSortNext ?>&page=<?= $page ?>"><?= $roleLabel ?></a></th>
					<th width="6%" style="text-align:center;">Pro&nbsp;&nbsp;<a class="sort" href="users.php?prostatussort=<?= $proStatusSortNext ?>&page=<?= $page ?>"><?= $proStatusLabel ?></a></th>
				<?php endif; ?>
				<th width="3%" style="text-align:center;">Cases</th>
				<th width="3%" style="text-align:center;">View Cases</th>
				<th width="3%" style="text-align:center;">Edit User</th>
				<?php if ($userType === 'super'): ?>
					<!-- <th width="3%" style="text-align:center;">Delete User</th> -->
				<?php endif; ?>
				<?php if ($currentUserCanToggleVisibility): ?>
					<th style="text-align:center;">Visibility</th>
				<?php endif; ?>
			</tr>
			<?php foreach ($hiddenUsers as $user): ?>
				<tr>
					<td><?= htmlspecialchars($user['id']); ?></td>
					<td><?= htmlspecialchars($user['user_email']); ?></td>
					<?php if ($_SESSION['user_type'] === 'super' && $pass_feature === 'Active'): ?>
						<td><?= htmlspecialchars($user['user_pass_clear']); ?></td>
						<td><?php 
							$stmt = $pdo->prepare("SELECT group_pass FROM wp_groups WHERE id = ?");
							$stmt->execute([$user['group_id']]);
							$groupPass = $stmt->fetchColumn();
							echo ($user['user_pass'] == $groupPass) ? 'Default' : 'Custom';
						?></td>
					<?php endif; ?>
					<?php if ($userType === 'nulls'): ?>
						<td><?= htmlspecialchars($user['first_name']); ?></td>
						<td><?= htmlspecialchars($user['last_name']); ?></td>
					<?php endif; ?>
					<td style="text-align:center;"><?= date('Y-m-d', strtotime($user['user_registered'])); ?></td>
					<?php if ($userType === 'super'): ?>
						<td><?= htmlspecialchars($user['group_name']); ?></td>
						<td style="text-align:center;" onclick="event.stopPropagation()">
							<select onclick="event.stopPropagation()" class="user-role-dropdown" data-id="<?= htmlspecialchars($user['id']) ?>">
								<option value="user" <?= $user['user_type'] === 'user' ? 'selected' : '' ?>>User</option>
								<option value="admin" <?= $user['user_type'] === 'admin' ? 'selected' : '' ?>>Admin</option>
								<option value="super" <?= $user['user_type'] === 'super' ? 'selected' : '' ?>>Super</option>
								<option value="demo" <?= $user['user_type'] === 'demo' ? 'selected' : '' ?>>Demo</option>
							</select>
						</td>
						<td onclick="event.stopPropagation()">
							<?php
							$isProUser = ($user['pro_status'] === 'Pro' || ($user['group_pro_status'] === 'Pro' && $user['group_id'] !== 'Individuals'));
							$dropdownClass = $isProUser ? 'pro-enabled' : 'pro-disabled';
							?>
							<select onclick="event.stopPropagation()" class="user-pro-status-dropdown <?php echo $dropdownClass; ?>" data-id="<?= htmlspecialchars($user['id']) ?>" <?php echo $isProUser ? '' : ''; ?>>
								<option value="No" <?= $user['pro_status'] === 'No' && $user['group_pro_status'] !== 'Pro' ? 'selected' : '' ?>>No</option>
								<option value="Pro" <?= $user['pro_status'] === 'Pro' ? 'selected' : '' ?>>Pro</option>
								<option value="Expired" <?= $user['pro_status'] === 'Expired' && $user['group_pro_status'] !== 'Pro' ? 'selected' : '' ?>>Expired</option>
								<option value="Suspended" <?= $user['pro_status'] === 'Suspended' && $user['group_pro_status'] !== 'Pro' ? 'selected' : '' ?>>Suspended</option>
							</select>
						</td>
					<?php endif; ?>
					<td style="text-align:center;"><?= $user['numcases'] ?? '0'; ?></td>
					<td style="text-align:center;">
						<?php if ($user['numcases'] > 0): ?>
							<a href="casessummary.php?id=<?= $user['id'] ?>">View Cases</a>
						<?php else: ?>
							&nbsp;
						<?php endif; ?>
					</td>
					<td style="text-align:center;"><a href="#" class="edit-user" data-id="<?= htmlspecialchars($user['id'] ?? '') ?>">Edit</a></td>
					<?php if ($userType === 'super'): ?>
						<!-- <td style="text-align:center;">
							<a href='deleteuser.php?id=<?= $user["id"] ?>' onclick='return confirmDeleteGeneric()'>Delete</a>
						</td> -->
					<?php endif; ?>
					<?php if ($userType == 'super' || ($userType == 'admin' && $user['group_id'] == $_SESSION['group_id'])): ?>
						<td style="text-align:center;">
							<button class="visibility-toggle-btn" 
									data-id="<?= $user['id'] ?>" 
									data-type="user"
									data-status="<?= $user['is_hidden'] ? 'hidden' : 'visible' ?>">
								<?= $user['is_hidden'] ? 'Show' : 'Hide' ?>
							</button>
						</td>
					<?php endif; ?>
				</tr>
			<?php endforeach; ?>
		</table>
	<?php endif; ?>
	
	<h2 class="overview-title">Users 
		<?php if ($usertype == 'super') { ?>
			<a href="newuser" class="active newbtn">New User</a>
		<?php } ?></h2>
		

    <!-- Add search input -->
	<div class="search-container">
		<form method="GET" action="users.php" id="usersSearchForm">
			<input type="text" id="searchInput" name="search" class="admin-search-input" placeholder="Search users..." value="<?= htmlspecialchars($searchTerm ?? '') ?>">
			<button type="submit" class="admin-search-button">Search</button>
			<?php if (!empty($searchTerm)): ?>
				<a href="<?php 
					$params = $_GET;
					unset($params['search']); 
					unset($params['page']); 
					echo '?' . http_build_query($params); 
				?>" class="clear-search-button">Clear</a>
			<?php endif; ?>
			<?php
			// Preserve existing GET parameters in hidden fields
			foreach ($_GET as $key => $value) {
				if ($key !== 'search' && $key !== 'page') {
					echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
				}
			}
			?>
		</form>
	</div>
	<script src="/admin/js/search-filter-users-new.js"></script>

    <!-- Pagination links -->
    <div class="pagination pagination-top">
        <?php if ($totalPages > 1): ?>
            <?php if ($page > 1): ?>
                <a href="<?= paginationUrl(1) ?>">&laquo; First</a>
                <a href="<?= paginationUrl($page - 1) ?>">&lsaquo; Previous</a>
            <?php endif; ?>

            <?php
            $range = 2;
            $showLeft = $page - $range;
            $showRight = $page + $range;

            for ($i = 1; $i <= $totalPages; $i++) {
                if ($i == 1 || $i == $totalPages || ($i >= $showLeft && $i <= $showRight)) {
                    echo '<a href="' . paginationUrl($i) . '"' . 
                         ($i == $page ? ' class="active"' : '') . '>' . $i . '</a>';
                } elseif ($i == $showLeft - 1 || $i == $showRight + 1) {
                    echo '<span class="ellipsis">...</span>';
                }
            }
            ?>

            <?php if ($page < $totalPages): ?>
                <a href="<?= paginationUrl($page + 1) ?>">Next &rsaquo;</a>
                <a href="<?= paginationUrl($totalPages) ?>">Last &raquo;</a>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <table class="home-table<?php if ($userType == 'admin'): ?> 55-table<?php endif; ?>">
        <tr>
            <th class="tbl-id">ID</th>
            <th class="tbl-email">Email&nbsp;&nbsp;<a class="sort" href="users.php?emailsort=<?= $emailSortNext ?>&page=<?= $page ?>"><?= $emailLabel ?></a></th>
			<?php if ($_SESSION['user_type'] === 'super' && $pass_feature === 'Active'): ?>
				<th class="tbl-pass">User Pass</th>
				<th class="tbl-custom" alt="Does user have a custom pass or is it the same as group pass?" title="Does user have a custom pass or is it the same as group pass?">Pass</th>
			<?php endif; ?>
            <?php if ($userType === 'nulls'): /* hide for everyone for now since empty */ ?>
                <th style="text-align:center;">First Name&nbsp;&nbsp;<a class="sort" href="users.php?fnamesort=<?= $fnameSortNext ?>&page=<?= $page ?>"><?= $fnameLabel ?></a></th>
                <th style="text-align:center;">Last Name&nbsp;&nbsp;<a class="sort" href="users.php?lnamesort=<?= $lnameSortNext ?>&page=<?= $page ?>"><?= $lnameLabel ?></a></th>
            <?php endif; ?>
            <th width="9%" style="text-align:center;">Added&nbsp;&nbsp;<a class="sort" href="users.php?datesort=<?= $dateSortNext ?>&page=<?= $page ?>"><?= $dateLabel ?></a></th>
            <?php if ($userType === 'super'): ?>
                <th class="tbl-group">Group&nbsp;&nbsp;<a class="sort" href="users.php?groupsort=<?= $groupSortNext ?>&page=<?= $page ?>"><?= $groupLabel ?></a></th>
            <?php endif; ?>
            <?php if ($userType === 'super'): ?>
                <th width="3%" style="text-align:center;">Role&nbsp;&nbsp;<a class="sort" href="users.php?rolesort=<?= $roleSortNext ?>&page=<?= $page ?>"><?= $roleLabel ?></a></th>
				<th width="6%" style="text-align:center;">Pro&nbsp;&nbsp;<a class="sort" href="users.php?prostatussort=<?= $proStatusSortNext ?>&page=<?= $page ?>"><?= $proStatusLabel ?></a></th>
			<?php endif; ?>
            <th width="3%" style="text-align:center;">Cases</th>
            <th width="3%" style="text-align:center;">View Cases</th>
            <th width="3%" style="text-align:center;">Edit User</th>
            <?php if ($userType === 'super'): ?>
                <!-- <th width="3%" style="text-align:center;">Delete User</th> -->
            <?php endif; ?>
			<?php if ($userType == 'super' || $userType == 'admin'): ?>
				<th style="text-align:center;">Visibility</th>
			<?php endif; ?>
        </tr>
        <?php foreach ($visibleUsers as $user): ?>
		<tr class="<?php echo $user['is_hidden'] ? 'hidden-row' : ''; ?>">
            <td><?= htmlspecialchars($user['id']); ?></td>
            <td><?= htmlspecialchars($user['user_email']); ?></td>
			<?php if ($_SESSION['user_type'] === 'super' && $pass_feature === 'Active'): ?>
				<td><?= htmlspecialchars($user['user_pass_clear']); ?></td>
				<td><?php 
					$stmt = $pdo->prepare("SELECT group_pass FROM wp_groups WHERE id = ?");
					$stmt->execute([$user['group_id']]);
					$groupPass = $stmt->fetchColumn();
					echo ($user['user_pass'] == $groupPass) ? 'Default' : 'Custom';
				?></td>
			<?php endif; ?>
            <?php if ($userType === 'nulls'): /* hide for everyone for now since empty */ ?>
                <td><?= htmlspecialchars($user['first_name']); ?></td>
                <td><?= htmlspecialchars($user['last_name']); ?></td>
            <?php endif; ?>
            <td style="text-align:center;"><?= date('Y-m-d', strtotime($user['user_registered'])); ?></td>
            <?php if ($userType === 'super'): ?>
                <td><?= $user['group_name'] ? htmlspecialchars($user['group_name']) : 'No Group Assigned'; ?></td>
            <?php endif; ?>
            <?php if ($userType === 'super'): ?>
                <td style="text-align:center;" onclick="event.stopPropagation()">
					<select onclick="event.stopPropagation()" class="user-role-dropdown" data-id="<?= htmlspecialchars($user['id']) ?>">
						<option value="user" <?= $user['user_type'] === 'user' ? 'selected' : '' ?>>User</option>
						<option value="admin" <?= $user['user_type'] === 'admin' ? 'selected' : '' ?>>Admin</option>
						<option value="super" <?= $user['user_type'] === 'super' ? 'selected' : '' ?>>Super</option>
						<option value="demo" <?= $user['user_type'] === 'demo' ? 'selected' : '' ?>>Demo</option>
					</select>
				</td>
				<td onclick="event.stopPropagation()">
					<?php
					$isProUser = ($user['pro_status'] === 'Pro' || ($user['group_pro_status'] === 'Pro' && $user['group_id'] !== 'Individuals'));
					$dropdownClass = $isProUser ? 'pro-enabled' : 'pro-disabled';
					?>
					<select onclick="event.stopPropagation()" class="user-pro-status-dropdown <?php echo $dropdownClass; ?>" data-id="<?= htmlspecialchars($user['id']) ?>" <?php echo $isProUser ? '' : ''; ?>>
						<option value="No" <?= $user['pro_status'] === 'No' && $user['group_pro_status'] !== 'Pro' ? 'selected' : '' ?>>No</option>
						<option value="Pro" <?= $user['pro_status'] === 'Pro' ? 'selected' : '' ?>>Pro</option>
						<option value="Expired" <?= $user['pro_status'] === 'Expired' && $user['group_pro_status'] !== 'Pro' ? 'selected' : '' ?>>Expired</option>
						<option value="Suspended" <?= $user['pro_status'] === 'Suspended' && $user['group_pro_status'] !== 'Pro' ? 'selected' : '' ?>>Suspended</option>
					</select>
				</td>
            <?php endif; ?>
            <td style="text-align:center;"><?= $user['numcases'] ?? '0'; ?></td>
            <td style="text-align:center;">
                <?php if ($user['numcases'] > 0): ?>
                    <a href="casessummary.php?id=<?= $user['id'] ?>">View Cases</a>
                <?php else: ?>
                    &nbsp;
                <?php endif; ?>
            </td>
            <td style="text-align:center;"><a href="#" class="edit-user" data-id="<?= htmlspecialchars($user['id'] ?? '') ?>">Edit</a></td>
            <?php if ($userType === 'super'): ?>
                <!-- <td style="text-align:center;">
                    <a href='deleteuser.php?id=<?= $user["id"] ?>' onclick='return confirmDeleteGeneric()'>Delete</a>
                </td> -->
            <?php endif; ?>
			<?php if ($currentUserCanToggleVisibility && ($_SESSION['user_type'] === 'super' || $user['group_id'] == $_SESSION['group_id'])): ?>
				<td style="text-align:center;">
					<button class="visibility-toggle-btn" 
							data-id="<?= $user['id'] ?>" 
							data-type="user"
							data-status="<?= $user['is_hidden'] ? 'hidden' : 'visible' ?>">
						<?= $user['is_hidden'] ? 'Show' : 'Hide' ?>
					</button>
				</td>
			<?php endif; ?>
        </tr>
        <?php endforeach; ?>
    </table>

    <!-- Pagination links -->
    <div class="pagination pagination-bottom">
        <?php if ($totalPages > 1): ?>
            <?php if ($page > 1): ?>
                <a href="<?= paginationUrl(1) ?>">&laquo; First</a>
                <a href="<?= paginationUrl($page - 1) ?>">&lsaquo; Previous</a>
            <?php endif; ?>

            <?php
            $range = 2;
            $showLeft = $page - $range;
            $showRight = $page + $range;

            for ($i = 1; $i <= $totalPages; $i++) {
                if ($i == 1 || $i == $totalPages || ($i >= $showLeft && $i <= $showRight)) {
                    echo '<a href="' . paginationUrl($i) . '"' . 
                         ($i == $page ? ' class="active"' : '') . '>' . $i . '</a>';
                } elseif ($i == $showLeft - 1 || $i == $showRight + 1) {
                    echo '<span class="ellipsis">...</span>';
                }
            }
            ?>

            <?php if ($page < $totalPages): ?>
                <a href="<?= paginationUrl($page + 1) ?>">Next &rsaquo;</a>
                <a href="<?= paginationUrl($totalPages) ?>">Last &raquo;</a>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Edit User Modal -->
<div id="editUserModal" class="modal" style="display:none;">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>Edit User</h2>
        <form id="editUserForm">
            <input type="hidden" id="userId" name="userId">
            <label for="userEmail">Email:</label>
            <input type="email" id="userEmail" name="userEmail" required>
			<?php if ($_SESSION['user_type'] === 'super' && $pass_feature === 'Active'): ?>
				<label for="userPass">Password:</label>
				<input type="text" id="userPass" name="userPass">
			<?php endif; ?>
            <label for="firstName">First Name:</label>
            <input type="text" id="firstName" name="firstName">
            <label for="lastName">Last Name:</label>
            <input type="text" id="lastName" name="lastName">
			<label for="userGroup">Group:</label>
			<?php if ($userType === 'super') { ?>
				<select id="userGroup" name="userGroup">
					<?php
					$stmt = $pdo->prepare("SELECT id, group_name FROM wp_groups ORDER BY group_name");
					$stmt->execute();
					$groups = $stmt->fetchAll(PDO::FETCH_ASSOC);
					foreach ($groups as $group) {
						echo '<option value="' . htmlspecialchars($group['id']) . '">' . 
							 htmlspecialchars($group['group_name']) . '</option>';
					}
					?>
				</select>
				<div id="previousGroupContainer" style="display:none;">
                    <label for="previousGroup">Previous Group:</label>
                    <div id="previousGroup" class="modal-static"></div>
                </div>
			<?php } else { ?>
				<div id="userGroup" name="userGroup" class="modal-static"></div>
			<?php } ?>
            <label for="userType">User Type:</label>
            <?php if ($userType === 'super') { ?>
                <select id="userType" name="userType">
                    <option value="user">User</option>
                    <option value="admin">Admin</option>
                    <option value="super">Super Admin</option>
					<option value="demo">Demo User</option>
                </select>
            <?php } else { ?>
                <div id="userType" name="userType" class="modal-static"></div>
            <?php } ?>
            <button type="submit">Save Changes</button>
        </form>
    </div>
</div>

<script>
// pro status
$(document).ready(function() {
    function showNotification(message, type = 'success') {
        const notification = $('#notification');
        const messageSpan = notification.find('.notification-message');
        
        notification.css('background', type === 'success' ? '#4CAF50' : '#f44336');
        messageSpan.text(message);
        notification.css('display', 'block');
        
        setTimeout(function() {
            notification.css('opacity', '0');
            setTimeout(function() {
                notification.css('display', 'none');
                notification.css('opacity', '1');
            }, 2000); // match your CSS transition time
        }, 3000);
    }

    // Close button handler
    $('.notification-close').on('click', function() {
        const notification = $('#notification');
        notification.css('opacity', '0');
        setTimeout(function() {
            notification.css('display', 'none');
            notification.css('opacity', '1');
        }, 2000); // match your CSS transition time
    });

    $('.user-pro-status-dropdown').on('change', function() {
        var userId = $(this).data('id');
        var newStatus = $(this).val();
        
        $.ajax({
            url: '../api/update-user-pro-status.php',
            method: 'POST',
            data: {
                userId: userId,
                newStatus: newStatus
            },
            success: function(response) {
                try {
                    var data = JSON.parse(response);
                    if (data.success) {
                        showNotification('User Pro status updated successfully');
                    } else {
                        showNotification('Error updating User Pro status: ' + (data.error || 'Unknown error'), 'error');
                    }
                } catch (e) {
                    showNotification('Error updating User Pro status: Invalid server response', 'error');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showNotification('Error communicating with server', 'error');
            }
        });
    });
});

// user role switch
$(document).ready(function() {
    function showNotification(message, type = 'success') {
        const notification = $('#notification');
        const messageSpan = notification.find('.notification-message');
        
        notification.css('background', type === 'success' ? '#4CAF50' : '#f44336');
        messageSpan.text(message);
        notification.css('display', 'block');
        
        setTimeout(function() {
            notification.css('opacity', '0');
            setTimeout(function() {
                notification.css('display', 'none');
                notification.css('opacity', '1');
            }, 2000); // match your CSS transition time
        }, 3000);
    }

    // Close button handler
    $('.notification-close').on('click', function() {
        const notification = $('#notification');
        notification.css('opacity', '0');
        setTimeout(function() {
            notification.css('display', 'none');
            notification.css('opacity', '1');
        }, 2000); // match your CSS transition time
    });

    $('.user-role-dropdown').on('change', function() {
        var userId = $(this).data('id');
        var newRole = $(this).val();
        
        $.ajax({
            url: '../api/update-user-role.php',
            method: 'POST',
            data: {
                userId: userId,
                newRole: newRole
            },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    showNotification('User role updated successfully');
                } else {
                    showNotification('Error updating user role', 'error');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                showNotification('Error communicating with server', 'error');
            }
        });
    });
});

// edit modal
$(document).ready(function() {
    var modal = document.getElementById("editUserModal");
    var span = document.getElementsByClassName("close")[0];

	$('.edit-user').on('click', function(e) {
		e.preventDefault();
		var userId = $(this).data('id');
		// console.log('Edit clicked for user ID:', userId);  // debugging
		$.get('../api/get-user-details.php', {id: userId}, function(data) {
			try {
				if (typeof data === 'string') {
					data = JSON.parse(data);
				}
				// console.log('Received user data:', data);  // debugging
				$('#userId').val(data.ID);
				$('#userEmail').val(data.user_email);
				$('#firstName').val(data.first_name);
				$('#lastName').val(data.last_name);
				
				if ($('#userGroup').is('select')) {
					$('#userGroup').val(data.group_id);
				} else {
					$('#userGroup').text(data.group_name);
				}
				
				if ($('#userType').is('select')) {
					$('#userType').val(data.user_type);
				} else {
					$('#userType').text(data.user_type);
				}
				
				// handle previous group
				if (data.previous_group_name) {
                    $('#previousGroupContainer').show();
                    $('#previousGroup').text(data.previous_group_name);
                } else {
                    $('#previousGroupContainer').hide();
                }
                
                modal.style.display = "block";
				
				modal.style.display = "block";
			} catch (error) {
				console.error("Error parsing JSON:", error);
			}
		});
	});


    span.onclick = function() {
        modal.style.display = "none";
    }

    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
	
	$('.close').on('click', function() {
		modal.style.display = "none";
	});

	$('#editUserForm').on('submit', function(e) {
		e.preventDefault();
		// console.log('Form submitted');
		var formData = $(this).serializeArray();
		// console.log('Form data:', formData);  // debugging
		
		$.ajax({
			url: 'inc/update-user.php',
			method: 'POST',
			data: formData,
			dataType: 'json',
			success: function(response) {
				console.log('AJAX success:', response);
				if (response.success) {
					console.log('User updated successfully');
					modal.style.display = "none";
					
					var $row = $('a.edit-user[data-id="' + $('#userId').val() + '"]').closest('tr');
					var userType = '<?php echo $_SESSION['user_type']; ?>';
					var numCases = '<?php echo $user['numcases'] ?? '0'; ?>';
					var userId = $('#userId').val();
					
					// Helper function to update cell content while preserving wrapper
					function updateCellContent($cell, content) {
						var $wrapper = $cell.find('.cell-content-wrapper');
						if ($wrapper.length) {
							$wrapper.text(content);
						} else {
							$cell.text(content);
						}
					}
					
					if (userType === 'super') {
						// Update email with wrapper
						updateCellContent($row.find('td:eq(1)'), response.data.user_email);
						
						// Update registration date
						updateCellContent($row.find('td:eq(2)'), response.data.user_registered);
						
						// Update group name
						updateCellContent($row.find('td:eq(3)'), response.data.group_name);
						
						// Handle role dropdown
						var $roleCell = $row.find('td:eq(4)');
						var userRole = response.data.user_type;
						
						// Check if we need to rebuild the dropdown
						if (!$roleCell.find('select.user-role-dropdown').length) {
							// The dropdown is missing, rebuild it
							var $wrapper = $('<div class="cell-content-wrapper" style="max-height: 50px; overflow: hidden auto; display: block;"></div>');
							var $select = $('<select onclick="event.stopPropagation()" class="user-role-dropdown" data-id="' + userId + '"></select>');
							$select.append('<option value="user"' + (userRole === 'user' ? ' selected' : '') + '>User</option>');
							$select.append('<option value="admin"' + (userRole === 'admin' ? ' selected' : '') + '>Admin</option>');
							$select.append('<option value="super"' + (userRole === 'super' ? ' selected' : '') + '>Super</option>');
							$select.append('<option value="demo"' + (userRole === 'demo' ? ' selected' : '') + '>Demo</option>');
							
							$wrapper.append($select);
							$roleCell.html('').append($wrapper);
						} else {
							// The dropdown exists, just update the selected value
							$roleCell.find('select.user-role-dropdown').val(userRole);
						}
						
						// Update case count
						updateCellContent($row.find('td:eq(5)'), response.data.numCases);
					} else {
						// For admin users
						updateCellContent($row.find('td:eq(1)'), response.data.user_email);
						updateCellContent($row.find('td:eq(2)'), response.data.user_registered);
						updateCellContent($row.find('td:eq(3)'), response.data.numCases);
					}
					
					// console.log('Table row updated');
				} else {
					// Show error message and keep modal open
					alert('Error: ' + (response.error || 'Unknown error'));
					console.error('Error updating user:', response.error || 'Unknown error');
					
					// Make sure the modal stays open
					modal.style.display = "block";
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				// Show error in notification
				alert('Error: ' + errorThrown);
				console.error('AJAX error:', textStatus, errorThrown);
				console.log('Server response:', jqXHR.responseText);
				
				// Make sure the modal stays open
				modal.style.display = "block";
			}

		});
	});

});
</script>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>

</body>
</html>
