
	</div> 
	<?php /*******************************/ 
	require_once 'inc/profile_picture_admin.php';
	
	// required to put this here to fetch it
	if($_SESSION['user_type'] == 'super') {
	    $usertype = 'super';
	} else {
	    $usertype = 'admin';
	}
	
	$roletitle = "";
	$license = "";
	$proStatus = "";
	
	if($usertype == 'admin') {
		$roletitle = "Group Admin";
	} else {
		$roletitle = "Super Admin";
	}
	
	// set license var based on status
	$query = "SELECT 
		group_status,
		expiration_date
	FROM wp_groups
	LIMIT 1";

	$stmt = $pdo->prepare($query);
	$stmt->execute();
	$row = $stmt->fetch(PDO::FETCH_ASSOC);
	
	// now checks if 60 days till expire and changes tag to "renew" -- later will change to a renew link
	if ($usertype == 'admin') {
		// Get fresh user and group data for every page load
		$query = "SELECT g.group_status, g.expiration_date, g.pro_status, g.pro_expiration_date, g.group_name,
						 u.user_email, u.first_name, u.last_name 
				  FROM wp_users u
				  JOIN wp_groups g ON g.id = u.group_id
				  WHERE u.id = :user_id 
				  LIMIT 1";
		$stmt = $pdo->prepare($query);
		$stmt->execute([':user_id' => $_SESSION['front_user_id']]);
		$userData = $stmt->fetch(PDO::FETCH_ASSOC);

		if ($userData) {
			$expirationDate = new DateTime($userData['expiration_date']);
			$currentDate = new DateTime();
			
			// If it's set as Permanent, always show that
			if ($userData['group_status'] == 'Permanent') {
				$license = 'Permanent';
				$licenseExpirationDate = 'Never';
			}
			// For Active accounts, check expiration
			else if ($userData['group_status'] == 'Active') {
				$daysDifference = $currentDate->diff($expirationDate)->days;
				if ($daysDifference <= 60 && $daysDifference > 0) {
					$license = "Renew";
				} else if ($daysDifference <= 0) {
					$license = "Expired";
				} else {
					$license = "Active";
				}
				$licenseExpirationDate = ($expirationDate instanceof DateTime) ? $expirationDate->format('Y-m-d') : $userData['expiration_date'];
			}
			// For all other statuses, use what's set in the database
			else {
				$license = $userData['group_status']; // Will be Inactive, Expired, Suspended, or Unknown
				$licenseExpirationDate = ($expirationDate instanceof DateTime) ? $expirationDate->format('Y-m-d') : $userData['expiration_date'];
			}

			// Handle Pro status
			if ($userData['pro_status'] === 'Pro') {
				if (!empty($userData['pro_expiration_date'])) {
					$proExpirationDateObj = new DateTime($userData['pro_expiration_date']);
					$daysUntilExpiration = $currentDate->diff($proExpirationDateObj)->days;
					$proStatus = ($proExpirationDateObj < $currentDate) ? 'Expired' : ($daysUntilExpiration <= 30 ? 'Renew' : 'Pro');
					$proExpirationDate = $proExpirationDateObj->format('Y-m-d');
				} else {
					$proStatus = 'Pro';
					$proExpirationDate = 'Never';
				}
			} else {
				$proStatus = 'Upgrade';
				$proExpirationDate = '';
			}

			// Update session values with fresh data
			$_SESSION['front_user_email'] = $userData['user_email'];
			$_SESSION['front_name'] = $userData['first_name'] . ' ' . $userData['last_name'];
			$_SESSION['user_group'] = $userData['group_name'];  // Added this line
		} else {
			$license = $proStatus = "Unknown";
			$licenseExpirationDate = $proExpirationDate = "Unknown";
		}
	} else if ($usertype == 'super') {
		$license = "Super";
		$licenseExpirationDate = "Never";
		$proStatus = "Pro";
		$proExpirationDate = "Never";
	}
	?>
	
<?php /* *********************************************
<?php /* html version for display * ?>

	<div class="top-menu" style="display: none;">
		<div class="logo">
			<a href="https://app.anesoft.com"><img src="https://app.anesoft.com/images/logo/logo-new-dark.png" title="Anesoft">
			</a>
		</div>
		<div class="center-title"><?php echo SITE_TITLE; ?> &nbsp; | &nbsp; Admin Dashboard</div>
		<div class="user-menu">
			<div class="my-account" id="my-account">
				<span>My Account</span>
<div class="profile-picture-container">
    <!-- Debug: Session user ID: 3 --><!-- Debug: getProfilePictureUrl function not found --><div class="icon-circle"><i class="fas fa-user-circle"></i></div></div>
			</div>
			<div class="hamburger-menu" id="hamburger-menu">
				<div class="bar1"></div>
				<div class="bar2"></div>
				<div class="bar3"></div>
			</div>
		</div>
	</div>

<?php /* *********************************************/ ?>

		  
<?php /* *************** top menu ********************/ ?>

	<?php /* if (hasProfilePicture($current_user['id'])): echo '<img src="' . getProfilePictureUrl($current_user['id']); . '" alt="Profile Picture" class="profile-picture">'; endif; */ ?>

	<div class="top-menu">
		<div class="logo">
			<a href="<?php echo MYSITE_URL; ?>/admin"><img src="<?php echo MYSITE_URL; ?>/images/logo/logo-new-dark.png" title="<?php echo COMPANY_NAME; ?>">
			</a>
		</div>
		<div class="center-title"><?php echo SITE_TITLE; ?></div>
		<div class="user-menu">
			<div class="my-account" id="my-account">
				<span>My Account</span>

				<div class="profile-picture-container">
					<?php
					$userId = $_SESSION['front_user_id'];
					echo "<!-- Debug: Session user ID: " . $userId . " -->";
					
					if (function_exists('getProfilePictureUrlAdmin')) {
						$profile_picture_url = getProfilePictureUrlAdmin($userId);
						if ($profile_picture_url) {
							echo '<img src="' . htmlspecialchars($profile_picture_url) . '" alt="Profile Picture" class="profile-picture">';
						} else {
							echo '<div class="icon-circle"><i class="fas fa-user-circle"></i></div>';
						}
					} else {
						echo '<div class="icon-circle"><i class="fas fa-user-circle"></i></div>';
					}
					?>
				</div>
			</div>
			
			<div class="hamburger-menu" id="hamburger-menu" style="display: none;">
				<div class="bar1"></div>
				<div class="bar2"></div>
				<div class="bar3"></div>
			</div>
		</div>
	</div>

	<div class="menu my-account-menu" id="my-account-menu">
		<ul>
			
			<li class="admin-menu admin-dash-btn theme-toggle simmulator-link">
				<a href="../">Go To Simulator</a>
				<i class="fa fa-arrow-circle-right"></i>
			</li>

			<hr>

			<div class="just-info-outer">
				<li class="just-info">
				  <div class="text-wrapper">
					<div class="inner-text"><?php echo htmlspecialchars($userDetails['email']); ?></div>
				  </div>
				  <i class="fas fa-copy copy-icon"></i>
				  <span class="info-mark"><i class="fa fa-info"></i><span class="info-tag">Email</span></span>
				</li>
				<li class="just-info">
				  <div class="text-wrapper">
					<div class="inner-text-group"><?php echo htmlspecialchars($userDetails['group']); ?></div>
				  </div>
				  <span class="info-mark"><i class="fa fa-info"></i><span class="info-tag">Group</span></span>
				</li>
				<?php if ($userDetails['is_admin'] == 1) {?>
					<li class="just-info user-type-menu">Administrator
						<span class="info-mark"><i class="fa fa-info"></i>
							<span class="info-tag">User Role</span>
						</span>
					</li>
				<?php } ?>
				<li class="pro-button">
					<?php if ($license === 'Inactive' || $license === 'Expired'): ?>
						<a href="#" id="proButton" data-status="Inactive" data-expiration="" 
						   onclick="try { showLicenseModal('<?= htmlspecialchars($license); ?>', '<?= htmlspecialchars($licenseExpirationDate); ?>'); } catch(e) { console.error(e); }">
							Renew License
						</a>
					<?php else: ?>
						<a href="#" id="proButton" 
						   data-status="<?= htmlspecialchars(strtolower($proStatus)); ?>" 
						   data-expiration="<?= ($proExpirationDate instanceof DateTime) ? htmlspecialchars($proExpirationDate->format('Y-m-d')) : htmlspecialchars($proExpirationDate); ?>" 
						   onclick="try { showProModal('<?= htmlspecialchars($proStatus); ?>', '<?= ($proExpirationDate instanceof DateTime) ? htmlspecialchars($proExpirationDate->format('Y-m-d')) : htmlspecialchars($proExpirationDate); ?>'); } catch(e) { console.error(e); }">
							<?php 
								$modalContent = json_decode(file_get_contents($_SERVER['DOCUMENT_ROOT'] . '/app/modal_data/modal-content.json'), true);
								$statusText = $modalContent['proModal']['statusText'] ?? [];
								
								switch($proStatus) {
									case 'Pro':
										echo $statusText['Pro'] ?? 'Pro Active';
										break;
									case 'Renew':
										echo $statusText['Renew'] ?? 'Renew Pro';
										break;
									case 'Expired':
										echo $statusText['Expired'] ?? 'Renew Pro';
										break;
									case 'Super':
										echo $statusText['Pro'] ?? 'Pro Active';
										break;
									default:
										echo $statusText['Upgrade'] ?? 'Upgrade to Pro';
								}
							?>
						</a>
					<?php endif; ?>
				</li>
			</div>
			
			<li class="admin-menu theme-toggle" id="theme-toggle">
				<i class="fas fa-moon"></i>
				<span>Theme: Dark</span>
			</li>

			<hr>

			<li class="admin-menu theme-toggle compact-toggle" id="compact-toggle">
				<i class="fas fa-expand"></i>
				<span>Expanded Mode</span>
			</li>

			<hr>

			<li class="admin-menu change-profile-picture">
				<i class="fas fa-camera"></i>
				<span>Change Profile Picture</span>
			</li>

			<hr>
			
			<?php /* 
			<li class="admin-menu my-settings-btn">
				<i class="fas fa-cog"></i>
				<a href="settings">My Profile</a>
			</li>
			*/ ?>

			<?php if ($userDetails['is_super']) { ?>
				<li class="admin-menu admin-dash-btn">
					<i class="fas fa-tachometer-alt"></i>
					<a href="../settings" target="_blank">My Settings</a>
				</li>
			<?php } else if ($userDetails['is_owner']) { ?>
				<li class="admin-menu admin-dash-btn">
					<i class="fas fa-tachometer-alt"></i>
					<a href="../settings" target="_blank">My Settings</a>
				</li>
			<?php } ?>
			
			<?php /*
			<li class="admin-menu my-settings-btn view-my-cases">
				<i class="fas fa-folder-open"></i>
				<span>View My Cases</span>
			</li>
			*/ ?>

			<hr>
			
			<a href="<?php echo MAINSITE_URL; ?>/help" target="_blank">
				<li class="admin-menu help-item">
					<i class="fas fa-question-circle"></i>
					<span>Help</span>
				</li>
			</a>
			<a href="<?php echo MAINSITE_URL; ?>/feedback" target="_blank">
				<li class="admin-menu feedback-item">
					<i class="fas fa-comment"></i>
					<span>Feedback</span>
				</li>
			</a>
			

			<?php if ($isLoggedIn) {
				echo '<a class="logout" href="../logout.php">Log Out</a>';
			} else {
				echo '<a class="logout" href="../login.php">Log In</a>';
			} ?>
		</ul>
	</div>


    <div class="menu" id="menu">
        <ul>
			<div class="just-info-outer">
				<li class="just-info"><?php echo htmlspecialchars($userDetails['email']); ?><span class="info-mark"><i class="fa fa-info"></i>
					<span class="info-tag">Email</span>
				  </span>
				</li>
				<li class="just-info"><?php echo htmlspecialchars($userDetails['group']); ?><span class="info-mark"><i class="fa fa-info"></i>
					<span class="info-tag">Group</span>
				  </span>
				</li>
				<?php if ($userDetails['is_admin'] == 1) {?>
					<li class="just-info user-type-menu">Administrator
					<span class="info-mark"><i class="fa fa-info"></i>
						<span class="info-tag">User Role</span>
					</span></li> <?php } ?>
			</div>
			<?php /**** we area already on this menu ****
			<?php if ($userDetails['is_super']) { ?>
            <br>
				<li><a href="admin">Super Admin Dashboard</a></li>
			<?php } else if ($userDetails['is_owner']) { ?>
            <br>
				<li><a href="admin">Admin Dashboard</a></li>
			<?php } ?>
            <br>
			*/ ?>
			<li class="compact-toggle" id="compact-toggle">
				<i class="fas fa-expand"></i>
				<span>Compact Mode</span>
			</li>

            <li class="theme-toggle" id="theme-toggle">
                <i class="fas fa-moon"></i>
                <span>Light Theme</span>
            </li>
        </ul>
    </div>
	
	<div id="profilePictureModal" class="modal">
		<div class="modal-content">
			<span class="close">&times;</span>
			<h2>Change Profile Picture</h2>
			<form id="profilePictureForm" enctype="multipart/form-data">
				<input type="file" name="profile_picture" id="profile_picture" accept=".jpg,.jpeg,.png,.gif">
				<button type="submit">Upload</button>
			</form>
			<?php 
			// Debug information
			echo "<!-- Debug: Checking for existing profile picture -->";
			$profilePicUrl = false;
			if (function_exists('getProfilePictureUrl') && isset($_SESSION['front_user_id'])) {
				$profilePicUrl = getProfilePictureUrl($_SESSION['front_user_id']);
			}
			echo "<!-- Debug: Profile picture URL: " . ($profilePicUrl ? htmlspecialchars($profilePicUrl) : 'Not set') . " -->";
			
			if ($profilePicUrl): 
			?>
				<button id="removeProfilePicture">Remove Profile Picture</button>
			<?php endif; ?>
			<p id="uploadStatus"></p>
		</div>
	</div>
	
	<div id="licenseModal" class="modal modal-<?= strtolower($license); ?>">
		<div class="modal-content">
			<span class="close">&times;</span>
			<div id="licenseStatus" class="status-button"></div>
			<p id="licenseExpiration"></p>
			<ul id="licenseFeatures"></ul>
			<a id="licenseAction" href="#" class="action-button"></a>
		</div>
	</div>

	<div id="proStatusModal" class="modal modal-<?= strtolower($proStatus); ?>">
		<div class="modal-content">
			<span class="close">&times;</span>
			<div id="proStatus" class="status-button"></div>
			<p id="proExpiration"></p>
			<ul id="proFeatures"></ul>
			<a id="proAction" href="#" class="action-button"></a>
		</div>
	</div>
	
	
<?php /* *************** end top menu ********************/ ?>
		

<?php /* *** second menu *** */ ?>
<div id="menu-wrap">
    <div class="menu-items-left"><a href="./<?php $_SERVER['DOCUMENT_ROOT'] ?>">Admin Home</a></div>
    <div class="menu-items-left menu-items-left-email">
	  <div class="text-wrapper">
		<div class="inner-text" title="<?= $_SESSION['front_user_email'];?>" alt="<?= $_SESSION['front_user_email'];?>"><?= $_SESSION['front_user_email'];?></div>
	  </div>
	  <i class="fas fa-copy copy-icon"></i>
	</div>
    <?php if ($usertype == 'super') { } else { ?><div class="menu-items-left">&nbsp;<?= $roletitle; ?>&nbsp;</div><?php } ?>
    <div class="menu-items-left" title="<?= $_SESSION['user_group'];?>" alt="<?= $_SESSION['user_group'];?>">&nbsp;<?= $_SESSION['user_group'];?>&nbsp;</div>
    <div class="menu-items-right"><a href="../">Go to Simulator <i class="fa fa-arrow-circle-right" aria-hidden="true"></i></a></div>
	<div class="menu-items-right">
        <?php if (isset($_SESSION['front_user_email'])): ?>
            <a href="?logout=true">Logout</a>
        <?php else: ?>
            <a href="../login">Login</a>
        <?php endif; ?>
    </div>
	<div class="menu-items-right">
		&nbsp;License: <span class="license license-<?= strtolower($license); ?>" 
			onclick="try { showLicenseModal('<?= htmlspecialchars($license); ?>', '<?= htmlspecialchars($licenseExpirationDate); ?>'); } catch(e) { console.error(e); }">
			<?= htmlspecialchars($license); ?>
		</span>&nbsp; 
		<?php if ($license === 'Inactive' || $license === 'Expired'): /* hide pro status if license is inactive or expired */ ?>
		<?php else: ?>
			<span class="pro-status pro-status-<?= strtolower($proStatus); ?>" 
				onclick="try { showProModal('<?= htmlspecialchars($proStatus); ?>', '<?= ($proExpirationDate instanceof DateTime) ? htmlspecialchars($proExpirationDate->format('Y-m-d')) : htmlspecialchars($proExpirationDate); ?>'); } catch(e) { console.error(e); }">
				<?= $proStatus === 'Upgrade' ? 'Get Pro' : htmlspecialchars($proStatus); ?>
			</span>
		<?php endif; ?>
	</div>


</div>
<br />

<div>
	<ul id="links"<?php if ($usertype == 'admin') { ?> class="group-admin"<?php } ?>>
		<?php if ($usertype == 'super') { ?>
			<li><a href="./" <?php echo ($current_page == 'overview') ? 'class="active"' : ''; ?>>Home</a></li>
		<?php } ?>
		<li><a href="groups" <?php echo ($current_page == 'groups') ? 'class="active"' : ''; ?>><?php
		      if ($usertype == 'super') {
			    echo "Groups";
			  } else {
			    echo "My Group";
			  } ?>
			  </a>
		</li>
		<li><a href="users" <?php echo ($current_page == 'users') ? 'class="active"' : ''; ?>><?php
		      if ($usertype == 'super') {
			    echo "Users and Cases";
			  } else {
			    echo "My Users and Cases"; 
			  } ?>
			  </a>
		</li>
		<?php if ($usertype == 'super') { ?>
			<?php /* <li><a href="cases" <?php echo ($current_page == 'cases') ? 'class="active"' : ''; ?>>View Cases</a></li> */ ?>
		<?php } ?>
		<?php if ($usertype == 'super') { ?>
			<li><a href="newgroup" <?php echo ($current_page == 'newgroup') ? 'class="active"' : ''; ?>>New Group</a></li>
		<?php } ?>
	</ul>
</div>
	
<p class="clearfloat spacer">