document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    if (searchInput) {
        searchInput.addEventListener('input', debounce(filterTable, 300));
    }
});

function filterTable() {
    const input = document.getElementById('searchInput');
    const searchTerm = input.value.trim();
    
    // Update the URL with the search term
    const currentUrl = new URL(window.location.href);
    currentUrl.searchParams.set('search', searchTerm);
    currentUrl.searchParams.set('page', '1');
    
    // Maintain show_hidden parameter if it exists
    const showHidden = currentUrl.searchParams.get('show_hidden');
    if (showHidden) {
        currentUrl.searchParams.set('show_hidden', showHidden);
    }
    
    window.location.href = currentUrl.toString();
}

// Debounce function to limit how often filterTable runs
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}