document.addEventListener('DOMContentLoaded', function() {
    // Handle the "Show Hidden" toggle to maintain its state
    var showHiddenToggle = document.getElementById('showHiddenToggle');
    if (showHiddenToggle) {
        showHiddenToggle.addEventListener('change', function() {
            var currentUrl = new URL(window.location.href);
            currentUrl.searchParams.set('show_hidden', this.checked ? '1' : '0');
            currentUrl.searchParams.delete('page'); // Reset to page 1
            window.location.href = currentUrl.toString();
        });
    }

    // Handle the "Show Users Without Cases" toggle
    var showNoCasesToggle = document.getElementById('showNoCasesToggle');
    if (showNoCasesToggle) {
        showNoCasesToggle.addEventListener('change', function() {
            var currentUrl = new URL(window.location.href);
            if (this.checked) {
                currentUrl.searchParams.delete('hide_no_cases');
            } else {
                currentUrl.searchParams.set('hide_no_cases', '1');
            }
            currentUrl.searchParams.delete('page'); // Reset to page 1
            window.location.href = currentUrl.toString();
        });
    }

    // Enhanced pagination link handling to preserve search parameters
    document.querySelectorAll('.pagination a').forEach(function(link) {
        link.addEventListener('click', function(e) {
            // Only intercept if we have a search param
            if (document.getElementById('searchInput').value.trim()) {
                e.preventDefault();
                var href = this.getAttribute('href');
                var url = new URL(window.location.origin + window.location.pathname + href);
                
                // Add current search term to pagination URL
                url.searchParams.set('search', document.getElementById('searchInput').value.trim());
                
                window.location.href = url.toString();
            }
        });
    });

    // Add 'Enter' key functionality to search form
    var searchInput = document.getElementById('searchInput');
    if (searchInput) {
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                document.getElementById('casesSearchForm').submit();
            }
        });
    }
});