<?php // Administration Bootstrap 
// index.php
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	//session_start();
	chdir('../');
	include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
	/* **************** HEADER FROM MAIN (REQUIRED FOR MENU) **************/
	// Attempts to move this to the header logic file failed, 
	// possibly because menu.php has relative queries
	include ($_SERVER['DOCUMENT_ROOT'] . '/menu.php');
	$userDetails = menuUserDetails($_SESSION['front_user_id']);
	/* ***************** END HEADER FROM MAIN *****************************/
	include ($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/header_logic.inc.php');
	
	// pro api
	include ($_SERVER['DOCUMENT_ROOT'] . '/api/pro_features.php');
	
	// current page variable
	$current_page = 'overview';
	
	// sync passwords api
	require_once($_SERVER['DOCUMENT_ROOT'] . '/api/sync_passwords.php');
	// process password sync if submitted
	$sync_message = '';
	if (isset($_POST['sync_passwords'])) {
		$sync_message = sync_user_passwords();
	}

	// redirect regular admins to groups page if they land here
	// effectively hides index (super admin overview) from regular admins
	if($usertype == 'admin'){
		header("Location: ../admin/groups"); // Redirect to the groups page
		exit();
	}
	
	
	function console_log($data) {
		echo '<script>';
		echo 'console.log(' . json_encode($data) . ')';
		echo '</script>';
	}
	
	// // console_log("GET parameters: " . print_r($_GET, true));
	
	$groupWhere = "";
	
	if($usertype == 'admin'){
	    $groupWhere = " WHERE group_name = '".$_SESSION['user_group']."' ";
	}
	
	// Default sorting
	$orderBy = "ORDER BY user_email ASC";

	if (isset($_GET["groupnamesort"]) && !empty($_GET["groupnamesort"])){
		if ($_GET["groupnamesort"] === "ORDER BY group_name asc") {
		     $groupNameSort = "ORDER BY group_name asc";
		     $groupNameSortNext = "ORDER BY group_name desc";
		     $groupNameLabel = "Sort Z-A";
		} else {
		     $groupNameSort = "ORDER BY group_name desc";
		     $groupNameSortNext = "ORDER BY group_name asc";
		     $groupNameLabel = "Sort A-Z";
		}
	}
	else {
	      $groupNameSort = "";
	      $groupNameSortNext = "ORDER BY group_name desc";
	      $groupNameLabel = "Sort Z-A";
	}
	
	if (isset($_GET["licensesort"]) && !empty($_GET["licensesort"])) {
		if ($_GET["licensesort"] === "ORDER BY group_status asc") {
			 $licenseSort = "ORDER BY group_status asc";
			 $licenseSortNext = "ORDER BY group_status desc";
			 $licenseLabel = "Sort Z-A";
		} else {
			 $licenseSort = "ORDER BY group_status desc";
			 $licenseSortNext = "ORDER BY group_status asc";
			 $licenseLabel = "Sort A-Z";
		}
	} else {
		$licenseSort = "";
		$licenseSortNext = "ORDER BY group_status asc";
		$licenseLabel = "Sort A-Z";
	}
	
	if (isset($_GET["expirationdatesort"]) && !empty($_GET["expirationdatesort"])){
		if ($_GET["expirationdatesort"] === "ORDER BY expiration_date asc") {
		     $expirationDateSort = "ORDER BY expiration_date asc";
		     $expirationDateSortNext = "ORDER BY expiration_date desc";
		     $expirationDateLabel = "Sort Z-A";
		} else {
		     $expirationDateSort = "ORDER BY expiration_date desc";
		     $expirationDateSortNext = "ORDER BY expiration_date asc";
		     $expirationDateLabel = "Sort A-Z";
		}
	}
	else {
	      $expirationDateSort = "";
	      $expirationDateSortNext = "ORDER BY expiration_date desc";
	      $expirationDateLabel = "Sort A-Z";
	}	
	
	if (isset($_GET["datesort"])) {
		if ($_GET["datesort"] === "asc") {
			$dateSort = "ORDER BY group_registered ASC";
			$dateSortNext = "desc";
			$dateLabel = "Newest"; 
		} else {
			$dateSort = "ORDER BY group_registered DESC";
			$dateSortNext = "asc";
			$dateLabel = "Oldest";
		}
	} else {
		$dateSort = "ORDER BY group_registered DESC"; // Default sorting
		$dateSortNext = "asc";
		$dateLabel = "Oldest";
	}

	
	if (isset($_GET["adminnamesort"]) && !empty($_GET["adminnamesort"])){
		if ($_GET["adminnamesort"] === "ORDER BY group_admin asc") {
		     $adminNameSort = "ORDER BY group_admin asc";
		     $adminNameSortNext = "ORDER BY group_admin desc";
		     $adminNameLabel = "Sort Z-A";
		} else {
		     $adminNameSort = "ORDER BY group_admin desc";
		     $adminNameSortNext = "ORDER BY group_admin asc";
		     $adminNameLabel = "Sort A-Z";
		}
	}
	else {
	      $adminNameSort = "";
	      $adminNameSortNext = "ORDER BY group_admin desc";
	      $adminNameLabel = "Sort Z-A";
	}
	
	if (isset($_GET["adminemailsort"]) && !empty($_GET["adminemailsort"])){
		if ($_GET["adminemailsort"] === "ORDER BY group_email asc") {
		     $adminEmailSort = "ORDER BY group_email asc";
		     $adminEmailSortNext = "ORDER BY group_email desc";
		     $adminEmailLabel = "Sort Z-A";
		} else {
		     $adminEmailSort = "ORDER BY group_email desc";
		     $adminEmailSortNext = "ORDER BY group_email asc";
		     $adminEmailLabel = "Sort A-Z";
		}
	}
	else {
	      $adminEmailSort = "";
	      $adminEmailSortNext = "ORDER BY group_email desc";
	      $adminEmailLabel = "Sort Z-A";
	}
	
	if  (!isset($_GET["groupnamesort"]) && !isset($_GET["expirationdatesort"]) && !isset($_GET["adminnamesort"])) {
	      $groupNameSort = "ORDER BY group_name asc";
	      $groupNameSortNext = "ORDER BY group_name desc";
	      $groupNameLabel = "Sort Z-A";
	}
	
	if (isset($_GET["prostatussort"]) && !empty($_GET["prostatussort"])) {
		if ($_GET["prostatussort"] === "ORDER BY pro_status asc") {
			 $proStatusSort = "ORDER BY pro_status asc";
			 $proStatusSortNext = "ORDER BY pro_status desc";
			 $proStatusLabel = "Sort Z-A";
		} else {
			 $proStatusSort = "ORDER BY pro_status desc";
			 $proStatusSortNext = "ORDER BY pro_status asc";
			 $proStatusLabel = "Sort A-Z";
		}
	} else {
		$proStatusSort = "";
		$proStatusSortNext = "ORDER BY pro_status asc";
		$proStatusLabel = "Sort A-Z";
	}

	
$orderByClause = $dateSort; // Use date sorting by default
console_log("Initial orderByClause: " . $orderByClause);

if (isset($_GET["groupnamesort"])) {
    $orderByClause = $groupNameSort;
} elseif (isset($_GET["licensesort"])) {
    $orderByClause = $licenseSort;
} elseif (isset($_GET["expirationdatesort"])) {
    $orderByClause = $expirationDateSort;
} elseif (isset($_GET["prostatussort"])) {
    $orderByClause = $proStatusSort;
}

console_log("Final orderByClause: " . $orderByClause);


	$groupNameLabel = ($groupNameSortNext === "ORDER BY group_name desc") ? 'Sort Z-A' : 'Sort A-Z';
	$licenseLabel = ($licenseSortNext === "ORDER BY group_status desc") ? 'Oldest' : 'Newest';
	$expirationDateLabel = ($expirationDateSortNext === "ORDER BY expiration_date desc") ? 'Oldest' : 'Newest';
	$dateLabel = ($dateSortNext === "asc") ? 'Oldest' : 'Newest';
	$adminNameLabel = ($adminNameSortNext === "ORDER BY group_admin desc") ? 'Sort A-Z' : 'Sort Z-A';
	$adminEmailLabel = ($adminEmailSortNext === "ORDER BY group_email desc") ? 'Sort A-Z' : 'Sort Z-A';
		
		
	// deactivate pro when expired
	function checkProStatus($groupId) {
		global $pdo;
		
		$query = "SELECT pro_status, pro_expiration_date FROM wp_groups WHERE id = ?";
		$stmt = $pdo->prepare($query);
		$stmt->execute([$groupId]);
		$result = $stmt->fetch(PDO::FETCH_ASSOC);
		
		if ($result && $result['pro_status'] === 'Pro' && $result['pro_expiration_date'] < date('Y-m-d')) {
		  /**** temporarily removed automatic expiration date to expire user. It works fine. It was requested to disable it. ********************
			$updateQuery = "UPDATE wp_groups SET pro_status = 'Expired' WHERE id = ?";
			$updateStmt = $pdo->prepare($updateQuery);
			$updateStmt->execute([$groupId]);
		  ***********************************************/
		}
	}
	
	include ($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');
?>

<?php /* ****************** BEGIN HOME PAGE ********************/ ?>

		<table class="home-table 95-table">
		<h2 class="top-title 95-table">Super Admin Overview</h2>
			<?php if (!empty($sync_message)): ?>
				<div class="confirmation-popup show-confirmation" style="display: block;">
					<?php echo $sync_message; ?>
					<script>
						setTimeout(function() {
							document.querySelector('.confirmation-popup').style.display = 'none';
						}, 3000);
					</script>
				</div>
			<?php endif; ?>

			<div class="admin-tools-container">
			  <div class="admin-tools-header">
				<h2>Admin Tools</h2>
				<span class="admin-toggle-icon">▼</span>
			  </div>
			  <div class="admin-tools-content">				
				<div class="admin-tool-column">
				  <h3>Site Backup</h3>
				  <p>Create a complete backup of the site including all files and configurations.</p>
				  <button id="adminBackupButton" class="admin-btn-primary">Create Site Backup</button>
				  <div id="adminBackupModal" class="admin-backup-modal">
					<div class="admin-modal-content">
					  <span class="admin-close-button">&times;</span>
					  <h2>Backup Status</h2>
					  <div id="adminBackupStatus">Processing...</div>
					  <div id="adminBackupLog" class="admin-backup-log"></div>
					</div>
				  </div>
				</div>
				
				<div class="admin-tool-column">
				  <h3>Database Backup</h3>
				  <p>Create a backup of the database only, preserving all user and system data.</p>
				  <button id="adminDbBackupButton" class="admin-btn-primary">Create Database Backup</button>
				  <div id="adminDbBackupModal" class="admin-backup-modal">
					<div class="admin-modal-content">
					  <span class="admin-close-db-button">&times;</span>
					  <h2>Database Backup Status</h2>
					  <div id="adminDbBackupStatus">Processing...</div>
					  <div id="adminDbBackupLog" class="admin-backup-log"></div>
					</div>
				  </div>
				</div>
				
				<div class="admin-tool-column">
				  <h3>Sync Passwords</h3>
				  <p>Force update all user accounts to use the passwords from their assigned groups.</p>
				  <form method="post" action="">
					<button type="submit" name="sync_passwords" class="admin-btn-primary psync-submit">
					  Sync User Passwords with Groups
					</button>
				  </form>
				</div>
			  </div>
			</div>
			
			<tr>
				<th style="width:3%;">ID</th>
				<th style="width:20%;">Group Name&nbsp;&nbsp;<a class="sort" href="index.php?groupnamesort=<?= $groupNameSortNext ?>"><?= $groupNameLabel ?></a></th>
                <th width="20%">Admin Email<a class="sort" href="index.php?adminemailsort=<?= htmlspecialchars($adminemailSortNext ?? '') ?>"><?= htmlspecialchars($adminemailLabel ?? '') ?></a></th>
				<th width="9%">License&nbsp;&nbsp;<a class="sort" href="index.php?licensesort=<?= $licenseSortNext ?>"><?= $licenseLabel ?></a></th>
				<th style="width:9%;">Created&nbsp;&nbsp;<a class="sort" href="index.php?datesort=<?= $dateSortNext ?>"><?= $dateLabel ?></a></th>
				<th style="width:9%;">Expires&nbsp;&nbsp;<a class="sort" href="index.php?expirationdatesort=<?= $expirationDateSortNext ?>"><?= $expirationDateLabel ?></a></th>
				<th style="width:9%;">Pro &nbsp;&nbsp;<a class="sort" href="index.php?prostatussort=<?= $proStatusSortNext ?>"><?= $proStatusLabel ?></a></th>
				<!-- <th style="width:9%;">Pro Upgraded</th> -->
				<!-- <th style="width:9%;">Pro Expires</th> -->
				<th style="width:6%;text-align:center;">Institution Address</a></th>
				<?php /* <th style="width:6%;text-align:center;">Years Active</a></th> ** could be a future feature - calculate active years as customer */ ?>
				<th style="width:10%;">Super Admin Notes</th>
				<?php /* <th style="width:6%;text-align:center;">Group Password</a></th> ** already on groups page */ ?>
				<th style="width:6%;text-align:center;">Users</a></th>
				<th style="width:6%;text-align:center;">Edit</a></th>
				<!-- <th style="width:6%;text-align:center;">Delete</a></th> -->
			</tr>
			
			<?php
				$groups = "SELECT 
								id, 
								group_name,
								group_admin, 
								group_email, 
								group_status,
								group_notes,
								group_pass,
								group_pass_clear,
								expiration_date,
								group_institution_address,
								group_registered,
								pro_status,
								pro_upgrade_date,
								pro_expiration_date,
								(SELECT COUNT(*) 
									FROM wp_users AS innertable
									WHERE innertable.group_id = outertable.id) AS numusers
							FROM wp_groups AS outertable
							$groupWhere
							" . ($orderByClause ?: "ORDER BY group_registered DESC");

 				$stmt = $pdo->prepare($groups);
				$stmt->execute();
				$result = $stmt->fetchAll(PDO::FETCH_ASSOC);

				foreach ($result as $oneRow) {
			 ?>
				       <tr>
						<td><?= htmlspecialchars($oneRow['id']); ?></td>
					    <td><?= $oneRow['group_name']; ?></td>
						<?php /* <td style="text-align:center;"><span class="edit_area" id="status_<?= htmlspecialchars($oneRow['id'] ?? '') ?>"><?= htmlspecialchars($oneRow['group_status'] ?? '') ?></span></td> */ ?>
					    <td><?= $oneRow['group_email']; ?></td>
						<td>
							<select class="group-status-dropdown" onclick="event.stopPropagation()" data-id="<?= htmlspecialchars($oneRow['id']) ?>">
								<option value="Permanent" <?= $oneRow['group_status'] == 'Permanent' ? 'selected' : '' ?> class="status-permanent">Permanent</option>
							    <option value="Active" <?= $oneRow['group_status'] == 'Active' ? 'selected' : '' ?> class="status-active">Active</option>
								<option value="Expired" <?= $oneRow['group_status'] == 'Expired' ? 'selected' : '' ?> class="status-expired">Expired</option>
								<option value="Suspended" <?= $oneRow['group_status'] == 'Suspended' ? 'selected' : '' ?> class="status-suspended">Suspended</option>
								<option value="Inactive" <?= $oneRow['group_status'] == 'Inactive' ? 'selected' : '' ?> class="status-inactive">Inactive</option>
								<option value="Unknown" <?= $oneRow['group_status'] == 'Unknown' ? 'selected' : '' ?> class="status-Unknown">Unknown</option>
							</select>
						</td>
					    <td style="text-align:center;"><?= $oneRow['group_registered']; ?></td>
						<td style="text-align:center;">
							<?php
							$expiration_date = $oneRow['expiration_date'];
							if ($expiration_date === '0000-00-00' || $expiration_date === '0001-01-01' || $expiration_date === null || $expiration_date === '') {
								echo 'Unknown';
							} elseif ($expiration_date == '9999-12-31') {
								echo 'Never';
							} else {
								echo $expiration_date;
							}
							?>
						</td>
						<td>
							<select class="pro-status-dropdown" onclick="event.stopPropagation()" data-id="<?= htmlspecialchars($oneRow['id']) ?>">
								<option value="Pro" <?= $oneRow['pro_status'] == 'Pro' ? 'selected' : '' ?> class="pro-yes">Pro</option>
								<option value="Expired" <?= $oneRow['pro_status'] == 'Expired' ? 'selected' : '' ?> class="pro-expired">Expired</option>
								<option value="Suspended" <?= $oneRow['pro_status'] == 'Suspended' ? 'selected' : '' ?> class="pro-suspended">Suspended</option>
								<option value="Inactive" <?= $oneRow['pro_status'] == 'Inactive' ? 'selected' : '' ?> class="pro-inactive">Inactive</option>
								<option value="Unknown" <?= $oneRow['pro_status'] == 'Unknown' ? 'selected' : '' ?> class="pro-unknown">Unknown</option>
								<option value="No" <?= $oneRow['pro_status'] == 'No' ? 'selected' : '' ?> class="pro-no">No</option>
							</select>
						</td>
						<!-- <td><?= isset($oneRow['pro_upgrade_date']) && $oneRow['pro_upgrade_date'] ? date('Y-m-d', strtotime($oneRow['pro_upgrade_date'])) : 'N/A' ?></td> -->
						<!-- <td><?= $oneRow['pro_expiration_date'] ? date('Y-m-d', strtotime($oneRow['pro_expiration_date'])) : 'N/A' ?></td> -->
						<td class="institution-address"><span class="edit_area" id="notes_<?= htmlspecialchars($oneRow['id'] ?? '') ?>"><?= htmlspecialchars($oneRow['group_institution_address'] ?? '') ?></span></td>
						<td class="group-notes"><span class="edit_area" id="notes_<?= htmlspecialchars($oneRow['id'] ?? '') ?>"><?= htmlspecialchars($oneRow['group_notes'] ?? '') ?></span></td>
					    <?php /* <td><?= $oneRow['group_pass_clear']; ?></td> ** already on groups page */ ?>
					    <td style="text-align:center;"><?= $oneRow['numusers']; ?></td>
					    <td style="text-align:center;">
							<a href="#" class="edit-group" data-id="<?= htmlspecialchars($oneRow['id']) ?>" onclick="event.stopPropagation();">Edit</a>
						</td>
						  <!-- <?
							if ($usertype == 'super') {
							      $groupId = $oneRow["id"];
							      //echo $oneRow["group_name"];exit;
							      $groupname = $oneRow["group_name"];
							      //echo $groupname;exit;
							      echo "<td style='text-align:center;'>";
								    echo "<a style='text-decoration: underline;' href='deletegroup.php?id=$groupId&groupname=$groupname' onclick='javascript: return confirmDeleteGeneric()'>Delete</a>";
							      echo "</td>";
							}
						  ?> -->
						</td>
				      </tr>
			<?php 
			      } // console_log("Number of rows returned: " . count($result));
			?>
		</table>
		
		
	<div id="editGroupModal" class="modal" style="display:none;">
		<div class="modal-content">
			<span class="close">&times;</span>
			<h2>Edit Group</h2>
			<form id="editGroupForm">
				<input type="hidden" id="groupId" name="groupId">
				<label for="groupName">Group Name:</label>
				<input type="text" id="groupName" name="groupName" required>
				<label for="groupName">Group Email:</label>
				<input type="text" id="groupEmail" name="groupEmail" required>
				<label for="groupPassword">Group Password:</label>
				<input type="text" id="groupPassword" name="groupPassword">
				<label for="groupStatus">License Status:</label>
				<select id="groupStatus" name="groupStatus">
					<option value="Active">Active</option>
					<option value="Expired">Expired</option>
					<option value="Suspended">Suspended</option>
					<option value="Inactive">Inactive</option>
					<option value="Unknown">Unknown</option>
					<option value="Permanent">Permanent</option>
				</select>
				<label for="expirationDate">License Expiration:</label>
				<input type="date" id="expirationDate" name="expirationDate">

				<label for="proStatus">Pro Status:</label>
				<div class="pro-history-section">
					<select id="proStatus" name="proStatus">
						<option value="No">No</option>
						<option value="Pro">Pro</option>
						<option value="Expired">Expired</option>
						<option value="Suspended">Suspended</option>
					<option value="Inactive">Inactive</option>
					<option value="Unknown">Unknown</option>
					</select>
					<?php if ($usertype == 'super') { ?> 
						<button type="button" class="pro-history-btn" title="View Pro Status History" style="display: none;">
							<i class="fas fa-history"></i>
						</button>
					<?php } ?>
				</div>
				
				<label for="proUpgradeDate">Pro Upgrade Date:</label>
				<input type="date" id="proUpgradeDate" name="proUpgradeDate">

				<label for="proExpirationDate">Pro Expiration Date:</label>
				<input type="date" id="proExpirationDate" name="proExpirationDate">
				<label for="groupInstitutionAddress">Institution Address:</label>
				<textarea id="groupInstitutionAddress" name="groupInstitutionAddress"></textarea>
				<label for="groupNotes">Notes About Group (only viewable by Super Admin):</label>
				<textarea id="groupNotes" name="groupNotes"></textarea>
				<button type="submit">Save Changes</button>
			</form>
		</div>
	</div>

	<div id="proHistoryModal" class="modal" style="display:none;">
		<div class="modal-content">
			<span class="close">&times;</span>
			<h2>Pro Status History</h2>
			<div class="history-table-container">
				<table class="history-table">
					<thead>
						<tr>
							<th>Date Changed</th>
							<th>From</th>
							<th>To</th>
							<th>Changed By</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody id="proHistoryContent">
					</tbody>
				</table>
			</div>
		</div>
	</div>
	
	<div id="popup" class="confirmation-popup" style="display: none;"></div>

	<script>
	$(document).ready(function() {
		var modal = document.getElementById("editGroupModal");
		var span = document.getElementsByClassName("close")[0];

		$('.edit-group').on('click', function(e) {
			e.preventDefault();
			var groupId = $(this).data('id');
			// console_log("Edit button clicked for group ID:", groupId); // debugging
			$.get('../api/get-group-details.php', {id: groupId}, function(data) {
				console.log('Response data:', data);
				try {
					data = JSON.parse(data);
					$('#groupId').val(data.id);
					$('#groupEmail').val(data.group_email);
					$('#groupName').val(data.group_name);
					$('#groupStatus').val(data.group_status);
					$('#expirationDate').val(data.expiration_date);
					$('#groupInstitutionAddress').val(data.group_institution_address);
					$('#groupPassword').val(data.group_pass_clear);
					$('#groupNotes').val(data.group_notes);
					//$('#proStatus').val(data.pro_status);
					$('#proStatus option[value="' + data.pro_status + '"]').prop('selected', true);
					$('#proUpgradeDate').val(data.pro_upgrade_date);
					$('#proExpirationDate').val(data.pro_expiration_date);
					modal.style.display = "block";
				} catch (error) {
					// console.error("Error parsing JSON:", error);
					// console_log("Raw server response:", data); // debugging
				}
			});
		});

		span.onclick = function() {
			modal.style.display = "none";
		}

		$('.close').on('click', function() {
			modal.style.display = "none";
		});

		window.onclick = function(event) {
			if (event.target == modal) {
				modal.style.display = "none";
			}
		}
	
		$('#editGroupForm').on('submit', function(e) {
			// console.log('Edit group form submitted');
			e.preventDefault();
			var formData = $(this).serialize();
			var groupId = $('#groupId').val();
			
			// console.log('Sending AJAX request to update group');
			$.ajax({
				url: 'inc/update-group.php',
				method: 'POST',
				data: formData,
				dataType: 'json',
				success: function(response) {
					// console.log('AJAX success callback executed');
					// console.log('Server response:', response);
					if (response.success) {
						modal.style.display = "none";
						
						var row = $('a.edit-group[data-id="' + groupId + '"]').closest('tr');
						row.find('td:eq(0)').text($('#groupId').val());
						row.find('td:eq(1)').text($('#groupName').val());
						row.find('td:eq(2)').text($('#groupEmail').val());
						row.find('td:eq(3) select').val($('#groupStatus').val());
						// Don't update the 'Created' column (index 4) as it shouldn't change
						
						var expirationDate = $('#expirationDate').val();
						if (expirationDate === '0000-00-00' || expirationDate === '0001-01-01' || expirationDate === null || expirationDate === '') {
							expirationDate = 'Unknown';
						} else if (expirationDate === '9999-12-31') {
							expirationDate = 'Never';
						}
						row.find('td:eq(5)').text(expirationDate);
						row.find('td:eq(6) select').val(response.data.pro_status);
						row.find('td:eq(7)').text($('#groupInstitutionAddress').val());
						row.find('td:eq(8)').text($('#groupNotes').val());
						
						if (typeof updateCompactMode === 'function') {
							updateCompactMode();
						}
						
						$('#editGroupForm')[0].reset();

						document.getElementById('popup').textContent = 'Group updated successfully';
						document.getElementById('popup').className = 'confirmation-popup show-confirmation';
						document.getElementById('popup').style.display = 'block';
						setTimeout(function() {
							document.getElementById('popup').style.display = 'none';
						}, 3000);
					} else {
						document.getElementById('popup').textContent = 'Error updating group: ' + (response.error || 'Unknown error');
						document.getElementById('popup').className = 'confirmation-popup hide-confirmation';
						document.getElementById('popup').style.display = 'block';
						setTimeout(function() {
							document.getElementById('popup').style.display = 'none';
						}, 3000);
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.error('AJAX error:', textStatus, errorThrown);
					// console_log('Server response:', jqXHR.responseText);
					alert('Error updating group. Please check the console for more information.');
				}
			});
		});

		
		/* handle pro status dropdown */
		$('.pro-status-dropdown').on('change', function() {
			var groupId = $(this).data('id');
			var newStatus = $(this).val();
			var $this = $(this);
			
			// console_log('Sending AJAX request to update Pro status');
			// console_log('Group ID:', groupId);
			// console_log('New Status:', newStatus);
			
			// Store the current value before making the request
			var previousValue = $this.data('previous-value') || $this.val();
			$this.data('previous-value', previousValue);
			
			$.ajax({
				url: '../api/update-pro-status.php',
				method: 'POST',
				data: {
					groupId: groupId,
					newStatus: newStatus
				},
				success: function(response) {
					try {
						var data = JSON.parse(response);
						if (data.success) {
							document.getElementById('popup').textContent = 'Pro status updated successfully';
							document.getElementById('popup').className = 'confirmation-popup show-confirmation';
							document.getElementById('popup').style.display = 'block';
							setTimeout(function() {
								document.getElementById('popup').style.display = 'none';
							}, 3000);
							
							// Keep the selected value in the dropdown
							$this.val(newStatus);
							
							// Store new value as previous for future changes
							$this.data('previous-value', newStatus);
							
							// Update pro status in dropdown (ensure it stays visible)
							var statusDropdown = $this.closest('tr').find('.pro-status-dropdown');
							statusDropdown.val(newStatus);
							
							// Update the pro expiration date
							if (data.proExpirationDate) {
								// Update the pro expiration date in the modal if it's open
								$('#proExpirationDate').val(data.proExpirationDate);
								
								// If pro status is "No" or "Expired", show "N/A" for expiration
								var displayDate = (newStatus === 'No' || newStatus === 'Expired') ? 
									'N/A' : data.proExpirationDate;
									
								// Update the pro expiration date in the table
								$this.closest('tr').find('td:eq(8)').text(displayDate);
							}
						} else {
							document.getElementById('popup').textContent = 'Error updating Pro status: ' + (data.error || 'Unknown error');
							document.getElementById('popup').className = 'confirmation-popup hide-confirmation';
							document.getElementById('popup').style.display = 'block';
							setTimeout(function() {
								document.getElementById('popup').style.display = 'none';
							}, 3000);
							
							console.error('Error updating Pro status:', data.error);
							// Revert to previous value on error
							$this.val(previousValue);
						}
					} catch (e) {
						console.error('Error parsing JSON:', e);
						// Revert to previous value on error
						$this.val(previousValue);
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.error('AJAX error:', textStatus, errorThrown);
					// Revert to previous value on error
					$this.val(previousValue);
				}
			});
		});

		// handle license status updates dropdown    
		$('.group-status-dropdown').on('change', function() {
			var groupId = $(this).data('id');
			var newStatus = $(this).val();
			
			$.ajax({
				url: '../api/update-group-status.php',
				method: 'POST',
				data: {
					groupId: groupId,
					newStatus: newStatus
				},
				success: function(response) {
					try {
						var data = JSON.parse(response);
						/* alert version **********
						if (data.success) {
							alert('Group status updated successfully');
						} else {
							alert('Error updating group status: ' + (data.error || 'Unknown error'));
						}
						**************************/
						if (data.success) {
							document.getElementById('popup').textContent = 'Group license status updated successfully';
							document.getElementById('popup').className = 'confirmation-popup show-confirmation';
							document.getElementById('popup').style.display = 'block';
							setTimeout(function() {
								document.getElementById('popup').style.display = 'none';
							}, 3000);
						} else {
							document.getElementById('popup').textContent = 'Error updating group license status: ' + (data.error || 'Unknown error');
							document.getElementById('popup').className = 'confirmation-popup hide-confirmation';
							document.getElementById('popup').style.display = 'block';
							setTimeout(function() {
								document.getElementById('popup').style.display = 'none';
							}, 3000);
						}
					} catch (e) {
						console.error('Error parsing JSON:', e);
						alert('Error updating group status: Invalid server response');
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					console.error('AJAX error:', textStatus, errorThrown);
					// console_log('Server response:', jqXHR.responseText);
					alert('Error communicating with server: ' + textStatus);
				}
			});
		});
	});
	document.querySelector('select').addEventListener('click', function(event) {
		event.stopPropagation();
	});

	// pro history js
	$('.pro-history-btn').on('click', function(e) {
		e.preventDefault();
		e.stopPropagation();
		var groupId = $('#groupId').val();
		
		$.ajax({
			url: '../api/get-pro-history.php',
			method: 'GET',
			data: { group_id: groupId },
			success: function(response) {
				try {
					var data = JSON.parse(response);
					var content = '';
					
					data.history.forEach(function(entry) {
						content += '<tr>';
						content += '<td>' + entry.changed_at + '</td>';
						content += '<td>' + entry.old_status + '</td>';
						content += '<td>' + entry.new_status + '</td>';
						content += '<td>' + entry.changed_by_email + '</td>';
						content += '<td><button class="revert-btn" data-history-id="' + entry.id + '">Revert</button></td>';
						content += '</tr>';
					});
					
					$('#proHistoryContent').html(content);
					$('#proHistoryModal').show();
				} catch (e) {
					console.error('Error parsing history:', e);
				}
			}
		});
	});

	// Close button for history modal
	$('#proHistoryModal .close').on('click', function() {
		$('#proHistoryModal').hide();
	});

	// Click outside to close
	$(window).on('click', function(event) {
		if (event.target.id === 'proHistoryModal') {
			$('#proHistoryModal').hide();
		}
	});


	$(document).on('click', '.revert-btn', function() {
		var historyId = $(this).data('history-id');
		if (confirm('Are you sure you want to revert to this state?')) {
			$.ajax({
				url: '../api/revert-pro-status.php',
				method: 'POST',
				data: { history_id: historyId },
				success: function(response) {
					if (response.success) {
						window.location.reload();
					} else {
						alert('Failed to revert status');
					}
				}
			});
		}
	});
	
	// Admin Tools Scripts
	</script>
	
	<script>
	// Site Backup script with format toggle support
	document.addEventListener('DOMContentLoaded', function() {
		const backupButton = document.getElementById('adminBackupButton');
		const backupModal = document.getElementById('adminBackupModal');
		const backupStatus = document.getElementById('adminBackupStatus');
		const backupLog = document.getElementById('adminBackupLog');
		const closeButton = document.querySelector('.admin-close-button');
		
		// Skip if elements don't exist
		if (!backupButton || !backupModal || !backupStatus || !backupLog) return;
		
		// Close modal when clicking the X
		if (closeButton) {
			closeButton.addEventListener('click', function() {
				backupModal.style.display = 'none';
			});
		}
		
		// Close modal when clicking outside of it
		window.addEventListener('click', function(event) {
			if (event.target === backupModal) {
				backupModal.style.display = 'none';
			}
		});
		
		// Backup button click handler
		backupButton.addEventListener('click', function() {
			// Show the modal
			backupModal.style.display = 'block';
			
			// Create and add progress bar
			const progressContainer = document.createElement('div');
			progressContainer.className = 'admin-progress-container';
			progressContainer.style.width = '100%';
			progressContainer.style.backgroundColor = '#e0e0e0';
			progressContainer.style.borderRadius = '4px';
			progressContainer.style.marginBottom = '15px';
			progressContainer.style.overflow = 'hidden';
			
			const progressBar = document.createElement('div');
			progressBar.className = 'admin-progress-bar';
			progressBar.style.width = '0%';
			progressBar.style.height = '20px';
			progressBar.style.backgroundColor = '#4CAF50';
			progressBar.style.transition = 'width 0.3s';
			progressBar.style.textAlign = 'center';
			progressBar.style.lineHeight = '20px';
			progressBar.style.color = 'white';
			progressBar.textContent = '0%';
			
			progressContainer.appendChild(progressBar);
			
			// Add the progress bar to the modal before the status
			if (backupStatus.parentNode.querySelector('.admin-progress-container')) {
				backupStatus.parentNode.querySelector('.admin-progress-container').remove();
			}
			backupStatus.parentNode.insertBefore(progressContainer, backupStatus);
			
			// Get the current format from window.backupEndpoint or use default
			const backupEndpoint = window.backupEndpoint || '/api/create_backup.php';
			const isZipFormat = backupEndpoint.includes('zip');
			const formatName = isZipFormat ? 'ZIP' : 'TAR.GZ';
			
			// Reset status and log
			backupStatus.innerHTML = `<p>Starting ${formatName} backup process...</p>`;
			backupLog.textContent = '';
			
			// Show animation while backup is running
			let progress = 0;
			const progressInterval = setInterval(function() {
				if (progress < 90) {
					progress += Math.random() * 3;
					progress = Math.min(progress, 90);
					progressBar.style.width = progress + '%';
					progressBar.textContent = Math.round(progress) + '%';
				}
			}, 300);
			
			// Add a timestamp to prevent caching
			const timestamp = new Date().getTime();
			const url = backupEndpoint + '?t=' + timestamp;
			
			// Make the AJAX request
			fetch(url, {
				method: 'GET',
				headers: {
					'X-Requested-With': 'XMLHttpRequest',
					'Cache-Control': 'no-cache, no-store, must-revalidate'
				}
			})
			.then(response => {
				// First check if the response is OK
				if (!response.ok) {
					throw new Error('Server returned ' + response.status);
				}
				
				// Get the response as text first to check for valid JSON
				return response.text();
			})
			.then(text => {
				// Try to parse the text as JSON
				try {
					return JSON.parse(text);
				} catch (e) {
					// If parsing fails, throw an error with the raw text
					throw new Error('Invalid JSON response: ' + text.substring(0, 100));
				}
			})
			.then(data => {
				// Clear the progress animation
				clearInterval(progressInterval);
				
				// Complete the progress bar
				progressBar.style.width = '100%';
				progressBar.textContent = '100%';
				progressBar.style.backgroundColor = data.success ? '#4CAF50' : '#f44336';
				
				// Update status based on success
				if (data.success) {
					backupStatus.innerHTML = `
						<p class="backup-success">${formatName} backup completed successfully!</p>
						<p><strong>File:</strong> ${data.backup_file || 'Unknown'}</p>
						<p><strong>Size:</strong> ${data.backup_size || 'Unknown'}</p>
						<p><strong>Time:</strong> ${data.timestamp || new Date().toLocaleString()}</p>
					`;
				} else {
					backupStatus.innerHTML = `
						<p style="color: red;">${formatName} backup process failed.</p>
						<p><strong>Time:</strong> ${data.timestamp || new Date().toLocaleString()}</p>
					`;
				}
				
				// Display the log
				if (data && data.log && Array.isArray(data.log)) {
					backupLog.textContent = data.log.join('\n');
				} else {
					backupLog.textContent = 'No log data available';
				}
			})
			.catch(error => {
				// Clear the progress animation
				clearInterval(progressInterval);
				
				// Update progress bar to show error
				progressBar.style.width = '100%';
				progressBar.textContent = 'Error';
				progressBar.style.backgroundColor = '#f44336';
				
				// Show error message
				backupStatus.innerHTML = `
					<p style="color: red;">Error communicating with the server:</p>
					<p>${error.message}</p>
				`;
				
				// Clear log area with error message
				backupLog.textContent = 'Error occurred during backup process';
			});
		});
	});
	</script>

	<script>
	// Database backup script
	document.addEventListener('DOMContentLoaded', function() {
		const dbBackupButton = document.getElementById('adminDbBackupButton');
		const dbBackupModal = document.getElementById('adminDbBackupModal');
		const dbBackupStatus = document.getElementById('adminDbBackupStatus');
		const dbBackupLog = document.getElementById('adminDbBackupLog');
		const closeDbButton = document.querySelector('.admin-close-db-button');
		
		// Skip if elements don't exist
		if (!dbBackupButton || !dbBackupModal || !dbBackupStatus || !dbBackupLog) return;
		
		// Close modal when clicking the X
		if (closeDbButton) {
			closeDbButton.addEventListener('click', function() {
				dbBackupModal.style.display = 'none';
			});
		}
		
		// Close modal when clicking outside of it
		window.addEventListener('click', function(event) {
			if (event.target === dbBackupModal) {
				dbBackupModal.style.display = 'none';
			}
		});
		
		// Database backup button click handler
		dbBackupButton.addEventListener('click', function() {
			// Show the modal
			dbBackupModal.style.display = 'block';
			
			// Create and add progress bar
			const progressContainer = document.createElement('div');
			progressContainer.className = 'admin-progress-container';
			progressContainer.style.width = '100%';
			progressContainer.style.backgroundColor = '#e0e0e0';
			progressContainer.style.borderRadius = '4px';
			progressContainer.style.marginBottom = '15px';
			progressContainer.style.overflow = 'hidden';
			
			const progressBar = document.createElement('div');
			progressBar.className = 'admin-progress-bar';
			progressBar.style.width = '0%';
			progressBar.style.height = '20px';
			progressBar.style.backgroundColor = '#4CAF50';
			progressBar.style.transition = 'width 0.3s';
			progressBar.style.textAlign = 'center';
			progressBar.style.lineHeight = '20px';
			progressBar.style.color = 'white';
			progressBar.textContent = '0%';
			
			progressContainer.appendChild(progressBar);
			
			// Add the progress bar to the modal before the status
			if (dbBackupStatus.parentNode.querySelector('.admin-progress-container')) {
				dbBackupStatus.parentNode.querySelector('.admin-progress-container').remove();
			}
			dbBackupStatus.parentNode.insertBefore(progressContainer, dbBackupStatus);
			
			// Reset status and log
			dbBackupStatus.innerHTML = '<p>Starting database backup process...</p>';
			dbBackupLog.textContent = '';
			
			// Record last progress state to avoid reverting to "Not started"
			let lastProgress = { progress: 0, message: 'Starting database backup process...' };
			let completionData = null;
			
			// Start real progress tracking with more frequent updates (100ms instead of 500ms)
			const progressInterval = setInterval(function() {
				fetch('/api/create_db_backup.php?check_progress=1')
					.then(response => response.json())
					.then(data => {
						if (data && typeof data.progress !== 'undefined') {
							// Only update if we get valid data with progress
							if (data.progress > 0 || (data.message && data.message !== 'Not started')) {
								// Update progress bar with real progress
								progressBar.style.width = data.progress + '%';
								progressBar.textContent = data.progress + '%';
								
								// Update status message if available
								if (data.message) {
									// Convert newlines to <br> tags for HTML display
									const formattedMessage = data.message.replace(/\n/g, '<br>');
									dbBackupStatus.innerHTML = `<p>${formattedMessage}</p>`;
								}
								
								// Store completion data if at 100%
								if (data.progress === 100) {
									completionData = data;
								}
								
								// Store this as our last valid progress
								lastProgress = { 
									progress: data.progress, 
									message: data.message 
								};
							} else if (lastProgress.progress > 0) {
								// If we got a "Not started" but had previous progress, restore it
								progressBar.style.width = lastProgress.progress + '%';
								progressBar.textContent = lastProgress.progress + '%';
								
								if (lastProgress.message) {
									// If already at 100%, don't override with older messages
									if (lastProgress.progress < 100 || !completionData) {
										const formattedMessage = lastProgress.message.replace(/\n/g, '<br>');
										dbBackupStatus.innerHTML = `<p>${formattedMessage}</p>`;
									}
								}
							}
							
							// If completed or error, stop checking
							if (data.progress === 100 || data.progress === -1) {
								clearInterval(progressInterval);
							}
						}
					})
					.catch(err => {
						console.error('Error checking progress:', err);
						// On error, keep last known progress
						if (lastProgress.progress > 0) {
							progressBar.style.width = lastProgress.progress + '%';
							progressBar.textContent = lastProgress.progress + '%';
							if (lastProgress.message) {
								const formattedMessage = lastProgress.message.replace(/\n/g, '<br>');
								dbBackupStatus.innerHTML = `<p>${formattedMessage}</p>`;
							}
						}
					});
			}, 100); // Check every 100ms instead of 500ms

			// Perform AJAX request to the database backup script
			fetch('/api/create_db_backup.php?start_backup=1', {
				method: 'GET',
				headers: {
					'X-Requested-With': 'XMLHttpRequest'
				}
			})
			.then(response => {
				if (!response.ok) {
					throw new Error('Network response was not ok: ' + response.status);
				}
				return response.json();
			})
			.then(data => {
				// Clear the progress interval
				clearInterval(progressInterval);
				
				// Ensure progress bar shows final state
				progressBar.style.width = data.progress === -1 ? '100%' : '100%';
				progressBar.textContent = data.progress === -1 ? 'Error' : '100%';
				progressBar.style.backgroundColor = data.success ? '#4CAF50' : '#f44336';
				
				// Create complete success information display
				if (data.success) {
					// Check if message already contains formatted information
					if (data.message && data.message.includes('Size:')) {
						// Message already has formatting, just convert newlines to <br>
						const formattedMessage = data.message.replace(/\n/g, '<br>');
						dbBackupStatus.innerHTML = `<p>${formattedMessage}</p>`;
					} else {
						// Create a nicely formatted message
						dbBackupStatus.innerHTML = `
							<p class="backup-success">Database backup completed successfully!</p>
							<p><strong>File:</strong> ${data.backup_file}</p>
							<p><strong>Size:</strong> ${data.backup_size}</p>
							<p><strong>Time:</strong> ${data.timestamp}</p>
						`;
					}
				} else {
					dbBackupStatus.innerHTML = `
						<p style="color: red;">Database backup process failed.</p>
						<p><strong>Error:</strong> ${data.error || 'Unknown error'}</p>
						<p><strong>Time:</strong> ${data.timestamp}</p>
					`;
				}
				
				// Display the log
				if (data && data.log && Array.isArray(data.log)) {
					dbBackupLog.textContent = data.log.join('\n');
				} else {
					dbBackupLog.textContent = 'No log data available';
				}
			})
			.catch(error => {
				// Clear the progress interval
				clearInterval(progressInterval);
				
				// Show error in progress bar
				progressBar.style.width = '100%';
				progressBar.textContent = 'Error';
				progressBar.style.backgroundColor = '#f44336';
				
				dbBackupStatus.innerHTML = `
					<p style="color: red;">Error communicating with the server:</p>
					<p>${error.message}</p>
				`;
			});
		});
	});
	</script>

	<script>
	// Admin tools toggle
	document.addEventListener('DOMContentLoaded', function() {
		const toolsHeader = document.querySelector('.admin-tools-header');
		const toolsContent = document.querySelector('.admin-tools-content');
		
		if (toolsHeader && toolsContent) {
			toolsHeader.addEventListener('click', function() {
				toolsContent.classList.toggle('admin-is-closed');
				toolsHeader.classList.toggle('admin-is-closed');
			});
		}
	});
	
	// Admin tools collapse state memory without initial animation
	document.addEventListener('DOMContentLoaded', function() {
		const toolsHeader = document.querySelector('.admin-tools-header');
		const toolsContent = document.querySelector('.admin-tools-content');
		
		if (toolsHeader && toolsContent) {
			// Get saved state from localStorage
			const isCollapsed = localStorage.getItem('adminToolsCollapsed') === 'true';
			
			// Apply saved state without animation
			if (isCollapsed) {
				toolsContent.classList.add('admin-is-closed');
				toolsHeader.classList.add('admin-is-closed');
			}
			
			// Add transition class after initial state is applied (delayed to ensure it's not visible)
			setTimeout(function() {
				toolsContent.classList.add('transition-enabled');
			}, 300);
			
			// Use click event instead of replacing the existing one
			toolsHeader.addEventListener('click', function() {
				// Save current state to localStorage after toggling
				setTimeout(function() {
					const currentlyCollapsed = toolsContent.classList.contains('admin-is-closed');
					localStorage.setItem('adminToolsCollapsed', currentlyCollapsed);
				}, 50);
			});
		}
	});
	</script>
	
	<script>
	// backup format toggle
	document.addEventListener('DOMContentLoaded', function() {
		// Backup format toggle
		const backupButton = document.getElementById('adminBackupButton');
		
		if (backupButton) {
			// Create toggle container
			const toggleContainer = document.createElement('div');
			toggleContainer.className = 'backup-format-toggle';
			
			// Create toggle switch
			const toggleLabel = document.createElement('label');
			toggleLabel.className = 'backup-format-switch';
			
			const toggleInput = document.createElement('input');
			toggleInput.type = 'checkbox';
			toggleInput.id = 'backupFormatToggle';
			
			// Set initial state from localStorage (default to TAR.GZ = false)
			const savedFormat = localStorage.getItem('backupFormatZip');
			const useZipFormat = savedFormat !== null ? savedFormat === 'true' : false;
			toggleInput.checked = useZipFormat;
			
			// Set the initial backup endpoint
			window.backupEndpoint = useZipFormat ? '/api/create_backup_zip.php' : '/api/create_backup.php';
			
			const toggleSlider = document.createElement('span');
			toggleSlider.className = 'backup-format-slider';
			
			// Add label text
			const toggleText = document.createElement('span');
			toggleText.id = 'backupFormatText';
			toggleText.textContent = useZipFormat ? '.ZIP' : '.TAR.GZ';
			
			// Build the toggle
			toggleLabel.appendChild(toggleInput);
			toggleLabel.appendChild(toggleSlider);
			toggleContainer.appendChild(toggleLabel);
			toggleContainer.appendChild(toggleText);
			
			// Create a wrapper for the button and toggle
			const buttonWrapper = document.createElement('div');
			buttonWrapper.className = 'admin-button-toggle-wrapper';
			
			// Insert wrapper in place of backup button
			backupButton.parentNode.insertBefore(buttonWrapper, backupButton);
			
			// Move backup button into wrapper and add toggle
			buttonWrapper.appendChild(backupButton);
			buttonWrapper.appendChild(toggleContainer);
			
			// Add event listener for toggle
			toggleInput.addEventListener('change', function() {
				const useZipFormat = this.checked;
				const formatText = document.getElementById('backupFormatText');
				
				// Update text to match the selected format
				formatText.textContent = useZipFormat ? '.ZIP' : '.TAR.GZ';
				
				// Update the endpoint
				window.backupEndpoint = useZipFormat ? '/api/create_backup_zip.php' : '/api/create_backup.php';
				
				// Save selection to localStorage
				localStorage.setItem('backupFormatZip', useZipFormat);
				
				console.log('Format changed to:', useZipFormat ? 'ZIP' : 'TAR.GZ', 'Endpoint:', window.backupEndpoint);
			});
			
			// Override the original click to ensure our endpoint is used
			backupButton.addEventListener('click', function(event) {
				event.preventDefault();
				
				// Get current endpoint
				const endpoint = window.backupEndpoint || '/api/create_backup.php';
				console.log('Using endpoint:', endpoint);
				
				// Display modal and start the backup process
				const backupModal = document.getElementById('adminBackupModal');
				const backupStatus = document.getElementById('adminBackupStatus');
				const backupLog = document.getElementById('adminBackupLog');
				
				if (backupModal && backupStatus && backupLog) {
					// Show the modal
					backupModal.style.display = 'block';
					
					// Create and add progress bar
					const progressContainer = document.createElement('div');
					progressContainer.className = 'admin-progress-container';
					
					const progressBar = document.createElement('div');
					progressBar.className = 'admin-progress-bar';
					progressBar.style.width = '0%';
					progressBar.textContent = '0%';
					
					progressContainer.appendChild(progressBar);
					
					// Add the progress bar to the modal before the status
					if (backupStatus.parentNode.querySelector('.admin-progress-container')) {
						backupStatus.parentNode.querySelector('.admin-progress-container').remove();
					}
					backupStatus.parentNode.insertBefore(progressContainer, backupStatus);
					
					// Get format name for display
					const isZipFormat = endpoint.includes('zip');
					const formatName = isZipFormat ? '.ZIP' : '.TAR.GZ';
					
					// Reset status and log
					backupStatus.innerHTML = `<p>Starting ${formatName} backup process...</p>`;
					backupLog.textContent = '';
					
					// Show animation while backup is running
					let progress = 0;
					const progressInterval = setInterval(function() {
						if (progress < 90) {
							progress += Math.random() * 3;
							progress = Math.min(progress, 90);
							progressBar.style.width = progress + '%';
							progressBar.textContent = Math.round(progress) + '%';
						}
					}, 300);
					
					// Add a timestamp to prevent caching
					const timestamp = new Date().getTime();
					const url = endpoint + '?t=' + timestamp;
					
					// Make the AJAX request
					fetch(url, {
						method: 'GET',
						headers: {
							'X-Requested-With': 'XMLHttpRequest',
							'Cache-Control': 'no-cache, no-store, must-revalidate'
						}
					})
					.then(response => {
						// First check if the response is OK
						if (!response.ok) {
							throw new Error('Server returned ' + response.status);
						}
						
						// Get the response as text first to check for valid JSON
						return response.text();
					})
					.then(text => {
						// Try to parse the text as JSON
						try {
							return JSON.parse(text);
						} catch (e) {
							// If parsing fails, throw an error with the raw text
							throw new Error('Invalid JSON response: ' + text.substring(0, 100));
						}
					})
					.then(data => {
						// Clear the progress animation
						clearInterval(progressInterval);
						
						// Complete the progress bar
						progressBar.style.width = '100%';
						progressBar.textContent = '100%';
						progressBar.style.backgroundColor = data.success ? '#4CAF50' : '#f44336';
						
						// Update status based on success
						if (data.success) {
							backupStatus.innerHTML = `
								<p class="backup-success">${formatName} backup completed successfully!</p>
								<p><strong>File:</strong> ${data.backup_file || 'Unknown'}</p>
								<p><strong>Size:</strong> ${data.backup_size || 'Unknown'}</p>
								<p><strong>Time:</strong> ${data.timestamp || new Date().toLocaleString()}</p>
							`;
						} else {
							backupStatus.innerHTML = `
								<p style="color: red;">${formatName} backup process failed.</p>
								<p><strong>Time:</strong> ${data.timestamp || new Date().toLocaleString()}</p>
							`;
						}
						
						// Display the log
						if (data.log && Array.isArray(data.log)) {
							backupLog.textContent = data.log.join('\n');
						} else {
							backupLog.textContent = 'No log data available';
						}
					})
					.catch(error => {
						// Clear the progress animation
						clearInterval(progressInterval);
						
						// Update progress bar to show error
						progressBar.style.width = '100%';
						progressBar.textContent = 'Error';
						progressBar.style.backgroundColor = '#f44336';
						
						// Show error message
						backupStatus.innerHTML = `
							<p style="color: red;">Error communicating with the server:</p>
							<p>${error.message}</p>
						`;
						
						// Clear log area with error message
						backupLog.textContent = 'Error occurred during backup process';
					});
				}
			}, true); // Use capture to ensure this runs first
		}
	});
	</script>
		      
	<?php include ($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>
</body>
</html>

