<?php
// File: includes/upload_profile_picture_admin.php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');

function resizeImage($file, $max_width, $max_height) {
    list($width, $height) = getimagesize($file);
    $ratio = min($max_width/$width, $max_height/$height);
    $new_width = $width * $ratio;
    $new_height = $height * $ratio;
    
    $src = imagecreatefromstring(file_get_contents($file));
    $dst = imagecreatetruecolor($new_width, $new_height);
    imagecopyresampled($dst, $src, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
    
    ob_start();
    imagejpeg($dst, null, 90);
    $resized_image = ob_get_contents();
    ob_end_clean();
    
    imagedestroy($src);
    imagedestroy($dst);
    
    return $resized_image;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['profile_picture'])) {
    $userId = $_SESSION['front_user_id'];
    $file = $_FILES['profile_picture'];

    $stmt = $pdo->prepare("SELECT unique_id FROM " . PREFIX . "users WHERE ID = ?");
    $stmt->execute([$userId]);
    $unique_id = $stmt->fetchColumn();

    if (!$unique_id) {
        $unique_id = bin2hex(random_bytes(8));
        $stmt = $pdo->prepare("UPDATE " . PREFIX . "users SET unique_id = ? WHERE ID = ?");
        $stmt->execute([$unique_id, $userId]);
    }

    $uploadDir = $_SERVER['DOCUMENT_ROOT'] . "/images/profiles/" . $unique_id . "/";
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $fileName = uniqid() . "." . pathinfo($file['name'], PATHINFO_EXTENSION);
    $targetFile = $uploadDir . $fileName;

    $resized_image = resizeImage($file['tmp_name'], 150, 150);

    if (file_put_contents($targetFile, $resized_image)) {
        $stmt = $pdo->prepare("UPDATE " . PREFIX . "users SET profile_picture = ? WHERE ID = ?");
        if ($stmt->execute([$fileName, $userId])) {
            echo json_encode([
                'success' => true,
                'message' => 'Profile picture updated successfully.',
                'newImageUrl' => "/images/profiles/" . $unique_id . "/" . $fileName
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update database.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to save uploaded file.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request.']);
}