<?php
// updategroup.php
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $groupId = $_POST['groupId'];
   
   // Fetch the current group data
   $stmt = $pdo->prepare("SELECT * FROM wp_groups WHERE id = ?");
   $stmt->execute([$groupId]);
   $currentGroupData = $stmt->fetch(PDO::FETCH_ASSOC);

   if (!$currentGroupData) {
       echo json_encode(['success' => false, 'error' => 'Group not found']);
       exit;
   }

   // Validate date fields
   $dateFields = ['expirationDate', 'proUpgradeDate', 'proExpirationDate'];
   foreach ($dateFields as $field) {
       if (!empty($_POST[$field]) && !validateDate($_POST[$field])) {
           echo json_encode(['success' => false, 'error' => "Invalid date for $field"]);
           exit;
       }
   }

   // Prepare update data
   $updateData = [
       'group_name' => $_POST['groupName'] ?? $currentGroupData['group_name'],
       'group_admin' => $_POST['groupAdmin'] ?? $currentGroupData['group_admin'],
       'group_email' => $_POST['groupEmail'] ?? $currentGroupData['group_email'],
       'expiration_date' => $_POST['expirationDate'] ?? $currentGroupData['expiration_date'],
       'group_status' => $_POST['groupStatus'] ?? $currentGroupData['group_status'],
       'group_institution_address' => $_POST['groupInstitutionAddress'] ?? $currentGroupData['group_institution_address'],
       'pro_status' => $_POST['proStatus'] ?? $currentGroupData['pro_status'],
       'pro_upgrade_date' => $_POST['proUpgradeDate'] ?? $currentGroupData['pro_upgrade_date'],
       'pro_expiration_date' => $_POST['proExpirationDate'] ?? $currentGroupData['pro_expiration_date'],
       'group_notes' => $_POST['groupNotes'] ?? $currentGroupData['group_notes'],
       'group_pass_clear' => $_POST['groupPassword'] ?? $currentGroupData['group_pass_clear']
   ];

   if (!empty($_POST['groupPassword'])) {
       $salt = sha1(md5($_POST['groupPassword']));
       $password = md5($_POST['groupPassword'].$salt);
       $updateData['group_pass'] = $password;
   }

   // Handle empty values
   foreach ($updateData as $key => $value) {
       if ($value === '') {
           $updateData[$key] = null;
       }
   }

   $sql = "UPDATE wp_groups SET 
           group_name = :group_name,
           group_admin = :group_admin,
           group_email = :group_email,
           expiration_date = :expiration_date,
           group_status = :group_status,
           group_institution_address = :group_institution_address,
           pro_status = :pro_status,
           pro_upgrade_date = :pro_upgrade_date,
           pro_expiration_date = :pro_expiration_date,
           group_notes = :group_notes,
           group_pass_clear = :group_pass_clear" .
           (!empty($_POST['groupPassword']) ? ", group_pass = :group_pass" : "") .
           " WHERE id = :id";

   $executeArray = [
       ':group_name' => $updateData['group_name'],
       ':group_admin' => $updateData['group_admin'],
       ':group_email' => $updateData['group_email'],
       ':expiration_date' => $updateData['expiration_date'],
       ':group_status' => $updateData['group_status'],
       ':group_institution_address' => $updateData['group_institution_address'],
       ':pro_status' => $updateData['pro_status'],
       ':pro_upgrade_date' => $updateData['pro_upgrade_date'],
       ':pro_expiration_date' => $updateData['pro_expiration_date'],
       ':group_notes' => $updateData['group_notes'],
       ':group_pass_clear' => $updateData['group_pass_clear'],
       ':id' => $groupId
   ];

   if (!empty($_POST['groupPassword'])) {
       $executeArray[':group_pass'] = $password;
   }

   $stmt = $pdo->prepare($sql);
   $result = $stmt->execute($executeArray);

	if ($result) {
		// If this is group admin's email (email matches group email), update user too
		if ($_POST['groupEmail'] !== $currentGroupData['group_email']) {
			$stmt = $pdo->prepare("SELECT id FROM wp_users WHERE user_email = ? AND group_id = ?");
			$stmt->execute([$currentGroupData['group_email'], $groupId]);
			
			if ($stmt->rowCount() > 0) {
				// This is the group admin user, update their email
				$stmt = $pdo->prepare("UPDATE wp_users SET user_email = ? WHERE user_email = ? AND group_id = ?");
				$stmt->execute([$_POST['groupEmail'], $currentGroupData['group_email'], $groupId]);
			}
		}

		// Handle password updates if needed
		if (!empty($_POST['groupPassword'])) {
			$stmt = $pdo->prepare("UPDATE wp_users SET user_pass = ? WHERE group_id = ?");
			$stmt->execute([$password, $groupId]);
		}

		echo json_encode(['success' => true, 'data' => $updateData]);
	} else {
       echo json_encode(['success' => false, 'error' => 'Failed to update group']);
   }
} else {
   echo json_encode(['success' => false, 'error' => 'Invalid request method (update group)']);
}

function validateDate($date, $format = 'Y-m-d') {
   $d = DateTime::createFromFormat($format, $date);
   return $d && $d->format($format) === $date;
}