<?php /** Administration Bootstrap */

	//session_start();
	chdir('../');
	
	include('includes/include_all.inc.php');
	
	include ($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/session_logic.inc.php');
		
	// current page variable
	$current_page = 'groups';

	$orderBy = "ORDER BY group_name ASC"; // Default sorting

	if (isset($_GET["sort"])) {
		switch ($_GET["sort"]) {
			case "name_asc":
				$orderBy = "ORDER BY group_name ASC";
				$nameSortNext = "name_desc";
				$nameLabel = "Sort Z-A";
				break;
			case "name_desc":
				$orderBy = "ORDER BY group_name DESC";
				$nameSortNext = "name_asc";
				$nameLabel = "Sort A-Z";
				break;
			case "admin_asc":
				$orderBy = "ORDER BY group_admin ASC";
				$adminSortNext = "admin_desc";
				$adminLabel = "Sort Z-A";
				break;
			case "admin_desc":
				$orderBy = "ORDER BY group_admin DESC";
				$adminSortNext = "admin_asc";
				$adminLabel = "Sort A-Z";
				break;
		}
	}

	$nameLabel = $nameLabel ?? "Sort Z-A";
	$nameSortNext = $nameSortNext ?? "name_desc";
	$adminLabel = $adminLabel ?? "Sort Z-A";
	$adminSortNext = $adminSortNext ?? "admin_desc";
	
	include ($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php'); 
	
?>

<div class="wrap about-wrap">

	<div class="tabs">
	   <div class="tab users-tab">
		   <a class="tabslinks" href="index.php">Users</a>
	   </div>

	   <div class="tab data-tab">
		   <a class="tabslinks" href="data.php">Data</a>
	   </div>
	   
	   <div class="tab groups-tab">
		   <span class="currentlink">Groups</span>
		   
		   <div class="content">
			   <h2>Registered Groups</h2><br>
				
				<script src="http://cdnjs.cloudflare.com/ajax/libs/jquery/1.9.0/jquery.min.js" type="text/javascript"></script>
				<script src="http://www.appelsiini.net/download/jquery.jeditable.js" type="text/javascript"></script>

				   <script type="text/javascript"> 
					   $(document).ready(function() {
					   $('.group_name').editable('../save-groups.php', {
						   name      : 'group_name',
						   id        : 'element_id'
					   });
					   $('.group_admin').editable('../save-groups.php', {
						   name      : 'group_admin',
						   id        : 'element_id'
					   });
					   $('.group_email').editable('../save-groups.php', {
						   name      : 'group_email',
						   id        : 'element_id'
					   });
					   $('.group_status').editable('../save-groups.php', {
						   name      : 'group_status',
						   id        : 'element_id'
					   });
					   $('.group_notes').editable('../save-groups.php', {
						   name      : 'group_notes',
						   id        : 'element_id'
					   });
					   $('.edit_area').editable('../save-groups.php', { 
						   type      : 'input',
						   id        : 'element_id',
						   cancel    : 'Cancel',
						   submit    : 'OK',
						   indicator : '<img src="img/indicator.gif">',
						   tooltip   : 'Click to edit...'
					   });
				   });
				   </script>
				<div class="table-cont">
				<div class="table-cont">
				<table class="home-table">
					<tr>
						<th width="20%">Group Name <a href="?sort=<?php echo $nameSortNext; ?>"><?php echo $nameLabel; ?></a></th>
						<th width="20%">Admin Username <a href="?sort=<?php echo $adminSortNext; ?>"><?php echo $adminLabel; ?></a></th>
						<th width="20%">Group Admin Email</th>
						<th width="10%">Is Group Paid?</th>
						<th width="10%">Notes</th>
					</tr>
					 <?php 
						try {
						// Prepare and execute the query
						$stmt = $pdo->query("SELECT * FROM wp_groups $orderBy");
						
						// Fetch all rows
						$groups = $stmt->fetchAll(PDO::FETCH_ASSOC);
						
						// Check if we have any groups
						if (count($groups) > 0) {
							foreach ($groups as $group) {
								echo "<tr>";
								echo "<td class='group_name' id='name_" . htmlspecialchars($group['id'] ?? '') . "'>" . htmlspecialchars($group['group_name'] ?? '') . "</td>";
								echo "<td class='group_admin' id='admin_" . htmlspecialchars($group['id'] ?? '') . "'>" . htmlspecialchars($group['group_admin'] ?? '') . "</td>";
								echo "<td class='group_email' id='email_" . htmlspecialchars($group['id'] ?? '') . "'>" . htmlspecialchars($group['group_email'] ?? '') . "</td>";
								echo "<td class='group_status' id='status_" . htmlspecialchars($group['id'] ?? '') . "'>" . htmlspecialchars($group['group_status'] ?? '') . "</td>";
								echo "<td class='group_notes' id='notes_" . htmlspecialchars($group['id'] ?? '') . "'>" . htmlspecialchars($group['group_notes'] ?? '') . "</td>";
								echo "</tr>";
							}
						} else {
							echo "<tr><td colspan='5'>No groups found</td></tr>";
						}
					} catch(PDOException $e) {
						// Handle any errors
						echo "An error occurred: " . htmlspecialchars($e->getMessage());
					}
					?>
				</table>
				</div>
		   </div> 
	   </div>
	   
		<div class="tab newuser-tab">
		   <a class="tabslinks" href="newuser.php">New User</a>
	   </div>
	   
		<div class="tab newgroup-tab">
		   <a class="tabslinks" href="newgroup.php">New Group</a>
	   </div>
	   
	   <div class="tab stats-tab">
		   <a class="tabslinks" href="statistics.php">Statistics</a>
	   </div>

	   <div class="tab ops-tab">
		   <a class="tabslinks" href="operations.php">Operations</a>
	   </div>
	</div>
	
</div>
<?php include ($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>
</body>
</html>