<?php // Administration Bootstrap 
// index.php
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	//session_start();
	chdir('../');
	include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
	/* **************** HEADER FROM MAIN (REQUIRED FOR MENU) **************/
	// Attempts to move this to the header logic file failed, 
	// possibly because menu.php has relative queries
	include ($_SERVER['DOCUMENT_ROOT'] . '/menu.php');
	$userDetails = menuUserDetails($_SESSION['front_user_id']);
	/* ***************** END HEADER FROM MAIN *****************************/
	include ($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/header_logic.inc.php');
	
	// pro api
	include ($_SERVER['DOCUMENT_ROOT'] . '/api/pro_features.php');
	
	// current page variable
	$current_page = 'dev_sync';

	// redirect regular admins to groups page if they land here
	// effectively hides index (super admin overview) from regular admins
	if($usertype == 'admin'){
		header("Location: ../admin/groups"); // Redirect to the groups page
		exit();
	}
	
	include ($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');
	
	$groupWhere = "";
	
	if($usertype == 'admin'){
	    $groupWhere = " WHERE group_name = '".$_SESSION['user_group']."' ";
	}
?>

<?php /* ****************** BEGIN HOME PAGE ********************/ ?>

			
			<h1>Push Dev To Live</h1>
		<div class="push-container">
			
			<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
			<style>
				.push-container {
					font-family: Arial, sans-serif;
					max-width: 237px;
					margin: -40px auto 0 auto;
					padding: 20px;
				}
				h1 {
					color: #fff;
					text-shadow: none;
				}
				.output-container {
					padding: 10px;
					border: 1px solid #5e6984;
					border-radius: 4px;
					background-color: #5e6984;
					min-height: 100px;
					display: none;
					max-width: 800px;
					margin: 20px auto;
				}
				.error {
					color: red;
				}
				button {
					padding: 10px 15px;
					background-color: #4CAF50;
					color: white;
					border: none;
					border-radius: 4px;
					cursor: pointer;
				}
				button:hover {
					background-color: #45a049;
				}
				select {
					padding: 8px;
					margin-right: 10px;
				}
				.loading {
					display: none;
					margin-left: 10px;
				}
				select {
					float: left;
					max-width: 131px;
					text-align: center;
				}
				pre {
					white-space: pre-wrap;
					word-wrap: break-word;
					background-color: #000;
					padding: 10px;
					border: 1px solid #ccc;
					border-radius: 4px;
					max-height: 500px;
					overflow-y: auto;
					color: #fff;
				}
				.refresh-btn {
					background-color: #007bff;
					margin-left: 10px;
				}
				.refresh-btn:hover {
					background-color: #0056b3;
				}
			</style>
			
			<div>
				<p>Do you want to create a backup?</p>
				<select id="backup_choice">
					<option value="y">Yes</option>
					<option value="n">No</option>
				</select>
				<button id="run_script">Run Script</button>
				<span class="loading">Running...</span>
			</div> 
		</div>
		
		<div class="output-container">
			<h3>Output: <button id="refresh_log" class="refresh-btn">Refresh</button></h3>
			<pre id="output"></pre>
		</div>
			
		<script>
			$(document).ready(function() {
				$('#run_script').click(function() {
					var backupChoice = $('#backup_choice').val();
					$('.loading').show();
					$('#output').html(''); // Clear previous output
					$('.output-container').show(); // Show container immediately
						
					$.ajax({
						url: '/api/push_live.php',
						type: 'POST',
						data: {
							backup_choice: backupChoice
						},
						success: function(response) {
							$('#output').html(response);
							$('.loading').hide();
							
							// Set up auto-refresh after script execution begins
							if (response.includes("Script execution scheduled")) {
								// Set a timer to check for log updates
								setTimeout(refreshLog, 10000); // Refresh after 10 seconds
							}
						},
						error: function(xhr, status, error) {
							$('#output').html('<span class="error">Error: ' + error + '</span>');
							$('.loading').hide();
						}
					});
				});
				
				// Function to refresh the log
				function refreshLog() {
					$.ajax({
						url: '/api/view_log.php',
						type: 'GET',
						success: function(response) {
							if (response.includes("Script execution completed")) {
								// If script has completed, update the output and stop refreshing
								$('#output').html(response);
							} else {
								// Otherwise, update and schedule another refresh
								$('#output').html(response);
								setTimeout(refreshLog, 10000); // Check again in 10 seconds
							}
						}
					});
				}
				
				// Manual refresh button
				$('#refresh_log').click(function() {
					$.ajax({
						url: '/api/view_log.php',
						type: 'GET',
						success: function(response) {
							$('#output').html(response);
						}
					});
				});
			});
		</script>
				      
		
	<div id="popup" class="confirmation-popup" style="display: none;"></div>
		      
	<?php include ($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>
</body>
</html>