<?php
	function ReportError($e, $mysqliMessage = ""){
		echo "<div style='background-color:#CCCCCC;
											border:1px dotted red;
											width:300px;
											height:380px;
											margin:0;
											padding:5px;
											word-wrap: break-word;
											display:block;
											position:fixed;
											top:15%;
											left:20%;
											font-family:Verdana,Geneva,sans-serif;
											font-size:70%;
											font-weight:bold;'>";
			echo "Error: ".$e->getMessage()."<br />";
			echo "File: ".basename($e->getFile())."<br />";
			echo "Line: ".$e->getLIne()."<br />";
			if ($mysqliMessage != "") {
				echo mysqli_connect_error();
			}
		echo "</div>\n";
	}

	chdir('../');

	include('includes/include_all.inc.php');

	try {
		$pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
		$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	} catch(PDOException $e) {
		die("Connection failed: " . $e->getMessage());
	}

	//Create User object
	$obj_users = new Users($pdo);

	if(!$obj_users->checkUserLoginOrNot()){
		header('Location: '.BASEURL.'login.php');
		exit();
	} 

	if($_SESSION['user_type']!='super' && $_SESSION['user_type']!='admin'){ 
		session_destroy();
		header('Location: '.BASEURL.'login.php');
		exit();
	}

	if(isset($_GET["id"]) && !empty($_GET["id"])) {
		$userID = (int)$_GET['id'];
	} else {
		header('Location: '.BASEURL.'admin/users.php');
		exit();
	}

	try {
		$pdo->beginTransaction();

		$deleteQuery = "DELETE FROM wp_users WHERE id = :userID";
		$stmt = $pdo->prepare($deleteQuery);
		$stmt->bindParam(':userID', $userID, PDO::PARAM_INT);
		$stmt->execute();

		$deleteCasesQuery = "DELETE FROM wp_groupusers_data WHERE user_id = :userID";
		$stmt = $pdo->prepare($deleteCasesQuery);
		$stmt->bindParam(':userID', $userID, PDO::PARAM_INT);
		$stmt->execute();

		$pdo->commit();
	} catch (Exception $e) {
		$pdo->rollBack();
		ReportError($e);
		header('Location: '.BASEURL.'admin/users.php');
		exit();
	}

	header('Location: '.BASEURL.'admin/users.php');
?>


