<?php
// casesdetailsuccinct.php - displays only the case detail no other columns or rows
chdir('../');

include('includes/include_all.inc.php');

// current page variable
$current_page = 'cases';

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

//Create User object
$obj_users = new Users($pdo);

if (!$obj_users->checkUserLoginOrNot()) {
    header('Location: ' . BASEURL . 'login.php');
    exit();
}

if ($_SESSION['user_type'] != 'super' && $_SESSION['user_type'] != 'admin') {
    session_destroy();
    header('Location: ' . BASEURL . 'login.php');
    exit();
}

// Check if the case ID and user ID are provided in the URL
if (!isset($_GET['id']) || !isset($_GET['userid'])) {
    header('Location: ' . BASEURL . 'admin/cases.php');
    exit();
}

$caseId = (int)$_GET['id'];
$userid = (int)$_GET['userid'];

// Fetch the user information
$user_info = $obj_users->getUsersFromId($userid);

// Check if the user exists
if (!$user_info) {
    header('Location: ' . BASEURL . 'admin/cases.php');
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');
?>

<h2><center><?php echo $user_info[0]['user_email'] ?></center></h2>

<div class="table-cont">
    <table class="home-table" style="width: 60%;">
        <?php
        $oneCase = "SELECT
                        user_data,
                        DATE_FORMAT(datetime, '%Y-%m-%d %l:%i %p') AS dateformatted
                    FROM wp_groupusers_data
                    WHERE id = :caseId";
        try {
            $stmt = $pdo->prepare($oneCase);
            $stmt->bindParam(':caseId', $caseId, PDO::PARAM_INT);
            $stmt->execute();

            while ($oneRow = $stmt->fetch(PDO::FETCH_ASSOC)) {
                ?>
                <tr>
                    <td>
                        <?php echo nl2br(urldecode($oneRow['user_data'])); ?>
                    </td>
                </tr>
                <?php
            }
        } catch (PDOException $e) {
            echo "An error occurred: " . htmlspecialchars($e->getMessage());
        }
        ?>
    </table>
</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>
</body>
</html>