<?php
// Include your header file
include_once 'header_basic.php';
?>

<div class="error-page-container">
    <div class="error-content">
        <h1>404</h1>
        <h2>Oops! Page Not Found</h2>
        <p>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>
        <a href="/" class="home-button">Go to Homepage</a>
    </div>
    <div class="error-image">
        <!-- You can replace this with an actual image or an SVG -->
        <svg xmlns="http://www.w3.org/2000/svg" width="300" height="300" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <circle cx="12" cy="12" r="10"/>
            <line x1="12" y1="8" x2="12" y2="12"/>
            <line x1="12" y1="16" x2="12" y2="16"/>
        </svg>
    </div>
</div>

<style>
    .error-page-container {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 60vh;
        padding: 2rem;
    }
    .error-content {
        text-align: center;
        margin-right: 2rem;
    }
    .error-content h1 {
        font-size: 6rem;
        color: #3498db;
        margin-bottom: 0;
    }
    .error-content h2 {
        font-size: 2rem;
        color: #2c3e50;
        margin-top: 0;
    }
    .error-content p {
        font-size: 1.2rem;
        color: #7f8c8d;
        max-width: 400px;
        margin: 1rem auto;
    }
    .home-button {
        display: inline-block;
        padding: 0.8rem 1.5rem;
        background-color: #3498db;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        font-weight: bold;
        transition: background-color 0.3s ease;
    }
    .home-button:hover {
        background-color: #2980b9;
    }
    .error-image {
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .error-image svg {
        width: 300px;
        height: 300px;
        stroke: #3498db;
    }
    @media (max-width: 768px) {
        .error-page-container {
            flex-direction: column;
        }
        .error-content {
            margin-right: 0;
            margin-bottom: 2rem;
        }
    }
</style>

<?php
// Include your footer file
include_once 'footer.php';
?>