CaseData[17] = {
    "title": "Case 17 - 60 year old for resection of posterior fossa tumor", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 3, 
    "debriefMsg": "\nYou must become adept at the differential diagnosis of hypotension under anesthesia. Venous air embolism can occur in any case in which the operative site is significantly higher than the heart. It is essential to make the diagnosis early and decrease the continued entrainment of air by lowering the operative site and flooding the operative field. It may be possible to aspirate some of the air from a central venous catheter. In addition, you must treat aggressively by securing the airway, ventilating with 100% oxygen, and providing inotropic support as needed. \n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 4, 
    "initialSat": 96, 
    "leanBodyMass": 80, 
    "learningObj": "\n60 year old for resection of posterior fossa tumor (75 kg)\n\nThis patient has a recently diagnosed brain tumor. After induction the surgeon will postion the patient lateral, 15 degrees head up.\n\nLearning Objectives\n1.  Describe the pathophysiology of venous air embolism.\n2.  Describe methods to monitor for this condition.\n3.  List treatment steps for venous air embolism.\n\nAnesthetic Considerations:\nPosterior fossa surgery is associated with venous air embolism, tension pneumocephalus, and hemodynamic instability.\n\nSuggested Anesthetic Plan:\n1.  Routine monitoring, plus direct arterial pressure, central venous catheter, precordial doppler\n2.  Hyperventilate with oxygen\n3.  Narcotics, propofol, relaxant prior to intubation\n4.  Maintenance with oxygen, narcotics, less than one MAC inhalation agent, relaxant\n5.  Extubate following return of airway reflexes\n\nClinical situations associated with Venous Air Embolism:\nProcedures with gas insufflation: arthroscopy, carbon dioxide hysteroscopy, laparoscopy, urethral insufflation\nPressure gradient for gas entry: head and neck trauma, hyperbaric oxygen therapy, positive pressure ventilation, vascular cannulation\nDiagnostic or therapeutic procedures: contrast enhanced CAT scan, percutaneous lung biopsy, use of Nd-YAG laser\nSurgical: Cesarean section, craniofacial surgery, dental implant surgery, posterior spinal fusion, total hip arthroplasty\n\nMonitors to detect Venous Air Embolism:\nHigh degree of sensitivity (<0.1 ml/kg):\nPrecordial doppler\nTransesophageal echo\n\nModerate to high sensitivity (0.1-0.2 ml/kg):\nEnd-tidal CO2 (decrease 0.5%)\nEnd-expired  N2 (increase 0.1%)\nPulmonary artery pressure (increase 3 mmHg)\n\nModerate sensitivity (0.5 ml/kg):\nCentral venous pressure (increase 2 mmHg)\n\nLow to moderate sensitivity (0.75 ml/kg):\nArterial oxygen tension (decrease 25 mmHg)\nArterial carbon dioxide tension (increase 5 mmHg)\n\nLow sensitivity (>1 ml/kg):\nWedge pressure (increase 3 mmHg)\nBlood pressure (decrease 10mmHg)\nMill-wheel murmur\n\nPathophysiology of Venous Air Embolism:\nVenous air embolism occurs when gas bubbles enter the venous circulation.\nVenous air embolism can cause right ventricular failure leading to hypotension and circulatory arrest, or passage of gas bubbles into the arterial circulation causing coronary or cerebral ischemia.\n\nTreatment Steps for Venous Air Embolism:\n1.  Notify surgeon\n2.  Discontinue nitrous oxide\n3.  Increase FiO2 to 100%\n4.  Aspirate central venous catheter\n5.  Flood surgical field\n6.  Brief bilateral jugular vein compression\n7.  Support blood pressure with vasopressors\n8.  If hemodynamic instability persists, place patient in head down, left lateral decubitus (Durant's) position\n\nClinical Points:\n1.  Venous air embolism can occur in many clinical situations besides sitting craniotomy.\n2.  Hypotension is a late sign of venous air embolism and signifies the presence of a large quantity of air.\n3.  The hallmark treatment of venous air embolism involves early detection, rapid aspiration from a central line, and sealing off the source of air entry.\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September 2024\n\n", 
    "possiblePoints": 1200, 
    "preopMsg": "\n60 year old for resection of posterior fossa tumor\n\nHistory of Present Illness\nThe patient has had ataxia and vertigo for two weeks. MRI showed posterior fossa tumor.\n\n\nPast Medical History\nIllnesses: mild hypertension\nSurgeries: inguinal hernia - uneventful general anesthesia\nMeds: nifedipine\nNo known drug allergies\nHabits: Quit smoking cigarettes, occasional alcohol\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nObese male in moderate distress  \nWeight: 92 kg   HR: 67   BP: 148/90    RR: 16\nAirway: normal\nLungs: mild rhonchi\nHeart: normal\n\nLabs\nHematocrit: 36\nElectrolytes, Glucose, Blood Urea Nitrogen, creatinine : normal\n\nNPO Status\nLast ate 10 hours ago. \n\nPatient and Surgeon Requests\nAfter induction, the surgeon will position the patient lateral, 15 degrees head up. The procedure will take many hours.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen by mask and a sedative agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 23.8, 
            "baseHr": 88, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You administered an intravenous sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered an inhalational anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert a laryngeal mask airway in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "COUGH5", 
                    "comment": "You tried to insert the endotracheal tube in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-1000 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV1", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDIV2", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 4, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.5
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.25
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV2", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You continued to administer inhalation agent.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWIV", 
            "whatNextMsg": "Deepen the level of anesthesia. Placement of arterial catheter and CVP line are suggested.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2IV", 
            "whatNextMsg": "Inform the surgeon when the patient is ready.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 97, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDINH", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 93, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient recovered from the sedative. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered enough intravenous agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You administered enough inhalation agent to lightly anesthetize the patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "COUGH4", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT4", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "whatNextMsg": "Place the endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 400, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDINH", 
                    "comment": "You decreased the anesthetic depth. (Lost points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered intravenous anesthetic agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You should place an endotracheal tube due to the meal four hours ago. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "You successfully placed the endotracheal tube. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWINH", 
                    "comment": "An endotracheal tube was successfully placed. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "HURT3", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWINH", 
            "whatNextMsg": "Deepen the level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and airway secured.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2INH", 
                    "comment": "You deepened the level of anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "HURT1", 
                    "comment": "You should not have allowed the surgeon to operate on a lightly anesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA2INH", 
            "whatNextMsg": "Inform the surgeon when the patient is ready.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Adequate anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAE1", 
                    "comment": "The simulation forced the patient to develop venous air embolism.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPIV", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAE1", 
                    "comment": "The simulation forced the patient to develop venous air embolism.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE1", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few air bubbles.", 
            "baseAbpD": 64, 
            "baseAbpM": 76, 
            "baseAbpS": 104, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 28, 
            "papS": 38, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Immediately after start of venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is somewhat reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE2", 
                    "comment": "You waited more than one minute to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE2", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few air bubbles.", 
            "baseAbpD": 54, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 109, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 32, 
            "papM": 38, 
            "papS": 48, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "One minute after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is somewhat reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 76, 
            "sat100": 81, 
            "spSignal": 2, 
            "spontRr": 28, 
            "spontTv": 170, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE3", 
                    "comment": "You waited more than two minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE3", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few air bubbles.", 
            "baseAbpD": 48, 
            "baseAbpM": 54, 
            "baseAbpS": 74, 
            "baseBicarb": 22, 
            "baseHr": 119, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 42, 
            "papM": 48, 
            "papS": 58, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Two minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 65, 
            "sat40": 70, 
            "sat100": 75, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE4", 
                    "comment": "You waited more than three minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE4", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few air bubbles.", 
            "baseAbpD": 42, 
            "baseAbpM": 48, 
            "baseAbpS": 62, 
            "baseBicarb": 20, 
            "baseHr": 129, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.6, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 22, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are barely audible. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 42, 
            "papM": 50, 
            "papS": 64, 
            "papW": 0, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Three minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 64, 
            "sat100": 69, 
            "spSignal": 1, 
            "spontRr": 24, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE5", 
                    "comment": "You waited more than four minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE5", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Change the position to trendelenberg and flood the surgical field to prevent further air entry.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with small air bubbles.", 
            "baseAbpD": 38, 
            "baseAbpM": 44, 
            "baseAbpS": 58, 
            "baseBicarb": 20, 
            "baseHr": 149, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.5, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 24, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds could be described as a mill-wheel murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 42, 
            "papM": 50, 
            "papS": 68, 
            "papW": 0, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Four minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is markedly reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 56, 
            "sat40": 60, 
            "sat100": 65, 
            "spSignal": 1, 
            "spontRr": 16, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited more than five minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE6", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Change the position to trendelenberg and flood the surgical field to prevent further air entry.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with small air bubbles.", 
            "baseAbpD": 32, 
            "baseAbpM": 38, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 139, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds could be described as a mill-wheel murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 40, 
            "papM": 48, 
            "papS": 60, 
            "papW": 0, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Five minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is markedly reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 55, 
            "sat40": 60, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 8, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE7", 
                    "comment": "You waited more than six minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE7", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Change the position to trendelenberg and flood the surgical field to prevent further air entry.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with several air bubbles.", 
            "baseAbpD": 16, 
            "baseAbpM": 24, 
            "baseAbpS": 42, 
            "baseBicarb": 18, 
            "baseHr": 109, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.3, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds could be described as a mill-wheel murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 26, 
            "papS": 40, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Six minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE8", 
                    "comment": "You waited more than seven minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE8", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Change the position to trendelenberg and flood the surgical field to prevent further air entry.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with lots of air bubbles.", 
            "baseAbpD": 14, 
            "baseAbpM": 20, 
            "baseAbpS": 32, 
            "baseBicarb": 18, 
            "baseHr": 69, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 10, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds could be described as a mill-wheel murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 10, 
            "papM": 12, 
            "papS": 20, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Seven minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE9", 
                    "comment": "You waited more than eight minutes to put the patient in trendelenberg and flood the field. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAE9", 
            "whatNextMsg": "Examine the patient and make the diagnosis. Support the ABCs. Change the position to trendelenberg and flood the surgical field to prevent further air entry.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with lots of air bubbles.", 
            "baseAbpD": 14, 
            "baseAbpM": 16, 
            "baseAbpS": 22, 
            "baseBicarb": 16, 
            "baseHr": 39, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breathsounds are clear.", 
            "cardiacOutput": 1, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 0, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "The heart sounds could be described as a mill-wheel murmur.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 0, 
            "papM": 0, 
            "papS": 2, 
            "papW": 0, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Eight minutes after venous air embolism.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 58, 
            "sat40": 60, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VAEX", 
                    "comment": "You appropriately put the patient in trendelenberg and had the surgeon flood the field. (+200 points)", 
                    "conditions": [
                        {
                            "type": "floodField", 
                            "value": true
                        }, 
                        {
                            "type": "trend", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "DEAD", 
                    "comment": "You waited too long to put the patient in trendelenberg and flood the field. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VAEX", 
            "whatNextMsg": "Support the ABCs. Administer pressors and intravenous fluid bolus, try to aspirate air from CVP catheter using the Resuscitate Options.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 44, 
            "baseAbpM": 50, 
            "baseAbpS": 64, 
            "baseBicarb": 22, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.6, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 22, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 42, 
            "papM": 50, 
            "papS": 64, 
            "papW": 0, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Position trendelenberg and field flooded.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 66, 
            "sat40": 68, 
            "sat100": 70, 
            "spSignal": 1, 
            "spontRr": 24, 
            "spontTv": 180, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 301
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAEX", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 20
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 300
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASP", 
                    "comment": "You aspirated from the CVP catheter appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "type": "aspirateCvp", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VAE5", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INO", 
            "whatNextMsg": "Now administer at least 500 mL bolus of intravenous fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 52, 
            "baseAbpM": 60, 
            "baseAbpS": 86, 
            "baseBicarb": 20, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 42, 
            "papM": 48, 
            "papS": 58, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "INOtropic agent administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 66, 
            "sat40": 72, 
            "sat100": 75, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "INOASP", 
                    "comment": "You aspirated from the CVP catheter appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "type": "aspirateCvp", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited too long to administer a fluid bolus. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "FLUID", 
            "whatNextMsg": "Now administer an inotrope.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 76, 
            "baseBicarb": 20, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 1.8, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 20, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 44, 
            "papM": 48, 
            "papS": 62, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 66, 
            "sat40": 70, 
            "sat100": 74, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 140, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASPFLUID", 
                    "comment": "You aspirated from the CVP catheter appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "type": "aspirateCvp", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASP", 
            "whatNextMsg": "Now administer an intropic agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 46, 
            "baseAbpM": 56, 
            "baseAbpS": 72, 
            "baseBicarb": 20, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
             "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 40, 
            "papM": 46, 
            "papS": 58, 
            "papW": 2, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Aspirated from CVP catheter.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 66, 
            "sat40": 70, 
            "sat100": 74, 
            "spSignal": 2, 
            "spontRr": 32, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOASP", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASP", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOASP", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOASP", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOASP", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOASP", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASPFLUID", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INOFLUID", 
            "whatNextMsg": "Now aspirate from the CVP catheter.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 56, 
            "baseAbpM": 68, 
            "baseAbpS": 92, 
            "baseBicarb": 20, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 3, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 42, 
            "papM": 48, 
            "papS": 60, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "INOtropic agent and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 74, 
            "sat100": 78, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 130, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You aspirated from the CVP catheter appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "type": "aspirateCvp", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited too long to aspirate from the CVP catheter. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INOASP", 
            "whatNextMsg": "Now administer a fluid bolus of at least 500 mL.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 54, 
            "baseAbpM": 64, 
            "baseAbpS": 88, 
            "baseBicarb": 20, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 3.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 38, 
            "papM": 44, 
            "papS": 56, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "An inotropic agent and CVP aspirated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 74, 
            "sat100": 78, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 100, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 499
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited too long to administer a fluid bolus. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASPFLUID", 
            "whatNextMsg": "Now administer an inotropic agent.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 74, 
            "baseBicarb": 20, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.8, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 46, 
            "papM": 52, 
            "papS": 62, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and weak. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "CVP catheter aspirated and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is reduced. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 68, 
            "sat40": 72, 
            "sat100": 76, 
            "spSignal": 2, 
            "spontRr": 24, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 39
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1001
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE9", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 40
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1000
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You administered an infusion of dopamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You administered an infusion of dobutamine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 4
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You administered an infusion of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You administered an infusion of norepinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VAE6", 
                    "comment": "You waited too long to administer an inotrope. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "INOFLUIDASP", 
            "whatNextMsg": "Observe and provide additional supportive measures as needed.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 62, 
            "baseAbpM": 72, 
            "baseAbpS": 102, 
            "baseBicarb": 20, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 4, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled. Jugular veins are bulging.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 24, 
            "papM": 30, 
            "papS": 40, 
            "papW": 4, 
            "pulseMsg": "The pulse is stronger.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "An inotropic agent and fluids administered, CVP aspirated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is improving.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 76, 
            "sat40": 82, 
            "sat100": 88, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "STABLE", 
                    "comment": "You observed the patient appropriately.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 55
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "You successfully averted a catastrophic venous air embolism.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with no air bubbles.", 
            "baseAbpD": 64, 
            "baseAbpM": 76, 
            "baseAbpS": 104, 
            "baseBicarb": 20, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 4.8, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 16, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 22, 
            "papM": 28, 
            "papS": 38, 
            "papW": 6, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has been stabilized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "Capillary refill is normal.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 80, 
            "sat40": 86, 
            "sat100": 90, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "VTACH1", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INO", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INO", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH2", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUID", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INOFLUID", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH3", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 18, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOASP", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INOASP", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "VTACH4", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter with a few small air bubbles.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are muffled.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent. Jugular veins are bulging.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "Capillary refill is absent. Jugular veins are bulging.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 80, 
            "sat100": 86, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "INOFLUIDASP", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 50
                }
            ]
        }, 
        {
            "name": "COUGH5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT5", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 91, 
            "sat100": 93, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "COUGH4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "HURT5", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT4", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 440, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. (+25 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 25
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "whatNextMsg": "Now perform laryngoscopy and place the endotracheal intubation.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "ASLEEP and paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDIV1", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "HURT3", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
 			"overdoseFlag": false,
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HURT1", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized but autonomic response to painful stimulus.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 91, 
            "sat100": 94, 
            "spSignal": 2, 
            "spontRr": 18, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}