CaseData[22] = {
    "title": "Case 22 - 21 yr old male for drainage of subdural hematoma", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "\nFrom the physical exam, this patient has a potentially difficult intubation and also presents with a full stomach. The choice is to secure the airway prior to induction of anesthesia and risk coughing and worsening of intracranial hypertension or intubate under deep general anesthesia and risk losing control of the airway and aspiration. While increased intracranial pressure may be detrimental, hypoxia and hypercapnia will definitely be detrimental. Intubate awake if management of the airway is a major concern.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 2, 
    "initialSat": 96, 
    "leanBodyMass": 70, 
    "learningObj": "\n21 yr old male with increased ICP for drainage of subdural hematoma (74 kg)\n\nThis patient presents a difficult set of problems: increased intracranial pressure, full stomach, and a potentially difficult intubation. Also, you must carefully search for other injuries in trauma patients.\n\nLearning Objectives\n1.  Describe anesthetic management of high intracranial pressure.\n2.  Describe the management of a patient with elevated intracranial pressure and difficult airway.\n\nAnesthetic Considerations\n1.  Increased intracranial pressure\n2.  Full stomach - prevention of aspiration\n3.  Potentially difficult intubation   \n\nAnesthesia for Increased Intracranial Pressure:\n1.  Hyperventilate and maintain cerebral perfusion pressure\n2.  Use propofol, narcotics, benzodiazepines, up to 1 MAC inhalation agent, and competitive NM blocker\n3.  Use mannitol\n4.  Avoid coughing, tachycardia and hypertension at time of intubation\n5.  Avoid deep inhalation anesthesia\n6.  Avoid ketamine\n7.  Succinylcholine and nitrous oxide can increase ICP\n8.  Avoid excessive fluid administration\n9.  Avoid glucose administration\n10. Avoid head down position\n\nSuggested Management\nFrom the physical exam, this patient has a potentially difficult intubation and also presents with a full stomach. The choice is to secure the airway prior to induction of anesthesia and risk coughing and worsening of intracranial hypertension or intubate under deep general anesthesia and risk losing control of the airway and aspiration. While increased intracranial pressure may be detrimental, hypoxia and hypercapnia will definitely be detrimental. Intubate awake if management of the airway is a major concern.\n\n1. Routine monitoring plus direct arterial pressure\n2. Oxygen by mask, encourage hyperventilation\n3. Mannitol 12.5-25 gms over 5-10 minutes\n4. Carefully sedate with benzodiazepines for patient cooperation, but avoid significant respiratory depression\n5. Very careful, gentle, and thorough topical anesthesia of the airway\n6. Fiberoptic intubation\n7. Induce anesthesia with propofol\n8. Maintain anesthesia with narcotics, inhalation agent, and competitive neuromuscular blocker\n9. Extubate promptly after return of airway reflexes \n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September 2024\n\n", 
    "possiblePoints": 600, 
    "preopMsg": "\n21 year old male with increased ICP for drainage of subdural hematoma\n\nHistory of Present Illness\nThe patient sustained a closed head injury in a motorcycle accident one hour ago.\n\nPast Medical History\nIllnesses - history of multiple fractures\nSurgeries - several open reductions of fractures\nMeds - none\nHabits - smokes, drinks, and uses intravenous drugs\nAllergies - none\n\nFamily History\nNo family history of anesthetic problems.\n\nPhysical Exam\nThin male, lethargic and somewhat combative\nWeight: 74 kg\nHR 100,  BP 126/60,  RR  20\nAirway - receding mandible, severe overbite, poor mouth opening, Mallampati score 3.\nLungs - clear \nHeart - normal\nNeuro - decreased strength, sensation left side\nMultiple scars from previous injuries\n\nLabs\nHematocrit - 41\nX-Ray cervical fractures ruled out\n\nNPO Status\nConsumed 'Delux-burger', onion rings, and 6 beers one hour prior to injury. \n\nPatient and Surgeon Requests\nThe surgeon states the procedure will take about two hours.\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Administer oxygen by mask and a sedative agent. Do not lose spontaneous breathing.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 23.8, 
            "baseHr": 92, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 39, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEIV", 
                    "comment": "You appropriately sedated this patient. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEINH", 
                    "comment": "You should not perform inhalation induction in a patient with a full stomach. (-100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.05
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You should have sedated the patient before performing fiberoptic intubation. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to place the LMA in this awake patient.  (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to perform laryngoscopy in an awake patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You allowed the surgeon to make the incision before the patient was adequately anesthetized. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have administered neuromuscular blocker to an awake patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKECOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and sedate.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing but the breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You should have sedated the patient before performing fiberoptic intubation. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEHURT", 
            "whatNextMsg": "Wait for the patient to settle down, secure the airway and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You should have sedated the patient before performing fiberoptic intubation. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 110, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You intubated using the fiberoptic bronchoscope. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "LMAIV", 
                    "comment": "You inserted the LMA to rescue the airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBED", 
            "whatNextMsg": "Now that the airway is secured, induce anesthesia and observe closely for bronchospasm.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Fiberoptic intubation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "You induced anesthesia primarily with intravenous agents. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "TUBEDINH", 
                    "comment": "You induced anesthesia primarily with inhalation anesthetics. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.2
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEHURT", 
            "whatNextMsg": "Deepen the anesthetic.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 112, 
            "baseAbpS": 182, 
            "baseBicarb": 24, 
            "baseHr": 106, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is reduced.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is reacting to the endotracheal tube.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Autonomic response to tracheal stimulation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBED", 
                    "comment": "You induced anesthesia. (+50 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "The autonomic response is abating.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEIV", 
            "whatNextMsg": "Secure the airway with fiberoptic intubation. This program assumes you adequately topicalized the airway.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 84, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You should have secured the airway before inducing anesthesia. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You performed fiberoptic intubation. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "SEDATEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-300 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEINH", 
            "whatNextMsg": "Continue induction. Do not lose spontaneous breathing.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is slowed.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You should not have induced anesthesia before securing the airway in this patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You should not have induced anesthesia before securing the airway in this patient. (-200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "TUBED", 
                    "comment": "You performed fiberoptic intubation in this sedated patient. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATECOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (-300 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "SEDATEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEPARA", 
                    "comment": "You should not have paralyzed a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATECOUGH", 
            "whatNextMsg": "Wait for the patient to settle down, secure the airway and induce anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 100, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing but the breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 18, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEIV", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You paralyzed an unanesthetized patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEHURT", 
            "whatNextMsg": "Wait for the patient to settle down, secure airway and induce anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 20, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 10, 
            "spontTv": 340, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATEIV", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "The sedative agent is starting to take effect. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEPARA", 
            "whatNextMsg": "Now perform quick fiberoptic bronchoscopy. This program assumes you provided adequate topical anesthesia of the airway.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 114, 
            "baseAbpS": 168, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated and paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TUBEDIV", 
                    "comment": "You placed the endotracheal tube in a timely fashion. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "LMAIV", 
                    "comment": "You rescued the airway with an LMA. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You deepened the anesthetic. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You took too long to intubate and the patient aspirated massive quantities of acidic fluids. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPIV", 
            "whatNextMsg": "Perform quick fiberoptic intubation, or rescue the airway with LMA. Perform cricothyroidotomy if unable to otherwise rescue.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 68, 
            "contPlateau": 66, 
            "cvp": 14, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized. Unable to intubate, unable to ventilate.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 74, 
            "sat40": 75, 
            "sat100": 76, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "LMAIV", 
                    "comment": "You placed the LMA to establish an emergent airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "You performed fiberoptic intubation in a deeply sedated patient with a difficult airway. Better to lightly sedate and maintain spontaneous ventilation. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You attempted oral laryngoscopy unsuccessfully. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (-300 points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You waited too long to establish the airway. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "ASLEEPINH", 
            "whatNextMsg": "Perform quick fiberoptic intubation, or rescue the airway with LMA. Perform cricothyroidotomy if unable to otherwise rescue.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 88, 
            "contPlateau": 86, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 73, 
            "sat40": 74, 
            "sat100": 75, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered intravenous anesthetic agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPIV", 
                    "comment": "You administered a NMB agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "LMAINH", 
                    "comment": "You placed the LMA to establish an emergent airway. (+100 points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPINH", 
                    "comment": "You unsuccessfully attempted oral laryngoscopy. (-50 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "TUBEDINH", 
                    "comment": "You successfully placed the endotracheal tube with the fiberoptic bronchoscope. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryFo", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "CRIC", 
                    "comment": "It wasn't necesary to perform cricothyroidotomy. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayCrico", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You should have established an airway faster. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "LMAIV", 
            "whatNextMsg": "Perform fiberoptic intubation throught he LMA. Provide adequate anesthesia and instruct the surgeon to make the incision.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "LMA in place.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 80, 
            "sat40": 86, 
            "sat100": 90, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPLMAIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. Endotracheal tube is preferred over LMA for patient with full stomach. Do this case again.", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPLMAIV", 
                    "comment": "You instructed the surgeon to operate.  Endotracheal tube is preferred over LMA for patient with full stomach. Do this case again.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEDIV", 
            "whatNextMsg": "Provide adequate anesthesia and instruct the surgeon to make the incision.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and intubated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 92, 
            "sat40": 95, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TUBEDINH", 
            "whatNextMsg": "Provide adequate anesthesia and instruct the surgeon to make the incision.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized and intubated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 80, 
            "sat40": 86, 
            "sat100": 90, 
            "spSignal": 2, 
            "spontRr": 22, 
            "spontTv": 260, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. (+100 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "OPINH", 
                    "comment": "You instructed the surgeon to operate.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TUBEDIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "LMAINH", 
            "whatNextMsg": "Perform fiberoptic intubation throught he LMA. Provide adequate anesthesia and instruct the surgeon to make the incision.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 96, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "LMA placed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 93, 
            "sat100": 95, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 220, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPLMAINH", 
                    "comment": "You instructed the surgeon to make the incision at the appropriate time. Endotracheal tube is preferred over LMA for patient with full stomach. Do this case again.", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPLMAINH", 
                    "comment": "You instructed the surgeon to operate.  Endotracheal tube is preferred over LMA for patient with full stomach. Do this case again.", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPLMAIV", 
            "whatNextMsg": "Endotracheal tube is preferred over LMA with full stomach.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are distant bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 32, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Surgery proceeding with LMA.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "OPIV", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPINH", 
            "whatNextMsg": "Monitor closely and adjust anesthetic as needed.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 78, 
            "baseAbpM": 98, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 30, 
            "contPlateau": 28, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Maintenance anesthesia.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 160, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPIV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPLMAINH", 
            "whatNextMsg": "Endotracheal tube is preferred over LMA, especially for patient with full stomach.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 76, 
            "baseAbpS": 104, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Surgery proceeding with LMA.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 91, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "FINAL", 
            "whatNextMsg": "End of simulation.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 88, 
            "baseAbpS": 124, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "Breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Stable.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 1, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "CRIC", 
            "whatNextMsg": "You should do this case again. It should not have been necessary to perform cricothyroidotomy.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 86, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 32, 
            "contPlateau": 30, 
            "cvp": 14, 
            "finalState": -1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is reduced.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Cricothyroidotomy performed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 95, 
            "sat40": 98, 
            "sat100": 99, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATDEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATDEAD", 
            "whatNextMsg": "Notify the family.", 
 			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": -1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}