import os
import re
import json
import ast

def js_to_python(js_object):
    # Convert JavaScript object to Python dictionary
    js_object = js_object.replace('true', 'True').replace('false', 'False')
    js_object = js_object.replace('null', 'None')
    return ast.literal_eval(js_object)

def process_single_file(filename):
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    json_dir = '/home/anesoft/public_html/app.anesoft.com/app/case_data/'
    
    if not os.path.exists(json_dir):
        os.makedirs(json_dir)
    
    print(f"\n--- Processing file: {filename} ---")
    with open(os.path.join(js_dir, filename), 'r') as f:
        content = f.read()

    pattern = r'CaseData\[(\d+)\]\s*=\s*({[\s\S]*?})(?:\s*;|\s*$)'
    match = re.search(pattern, content, re.DOTALL)
    
    if match:
        case_id = match.group(1)
        case_data = match.group(2)
        
        try:
            case_dict = js_to_python(case_data)
            case_dict['id'] = int(case_id)
            case_dict['isPro'] = int(case_id) > 2
            
            json_filename = f'case_{case_id}.json'
            json_path = os.path.join(json_dir, json_filename)
            with open(json_path, 'w') as f:
                json.dump(case_dict, f, indent=2)
            
            print(f"Successfully converted {filename} to {json_filename}")
            return True
        except (SyntaxError, ValueError) as e:
            print(f"Error processing {filename}: {e}")
            return False
    else:
        print(f"No matching CaseData object found in: {filename}")
        return False

if __name__ == "__main__":
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    processed_files = []
    unprocessed_files = []
    
    for filename in sorted(os.listdir(js_dir)):
        if filename.startswith('Anesth6Case') and filename.endswith('.js'):
            if process_single_file(filename):
                processed_files.append(filename)
            else:
                unprocessed_files.append(filename)
    
    print("\n--- Summary ---")
    print(f"Successfully processed files: {len(processed_files)}")
    print(f"Files that couldn't be processed: {len(unprocessed_files)}")
    print("\nUnprocessed files:")
    for file in unprocessed_files:
        print(file)