import os
import re
import json

def analyze_file(filename):
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    
    print(f"\n--- Analyzing file: {filename} ---")
    with open(os.path.join(js_dir, filename), 'r') as f:
        content = f.read()

    # Print the first and last 200 characters of the file content
    print(f"File content preview (first 200 chars):\n{content[:200]}")
    print(f"\nFile content preview (last 200 chars):\n{content[-200:]}")

    # Check for CaseData pattern
    pattern = r'CaseData\[(\d+)\]\s*=\s*({[\s\S]*?})(?:\s*;|\s*$)'
    match = re.search(pattern, content, re.DOTALL)
    
    if match:
        case_id = match.group(1)
        case_data = match.group(2)
        print(f"\nFound CaseData for ID {case_id}")
        print(f"CaseData preview (first 200 chars):\n{case_data[:200]}")
        print(f"\nCaseData preview (last 200 chars):\n{case_data[-200:]}")
    else:
        print("\nNo CaseData object found. Searching for alternative patterns...")
        
        # Check for var CaseData pattern
        var_pattern = r'var\s+CaseData\s*=\s*({[\s\S]*?})(?:\s*;|\s*$)'
        var_match = re.search(var_pattern, content, re.DOTALL)
        
        if var_match:
            case_data = var_match.group(1)
            print("Found 'var CaseData' pattern")
            print(f"CaseData preview (first 200 chars):\n{case_data[:200]}")
            print(f"\nCaseData preview (last 200 chars):\n{case_data[-200:]}")
        else:
            print("No 'var CaseData' pattern found either.")
            
    print("\n--- End of file analysis ---")

if __name__ == "__main__":
    js_dir = '/home/anesoft/public_html/app.anesoft.com/app/cases/'
    
    for filename in sorted(os.listdir(js_dir)):
        if filename.startswith('Anesth6Case') and filename.endswith('.js'):
            analyze_file(filename)