(function() {	
    const loaderText = document.getElementById('loader-text');
    let ellipsesSpan = document.getElementById('loading-ellipses');
    
    // Create ellipses span if it doesn't exist
    if (!ellipsesSpan) {
        ellipsesSpan = document.createElement('span');
        ellipsesSpan.id = 'loading-ellipses';
        loaderText.appendChild(ellipsesSpan);
    }

    // Get the original text from the existing content
    const originalText = loaderText.textContent.trim();
    
    const messages = [
        originalText,
        "Getting ready",
        "Preparing the anesthesia machine",
        "Checking the oxygen supply",
        "Calibrating the vaporizers",
        "Reviewing patient history",
        "Adjusting the ventilator settings",
        "Preparing medications",
        "Ensuring monitors are functional",
        "Double-checking the difficult airway cart",
        "Verifying consent forms",
        "Warming up the ultrasound",
        "Reviewing the surgical plan",
        "Prepping the regional block kit",
        "Confirming NPO status",
        "Briefing the anesthesia team"
    ];
    let messageIndex = 0;
    let dotCount = 0;

    function updateLoadingText() {
        dotCount = (dotCount % 3) + 1;
        const currentMessage = messages[messageIndex];
        loaderText.firstChild.textContent = currentMessage;
        ellipsesSpan.textContent = '.'.repeat(dotCount);
    }

    function rotateMessage() {
        messageIndex = (messageIndex + 1) % messages.length;
    }

    // Ensure the original text is set (in case it was empty)
    if (!loaderText.firstChild || loaderText.firstChild.nodeType !== Node.TEXT_NODE) {
        loaderText.textContent = originalText;
    }

    // Update dots every 500ms
    setInterval(updateLoadingText, 500);

    // Rotate message every 2 seconds, but start after 3 seconds
    setTimeout(() => {
        setInterval(rotateMessage, 2000);
    }, 0);

    // Optional: Change to "Getting ready" after all messages have been shown once
    setTimeout(() => {
        messages.push("Getting ready");
    }, messages.length * 2000 + 3000);
	
	
	
	
	// Force a logo to display immediately instead of waiting for page to load
	function insertLogo() {
		const loaderContainer = document.getElementById('loader-container');
		const logoDiv = document.createElement('div');
		logoDiv.id = 'loader-logo';
		
		logoDiv.className = 'top-menu'; // Use same container class
		logoDiv.innerHTML = `
			<div class="logo">
				<a href="#">
					${svgContent} <?xml version="1.0" encoding="UTF-8"?>
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="loader-logo-svg" width="215px" height="49px" style="margin-left: -2px;" viewBox="0 0 225 52" version="1.1">
						<g id="surface1">
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 30.917969 1.796875 C 31.722656 2.320312 32.121094 3.273438 32.398438 4.171875 C 32.542969 4.84375 32.550781 5.519531 32.574219 6.203125 C 32.582031 6.402344 32.582031 6.402344 32.585938 6.609375 C 32.636719 8.097656 32.652344 9.582031 32.664062 11.070312 C 32.667969 11.480469 32.671875 11.886719 32.675781 12.296875 C 32.683594 13 32.691406 13.703125 32.695312 14.40625 C 32.703125 15.425781 32.714844 16.445312 32.722656 17.46875 C 32.742188 19.128906 32.757812 20.789062 32.773438 22.453125 C 32.773438 22.550781 32.773438 22.648438 32.773438 22.75 C 32.78125 23.453125 32.789062 24.15625 32.792969 24.859375 C 32.800781 25.660156 32.808594 26.460938 32.816406 27.261719 C 32.816406 27.363281 32.816406 27.460938 32.820312 27.5625 C 32.835938 29.21875 32.851562 30.875 32.867188 32.53125 C 32.875 33.546875 32.886719 34.5625 32.894531 35.578125 C 32.898438 36.277344 32.90625 36.972656 32.914062 37.671875 C 32.917969 38.070312 32.921875 38.472656 32.925781 38.871094 C 32.9375 40.476562 32.964844 42.082031 33.015625 43.683594 C 33.019531 43.824219 33.023438 43.964844 33.027344 44.113281 C 33.03125 44.242188 33.035156 44.371094 33.039062 44.503906 C 33.042969 44.617188 33.046875 44.730469 33.050781 44.847656 C 33.058594 45.121094 33.058594 45.121094 33.1875 45.34375 C 33.433594 44.757812 33.597656 44.167969 33.742188 43.546875 C 33.90625 42.867188 34.09375 42.238281 34.425781 41.621094 C 34.464844 41.542969 34.507812 41.464844 34.550781 41.382812 C 35.039062 40.515625 35.734375 40.085938 36.675781 39.816406 C 37.695312 39.589844 38.695312 39.558594 39.738281 39.5625 C 39.910156 39.5625 40.082031 39.558594 40.253906 39.558594 C 40.722656 39.558594 41.195312 39.558594 41.664062 39.558594 C 42.183594 39.558594 42.699219 39.554688 43.214844 39.554688 C 44.128906 39.554688 45.042969 39.550781 45.953125 39.550781 C 47.339844 39.550781 48.722656 39.546875 50.109375 39.542969 C 52.5 39.539062 54.894531 39.535156 57.289062 39.535156 C 59.726562 39.53125 62.164062 39.527344 64.597656 39.523438 C 64.753906 39.523438 64.910156 39.523438 65.066406 39.523438 C 65.695312 39.519531 66.324219 39.519531 66.953125 39.519531 C 73.757812 39.507812 80.558594 39.5 87.363281 39.488281 C 88.160156 39.488281 88.953125 39.488281 89.75 39.488281 C 89.953125 39.484375 90.15625 39.484375 90.359375 39.484375 C 93.726562 39.480469 97.097656 39.476562 100.46875 39.472656 C 100.640625 39.472656 100.640625 39.472656 100.816406 39.472656 C 101.992188 39.46875 103.164062 39.46875 104.339844 39.464844 C 116.015625 39.449219 127.695312 39.433594 139.371094 39.417969 C 141.097656 39.417969 142.824219 39.414062 144.550781 39.414062 C 161.847656 39.390625 161.847656 39.390625 170.285156 39.382812 C 170.394531 39.382812 170.507812 39.382812 170.621094 39.382812 C 172.972656 39.378906 175.324219 39.378906 177.675781 39.375 C 178.78125 39.375 179.886719 39.371094 180.992188 39.371094 C 181.15625 39.371094 181.15625 39.371094 181.324219 39.371094 C 184.910156 39.367188 188.492188 39.363281 192.078125 39.359375 C 195.777344 39.351562 199.476562 39.347656 203.179688 39.347656 C 203.691406 39.34375 204.207031 39.34375 204.722656 39.34375 C 204.871094 39.34375 204.871094 39.34375 205.027344 39.34375 C 206.628906 39.34375 208.230469 39.339844 209.835938 39.335938 C 211.410156 39.335938 212.988281 39.332031 214.566406 39.332031 C 215.492188 39.332031 216.421875 39.332031 217.351562 39.328125 C 218.039062 39.328125 218.726562 39.328125 219.417969 39.328125 C 219.695312 39.328125 219.972656 39.328125 220.25 39.324219 C 220.628906 39.324219 221.003906 39.324219 221.378906 39.324219 C 221.488281 39.324219 221.597656 39.324219 221.710938 39.324219 C 222.429688 39.328125 222.804688 39.449219 223.347656 39.9375 C 223.625 40.421875 223.609375 40.851562 223.539062 41.398438 C 223.34375 41.882812 223.097656 42.066406 222.636719 42.300781 C 222.335938 42.34375 222.335938 42.34375 222.003906 42.34375 C 221.875 42.34375 221.75 42.34375 221.617188 42.34375 C 221.476562 42.34375 221.335938 42.34375 221.191406 42.34375 C 221.042969 42.34375 220.890625 42.34375 220.738281 42.34375 C 220.316406 42.347656 219.898438 42.347656 219.476562 42.347656 C 219.015625 42.347656 218.554688 42.347656 218.09375 42.347656 C 217.277344 42.351562 216.460938 42.351562 215.640625 42.351562 C 214.394531 42.351562 213.148438 42.355469 211.898438 42.359375 C 209.726562 42.363281 207.554688 42.363281 205.378906 42.367188 C 203.152344 42.367188 200.921875 42.371094 198.695312 42.375 C 198.484375 42.375 198.484375 42.375 198.265625 42.375 C 197.6875 42.375 197.109375 42.378906 196.53125 42.378906 C 190.804688 42.386719 185.078125 42.394531 179.351562 42.402344 C 179.257812 42.402344 179.167969 42.402344 179.074219 42.402344 C 178.046875 42.402344 177.015625 42.402344 175.988281 42.40625 C 175.894531 42.40625 175.796875 42.40625 175.699219 42.40625 C 175.214844 42.40625 174.730469 42.40625 174.246094 42.40625 C 169.542969 42.414062 164.835938 42.417969 160.132812 42.425781 C 158.9375 42.425781 157.742188 42.425781 156.546875 42.429688 C 152.589844 42.433594 148.628906 42.4375 144.671875 42.441406 C 141.628906 42.445312 138.585938 42.449219 135.542969 42.453125 C 135.160156 42.453125 134.777344 42.453125 134.394531 42.457031 C 128.613281 42.460938 122.832031 42.46875 117.050781 42.476562 C 116.871094 42.476562 116.871094 42.476562 116.6875 42.476562 C 115.71875 42.476562 114.746094 42.476562 113.777344 42.476562 C 102.160156 42.488281 90.546875 42.503906 77.511719 42.523438 C 77.394531 42.523438 77.273438 42.523438 77.152344 42.527344 C 71.027344 42.535156 64.90625 42.546875 58.78125 42.5625 C 58.441406 42.5625 58.101562 42.5625 57.757812 42.5625 C 57.53125 42.5625 57.308594 42.566406 57.082031 42.566406 C 55.410156 42.570312 53.742188 42.574219 52.074219 42.574219 C 50.207031 42.578125 48.34375 42.582031 46.476562 42.589844 C 45.4375 42.589844 44.398438 42.59375 43.363281 42.59375 C 42.671875 42.597656 41.980469 42.597656 41.289062 42.601562 C 40.894531 42.601562 40.5 42.601562 40.105469 42.601562 C 39.683594 42.601562 39.261719 42.605469 38.839844 42.605469 C 38.714844 42.605469 38.59375 42.605469 38.464844 42.605469 C 38.355469 42.605469 38.242188 42.609375 38.128906 42.609375 C 38.03125 42.609375 37.933594 42.609375 37.835938 42.609375 C 37.546875 42.640625 37.367188 42.710938 37.125 42.863281 C 36.988281 43.101562 36.988281 43.101562 36.898438 43.390625 C 36.84375 43.558594 36.84375 43.558594 36.785156 43.730469 C 36.667969 44.125 36.570312 44.527344 36.472656 44.929688 C 36.105469 46.328125 35.484375 47.710938 34.277344 48.578125 C 33.582031 48.925781 32.71875 49.003906 31.957031 48.882812 C 31.785156 48.808594 31.785156 48.808594 31.613281 48.730469 C 31.542969 48.699219 31.476562 48.671875 31.40625 48.644531 C 30.917969 48.414062 30.675781 48.140625 30.46875 47.640625 C 30.160156 46.777344 30.113281 45.898438 30.105469 44.988281 C 30.105469 44.863281 30.105469 44.738281 30.101562 44.609375 C 30.097656 44.25 30.09375 43.894531 30.089844 43.539062 C 30.085938 43.222656 30.082031 42.90625 30.078125 42.59375 C 30.0625 41.328125 30.050781 40.066406 30.039062 38.800781 C 30.035156 38.6875 30.035156 38.570312 30.035156 38.449219 C 29.992188 33.777344 29.957031 29.105469 29.917969 24.433594 C 29.917969 24.050781 29.914062 23.667969 29.910156 23.28125 C 29.910156 23.207031 29.910156 23.132812 29.910156 23.054688 C 29.898438 21.769531 29.890625 20.484375 29.878906 19.203125 C 29.875 18.492188 29.867188 17.78125 29.863281 17.070312 C 29.835938 13.222656 29.777344 9.375 29.699219 5.527344 C 29.648438 5.875 29.597656 6.226562 29.542969 6.574219 C 29.53125 6.671875 29.515625 6.769531 29.5 6.871094 C 29.425781 7.375 29.351562 7.878906 29.277344 8.386719 C 29.144531 9.269531 29.007812 10.152344 28.84375 11.03125 C 28.777344 11.40625 28.738281 11.777344 28.703125 12.152344 C 28.617188 12.914062 28.5 13.664062 28.363281 14.417969 C 28.160156 15.546875 27.996094 16.679688 27.835938 17.816406 C 27.722656 18.628906 27.597656 19.4375 27.457031 20.246094 C 27.328125 21.011719 27.226562 21.777344 27.125 22.546875 C 27.042969 23.171875 26.945312 23.792969 26.832031 24.414062 C 26.695312 25.152344 26.59375 25.890625 26.5 26.632812 C 26.378906 27.613281 26.222656 28.582031 26.050781 29.554688 C 25.871094 30.566406 25.726562 31.582031 25.585938 32.597656 C 25.472656 33.398438 25.347656 34.195312 25.199219 34.988281 C 25.105469 35.511719 25.039062 36.03125 24.980469 36.5625 C 24.890625 37.417969 24.746094 38.261719 24.59375 39.113281 C 24.464844 39.824219 24.355469 40.535156 24.261719 41.253906 C 24.082031 42.578125 23.871094 43.898438 23.632812 45.214844 C 23.601562 45.390625 23.566406 45.570312 23.535156 45.75 C 23.371094 46.683594 23.171875 47.582031 22.839844 48.472656 C 22.800781 48.582031 22.800781 48.582031 22.757812 48.695312 C 22.378906 49.667969 21.832031 50.34375 20.878906 50.769531 C 20.242188 50.984375 19.660156 51.082031 19.011719 50.871094 C 18.3125 50.417969 17.96875 49.941406 17.78125 49.136719 C 17.742188 48.992188 17.742188 48.992188 17.703125 48.839844 C 17.292969 47.210938 16.957031 45.558594 16.605469 43.917969 C 16.410156 43.019531 16.203125 42.125 15.996094 41.230469 C 15.835938 40.542969 15.6875 39.855469 15.546875 39.164062 C 15.511719 38.988281 15.476562 38.816406 15.441406 38.644531 C 15.371094 38.308594 15.304688 37.972656 15.238281 37.636719 C 15.207031 37.484375 15.175781 37.332031 15.144531 37.179688 C 15.117188 37.042969 15.089844 36.90625 15.0625 36.765625 C 14.964844 36.4375 14.890625 36.304688 14.625 36.09375 C 14.589844 36.1875 14.550781 36.277344 14.511719 36.371094 C 14.375 36.714844 14.234375 37.0625 14.089844 37.40625 C 14.03125 37.554688 13.972656 37.703125 13.910156 37.851562 C 12.535156 41.246094 12.535156 41.246094 11.171875 41.882812 C 10.550781 42.144531 9.996094 42.207031 9.324219 42.222656 C 9.1875 42.226562 9.1875 42.226562 9.046875 42.230469 C 8.746094 42.238281 8.449219 42.242188 8.148438 42.25 C 8.046875 42.253906 7.945312 42.253906 7.839844 42.257812 C 7.101562 42.273438 6.363281 42.285156 5.625 42.300781 C 5.527344 42.300781 5.425781 42.304688 5.324219 42.304688 C 4.769531 42.3125 4.214844 42.320312 3.660156 42.324219 C 3.488281 42.328125 3.320312 42.328125 3.148438 42.332031 C 2.914062 42.335938 2.675781 42.335938 2.441406 42.335938 C 2.308594 42.335938 2.175781 42.339844 2.039062 42.339844 C 1.511719 42.277344 1.125 42.03125 0.789062 41.621094 C 0.605469 41.078125 0.582031 40.582031 0.824219 40.066406 C 1.101562 39.703125 1.25 39.511719 1.6875 39.367188 C 1.953125 39.351562 2.222656 39.339844 2.488281 39.332031 C 2.570312 39.332031 2.652344 39.328125 2.734375 39.328125 C 3.003906 39.320312 3.273438 39.3125 3.542969 39.304688 C 3.726562 39.300781 3.914062 39.296875 4.101562 39.292969 C 4.589844 39.277344 5.078125 39.265625 5.570312 39.253906 C 6.070312 39.242188 6.570312 39.230469 7.070312 39.214844 C 8.050781 39.191406 9.03125 39.164062 10.011719 39.140625 C 10.359375 38.457031 10.359375 38.457031 10.671875 37.757812 C 10.707031 37.675781 10.742188 37.589844 10.777344 37.507812 C 10.8125 37.417969 10.847656 37.332031 10.882812 37.246094 C 10.964844 37.054688 11.042969 36.867188 11.121094 36.675781 C 11.160156 36.582031 11.199219 36.484375 11.242188 36.386719 C 11.359375 36.101562 11.480469 35.816406 11.601562 35.53125 C 11.929688 34.757812 12.253906 33.988281 12.542969 33.199219 C 13.558594 30.507812 13.558594 30.507812 14.398438 29.664062 C 14.75 29.59375 15.0625 29.585938 15.414062 29.664062 C 18.5 32.207031 19.558594 43.367188 20.023438 47.148438 C 20.027344 47.335938 20.027344 47.527344 20.023438 47.714844 C 20.136719 47.675781 20.246094 47.640625 20.363281 47.601562 C 21.074219 43.210938 21.757812 38.816406 22.429688 34.421875 C 22.558594 33.566406 22.6875 32.714844 22.816406 31.863281 C 23.125 29.851562 23.429688 27.839844 23.738281 25.832031 C 23.757812 25.707031 23.773438 25.582031 23.792969 25.457031 C 23.957031 24.390625 24.117188 23.324219 24.28125 22.257812 C 24.316406 22.019531 24.355469 21.777344 24.390625 21.539062 C 24.414062 21.382812 24.4375 21.226562 24.460938 21.070312 C 24.898438 18.210938 25.335938 15.355469 25.777344 12.496094 C 25.792969 12.414062 25.804688 12.332031 25.816406 12.25 C 25.867188 11.925781 25.917969 11.605469 25.96875 11.28125 C 26.109375 10.363281 26.253906 9.441406 26.390625 8.519531 C 26.460938 8.058594 26.53125 7.597656 26.601562 7.136719 C 26.632812 6.933594 26.664062 6.730469 26.691406 6.527344 C 27.195312 3.082031 27.195312 3.082031 28.351562 2.144531 C 29.136719 1.558594 29.992188 1.570312 30.917969 1.796875 Z M 30.917969 1.796875 "/>
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 69.863281 8.347656 C 70.414062 8.339844 70.964844 8.335938 71.515625 8.335938 C 71.699219 8.332031 71.886719 8.332031 72.074219 8.328125 C 72.34375 8.328125 72.613281 8.324219 72.882812 8.324219 C 73.007812 8.324219 73.007812 8.324219 73.136719 8.320312 C 73.59375 8.320312 73.949219 8.367188 74.363281 8.574219 C 74.398438 8.871094 74.4375 9.167969 74.476562 9.476562 C 74.550781 9.476562 74.625 9.476562 74.699219 9.476562 C 75.085938 10.535156 75.085938 10.535156 75.039062 11.054688 C 75.113281 11.054688 75.1875 11.054688 75.261719 11.054688 C 75.300781 11.351562 75.335938 11.648438 75.375 11.957031 C 75.449219 11.957031 75.523438 11.957031 75.601562 11.957031 C 75.835938 13.019531 75.835938 13.019531 75.9375 13.535156 C 76.011719 13.535156 76.085938 13.535156 76.164062 13.535156 C 76.199219 13.871094 76.238281 14.207031 76.273438 14.550781 C 76.347656 14.550781 76.421875 14.550781 76.5 14.550781 C 76.558594 14.710938 76.613281 14.871094 76.667969 15.03125 C 76.714844 15.164062 76.714844 15.164062 76.765625 15.300781 C 76.835938 15.566406 76.835938 15.566406 76.835938 16.015625 C 76.910156 16.015625 76.984375 16.015625 77.0625 16.015625 C 77.101562 16.316406 77.136719 16.613281 77.175781 16.917969 C 77.25 16.917969 77.324219 16.917969 77.398438 16.917969 C 77.4375 17.253906 77.472656 17.589844 77.511719 17.933594 C 77.585938 17.933594 77.660156 17.933594 77.738281 17.933594 C 77.75 18.011719 77.761719 18.085938 77.773438 18.164062 C 77.792969 18.265625 77.808594 18.367188 77.828125 18.472656 C 77.855469 18.621094 77.855469 18.621094 77.878906 18.773438 C 77.96875 19.089844 78.101562 19.253906 78.300781 19.515625 C 78.429688 19.859375 78.429688 19.859375 78.546875 20.242188 C 78.585938 20.367188 78.625 20.492188 78.664062 20.621094 C 78.742188 20.945312 78.769531 21.210938 78.75 21.542969 C 78.824219 21.542969 78.898438 21.542969 78.976562 21.542969 C 78.976562 21.730469 78.976562 21.917969 78.976562 22.109375 C 79.050781 22.109375 79.125 22.109375 79.199219 22.109375 C 79.238281 22.40625 79.273438 22.703125 79.3125 23.011719 C 79.386719 23.011719 79.460938 23.011719 79.539062 23.011719 C 79.574219 23.347656 79.613281 23.679688 79.648438 24.027344 C 79.722656 24.027344 79.796875 24.027344 79.875 24.027344 C 79.933594 24.183594 79.988281 24.34375 80.042969 24.503906 C 80.089844 24.640625 80.089844 24.640625 80.140625 24.773438 C 80.210938 25.042969 80.210938 25.042969 80.210938 25.492188 C 80.285156 25.492188 80.359375 25.492188 80.4375 25.492188 C 80.449219 25.554688 80.460938 25.617188 80.472656 25.679688 C 80.585938 26.261719 80.757812 26.761719 81.023438 27.292969 C 81.113281 27.523438 81.113281 27.523438 81.113281 27.972656 C 81.1875 27.972656 81.261719 27.972656 81.335938 27.972656 C 81.375 28.308594 81.410156 28.644531 81.449219 28.988281 C 81.523438 28.988281 81.597656 28.988281 81.675781 28.988281 C 81.710938 29.363281 81.75 29.734375 81.789062 30.117188 C 81.863281 30.117188 81.9375 30.117188 82.011719 30.117188 C 82.082031 30.320312 82.148438 30.527344 82.214844 30.730469 C 82.257812 30.851562 82.300781 30.976562 82.34375 31.101562 C 82.460938 31.472656 82.460938 31.472656 82.53125 31.777344 C 82.597656 32.046875 82.648438 32.253906 82.800781 32.484375 C 83.132812 32.636719 83.449219 32.6875 83.8125 32.710938 C 83.8125 32.785156 83.8125 32.859375 83.8125 32.9375 C 84.296875 32.972656 84.777344 33.011719 85.273438 33.050781 C 85.273438 33.125 85.273438 33.199219 85.273438 33.277344 C 85.382812 33.277344 85.488281 33.277344 85.597656 33.277344 C 86.015625 33.277344 86.433594 33.277344 86.851562 33.277344 C 86.851562 33.199219 86.851562 33.125 86.851562 33.050781 C 86.976562 33.035156 87.105469 33.023438 87.238281 33.007812 C 87.367188 32.984375 87.5 32.960938 87.636719 32.9375 C 87.675781 32.863281 87.710938 32.789062 87.75 32.710938 C 88.046875 32.675781 88.34375 32.636719 88.648438 32.597656 C 88.6875 28.019531 88.722656 23.441406 88.761719 18.722656 C 88.503906 18.722656 88.242188 18.722656 87.976562 18.722656 C 87.75 18.625 87.75 18.625 87.523438 18.5 C 86.960938 18.3125 86.425781 18.222656 85.835938 18.160156 C 85.835938 18.085938 85.835938 18.011719 85.835938 17.933594 C 85.6875 17.898438 85.539062 17.859375 85.386719 17.820312 C 85.386719 16.929688 85.386719 16.035156 85.386719 15.113281 C 87.613281 15.113281 89.84375 15.113281 92.136719 15.113281 C 92.136719 15.226562 92.136719 15.339844 92.136719 15.453125 C 92.210938 15.453125 92.285156 15.453125 92.363281 15.453125 C 92.4375 16.199219 92.511719 16.941406 92.585938 17.710938 C 92.625 17.636719 92.660156 17.558594 92.699219 17.484375 C 92.886719 17.410156 93.074219 17.332031 93.261719 17.257812 C 93.300781 17.183594 93.335938 17.109375 93.375 17.03125 C 93.542969 16.976562 93.542969 16.976562 93.710938 16.917969 C 93.75 16.84375 93.785156 16.769531 93.824219 16.695312 C 94.015625 16.609375 94.210938 16.523438 94.40625 16.445312 C 94.636719 16.351562 94.636719 16.351562 94.921875 16.164062 C 95.175781 16.015625 95.175781 16.015625 95.511719 16.015625 C 95.511719 15.941406 95.511719 15.867188 95.511719 15.792969 C 95.617188 15.753906 95.722656 15.714844 95.828125 15.671875 C 95.964844 15.621094 96.097656 15.570312 96.238281 15.515625 C 96.4375 15.441406 96.4375 15.441406 96.644531 15.363281 C 96.957031 15.261719 96.957031 15.261719 97.085938 15.113281 C 97.386719 15.097656 97.6875 15.109375 97.988281 15.113281 C 97.988281 15.039062 97.988281 14.964844 97.988281 14.890625 C 99.101562 14.890625 100.214844 14.890625 101.363281 14.890625 C 101.363281 14.925781 101.363281 14.964844 101.363281 15.003906 C 101.535156 15.050781 101.535156 15.050781 101.714844 15.101562 C 102.089844 15.207031 102.457031 15.328125 102.824219 15.453125 C 102.824219 15.527344 102.824219 15.601562 102.824219 15.679688 C 102.976562 15.6875 102.976562 15.6875 103.128906 15.699219 C 103.59375 15.8125 103.746094 16.003906 104.0625 16.355469 C 104.160156 16.429688 104.257812 16.503906 104.359375 16.582031 C 104.644531 16.820312 104.796875 17.039062 104.960938 17.371094 C 104.960938 17.445312 104.960938 17.519531 104.960938 17.597656 C 105.035156 17.597656 105.109375 17.597656 105.1875 17.597656 C 105.453125 18.15625 105.597656 18.675781 105.703125 19.285156 C 105.726562 19.511719 105.726562 19.511719 105.863281 19.625 C 105.871094 19.835938 105.871094 20.046875 105.871094 20.253906 C 105.867188 20.367188 105.867188 20.484375 105.867188 20.601562 C 105.863281 20.734375 105.863281 20.734375 105.863281 20.867188 C 105.9375 20.867188 106.011719 20.867188 106.085938 20.867188 C 106.085938 24.777344 106.085938 28.683594 106.085938 32.710938 C 106.273438 32.710938 106.457031 32.710938 106.648438 32.710938 C 106.648438 32.785156 106.648438 32.859375 106.648438 32.9375 C 106.984375 32.972656 107.316406 33.011719 107.664062 33.050781 C 107.664062 33.125 107.664062 33.199219 107.664062 33.277344 C 107.742188 33.269531 107.820312 33.265625 107.902344 33.261719 C 108.226562 33.277344 108.226562 33.277344 108.898438 33.5 C 108.898438 34.320312 108.898438 35.140625 108.898438 35.984375 C 105.746094 36.019531 102.589844 36.058594 99.335938 36.09375 C 99.140625 35.699219 99.191406 35.25 99.183594 34.8125 C 99.179688 34.714844 99.175781 34.617188 99.171875 34.515625 C 99.160156 33.800781 99.160156 33.800781 99.480469 33.433594 C 99.789062 33.277344 99.789062 33.277344 100.238281 33.277344 C 100.238281 33.199219 100.238281 33.125 100.238281 33.050781 C 100.570312 33.011719 100.90625 32.976562 101.25 32.9375 C 101.25 32.863281 101.25 32.789062 101.25 32.710938 C 101.417969 32.601562 101.417969 32.601562 101.585938 32.484375 C 101.824219 32.25 101.722656 31.726562 101.722656 31.398438 C 101.722656 31.296875 101.726562 31.191406 101.726562 31.085938 C 101.730469 30.746094 101.734375 30.40625 101.734375 30.066406 C 101.738281 29.832031 101.742188 29.597656 101.742188 29.363281 C 101.75 28.742188 101.753906 28.121094 101.761719 27.503906 C 101.765625 26.871094 101.773438 26.238281 101.777344 25.605469 C 101.789062 24.363281 101.800781 23.125 101.8125 21.882812 C 101.738281 21.882812 101.664062 21.882812 101.585938 21.882812 C 101.582031 21.8125 101.578125 21.738281 101.574219 21.664062 C 101.527344 21.019531 101.421875 20.542969 101.136719 19.964844 C 101.101562 19.859375 101.0625 19.75 101.023438 19.640625 C 100.988281 19.5625 100.949219 19.484375 100.914062 19.402344 C 100.800781 19.363281 100.691406 19.328125 100.574219 19.289062 C 100.574219 19.214844 100.574219 19.140625 100.574219 19.0625 C 100.425781 19.0625 100.277344 19.0625 100.125 19.0625 C 100.125 18.988281 100.125 18.914062 100.125 18.835938 C 98.972656 18.835938 97.824219 18.835938 96.636719 18.835938 C 96.636719 18.910156 96.636719 18.984375 96.636719 19.0625 C 96.453125 19.0625 96.265625 19.0625 96.074219 19.0625 C 96.039062 19.175781 96 19.285156 95.960938 19.402344 C 95.59375 19.546875 95.222656 19.652344 94.835938 19.738281 C 94.835938 19.8125 94.835938 19.886719 94.835938 19.964844 C 94.761719 19.964844 94.6875 19.964844 94.613281 19.964844 C 94.574219 20.078125 94.539062 20.1875 94.5 20.304688 C 94.371094 20.378906 94.371094 20.378906 94.238281 20.457031 C 93.921875 20.628906 93.921875 20.628906 93.707031 20.9375 C 93.488281 21.207031 93.488281 21.207031 93.039062 21.320312 C 93.039062 25.078125 93.039062 28.839844 93.039062 32.710938 C 93.222656 32.710938 93.410156 32.710938 93.601562 32.710938 C 93.601562 32.785156 93.601562 32.859375 93.601562 32.9375 C 93.898438 32.972656 94.195312 33.011719 94.5 33.050781 C 94.5 33.125 94.5 33.199219 94.5 33.277344 C 94.835938 33.351562 95.167969 33.425781 95.511719 33.5 C 95.511719 34.320312 95.511719 35.140625 95.511719 35.984375 C 88.570312 35.984375 81.628906 35.984375 74.476562 35.984375 C 74.476562 35.125 74.476562 34.269531 74.476562 33.386719 C 74.863281 33.277344 74.863281 33.277344 75.261719 33.164062 C 75.261719 33.125 75.261719 33.089844 75.261719 33.050781 C 75.367188 33.035156 75.472656 33.019531 75.578125 33.003906 C 75.78125 32.976562 75.78125 32.976562 75.988281 32.945312 C 76.121094 32.925781 76.253906 32.90625 76.394531 32.882812 C 76.710938 32.859375 76.710938 32.859375 76.835938 32.710938 C 77.007812 32.683594 77.179688 32.664062 77.351562 32.648438 C 77.445312 32.636719 77.535156 32.628906 77.632812 32.621094 C 77.703125 32.613281 77.777344 32.605469 77.851562 32.597656 C 77.8125 32.339844 77.777344 32.078125 77.738281 31.808594 C 77.664062 31.808594 77.589844 31.808594 77.511719 31.808594 C 77.476562 31.472656 77.4375 31.140625 77.398438 30.792969 C 77.324219 30.792969 77.25 30.792969 77.175781 30.792969 C 77.101562 30.542969 77.03125 30.292969 76.957031 30.039062 C 76.894531 29.828125 76.894531 29.828125 76.835938 29.617188 C 76.746094 29.296875 76.675781 28.972656 76.613281 28.652344 C 71.769531 28.707031 71.769531 28.707031 66.824219 28.761719 C 66.789062 28.949219 66.75 29.136719 66.710938 29.328125 C 66.636719 29.328125 66.5625 29.328125 66.488281 29.328125 C 66.480469 29.425781 66.480469 29.425781 66.472656 29.53125 C 66.425781 30.027344 66.371094 30.453125 66.148438 30.90625 C 66.074219 30.90625 66 30.90625 65.925781 30.90625 C 65.886719 31.277344 65.851562 31.652344 65.8125 32.035156 C 65.738281 32.035156 65.664062 32.035156 65.585938 32.035156 C 65.550781 32.222656 65.511719 32.40625 65.476562 32.597656 C 65.847656 32.636719 66.21875 32.671875 66.601562 32.710938 C 66.601562 32.785156 66.601562 32.859375 66.601562 32.9375 C 67.121094 32.972656 67.640625 33.011719 68.175781 33.050781 C 68.175781 33.125 68.175781 33.199219 68.175781 33.277344 C 68.433594 33.277344 68.695312 33.277344 68.960938 33.277344 C 68.960938 34.207031 68.960938 35.136719 68.960938 36.09375 C 65.363281 36.09375 61.761719 36.09375 58.050781 36.09375 C 58.050781 35.164062 58.050781 34.234375 58.050781 33.277344 C 58.273438 33.277344 58.496094 33.277344 58.726562 33.277344 C 58.726562 33.199219 58.726562 33.125 58.726562 33.050781 C 59.171875 33.011719 59.617188 32.976562 60.074219 32.9375 C 60.074219 32.863281 60.074219 32.789062 60.074219 32.710938 C 60.445312 32.675781 60.816406 32.636719 61.199219 32.597656 C 61.238281 32.300781 61.273438 32.003906 61.3125 31.695312 C 61.386719 31.695312 61.460938 31.695312 61.539062 31.695312 C 61.550781 31.535156 61.550781 31.535156 61.566406 31.371094 C 61.632812 30.894531 61.808594 30.480469 61.996094 30.042969 C 62.089844 29.804688 62.15625 29.578125 62.210938 29.328125 C 62.285156 29.328125 62.359375 29.328125 62.4375 29.328125 C 62.476562 28.992188 62.511719 28.65625 62.550781 28.3125 C 62.625 28.3125 62.699219 28.3125 62.773438 28.3125 C 62.773438 28.125 62.773438 27.941406 62.773438 27.75 C 62.847656 27.75 62.921875 27.75 63 27.75 C 63.011719 27.640625 63.023438 27.53125 63.035156 27.417969 C 63.105469 26.902344 63.273438 26.429688 63.449219 25.945312 C 63.523438 25.945312 63.597656 25.945312 63.675781 25.945312 C 63.730469 25.496094 63.730469 25.496094 63.789062 25.042969 C 63.863281 25.042969 63.9375 25.042969 64.011719 25.042969 C 64.011719 24.816406 64.011719 24.59375 64.011719 24.363281 C 64.085938 24.363281 64.160156 24.363281 64.238281 24.363281 C 64.25 24.253906 64.261719 24.144531 64.273438 24.03125 C 64.34375 23.519531 64.511719 23.046875 64.6875 22.558594 C 64.761719 22.558594 64.835938 22.558594 64.914062 22.558594 C 64.90625 22.488281 64.898438 22.414062 64.890625 22.339844 C 64.921875 21.855469 65.085938 21.433594 65.25 20.980469 C 65.324219 20.980469 65.398438 20.980469 65.476562 20.980469 C 65.511719 20.644531 65.550781 20.308594 65.585938 19.964844 C 65.660156 19.964844 65.734375 19.964844 65.8125 19.964844 C 65.832031 19.789062 65.832031 19.789062 65.855469 19.613281 C 65.917969 19.21875 66.011719 18.871094 66.148438 18.5 C 66.222656 18.5 66.296875 18.5 66.375 18.5 C 66.390625 18.378906 66.402344 18.257812 66.417969 18.132812 C 66.476562 17.765625 66.546875 17.578125 66.710938 17.257812 C 66.753906 17.035156 66.792969 16.808594 66.824219 16.582031 C 66.898438 16.582031 66.972656 16.582031 67.050781 16.582031 C 67.066406 16.515625 67.082031 16.453125 67.097656 16.382812 C 67.160156 16.144531 67.226562 15.90625 67.296875 15.667969 C 67.335938 15.539062 67.335938 15.539062 67.371094 15.410156 C 67.398438 15.320312 67.425781 15.234375 67.449219 15.144531 C 67.492188 15.007812 67.492188 15.007812 67.53125 14.871094 C 67.59375 14.652344 67.660156 14.433594 67.726562 14.210938 C 67.800781 14.210938 67.875 14.210938 67.949219 14.210938 C 67.988281 13.914062 68.023438 13.617188 68.0625 13.308594 C 68.136719 13.308594 68.210938 13.308594 68.289062 13.308594 C 68.289062 13.160156 68.289062 13.011719 68.289062 12.859375 C 68.363281 12.859375 68.4375 12.859375 68.511719 12.859375 C 68.523438 12.710938 68.535156 12.566406 68.546875 12.414062 C 68.609375 11.855469 68.765625 11.355469 68.960938 10.828125 C 69.035156 10.828125 69.109375 10.828125 69.1875 10.828125 C 69.207031 10.714844 69.207031 10.714844 69.230469 10.597656 C 69.308594 10.214844 69.414062 9.847656 69.523438 9.476562 C 69.597656 9.476562 69.671875 9.476562 69.75 9.476562 C 69.789062 9.101562 69.824219 8.730469 69.863281 8.347656 Z M 71.664062 14.4375 C 71.664062 14.585938 71.664062 14.734375 71.664062 14.890625 C 71.589844 14.890625 71.515625 14.890625 71.4375 14.890625 C 71.398438 15.261719 71.363281 15.632812 71.324219 16.015625 C 71.25 16.015625 71.175781 16.015625 71.101562 16.015625 C 71.0625 16.351562 71.027344 16.6875 70.988281 17.03125 C 70.914062 17.03125 70.839844 17.03125 70.761719 17.03125 C 70.738281 17.132812 70.738281 17.132812 70.71875 17.238281 C 70.699219 17.328125 70.675781 17.417969 70.65625 17.511719 C 70.628906 17.644531 70.628906 17.644531 70.597656 17.78125 C 70.542969 18.023438 70.484375 18.261719 70.425781 18.5 C 70.351562 18.5 70.277344 18.5 70.199219 18.5 C 70.164062 18.832031 70.125 19.167969 70.085938 19.515625 C 70.011719 19.515625 69.9375 19.515625 69.863281 19.515625 C 69.824219 19.886719 69.789062 20.257812 69.75 20.640625 C 69.675781 20.640625 69.601562 20.640625 69.523438 20.640625 C 69.320312 21.140625 69.320312 21.140625 69.414062 21.65625 C 69.339844 21.65625 69.265625 21.65625 69.1875 21.65625 C 68.890625 22.367188 68.890625 22.367188 68.851562 23.125 C 68.777344 23.125 68.703125 23.125 68.625 23.125 C 68.585938 23.457031 68.550781 23.792969 68.511719 24.140625 C 68.4375 24.140625 68.363281 24.140625 68.289062 24.140625 C 68.144531 24.464844 68.0625 24.679688 68.0625 25.042969 C 70.511719 25.042969 72.964844 25.042969 75.488281 25.042969 C 75.414062 25.003906 75.339844 24.964844 75.261719 24.929688 C 75.261719 24.742188 75.261719 24.554688 75.261719 24.363281 C 75.1875 24.363281 75.113281 24.363281 75.039062 24.363281 C 75.027344 24.230469 75.015625 24.09375 75.003906 23.957031 C 74.949219 23.507812 74.792969 23.1875 74.585938 22.785156 C 74.566406 22.460938 74.566406 22.460938 74.585938 22.222656 C 74.511719 22.222656 74.4375 22.222656 74.363281 22.222656 C 74.347656 22.152344 74.332031 22.085938 74.316406 22.015625 C 74.296875 21.925781 74.277344 21.835938 74.257812 21.742188 C 74.238281 21.652344 74.21875 21.5625 74.199219 21.472656 C 74.144531 21.230469 74.085938 20.992188 74.023438 20.753906 C 73.949219 20.753906 73.875 20.753906 73.800781 20.753906 C 73.792969 20.6875 73.789062 20.621094 73.785156 20.550781 C 73.738281 20.054688 73.683594 19.628906 73.460938 19.175781 C 73.386719 19.175781 73.3125 19.175781 73.238281 19.175781 C 73.199219 18.765625 73.164062 18.355469 73.125 17.933594 C 73.050781 17.933594 72.976562 17.933594 72.898438 17.933594 C 72.84375 17.488281 72.84375 17.488281 72.789062 17.03125 C 72.714844 17.03125 72.640625 17.03125 72.5625 17.03125 C 72.5625 16.808594 72.5625 16.585938 72.5625 16.355469 C 72.488281 16.355469 72.414062 16.355469 72.335938 16.355469 C 72.28125 15.910156 72.28125 15.910156 72.226562 15.453125 C 72.152344 15.453125 72.078125 15.453125 72 15.453125 C 71.945312 14.949219 71.945312 14.949219 71.886719 14.4375 C 71.8125 14.4375 71.738281 14.4375 71.664062 14.4375 Z M 71.664062 14.4375 "/>
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 119.136719 14.890625 C 120.363281 14.890625 121.585938 14.890625 122.851562 14.890625 C 122.851562 14.964844 122.851562 15.039062 122.851562 15.113281 C 122.949219 15.109375 122.949219 15.109375 123.046875 15.105469 C 123.597656 15.09375 124.019531 15.136719 124.539062 15.339844 C 124.6875 15.378906 124.835938 15.417969 124.988281 15.453125 C 124.988281 15.527344 124.988281 15.601562 124.988281 15.679688 C 125.136719 15.695312 125.136719 15.695312 125.289062 15.714844 C 125.671875 15.792969 125.914062 15.898438 126.226562 16.128906 C 126.226562 16.203125 126.226562 16.277344 126.226562 16.355469 C 126.300781 16.355469 126.375 16.355469 126.449219 16.355469 C 126.632812 16.511719 126.632812 16.511719 126.789062 16.695312 C 126.789062 16.769531 126.789062 16.84375 126.789062 16.917969 C 126.855469 16.925781 126.925781 16.933594 127 16.941406 C 127.078125 16.972656 127.15625 17 127.238281 17.03125 C 127.316406 17.21875 127.390625 17.40625 127.460938 17.597656 C 127.574219 17.632812 127.683594 17.671875 127.800781 17.710938 C 128.035156 18.039062 128.136719 18.203125 128.136719 18.613281 C 128.210938 18.648438 128.285156 18.6875 128.363281 18.722656 C 128.433594 19.070312 128.433594 19.070312 128.476562 19.402344 C 128.550781 19.402344 128.625 19.402344 128.699219 19.402344 C 128.738281 19.886719 128.773438 20.367188 128.8125 20.867188 C 128.886719 20.867188 128.960938 20.867188 129.039062 20.867188 C 129.128906 21.425781 129.164062 21.960938 129.164062 22.527344 C 129.164062 22.609375 129.164062 22.6875 129.164062 22.773438 C 129.164062 22.941406 129.164062 23.109375 129.164062 23.277344 C 129.164062 23.53125 129.164062 23.789062 129.164062 24.046875 C 129.164062 24.210938 129.164062 24.375 129.164062 24.539062 C 129.164062 24.6875 129.164062 24.832031 129.164062 24.988281 C 129.148438 25.378906 129.148438 25.378906 129.039062 25.945312 C 124.621094 25.945312 120.203125 25.945312 115.648438 25.945312 C 115.621094 26.6875 115.621094 26.6875 115.875 27.296875 C 115.902344 27.5625 115.921875 27.828125 115.9375 28.09375 C 115.949219 28.238281 115.957031 28.386719 115.96875 28.535156 C 115.972656 28.648438 115.980469 28.761719 115.988281 28.875 C 116.0625 28.875 116.136719 28.875 116.210938 28.875 C 116.234375 28.941406 116.257812 29.003906 116.277344 29.070312 C 116.324219 29.195312 116.324219 29.195312 116.367188 29.320312 C 116.394531 29.402344 116.425781 29.484375 116.453125 29.570312 C 116.535156 29.800781 116.535156 29.800781 116.773438 29.890625 C 116.785156 29.972656 116.796875 30.054688 116.8125 30.140625 C 116.914062 30.570312 117.140625 30.78125 117.441406 31.105469 C 117.542969 31.210938 117.644531 31.320312 117.75 31.433594 C 117.988281 31.699219 117.988281 31.699219 118.238281 31.808594 C 118.238281 31.882812 118.238281 31.957031 118.238281 32.035156 C 118.304688 32.054688 118.371094 32.078125 118.4375 32.101562 C 118.527344 32.128906 118.617188 32.160156 118.707031 32.191406 C 118.796875 32.21875 118.882812 32.246094 118.972656 32.277344 C 119.25 32.375 119.25 32.375 119.492188 32.492188 C 119.898438 32.628906 120.28125 32.625 120.703125 32.621094 C 120.789062 32.621094 120.871094 32.621094 120.960938 32.621094 C 121.226562 32.617188 121.492188 32.617188 121.761719 32.613281 C 121.941406 32.613281 122.125 32.609375 122.304688 32.609375 C 122.75 32.605469 123.195312 32.601562 123.636719 32.597656 C 123.636719 32.523438 123.636719 32.449219 123.636719 32.375 C 124.160156 32.238281 124.675781 32.117188 125.210938 32.035156 C 125.210938 31.960938 125.210938 31.886719 125.210938 31.808594 C 125.472656 31.773438 125.730469 31.734375 126 31.695312 C 126 31.621094 126 31.546875 126 31.472656 C 126.648438 31.132812 126.648438 31.132812 126.898438 31.132812 C 126.898438 31.058594 126.898438 30.984375 126.898438 30.90625 C 127.234375 30.871094 127.566406 30.832031 127.914062 30.792969 C 128.136719 31.132812 128.136719 31.132812 128.136719 31.472656 C 128.210938 31.472656 128.285156 31.472656 128.363281 31.472656 C 128.722656 31.894531 129.007812 32.3125 129.101562 32.867188 C 129.027344 33.203125 128.984375 33.3125 128.699219 33.5 C 128.398438 33.578125 128.398438 33.578125 128.136719 33.613281 C 128.101562 33.726562 128.0625 33.835938 128.023438 33.953125 C 127.804688 34.109375 127.804688 34.109375 127.53125 34.253906 C 127.445312 34.304688 127.355469 34.355469 127.261719 34.40625 C 127.011719 34.515625 127.011719 34.515625 126.675781 34.515625 C 126.675781 34.589844 126.675781 34.664062 126.675781 34.742188 C 126.511719 34.816406 126.351562 34.894531 126.191406 34.96875 C 126.101562 35.007812 126.007812 35.050781 125.917969 35.09375 C 125.664062 35.191406 125.664062 35.191406 125.324219 35.191406 C 125.324219 35.265625 125.324219 35.34375 125.324219 35.417969 C 124.769531 35.648438 124.359375 35.804688 123.75 35.757812 C 123.75 35.832031 123.75 35.90625 123.75 35.984375 C 122.691406 36.179688 121.671875 36.242188 120.601562 36.238281 C 120.457031 36.238281 120.316406 36.238281 120.167969 36.238281 C 119.242188 36.238281 118.359375 36.152344 117.449219 35.984375 C 117.449219 35.90625 117.449219 35.832031 117.449219 35.757812 C 117.328125 35.761719 117.203125 35.765625 117.078125 35.769531 C 116.664062 35.757812 116.664062 35.757812 116.324219 35.53125 C 116.101562 35.453125 115.875 35.375 115.648438 35.304688 C 115.648438 35.230469 115.648438 35.15625 115.648438 35.082031 C 115.550781 35.058594 115.550781 35.058594 115.453125 35.039062 C 115.199219 34.964844 114.984375 34.867188 114.75 34.742188 C 114.75 34.667969 114.75 34.59375 114.75 34.515625 C 114.679688 34.488281 114.609375 34.460938 114.539062 34.433594 C 114.261719 34.265625 114.191406 34.136719 114.074219 33.839844 C 113.964844 33.839844 113.851562 33.839844 113.738281 33.839844 C 113.707031 33.75 113.675781 33.65625 113.644531 33.566406 C 113.601562 33.46875 113.558594 33.375 113.511719 33.277344 C 113.402344 33.238281 113.289062 33.199219 113.175781 33.164062 C 112.613281 32.433594 112.210938 31.613281 111.882812 30.757812 C 111.851562 30.6875 111.824219 30.613281 111.792969 30.539062 C 111.597656 29.996094 111.574219 29.554688 111.601562 28.988281 C 111.527344 28.988281 111.453125 28.988281 111.375 28.988281 C 111.28125 27.984375 111.246094 26.984375 111.246094 25.972656 C 111.25 25.746094 111.246094 25.515625 111.246094 25.285156 C 111.25 23.136719 111.25 23.136719 111.488281 22.898438 C 111.53125 22.671875 111.570312 22.441406 111.605469 22.214844 C 111.636719 22.027344 111.636719 22.027344 111.667969 21.835938 C 111.683594 21.738281 111.695312 21.644531 111.710938 21.542969 C 111.785156 21.542969 111.859375 21.542969 111.9375 21.542969 C 111.945312 21.433594 111.957031 21.320312 111.964844 21.207031 C 112.039062 20.695312 112.253906 20.296875 112.5 19.851562 C 112.546875 19.761719 112.597656 19.667969 112.648438 19.574219 C 113.03125 18.851562 113.03125 18.851562 113.289062 18.722656 C 113.34375 18.628906 113.398438 18.535156 113.457031 18.433594 C 113.511719 18.34375 113.566406 18.253906 113.625 18.160156 C 113.699219 18.160156 113.773438 18.160156 113.851562 18.160156 C 113.851562 18.085938 113.851562 18.011719 113.851562 17.933594 C 113.925781 17.933594 114 17.933594 114.074219 17.933594 C 114.101562 17.863281 114.128906 17.796875 114.160156 17.722656 C 114.324219 17.445312 114.453125 17.375 114.75 17.257812 C 114.75 17.183594 114.75 17.109375 114.75 17.03125 C 115.078125 16.628906 115.378906 16.492188 115.875 16.355469 C 115.875 16.28125 115.875 16.207031 115.875 16.128906 C 116.0625 16.09375 116.246094 16.054688 116.4375 16.015625 C 116.4375 15.941406 116.4375 15.867188 116.4375 15.792969 C 116.828125 15.734375 116.828125 15.734375 117.226562 15.679688 C 117.226562 15.605469 117.226562 15.53125 117.226562 15.453125 C 117.726562 15.398438 117.726562 15.398438 118.238281 15.339844 C 118.238281 15.265625 118.238281 15.191406 118.238281 15.113281 C 118.535156 15.113281 118.832031 15.113281 119.136719 15.113281 C 119.136719 15.039062 119.136719 14.964844 119.136719 14.890625 Z M 119.023438 18.5 C 119.023438 18.574219 119.023438 18.648438 119.023438 18.722656 C 118.765625 18.761719 118.503906 18.800781 118.238281 18.835938 C 118.238281 18.910156 118.238281 18.984375 118.238281 19.0625 C 118.050781 19.101562 117.867188 19.136719 117.675781 19.175781 C 117.675781 19.25 117.675781 19.324219 117.675781 19.402344 C 117.601562 19.402344 117.527344 19.402344 117.449219 19.402344 C 117.261719 19.550781 117.261719 19.550781 117.113281 19.738281 C 117.113281 19.8125 117.113281 19.886719 117.113281 19.964844 C 117.039062 19.964844 116.964844 19.964844 116.886719 19.964844 C 116.886719 20.078125 116.886719 20.1875 116.886719 20.304688 C 116.8125 20.339844 116.738281 20.378906 116.664062 20.417969 C 116.285156 20.988281 116.285156 20.988281 116.210938 21.65625 C 116.136719 21.65625 116.0625 21.65625 115.988281 21.65625 C 115.914062 22.03125 115.839844 22.402344 115.761719 22.785156 C 118.734375 22.785156 121.703125 22.785156 124.761719 22.785156 C 124.761719 22.488281 124.761719 22.191406 124.761719 21.882812 C 124.6875 21.882812 124.613281 21.882812 124.539062 21.882812 C 124.5 21.511719 124.464844 21.136719 124.425781 20.753906 C 124.351562 20.753906 124.277344 20.753906 124.199219 20.753906 C 124.1875 20.652344 124.171875 20.550781 124.15625 20.445312 C 124.097656 20.125 124.023438 19.90625 123.863281 19.625 C 123.789062 19.625 123.714844 19.625 123.636719 19.625 C 123.613281 19.5625 123.589844 19.496094 123.566406 19.429688 C 123.355469 19.082031 123.085938 18.914062 122.738281 18.722656 C 122.664062 18.683594 122.585938 18.640625 122.511719 18.597656 C 121.882812 18.292969 121.3125 18.234375 120.628906 18.230469 C 120.546875 18.230469 120.464844 18.230469 120.382812 18.230469 C 119.890625 18.242188 119.480469 18.320312 119.023438 18.5 Z M 119.023438 18.5 "/>
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 158.511719 14.890625 C 159.738281 14.890625 160.960938 14.890625 162.226562 14.890625 C 162.226562 14.964844 162.226562 15.039062 162.226562 15.113281 C 162.371094 15.109375 162.515625 15.101562 162.667969 15.09375 C 163.230469 15.09375 163.742188 15.207031 164.25 15.453125 C 164.304688 15.566406 164.304688 15.566406 164.363281 15.679688 C 164.703125 15.753906 164.703125 15.753906 165.039062 15.792969 C 165.039062 15.867188 165.039062 15.941406 165.039062 16.015625 C 165.261719 16.074219 165.261719 16.074219 165.488281 16.128906 C 165.488281 16.203125 165.488281 16.277344 165.488281 16.355469 C 165.671875 16.394531 165.859375 16.429688 166.050781 16.46875 C 166.050781 16.542969 166.050781 16.617188 166.050781 16.695312 C 166.125 16.695312 166.199219 16.695312 166.273438 16.695312 C 166.3125 16.769531 166.347656 16.84375 166.386719 16.917969 C 166.5 16.957031 166.609375 16.996094 166.726562 17.03125 C 166.761719 17.125 166.792969 17.214844 166.832031 17.308594 C 166.917969 17.609375 166.917969 17.609375 167.160156 17.703125 C 167.515625 17.878906 167.644531 18.167969 167.851562 18.5 C 167.925781 18.574219 168 18.648438 168.074219 18.722656 C 168.523438 19.441406 168.523438 19.441406 168.523438 19.964844 C 168.597656 19.964844 168.671875 19.964844 168.75 19.964844 C 168.789062 20.261719 168.824219 20.5625 168.863281 20.867188 C 168.9375 20.867188 169.011719 20.867188 169.085938 20.867188 C 169.46875 21.707031 169.441406 22.5625 169.425781 23.460938 C 169.5 23.460938 169.574219 23.460938 169.648438 23.460938 C 169.648438 24.578125 169.648438 25.695312 169.648438 26.847656 C 169.574219 26.847656 169.5 26.847656 169.425781 26.847656 C 169.425781 26.933594 169.425781 27.023438 169.429688 27.113281 C 169.433594 27.753906 169.425781 28.359375 169.3125 28.988281 C 169.238281 28.988281 169.164062 28.988281 169.085938 28.988281 C 169.085938 29.175781 169.085938 29.363281 169.085938 29.554688 C 169.011719 29.554688 168.9375 29.554688 168.863281 29.554688 C 168.851562 29.683594 168.84375 29.8125 168.835938 29.949219 C 168.777344 30.40625 168.628906 30.75 168.410156 31.152344 C 168.289062 31.371094 168.289062 31.371094 168.1875 31.667969 C 168.050781 31.976562 167.863281 32.132812 167.625 32.375 C 167.472656 32.609375 167.332031 32.851562 167.191406 33.09375 C 167.148438 33.152344 167.105469 33.214844 167.0625 33.277344 C 166.988281 33.277344 166.914062 33.277344 166.835938 33.277344 C 166.835938 33.351562 166.835938 33.425781 166.835938 33.5 C 166.640625 33.683594 166.441406 33.855469 166.234375 34.023438 C 166.121094 34.113281 166.007812 34.207031 165.894531 34.300781 C 165.601562 34.515625 165.601562 34.515625 165.375 34.515625 C 165.335938 34.628906 165.300781 34.738281 165.261719 34.855469 C 165.113281 34.855469 164.964844 34.855469 164.8125 34.855469 C 164.8125 34.929688 164.8125 35.003906 164.8125 35.082031 C 164.699219 35.082031 164.589844 35.082031 164.476562 35.082031 C 164.4375 35.191406 164.402344 35.304688 164.363281 35.417969 C 164.144531 35.527344 164.144531 35.527344 163.878906 35.609375 C 163.789062 35.636719 163.703125 35.664062 163.613281 35.695312 C 163.351562 35.757812 163.351562 35.757812 162.898438 35.757812 C 162.898438 35.832031 162.898438 35.90625 162.898438 35.984375 C 161.886719 36.171875 160.898438 36.242188 159.871094 36.238281 C 159.636719 36.238281 159.40625 36.238281 159.175781 36.238281 C 156.792969 36.242188 156.792969 36.242188 155.925781 35.757812 C 155.757812 35.679688 155.585938 35.605469 155.417969 35.53125 C 155.09375 35.390625 154.777344 35.242188 154.460938 35.082031 C 154.460938 35.003906 154.460938 34.929688 154.460938 34.855469 C 154.347656 34.855469 154.234375 34.855469 154.117188 34.855469 C 153.589844 34.785156 153.355469 34.449219 153.03125 34.054688 C 152.886719 33.839844 152.886719 33.839844 152.886719 33.613281 C 152.824219 33.589844 152.761719 33.566406 152.699219 33.542969 C 151.902344 33.070312 151.578125 32.160156 151.199219 31.359375 C 151.15625 31.273438 151.113281 31.1875 151.070312 31.101562 C 150.40625 29.742188 150.363281 28.324219 150.414062 26.847656 C 150.339844 26.847656 150.265625 26.847656 150.1875 26.847656 C 150.1875 26.214844 150.1875 25.582031 150.1875 24.929688 C 150.261719 24.929688 150.335938 24.929688 150.414062 24.929688 C 150.410156 24.800781 150.410156 24.671875 150.410156 24.539062 C 150.40625 24.371094 150.40625 24.203125 150.40625 24.03125 C 150.40625 23.949219 150.402344 23.863281 150.402344 23.773438 C 150.402344 23.558594 150.40625 23.339844 150.414062 23.125 C 150.46875 23.066406 150.46875 23.066406 150.523438 23.011719 C 150.519531 22.914062 150.515625 22.816406 150.511719 22.714844 C 150.527344 22.257812 150.675781 21.960938 150.863281 21.542969 C 150.949219 21.246094 151.019531 20.945312 151.085938 20.640625 C 151.160156 20.640625 151.234375 20.640625 151.3125 20.640625 C 151.324219 20.5625 151.335938 20.484375 151.347656 20.402344 C 151.4375 20.03125 151.582031 19.753906 151.769531 19.421875 C 151.832031 19.3125 151.894531 19.203125 151.957031 19.089844 C 152.003906 19.007812 152.050781 18.921875 152.101562 18.835938 C 152.175781 18.835938 152.25 18.835938 152.324219 18.835938 C 152.355469 18.746094 152.386719 18.65625 152.417969 18.5625 C 152.460938 18.46875 152.503906 18.371094 152.550781 18.273438 C 152.660156 18.234375 152.773438 18.199219 152.886719 18.160156 C 152.925781 18.050781 152.960938 17.9375 153 17.820312 C 153.074219 17.820312 153.148438 17.820312 153.226562 17.820312 C 153.226562 17.746094 153.226562 17.671875 153.226562 17.597656 C 153.300781 17.597656 153.375 17.597656 153.449219 17.597656 C 153.488281 17.484375 153.523438 17.375 153.5625 17.257812 C 153.636719 17.257812 153.710938 17.257812 153.789062 17.257812 C 153.8125 17.167969 153.839844 17.082031 153.863281 16.992188 C 154.011719 16.695312 154.011719 16.695312 154.28125 16.554688 C 154.574219 16.46875 154.574219 16.46875 154.828125 16.417969 C 154.925781 16.386719 154.925781 16.386719 155.023438 16.355469 C 155.0625 16.242188 155.097656 16.132812 155.136719 16.015625 C 155.210938 16.015625 155.285156 16.015625 155.363281 16.015625 C 155.398438 15.941406 155.4375 15.867188 155.476562 15.792969 C 155.792969 15.6875 156.109375 15.589844 156.429688 15.503906 C 157.011719 15.386719 157.011719 15.386719 157.5 15.113281 C 157.671875 15.105469 157.84375 15.105469 158.011719 15.109375 C 158.105469 15.109375 158.199219 15.109375 158.296875 15.109375 C 158.367188 15.113281 158.4375 15.113281 158.511719 15.113281 C 158.511719 15.039062 158.511719 14.964844 158.511719 14.890625 Z M 157.835938 18.722656 C 157.6875 18.765625 157.539062 18.804688 157.386719 18.835938 C 157.386719 18.910156 157.386719 18.984375 157.386719 19.0625 C 157.304688 19.089844 157.226562 19.117188 157.140625 19.148438 C 156.210938 19.5625 155.789062 20.402344 155.375 21.296875 C 155.257812 21.636719 155.21875 21.867188 155.25 22.222656 C 155.175781 22.222656 155.101562 22.222656 155.023438 22.222656 C 155.023438 22.445312 155.023438 22.667969 155.023438 22.898438 C 154.949219 22.898438 154.875 22.898438 154.800781 22.898438 C 154.65625 24.625 154.609375 26.359375 154.800781 28.085938 C 154.875 28.085938 154.949219 28.085938 155.023438 28.085938 C 155.023438 28.382812 155.023438 28.683594 155.023438 28.988281 C 155.097656 28.988281 155.171875 28.988281 155.25 28.988281 C 155.289062 29.285156 155.324219 29.585938 155.363281 29.890625 C 155.4375 29.890625 155.511719 29.890625 155.585938 29.890625 C 155.578125 29.972656 155.570312 30.050781 155.5625 30.132812 C 155.59375 30.558594 155.753906 30.761719 156.003906 31.105469 C 156.117188 31.265625 156.117188 31.265625 156.234375 31.433594 C 156.515625 31.722656 156.65625 31.777344 157.050781 31.808594 C 157.085938 31.921875 157.125 32.03125 157.164062 32.148438 C 157.496094 32.414062 157.496094 32.414062 157.949219 32.375 C 157.949219 32.449219 157.949219 32.523438 157.949219 32.597656 C 158.613281 32.742188 159.277344 32.738281 159.953125 32.738281 C 160.070312 32.742188 160.1875 32.746094 160.308594 32.746094 C 161.335938 32.75 162.109375 32.523438 163.011719 32.035156 C 163.011719 31.960938 163.011719 31.886719 163.011719 31.808594 C 163.125 31.773438 163.234375 31.734375 163.351562 31.695312 C 163.351562 31.621094 163.351562 31.546875 163.351562 31.472656 C 163.425781 31.472656 163.5 31.472656 163.574219 31.472656 C 163.902344 31.207031 164.046875 30.890625 164.214844 30.511719 C 164.265625 30.402344 164.3125 30.296875 164.363281 30.183594 C 164.496094 29.890625 164.496094 29.890625 164.476562 29.554688 C 164.550781 29.554688 164.625 29.554688 164.699219 29.554688 C 164.738281 29.144531 164.773438 28.734375 164.8125 28.3125 C 164.886719 28.3125 164.960938 28.3125 165.039062 28.3125 C 165.144531 27.347656 165.164062 26.390625 165.164062 25.421875 C 165.164062 25.304688 165.164062 25.183594 165.164062 25.0625 C 165.164062 23.355469 164.953125 21.933594 164.136719 20.417969 C 164.0625 20.265625 163.988281 20.117188 163.914062 19.964844 C 163.839844 19.964844 163.765625 19.964844 163.6875 19.964844 C 163.640625 19.863281 163.640625 19.863281 163.597656 19.761719 C 163.382812 19.367188 163.214844 19.207031 162.789062 19.0625 C 162.730469 18.953125 162.730469 18.953125 162.675781 18.835938 C 162.285156 18.707031 161.960938 18.714844 161.550781 18.722656 C 161.550781 18.648438 161.550781 18.574219 161.550781 18.5 C 161.054688 18.25 160.589844 18.238281 160.046875 18.246094 C 159.921875 18.242188 159.921875 18.242188 159.796875 18.242188 C 159.074219 18.246094 158.484375 18.390625 157.835938 18.722656 Z M 157.835938 18.722656 "/>
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 183.460938 5.386719 C 183.539062 5.386719 183.617188 5.386719 183.699219 5.386719 C 186.84375 5.398438 186.84375 5.398438 187.648438 5.867188 C 187.949219 5.992188 188.242188 6.101562 188.550781 6.195312 C 188.660156 6.238281 188.773438 6.277344 188.886719 6.316406 C 188.984375 6.351562 189.085938 6.386719 189.1875 6.421875 C 189.449219 6.65625 189.449219 6.65625 189.5 6.882812 C 189.515625 7.1875 189.511719 7.492188 189.503906 7.796875 C 189.503906 7.964844 189.503906 7.964844 189.503906 8.136719 C 189.5 8.496094 189.492188 8.855469 189.484375 9.214844 C 189.480469 9.457031 189.480469 9.699219 189.476562 9.941406 C 189.472656 10.539062 189.460938 11.136719 189.449219 11.730469 C 189.300781 11.730469 189.152344 11.730469 189 11.730469 C 189 11.804688 189 11.878906 189 11.957031 C 188.21875 11.957031 187.441406 11.957031 186.636719 11.957031 C 186.636719 11.882812 186.636719 11.808594 186.636719 11.730469 C 186.488281 11.730469 186.339844 11.730469 186.1875 11.730469 C 186.023438 11.214844 185.949219 10.8125 185.960938 10.265625 C 185.925781 10.226562 185.886719 10.191406 185.851562 10.152344 C 185.84375 9.960938 185.839844 9.769531 185.84375 9.582031 C 185.84375 9.476562 185.84375 9.375 185.847656 9.265625 C 185.847656 9.1875 185.847656 9.105469 185.851562 9.023438 C 185.777344 9.023438 185.703125 9.023438 185.625 9.023438 C 185.625 8.949219 185.625 8.875 185.625 8.796875 C 185.234375 8.675781 184.875 8.671875 184.464844 8.675781 C 184.261719 8.675781 184.261719 8.675781 184.054688 8.675781 C 183.84375 8.675781 183.84375 8.675781 183.628906 8.679688 C 183.414062 8.679688 183.414062 8.679688 183.195312 8.679688 C 182.84375 8.679688 182.488281 8.683594 182.136719 8.683594 C 182.136719 8.761719 182.136719 8.835938 182.136719 8.910156 C 182.046875 8.925781 181.957031 8.9375 181.863281 8.953125 C 181.769531 8.976562 181.671875 9 181.574219 9.023438 C 181.519531 9.136719 181.519531 9.136719 181.460938 9.25 C 181.296875 9.304688 181.296875 9.304688 181.125 9.363281 C 180.964844 9.605469 180.964844 9.605469 180.828125 9.898438 C 180.78125 9.996094 180.734375 10.09375 180.683594 10.191406 C 180.445312 10.773438 180.429688 11.351562 180.414062 11.972656 C 180.414062 12.050781 180.410156 12.128906 180.40625 12.207031 C 180.402344 12.492188 180.394531 12.777344 180.386719 13.0625 C 180.371094 13.703125 180.355469 14.34375 180.335938 15.003906 C 182.789062 15.058594 182.789062 15.058594 185.289062 15.113281 C 185.289062 16.15625 185.289062 17.199219 185.289062 18.273438 C 183.691406 18.308594 182.09375 18.347656 180.449219 18.386719 C 180.414062 23.078125 180.375 27.765625 180.335938 32.597656 C 180.707031 32.636719 181.078125 32.671875 181.460938 32.710938 C 181.460938 32.785156 181.460938 32.859375 181.460938 32.9375 C 181.871094 32.972656 182.277344 33.011719 182.699219 33.050781 C 182.699219 33.125 182.699219 33.199219 182.699219 33.277344 C 182.796875 33.269531 182.894531 33.261719 182.996094 33.253906 C 183.375 33.277344 183.375 33.277344 184.050781 33.613281 C 184.050781 34.394531 184.050781 35.175781 184.050781 35.984375 C 180.300781 35.984375 176.550781 35.984375 172.6875 35.984375 C 172.6875 35.164062 172.6875 34.34375 172.6875 33.5 C 173.097656 33.390625 173.503906 33.277344 173.925781 33.164062 C 173.925781 33.125 173.925781 33.089844 173.925781 33.050781 C 174.332031 33.011719 174.742188 32.976562 175.164062 32.9375 C 175.164062 32.863281 175.164062 32.789062 175.164062 32.710938 C 175.550781 32.601562 175.550781 32.601562 175.949219 32.484375 C 175.949219 27.832031 175.949219 23.179688 175.949219 18.386719 C 174.800781 18.347656 173.648438 18.3125 172.460938 18.273438 C 172.460938 17.417969 172.460938 16.5625 172.460938 15.679688 C 172.535156 15.679688 172.609375 15.679688 172.6875 15.679688 C 172.6875 15.605469 172.6875 15.53125 172.6875 15.453125 C 173.210938 15.347656 173.714844 15.328125 174.25 15.332031 C 174.324219 15.335938 174.402344 15.335938 174.484375 15.335938 C 174.671875 15.335938 174.859375 15.339844 175.050781 15.339844 C 175.050781 15.265625 175.050781 15.191406 175.050781 15.113281 C 175.382812 15.113281 175.71875 15.113281 176.0625 15.113281 C 176.0625 14.996094 176.0625 14.878906 176.0625 14.757812 C 176.058594 14.3125 176.058594 13.871094 176.054688 13.429688 C 176.054688 13.238281 176.054688 13.046875 176.054688 12.855469 C 176.050781 12.582031 176.050781 12.304688 176.050781 12.03125 C 176.050781 11.90625 176.050781 11.90625 176.050781 11.777344 C 176.050781 11.226562 176.097656 10.695312 176.175781 10.152344 C 176.25 10.152344 176.324219 10.152344 176.398438 10.152344 C 176.417969 10.039062 176.417969 10.039062 176.433594 9.925781 C 176.644531 9.019531 177.03125 8.066406 177.75 7.445312 C 177.824219 7.445312 177.898438 7.445312 177.976562 7.445312 C 178.03125 7.277344 178.03125 7.277344 178.085938 7.105469 C 178.160156 7.105469 178.234375 7.105469 178.3125 7.105469 C 178.3125 7.03125 178.3125 6.957031 178.3125 6.878906 C 178.800781 6.429688 178.800781 6.429688 179.210938 6.429688 C 179.210938 6.355469 179.210938 6.28125 179.210938 6.203125 C 179.546875 6.054688 179.878906 5.90625 180.226562 5.753906 C 180.226562 5.714844 180.226562 5.679688 180.226562 5.640625 C 181.308594 5.4375 182.359375 5.378906 183.460938 5.386719 Z M 183.460938 5.386719 "/>
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 137.699219 14.890625 C 139.035156 14.890625 140.371094 14.890625 141.75 14.890625 C 141.75 14.964844 141.75 15.039062 141.75 15.113281 C 141.832031 15.113281 141.910156 15.109375 141.992188 15.105469 C 142.636719 15.09375 143.15625 15.132812 143.773438 15.339844 C 144.523438 15.542969 145.253906 15.71875 146.023438 15.792969 C 146.023438 15.867188 146.023438 15.941406 146.023438 16.015625 C 146.171875 16.09375 146.320312 16.167969 146.476562 16.242188 C 146.476562 16.464844 146.476562 16.691406 146.476562 16.917969 C 146.402344 16.917969 146.328125 16.917969 146.25 16.917969 C 146.25 18.445312 146.25 19.972656 146.25 21.542969 C 145.285156 21.542969 144.320312 21.542969 143.324219 21.542969 C 143.269531 21.097656 143.269531 21.097656 143.210938 20.640625 C 143.175781 20.605469 143.136719 20.566406 143.101562 20.527344 C 143.09375 20.265625 143.09375 20.003906 143.101562 19.738281 C 143.027344 19.738281 142.953125 19.738281 142.875 19.738281 C 142.835938 19.332031 142.800781 18.921875 142.761719 18.5 C 141.796875 18.3125 140.882812 18.238281 139.902344 18.246094 C 139.773438 18.246094 139.644531 18.242188 139.511719 18.242188 C 139.324219 18.242188 139.324219 18.242188 139.136719 18.242188 C 138.96875 18.242188 138.96875 18.242188 138.796875 18.242188 C 138.46875 18.273438 138.226562 18.371094 137.925781 18.5 C 137.8125 18.5 137.703125 18.5 137.585938 18.5 C 137.585938 18.574219 137.585938 18.648438 137.585938 18.722656 C 137.476562 18.761719 137.363281 18.800781 137.25 18.835938 C 137.054688 18.984375 137.054688 18.984375 136.914062 19.175781 C 136.914062 19.289062 136.914062 19.398438 136.914062 19.515625 C 136.839844 19.515625 136.765625 19.515625 136.6875 19.515625 C 136.6875 19.773438 136.6875 20.035156 136.6875 20.304688 C 136.613281 20.304688 136.539062 20.304688 136.460938 20.304688 C 136.460938 20.414062 136.460938 20.527344 136.460938 20.640625 C 136.535156 20.640625 136.609375 20.640625 136.6875 20.640625 C 136.742188 20.867188 136.796875 21.089844 136.851562 21.3125 C 136.941406 21.734375 136.941406 21.734375 137.234375 22.007812 C 137.425781 22.085938 137.617188 22.15625 137.8125 22.222656 C 137.8125 22.296875 137.8125 22.371094 137.8125 22.445312 C 138.148438 22.503906 138.148438 22.503906 138.488281 22.558594 C 138.488281 22.632812 138.488281 22.707031 138.488281 22.785156 C 138.785156 22.824219 139.082031 22.859375 139.386719 22.898438 C 139.386719 22.972656 139.386719 23.046875 139.386719 23.125 C 139.53125 23.144531 139.53125 23.144531 139.675781 23.164062 C 140.078125 23.238281 140.457031 23.34375 140.851562 23.460938 C 140.851562 23.535156 140.851562 23.609375 140.851562 23.6875 C 141.183594 23.726562 141.519531 23.761719 141.863281 23.800781 C 141.863281 23.875 141.863281 23.949219 141.863281 24.027344 C 141.972656 24.035156 142.085938 24.042969 142.199219 24.054688 C 142.617188 24.113281 142.929688 24.265625 143.296875 24.464844 C 143.6875 24.65625 144.09375 24.789062 144.503906 24.925781 C 144.792969 25.042969 145.003906 25.171875 145.238281 25.378906 C 145.238281 25.453125 145.238281 25.527344 145.238281 25.605469 C 145.335938 25.625 145.433594 25.640625 145.53125 25.660156 C 146.058594 25.894531 146.277344 26.261719 146.585938 26.734375 C 146.699219 26.902344 146.699219 26.902344 146.8125 27.070312 C 147.195312 27.675781 147.1875 28.183594 147.148438 28.875 C 147.222656 28.875 147.296875 28.875 147.375 28.875 C 147.375 29.398438 147.375 29.917969 147.375 30.457031 C 147.300781 30.457031 147.226562 30.457031 147.148438 30.457031 C 147.15625 30.535156 147.160156 30.609375 147.164062 30.691406 C 147.203125 31.636719 146.996094 32.269531 146.476562 33.050781 C 146.402344 33.050781 146.328125 33.050781 146.25 33.050781 C 146.242188 33.113281 146.230469 33.179688 146.222656 33.246094 C 146.113281 33.574219 145.949219 33.730469 145.6875 33.953125 C 145.613281 33.953125 145.539062 33.953125 145.460938 33.953125 C 145.460938 34.027344 145.460938 34.101562 145.460938 34.179688 C 145.386719 34.179688 145.3125 34.179688 145.238281 34.179688 C 145.238281 34.253906 145.238281 34.328125 145.238281 34.402344 C 145.164062 34.402344 145.089844 34.402344 145.011719 34.402344 C 144.976562 34.515625 144.9375 34.625 144.898438 34.742188 C 144.675781 34.777344 144.453125 34.816406 144.226562 34.855469 C 144.226562 34.929688 144.226562 35.003906 144.226562 35.082031 C 143.75 35.332031 143.289062 35.511719 142.777344 35.664062 C 142.648438 35.703125 142.515625 35.742188 142.382812 35.78125 C 142.285156 35.8125 142.1875 35.839844 142.085938 35.871094 C 142.085938 35.90625 142.085938 35.945312 142.085938 35.984375 C 140.851562 36.183594 139.652344 36.246094 138.402344 36.238281 C 138.316406 36.234375 138.226562 36.234375 138.136719 36.234375 C 136.816406 36.230469 135.519531 36.179688 134.210938 35.984375 C 134.210938 35.90625 134.210938 35.832031 134.210938 35.757812 C 134.148438 35.757812 134.085938 35.761719 134.019531 35.765625 C 133.933594 35.765625 133.84375 35.769531 133.753906 35.769531 C 133.671875 35.773438 133.585938 35.777344 133.5 35.777344 C 133.199219 35.757812 133.199219 35.757812 132.414062 35.53125 C 132.414062 33.484375 132.414062 31.4375 132.414062 29.328125 C 133.304688 29.328125 134.195312 29.328125 135.113281 29.328125 C 135.113281 29.402344 135.113281 29.476562 135.113281 29.554688 C 135.222656 29.554688 135.335938 29.554688 135.449219 29.554688 C 135.585938 30.191406 135.574219 30.820312 135.5625 31.472656 C 135.636719 31.472656 135.710938 31.472656 135.789062 31.472656 C 135.824219 31.84375 135.863281 32.214844 135.898438 32.597656 C 136.121094 32.636719 136.34375 32.671875 136.574219 32.710938 C 136.574219 32.785156 136.574219 32.859375 136.574219 32.9375 C 137.949219 32.9375 139.320312 32.9375 140.738281 32.9375 C 140.738281 32.863281 140.738281 32.789062 140.738281 32.710938 C 140.835938 32.695312 140.835938 32.695312 140.9375 32.679688 C 141.515625 32.566406 141.867188 32.441406 142.3125 32.035156 C 142.386719 32.035156 142.460938 32.035156 142.539062 32.035156 C 142.71875 31.621094 142.8125 31.238281 142.875 30.792969 C 142.949219 30.792969 143.023438 30.792969 143.101562 30.792969 C 143.101562 30.421875 143.101562 30.050781 143.101562 29.664062 C 143.027344 29.664062 142.953125 29.664062 142.875 29.664062 C 142.832031 29.546875 142.792969 29.425781 142.75 29.300781 C 142.492188 28.699219 142.03125 28.503906 141.460938 28.234375 C 141.140625 28.113281 140.851562 28.027344 140.511719 27.972656 C 140.511719 27.898438 140.511719 27.824219 140.511719 27.75 C 140.425781 27.726562 140.335938 27.703125 140.246094 27.683594 C 139.160156 27.414062 139.160156 27.414062 138.71875 27.28125 C 138.417969 27.195312 138.121094 27.128906 137.8125 27.070312 C 137.8125 26.996094 137.8125 26.921875 137.8125 26.847656 C 137.550781 26.808594 137.292969 26.773438 137.023438 26.734375 C 137.023438 26.660156 137.023438 26.585938 137.023438 26.507812 C 136.9375 26.511719 136.847656 26.515625 136.757812 26.523438 C 136.460938 26.507812 136.460938 26.507812 136.238281 26.28125 C 136.003906 26.210938 136.003906 26.210938 135.789062 26.167969 C 135.789062 26.09375 135.789062 26.019531 135.789062 25.945312 C 135.398438 25.886719 135.398438 25.886719 135 25.832031 C 135 25.757812 135 25.683594 135 25.605469 C 134.851562 25.566406 134.703125 25.53125 134.550781 25.492188 C 134.550781 25.417969 134.550781 25.34375 134.550781 25.265625 C 134.4375 25.265625 134.328125 25.265625 134.210938 25.265625 C 134.210938 25.191406 134.210938 25.117188 134.210938 25.042969 C 134.144531 25.03125 134.078125 25.023438 134.007812 25.011719 C 133.6875 24.902344 133.613281 24.757812 133.425781 24.476562 C 133.34375 24.378906 133.261719 24.28125 133.179688 24.179688 C 132.976562 23.914062 132.976562 23.914062 132.976562 23.6875 C 132.902344 23.6875 132.828125 23.6875 132.75 23.6875 C 132.496094 23.082031 132.371094 22.648438 132.414062 21.996094 C 132.339844 21.996094 132.265625 21.996094 132.1875 21.996094 C 132.183594 21.695312 132.183594 21.398438 132.179688 21.101562 C 132.179688 21.015625 132.179688 20.929688 132.175781 20.84375 C 132.175781 20.625 132.179688 20.40625 132.1875 20.191406 C 132.242188 20.136719 132.242188 20.136719 132.300781 20.078125 C 132.324219 19.90625 132.347656 19.734375 132.363281 19.5625 C 132.371094 19.46875 132.382812 19.378906 132.390625 19.28125 C 132.398438 19.210938 132.40625 19.136719 132.414062 19.0625 C 132.488281 19.0625 132.5625 19.0625 132.636719 19.0625 C 132.675781 18.765625 132.710938 18.46875 132.75 18.160156 C 132.824219 18.160156 132.898438 18.160156 132.976562 18.160156 C 132.976562 18.066406 132.976562 17.96875 132.976562 17.871094 C 133.121094 17.371094 133.367188 17.195312 133.761719 16.875 C 133.988281 16.703125 133.988281 16.703125 134.171875 16.5 C 134.324219 16.355469 134.324219 16.355469 134.550781 16.355469 C 134.550781 16.28125 134.550781 16.207031 134.550781 16.128906 C 134.660156 16.09375 134.773438 16.054688 134.886719 16.015625 C 134.925781 15.941406 134.960938 15.867188 135 15.792969 C 135.261719 15.679688 135.261719 15.679688 135.589844 15.566406 C 136.0625 15.402344 136.0625 15.402344 136.527344 15.214844 C 136.804688 15.113281 136.996094 15.089844 137.285156 15.101562 C 137.421875 15.105469 137.558594 15.109375 137.699219 15.113281 C 137.699219 15.039062 137.699219 14.964844 137.699219 14.890625 Z M 137.699219 14.890625 "/>
						<path style=" stroke:none;fill-rule:nonzero;fill:rgb(100%,100%,100%);fill-opacity:1;" d="M 193.949219 9.585938 C 194.246094 9.585938 194.546875 9.582031 194.84375 9.582031 C 194.929688 9.578125 195.011719 9.578125 195.101562 9.578125 C 195.316406 9.578125 195.535156 9.582031 195.75 9.585938 C 195.863281 9.699219 195.863281 9.699219 195.875 9.914062 C 195.875 10.007812 195.875 10.101562 195.875 10.199219 C 195.875 10.359375 195.875 10.359375 195.875 10.523438 C 195.875 10.636719 195.875 10.753906 195.875 10.871094 C 195.875 10.988281 195.875 11.105469 195.871094 11.226562 C 195.871094 11.605469 195.871094 11.980469 195.871094 12.359375 C 195.867188 12.613281 195.867188 12.867188 195.867188 13.125 C 195.867188 13.75 195.863281 14.375 195.863281 15.003906 C 195.929688 15.003906 195.996094 15.003906 196.066406 15.003906 C 196.765625 15.019531 197.464844 15.03125 198.164062 15.042969 C 198.425781 15.050781 198.6875 15.054688 198.945312 15.058594 C 199.320312 15.066406 199.695312 15.070312 200.070312 15.078125 C 200.1875 15.082031 200.304688 15.082031 200.425781 15.085938 C 200.535156 15.085938 200.644531 15.089844 200.753906 15.09375 C 200.851562 15.09375 200.945312 15.09375 201.042969 15.097656 C 201.261719 15.113281 201.261719 15.113281 201.375 15.226562 C 201.386719 15.453125 201.386719 15.679688 201.386719 15.90625 C 201.386719 16.027344 201.386719 16.152344 201.386719 16.277344 C 201.382812 16.4375 201.382812 16.59375 201.382812 16.757812 C 201.378906 17.257812 201.378906 17.757812 201.375 18.273438 C 199.59375 18.308594 197.8125 18.347656 195.976562 18.386719 C 195.839844 18.65625 195.847656 18.820312 195.847656 19.121094 C 195.847656 19.230469 195.84375 19.335938 195.84375 19.449219 C 195.84375 19.566406 195.84375 19.683594 195.84375 19.808594 C 195.84375 19.929688 195.84375 20.054688 195.84375 20.183594 C 195.839844 20.597656 195.839844 21.011719 195.839844 21.421875 C 195.839844 21.710938 195.839844 21.996094 195.835938 22.28125 C 195.835938 22.804688 195.835938 23.332031 195.835938 23.855469 C 195.835938 24.625 195.832031 25.398438 195.828125 26.167969 C 195.828125 26.835938 195.828125 27.503906 195.824219 28.171875 C 195.824219 28.457031 195.824219 28.742188 195.824219 29.023438 C 195.820312 29.421875 195.820312 29.820312 195.824219 30.21875 C 195.820312 30.335938 195.820312 30.453125 195.820312 30.574219 C 195.824219 31.191406 195.871094 31.605469 196.199219 32.148438 C 196.199219 32.222656 196.199219 32.296875 196.199219 32.375 C 196.273438 32.375 196.347656 32.375 196.425781 32.375 C 196.425781 32.449219 196.425781 32.523438 196.425781 32.597656 C 198.25 32.6875 198.25 32.6875 199.914062 32.035156 C 200.140625 32.011719 200.140625 32.011719 200.382812 32.019531 C 200.523438 32.023438 200.667969 32.03125 200.8125 32.035156 C 200.921875 32.253906 201.03125 32.472656 201.140625 32.695312 C 201.242188 32.894531 201.347656 33.09375 201.460938 33.289062 C 201.621094 33.667969 201.667969 33.882812 201.601562 34.289062 C 201.339844 34.613281 201.339844 34.613281 201.039062 34.855469 C 200.925781 34.855469 200.816406 34.855469 200.699219 34.855469 C 200.699219 34.929688 200.699219 35.003906 200.699219 35.082031 C 199.308594 35.792969 199.308594 35.792969 198.675781 35.757812 C 198.675781 35.832031 198.675781 35.90625 198.675781 35.984375 C 197.859375 36.179688 197.085938 36.242188 196.25 36.238281 C 196.140625 36.238281 196.03125 36.238281 195.917969 36.238281 C 195.140625 36.238281 194.34375 36.214844 193.660156 35.8125 C 193.5 35.644531 193.5 35.644531 193.5 35.417969 C 193.3125 35.382812 193.128906 35.34375 192.9375 35.304688 C 192.9375 35.230469 192.9375 35.15625 192.9375 35.082031 C 192.824219 35.042969 192.714844 35.003906 192.601562 34.96875 C 191.640625 33.792969 191.570312 32.449219 191.5625 31 C 191.5625 30.863281 191.5625 30.726562 191.5625 30.585938 C 191.558594 30.214844 191.554688 29.839844 191.554688 29.46875 C 191.550781 29.078125 191.546875 28.6875 191.542969 28.300781 C 191.539062 27.5625 191.535156 26.824219 191.527344 26.085938 C 191.523438 25.246094 191.515625 24.40625 191.511719 23.566406 C 191.5 21.839844 191.488281 20.113281 191.476562 18.386719 C 190.210938 18.347656 188.949219 18.3125 187.648438 18.273438 C 187.648438 17.34375 187.648438 16.414062 187.648438 15.453125 C 189.050781 15.347656 189.050781 15.347656 189.492188 15.316406 C 189.605469 15.304688 189.71875 15.296875 189.835938 15.289062 C 189.953125 15.277344 190.070312 15.269531 190.191406 15.261719 C 190.457031 15.257812 190.457031 15.257812 190.574219 15.113281 C 190.871094 15.113281 191.167969 15.113281 191.476562 15.113281 C 191.511719 13.476562 191.550781 11.839844 191.585938 10.152344 C 191.921875 10.152344 192.253906 10.152344 192.601562 10.152344 C 192.601562 10.078125 192.601562 10.003906 192.601562 9.925781 C 193.269531 9.871094 193.269531 9.871094 193.949219 9.8125 C 193.949219 9.738281 193.949219 9.664062 193.949219 9.585938 Z M 193.949219 9.585938 "/>
						</g>
						</svg>
				</a>
			</div>
		`;
		
		logoDiv.style.cssText = `
			position: fixed;
			top: 0;
			left: 0;
			right: 0;
			z-index: 9999;
			background: rgba(0,0,0,0.9);
		`;
		
		loaderContainer.insertBefore(logoDiv, loaderContainer.firstChild);
	}

	// cleanup to prevent overlap
	window.addEventListener('load', function() {
		setTimeout(() => {
			const loaderLogo = document.getElementById('loader-logo');
			if (loaderLogo) {
				loaderLogo.style.transition = 'opacity 0.2s';
				loaderLogo.style.opacity = '0';
				setTimeout(() => loaderLogo.remove(), 200);
			}
			
			const loaderElement = document.getElementById('divErrorScreen');
			if (loaderElement && loaderElement.parentNode) {
				loaderElement.parentNode.removeChild(loaderElement);
			}
			const mainContent = document.getElementById('mainContent');
			if (mainContent) {
				mainContent.style.display = 'block';
			}
		}, 50);
	});

})();