CaseData[26] = {
    "title": "Case 26 - 54 year old for axillary node biopsy", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "\nYou must become adept at the differential diagnosis of hypotension under anesthesia. Anaphylactic reaction or, as in this case, anaphylactoid reaction must be suspected in any patient with refractory hypotension. Other signs of anaphylactic (or anaphylactoid) reaction exhibited in this patient include tachycardia, bronchospasm, hypoxia, periorbital edema and cutaneous flushing.\n\nYou must treat aggressively by securing the airway, ventilating with 100% oxygen, rapid administration of intravenous fluids, and appropriate boluses of epinephrine.\n\n", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": true, 
    "imageSet": 5, 
    "initialSat": 96, 
    "leanBodyMass": 66, 
    "learningObj": "\n54 year old for axillary node biopsy (66 kg)\n\nThis patient has a mild history of chronic lung disease. She also has allergies to penicillin and cephazolin.  Note that vancomycin was administered over a very short period of time in this busy ambulatory surgery unit.\n\nLearning Objectives\n1.  List the characteristic features of vancomycin reaction and anaphylaxis.\n2.  Describe the management of vancomycin reaction.\n\nCharacteristics of Vancomycin Reaction\n1.  \"Red man syndrome\", intense erythematous rash of the head, neck and ears, is the most common toxicity of vancomycin therapy.\n2.  Hypotension\n3.  Pruritis\n4.  Reaction is not immunologically mediated\n\nCharacteristics of Anaphylaxis\n1.  Bright red skin rash - 'brick red', often over entire body\n2.  Urticaria\n3.  Wheezing/dyspnea\n4.  Facial swelling and upper airway swelling\n5.  Hypotension\n6.  Reaction is immunologically mediated\n\nPathophysiology of Vancomycin Reaction\n1.  Vancomycin produces anaphylactoid reactions including hypotension, wheezing, dyspnea, urticaria, and pruritis.\n2.  There is characteristic flushing of the upper body - so called Red Man Syndrome (RMS).\n3.  The reaction is caused by histamine release with its resultant vasodilation and increased capillary permeability.\n4.  The rate of the infusion when administering vancomycin is the important determinant of Red Man Syndrome in susceptible cases. Diphenhydramine pretreatment may help especially in patients with previous reactions.\n\nManagement of Vancomycin Reaction\n1.  Stop vancomycin infusion\n2.  Fluids\n3.  Vasopressors\n4.  Diphenhydramine\n5.  If epinephrine is needed to support the circulation, administer it by small bolus doses (5-10 mcg) or continuous infusion so that it can be titrated to effect and undesirable chronotropic or vasoconstrictor effects can be avoided.\n\nClinical Points\n1. Vancomycin should be administered over at least 30-60 minutes, never faster, and never as a bolus. The manufacturer recommends 10 mg/min or an infusion time of at least 60 min for 1 gram. \n2. Concentrations of no more than 5 mg/cc are recommended. \n3. Reactions may occur even with dilute, slow infusion.\n\nReferences\n1.  Wallace: Red man syndrome - incidence, etiology and prophylaxis. J Infect Dis 1991; 164: 1180-1185 \n2.  Valero: Adverse reactions to vancomycin.  J Cardiothor Vasc Anesth 1991; 5: 574-576\n3.  Healy: Vancomycin-induced histamine release and red man syndrome. Antimicrob Agents Chemother 1990; 34: 550-554\n4.  Levy: Histamine release by vancomycin: a mechanism for hypotension in man. Anesthesiology 1987; 67: 122-5\n5. Levy: ASA Refresher Lecture 2023:101.\n\nCase author: Howard A. Schwid, M.D.\nAffiliation: Department of Anesthesiology, University of Washington \nDate of Last Modification: September, 2024\n\n", 
    "possiblePoints": 1400, 
    "preopMsg": "\n54 year old female for axillary node biopsy\n\nHistory of Present Illness\nThe patient has lymphadenopathy and requires axillary node biopsy. The patient is scheduled as an outpatient.\nNote - Vancomycin 1 gram was administered in 5 minutes as the patient was brought to the operating room.\n\nPast Medical History\nIllnesses - moderate chronic lung disease\nSurgeries - inguinal hernia repair\nMeds - albuterol inhaler\nAllergies - penicillin and cephazolin\nHabits - smokes and drinks\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nMiddle-aged female, normal body habitus\nWeight: 66 kg\nHR 82,  BP 106/60,  RR 20,  T 36.8\nAirway - normal\nLungs - clear\nHeart - normal\n\nLabs\nHematocrit 42,  WBC 16.2\n\nNPO Status\nLast ate 8 hours ago. \n\nPatient and Surgeon Requests\nThe patient refuses regional anesthesia and the surgeon states the procedure will take 1 hour. \n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "VANCO1", 
            "whatNextMsg": "Examine the patient, review the history, and make the diagnosis.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 50, 
            "baseAbpS": 68, 
            "baseBicarb": 22, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There are a few scattered wheezes present.", 
            "cardiacOutput": 3, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 7, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate with murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a feeling of impending doom.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 8, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is rapid and weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Vancomycin reaction - early.", 
            "rhythm": "Sinus1", 
            "skinMsg": "There is a red rash spreading up the arm from the IV site.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 94, 
            "sat40": 96, 
            "sat100": 98, 
            "spSignal": 1, 
            "spontRr": 26, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEP", 
                    "comment": "You sedated the patient appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered a bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VANCO1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH3", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VANCO2", 
                    "comment": "You need to secure the airway, administer fluids and epinephrine faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "VANCO1", 
                    "comment": "You cannot place the LMA in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "VANCO1", 
                    "comment": "You cannot place an endotracheal tube in a conscious, unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "VANCO2", 
                    "comment": "The simulation forced the patient to become more tachycardic and hypotensive. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VANCO2", 
            "whatNextMsg": "Examine the patient, review the history quickly! Aggressively treat the problem.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 45, 
            "baseAbpM": 47, 
            "baseAbpS": 52, 
            "baseBicarb": 22, 
            "baseHr": 134, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There are scattered wheezes present.", 
            "cardiacOutput": 2.4, 
            "contPip": 46, 
            "contPlateau": 44, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid rate.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and thready.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Vancomycin reaction - late.", 
            "rhythm": "Sinus1", 
            "skinMsg": "There is a red rash spreading up the arm from the IV site.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "V2LMA", 
                    "comment": "You should secure the airway with an endotracheal tube. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "You secured the airway with an endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VANCO3", 
                    "comment": "The simulation forced the patient to become even more tachycardic and hypotensive. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered a bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VANCO2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH3", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "V2LMA", 
            "whatNextMsg": "Correct the airway immediately. Remove the LMA and place an endotracheal tube.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 48, 
            "baseAbpS": 58, 
            "baseBicarb": 22, 
            "baseHr": 130, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There are scattered wheezes present.", 
            "cardiacOutput": 2.4, 
            "contPip": 52, 
            "contPlateau": 54, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Rapid heart rate.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 7, 
            "papS": 12, 
            "papW": 4, 
            "pulseMsg": "The pulse is rapid and thready.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Vancomycin reaction. LMA in place but obstructed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "There is a red rash spreading up the arm from the IV site.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWSECURED", 
                    "comment": "You replaced the LMA with an endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HARDVENT", 
                    "comment": "You waited too long to replace the LMA with ETT. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered a bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "V2LMA", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH3", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VANCO3", 
            "whatNextMsg": "Severe refractory hypotension. Notice that the vancomycin was administered in 5 minutes. Secure the airway, administer fluids and epinephrine immediately.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 38, 
            "baseAbpS": 42, 
            "baseBicarb": 22, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Vancomycin reaction - late.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 86, 
            "sat100": 90, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "VANCO4", 
                    "comment": "You should have placed an endotracheal tube in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "The airway is secured with an endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VANCO3", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "V3LMA", 
            "whatNextMsg": "Correct the airway. Remove the LMA and place an endotracheal tube.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 38, 
            "baseAbpS": 42, 
            "baseBicarb": 20, 
            "baseHr": 134, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 36, 
            "contPlateau": 34, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Vancomycin reaction. LMA in place but obstructed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWSECURED", 
                    "comment": "You replaced the LMA with an ETT. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HARDVENT", 
                    "comment": "You waited too long to replace the LMA with ETT. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway sooner. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "VANCO4", 
            "whatNextMsg": "Severe vancomycin reaction. Secure the airway with an endotracheal tube, ventilate with oxygen, administer epinephrine and fluids.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 32, 
            "baseAbpM": 34, 
            "baseAbpS": 40, 
            "baseBicarb": 20, 
            "baseHr": 130, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 54, 
            "contPlateau": 56, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Vancomycin reaction - too late.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 80, 
            "sat40": 85, 
            "sat100": 88, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You should have placed an endotracheal tube in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "The airway is secured with an endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VANCO4", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "HARDVENT", 
            "whatNextMsg": "You should have secured the airway with an endotracheal much faster. You will now find it difficult to ventilate the patient. The patient will arrest soon. Try this case again.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 26, 
            "baseAbpM": 32, 
            "baseAbpS": 48, 
            "baseBicarb": 18, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 68, 
            "contPlateau": 66, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient has become pulseless and difficult to ventilate.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now ashen gray", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 70, 
            "sat40": 76, 
            "sat100": 80, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "The patient became severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 40
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ASLEEP", 
            "whatNextMsg": "Secure the airway with an endotracheal tube immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 48, 
            "baseAbpS": 66, 
            "baseBicarb": 20, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 3.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPFLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPEP1", 
                    "comment": "You administered a bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEP", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH3", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ASLEEPEP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VANCO2", 
                    "comment": "You need to administer epinephrine and fluids, sedate and secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPEP1", 
            "whatNextMsg": "Place the endotracheal tube immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 48, 
            "baseAbpS": 60, 
            "baseBicarb": 24, 
            "baseHr": 128, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 3.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized. Epinephrine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWEP1", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWEP1", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPEP1FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VTACH3", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
               {
                    "nextState": "VANCO2", 
                    "comment": "You secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP1", 
            "whatNextMsg": "Secure the airway as soon as possible.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 52, 
            "baseAbpS": 72, 
            "baseBicarb": 20, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is moving spontaneously.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 1, 
            "spontRr": 14, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPEP1", 
                    "comment": "You sedated the patient appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VTACH3", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "VANCO3", 
                    "comment": "You need to secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You cannot place the LMA in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You cannot place an endotracheal tube in a conscious, unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "VANCO2", 
                    "comment": "The simulation forced the patient to become more tachycardic and hypotensive. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPFLUID1", 
            "whatNextMsg": "Place the endotracheal tube as soon as possible.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 40, 
            "baseAbpM": 48, 
            "baseAbpS": 60, 
            "baseBicarb": 20, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized. Fluid bolus administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWFLUID1", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWFLUID1", 
                    "comment": "An endotracheal tube was successfully placed. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "ASLEEPFLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH4", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 500
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "VANCO3", 
                    "comment": "You need to administer epinephrine and fluids, sedate and secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "FLUID1", 
            "whatNextMsg": "Secure the airway as soon as possible.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 42, 
            "baseAbpM": 52, 
            "baseAbpS": 72, 
            "baseBicarb": 20, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 3, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is moving spontaneously.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The first fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 92, 
            "sat100": 94, 
            "spSignal": 1, 
            "spontRr": 16, 
            "spontTv": 120, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPFLUID1", 
                    "comment": "You sedated the patient appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "VANCO3", 
                    "comment": "You need to administer epinephrine and fluids, sedate and secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You cannot place the LMA in an unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You cannot place an endotracheal tube in a conscious, unanesthetized patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (-500 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 199
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPEP1FLUID1", 
            "whatNextMsg": "Secure the airway with an endotracheal tube as soon as possible.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 70, 
            "baseBicarb": 20, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 4.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 8, 
            "papS": 14, 
            "papW": 6, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized. Epinephrine and fluids administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 88, 
            "sat100": 90, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWEP1FLUID1", 
                    "comment": "You successfully placed the endotracheal tube. (+200 points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": true
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 90
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWSECURED", 
            "whatNextMsg": "Examine the patient and make the diagnosis.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is not palpable.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The airway is secured but the patient has become pulseless.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 80, 
            "sat40": 86, 
            "sat100": 88, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer fluids and epinephrine faster. (-400 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "AWFLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWEP1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWSECURED", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "AWEP1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWEP1", 
            "whatNextMsg": "Now administer a 1000 mL bolus of intravenous fluids.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 52, 
            "baseAbpS": 62, 
            "baseBicarb": 20, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 84, 
            "sat40": 88, 
            "sat100": 90, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "You administered a second bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWEP1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 400
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP2", 
            "whatNextMsg": "Administer a bolus of fluids immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 56, 
            "baseAbpS": 72, 
            "baseBicarb": 20, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Second dose of epinephrine administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You administered a bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2", 
                    "comment": "You need to administer intravenous fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 400
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWFLUID1", 
            "whatNextMsg": "Now administer an epinephrine bolus.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 46, 
            "baseAbpM": 52, 
            "baseAbpS": 62, 
            "baseBicarb": 20, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 3, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 6, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 4, 
            "papM": 8, 
            "papS": 14, 
            "papW": 4, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The first fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 86, 
            "sat100": 88, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to administer epinephrine and fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "FLUID2", 
                    "comment": "You administered a second bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "AWFLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP1FLUID1", 
            "whatNextMsg": "Administer additional epinephrine and IV fluids.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 50, 
            "baseAbpM": 58, 
            "baseAbpS": 72, 
            "baseBicarb": 20, 
            "baseHr": 122, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is thready.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine and fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 86, 
            "sat40": 88, 
            "sat100": 90, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "You administered a second bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You administered a second bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1FLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 400
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP2FLUID1", 
            "whatNextMsg": "Administer additional epinephrine and IV fluids.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 62, 
            "baseAbpS": 82, 
            "baseBicarb": 20, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Second dose of epinephrine and first bolus of intravenous fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 240
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP2FLUID2", 
                    "comment": "You administered a second bolus of intravenous fluid appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "tFluid", 
                            "value": 1999
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You need to administer intravenous fluids faster. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP2FLUID1", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 400
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "FLUID2", 
            "whatNextMsg": "Administer additional epinephrine and IV fluids.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 62, 
            "baseAbpS": 72, 
            "baseBicarb": 20, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 4, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 9, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The second fluid bolus was administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 82, 
            "sat40": 84, 
            "sat100": 87, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "You administered an appropriate bolus of epinephrine. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "FLUID2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 5
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH1", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP1FLUID2", 
            "whatNextMsg": "Administer additional epinephrine and IV fluids.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 58, 
            "baseAbpM": 68, 
            "baseAbpS": 82, 
            "baseBicarb": 20, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is moderate wheezing throughout.", 
            "cardiacOutput": 3.2, 
            "contPip": 38, 
            "contPlateau": 36, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 5, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "First dose of epinephrine and second bolus of fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 88, 
            "sat40": 90, 
            "sat100": 92, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You need to secure the airway faster. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "EP2FLUID2", 
                    "comment": "You administered a second bolus of epinephrine appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 4
                        }, 
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 11
                        }
                    ], 
                    "points": 200
                }, 
                {
                    "nextState": "EP1FLUID2", 
                    "comment": "You administered an inadequate bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 400
                        }
                    ], 
                    "points": -200
                }, 
                 {
                    "nextState": "EP2FLUID2", 
                    "comment": "Recommended bolus of epinephrine for anaphylaxis is 5-10 mcg. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 10
                        }
                    ], 
                    "points": -100
                }, 
               {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "EP2FLUID2", 
            "whatNextMsg": "Administer diphenhydramine and albuterol.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 74, 
            "baseAbpS": 92, 
            "baseBicarb": 20, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Second bolus of epinephrine and intravenous fluid administered.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "HARDVENT", 
                    "comment": "You maintain a secure airway until stable. (Lost points)", 
                    "conditions": [
                        {
                            "type": "airwayTube", 
                            "value": false
                        } 
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "STABLE", 
                    "comment": "You administered diphenhydramine and albuterol appropriately. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Diphenhydramine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 49
                        }, 
                        {
                            "drug": "Albuterol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1
                        }
                    ], 
                    "points": 200
                }, 
                 {
                    "nextState": "STABLE", 
                    "comment": "You should have administered diphenhydramine and albuterol. (Lost points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -500
                }, 
               {
                    "nextState": "EP2FLUID2", 
                    "comment": "You administered an inadequate dose of diphenhydramine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Diphenhydramine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "VTACH2", 
                    "comment": "You administered an excessive bolus of epinephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 400
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "V3LMA", 
                    "comment": "You should have placed an endotracheal tube, not an LMA, in this unstable patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "airwayLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "STABLE", 
            "whatNextMsg": "You successfully resuscitated from vancomycin reaction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 64, 
            "baseAbpM": 74, 
            "baseAbpS": 92, 
            "baseBicarb": 20, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is mild wheezing throughout.", 
            "cardiacOutput": 4, 
            "contPip": 34, 
            "contPlateau": 32, 
            "cvp": 8, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are present.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 6, 
            "papM": 10, 
            "papS": 16, 
            "papW": 6, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small. There is periorbital edema.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient is stable.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The red rash is now mottled.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }, 
        {
            "name": "VTACH1", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWEP1", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "AWEP1", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "VTACH2", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "EP1", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "VTACH3", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "EP1", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "EP1", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "VTACH4", 
            "whatNextMsg": "Pulseless ventricular tachycardia should be treated the same as V Fib - defibrillate.", 
			"airwayStr": "restricted",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 36, 
            "baseAbpM": 42, 
            "baseAbpS": 52, 
            "baseBicarb": 20, 
            "baseHr": 142, 
            "basePot": 4.2, 
            "breathSoundsMsg": "There is severe wheezing throughout.", 
            "cardiacOutput": 2.2, 
            "contPip": 48, 
            "contPlateau": 46, 
            "cvp": 4, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are distant.", 
            "hiCo2ProdFlag": true, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent. There is periorbital edema.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 2, 
            "papM": 5, 
            "papS": 10, 
            "papW": 2, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive dose of epinephrine administered.", 
            "rhythm": "Vtach3", 
            "skinMsg": "The red rash is now mottled and purple.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 96, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FLUID1", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "FLUID1", 
                    "comment": "You defibrillated for pulseless v tach appropriately. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "defib", 
                            "value": 199
                        }
                    ], 
                    "points": 100
                }
            ]
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 16, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 16, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 16, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATDEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATDEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 16, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated. End of case simulation.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9
        }
    ]
}