CaseData[45] = {
    "title": "Case 104 - 57 year old for incarcerated inguinal hernia repair", 
    "badDrugs": ["Dantrolene"], 
    "coMin": 1.2, 
    "debriefMsg": "myocardial ischemia based on case 7", 
    "depthCarina": 25, 
    "depthCords": 18, 
    "depthTubeInitial": 22, 
    "durationPrep": 60, 
    "durationSurgery": 1200, 
    "helpFlag": false, 
    "imageSet": 4, 
    "initialSat": 96, 
    "leanBodyMass": 78, 
    "learningObj": "", 
    "possiblePoints": 1200, 
    "preopMsg": "\n57 year old for inguinal hernia repair\n\nHistory of Present Illness\nThe patient has an incarcerated inguinal hernia.\n\nPast Medical History\nInferoposterior myocardial infarction 8 months ago. Now has occasional angina. Dipyridamole-thallium scan shows two reversible defects. \nPatient refuses cardiac catheterization.\nSurgeries - none\nMeds - atenolol, diltiazem, nitroglycerin\nAllergies - penicillin\nHabits - smokes 2 packs/day for 50 years\n\nFamily History\nNo anesthetic complications\n\nPhysical Exam\nWeight: 82kg\nHR 64,  BP 140/86,  RR 18\nAirway - normal\nLungs - scattered rhonchi\nHeart - S4, no murmurs\n\nLabs\nHematocrit 38 \nBUN 24,     Cr 1.3\nECG - sinus rhythm, old inferior myocardial infarction\n\nNPO Status\nThe patient last ate 13 hours ago.\n\nPatient and Surgeon Requests\nThe surgery is scheduled to last for 3 hours.\n\n\n", 
    "volAnDsp": 80, 
    "states": [
        {
            "name": "AWAKE", 
            "whatNextMsg": "Sedate, preoxygenate and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 86, 
            "baseAbpM": 100, 
            "baseAbpS": 132, 
            "baseBicarb": 23.8, 
            "baseHr": 88, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 8, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 48, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 10, 
            "papM": 14, 
            "papS": 22, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and rapid.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake, alert, and anxiously awaiting induction.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry but has slow capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 93, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 16, 
            "spontTv": 370, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": 0.1, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "You administered a sedative agent. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to place the LMA in an unsedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKECOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in an unsedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in an unsedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "AWAKEPARA", 
                    "comment": "You should not have paralyzed an unsedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKECOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 104, 
            "baseAbpS": 160, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is upset and uncooperative. The patient is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong and fast.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Upset and coughing.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 18, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEHURT", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 132, 
            "baseAbpS": 200, 
            "baseBicarb": 24, 
            "baseHr": 124, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is screaming but the breath sounds seem to be clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is screaming and writhing in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is bounding.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Screaming and writhing in pain.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 92, 
            "sat100": 98, 
            "spSignal": 3, 
            "spontRr": 20, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": 0.3, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The patient stopped screaming.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "AWAKEPARA", 
            "whatNextMsg": "Call your lawyer.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 100, 
            "baseAbpM": 124, 
            "baseAbpS": 180, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is not moving, but is thinking about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Awake but paralyzed.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": 0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "AWAKE", 
                    "comment": "The muscle relaxant is wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "You sedated this patient after you administered muscle relaxant. ", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.1
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATED", 
            "whatNextMsg": "Continue induction.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 14, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": 0.1, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "You administered an appropriate dose of propofol. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 119
                        }, 
                        {
                            "drug": "Propofol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "XSINDUCTION", 
                    "comment": "You administered an excessive dose of propofol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Propofol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "Consider not using etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 11
                        }, 
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 25
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "XSINDUCTION", 
                    "comment": "You administered an excessive dose of etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "SEDATED", 
                    "comment": "You administered an inadequate dose of etomidate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Etomidate", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 12
                        }
                    ], 
                    "points": -400
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "You administered enough intravenous agent to induce anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.4
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPBREATHE", 
                    "comment": "You administered enough inhalation agent to induce anesthesia. (+100 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.8
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.3
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "SEDATEDCOUGH", 
                    "comment": "You should not have tried to place the LMA in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLma", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDCOUGH", 
                    "comment": "You should not have tried to place the endotracheal tube in a lightly sedated patient. (Lost points)", 
                    "conditions": [
                        {
                            "type": "tryLaryTube", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDHURT", 
                    "comment": "You should not have allowed the surgeon to make an incision in a lightly sedated patient. (-500 points)", 
                    "conditions": [
                        {
                            "type": "makeIncision", 
                            "value": true
                        }
                    ], 
                    "points": -500
                }, 
                {
                    "nextState": "SEDATEDPARA", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": -500
                }
            ]
        }, 
        {
            "name": "SEDATEDCOUGH", 
            "whatNextMsg": "Wait for the patient to settle down and induce anesthesia.", 
			"airwayStr": "obstructed",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 84, 
            "baseAbpM": 102, 
            "baseAbpS": 154, 
            "baseBicarb": 24, 
            "baseHr": 104, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is coughing.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice, but is coughing.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated and coughing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 230, 
            "sputumAmount": 0, 
            "stSegII": -0.1, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "The patient stopped coughing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDHURT", 
            "whatNextMsg": "Induce anesthesia immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 90, 
            "baseAbpM": 126, 
            "baseAbpS": 196, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The patient is moaning, but the breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is moaning in pain.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Moaning in pain.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 24, 
            "spontTv": 210, 
            "sputumAmount": 0, 
            "stSegII": 0.3, 
            "stSegV5": 0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "The patient stopped moaning.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "SEDATEDPARA", 
            "whatNextMsg": "Induce anesthesia immediately.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 96, 
            "baseAbpM": 116, 
            "baseAbpS": 176, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is dreaming about calling his lawyer.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated but paralyzed.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0.2, 
            "stSegV5": 0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "SEDATED", 
                    "comment": "The neuromuscular blocker started wearing off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "You administered sedative agent to this paralyzed patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPAPNEA", 
            "whatNextMsg": "Secure the airway, ensure adequate anesthesia and instruct the surgeon to operate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 76, 
            "baseAbpM": 90, 
            "baseAbpS": 118, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized mainly with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPAPNEA", 
                    "comment": "The surgeon is operating. (+100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPBREATHE", 
                    "comment": "The intravenous agent(s) are starting to wear off.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ASLEEPBREATHE", 
            "whatNextMsg": "Secure the airway, ensure adequate anesthesia and instruct the surgeon to operate.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 68, 
            "baseAbpS": 88, 
            "baseBicarb": 24, 
            "baseHr": 92, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized mainly with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 80, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "OPBREATHE", 
                    "comment": "The surgeon is operating. (+100 points)", 
                    "conditions": [
                        {
                            "type": "doingSurgery", 
                            "value": true
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSINDUCTION", 
            "whatNextMsg": "Secure the airway and administer pressors.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 64, 
            "baseAbpS": 76, 
            "baseBicarb": 23.8, 
            "baseHr": 98, 
            "basePot": 4.8, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 5, 
            "finalState": 0, 
            "glucose": 120, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 6, 
            "papM": 9, 
            "papS": 15, 
            "papW": 5, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive induction agent administered.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 144, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ASLEEPAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "OPAPNEA", 
            "whatNextMsg": "Maintain appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 134, 
            "baseBicarb": 24, 
            "baseHr": 98, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, no spontaneous breathing.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.2, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TACHYAPNEA", 
                    "comment": "The heart rate is increasing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 10
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "OPBREATHE", 
            "whatNextMsg": "Maintain appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 70, 
            "baseAbpM": 86, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 102, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, does breathe spontaneously.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 80, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "TACHYBREATHE", 
                    "comment": "The heart rate is increasing.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 10
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "OPAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TACHYAPNEA", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 92, 
            "baseAbpM": 116, 
            "baseAbpS": 144, 
            "baseBicarb": 24, 
            "baseHr": 108, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, tachycardic, no spontaneous ventilation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST1APNEA", 
                    "comment": "The blood pressure is falling.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "TACHYBREATHE", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 92, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 12, 
            "papM": 16, 
            "papS": 28, 
            "papW": 10, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, tachycardic, has spontaneous ventilation.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 80, 
            "sputumAmount": 0, 
            "stSegII": -0.3, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST1BREATHE", 
                    "comment": "The blood pressure is falling.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 60
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TACHYAPNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "TACHYAPNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA1IV", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized with intravenous agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 95, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You administered enough induction agent to adequately anesthetize this patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA1INH", 
                    "comment": "You continued to administer inhalation agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 1.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "GA1INH", 
            "whatNextMsg": "Deepen the anesthetic.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 99, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly anesthetized with inhalation agents.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 90, 
            "sat40": 94, 
            "sat100": 99, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": -0.3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1IV", 
                    "comment": "You should continue to deepen the inhalation agent.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 1.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "You administered enough inhalation agent to adequately anesthetize this patient.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "GA2IV", 
            "whatNextMsg": "Maintenance phase - monitor the patient carefully.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 66, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You administered deep anesthesia.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA1IV", 
                    "comment": "You lightened the anesthetic depth.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 1.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC1IV", 
                    "comment": "The patient is starting to recover from the inhalation anesthestic agent.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "GA2INH", 
            "whatNextMsg": "Maintenance phase - monitor the patient carefully.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 60, 
            "baseAbpM": 74, 
            "baseAbpS": 108, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Adequately anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 14, 
            "spontTv": 80, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 1.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.7
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA1INH", 
                    "comment": "You lightened the anesthetic depth.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 1.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC1INH", 
                    "comment": "The patient is starting to recover from the inhalation anesthestic agent.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA3", 
                    "comment": "You administered a deep level of anesthesia.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "GA3", 
            "whatNextMsg": "Deep maintenance anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 56, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA2IV", 
                    "comment": "You lightened the anesthetic depth.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 1.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA2INH", 
                    "comment": "You lightened the anesthetic depth.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 2.5
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 1.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA4", 
                    "comment": "You administered an excessively deep anesthetic.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 3.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "GA4", 
            "whatNextMsg": "Excessively deep anesthesia during maintenance. Decrease anesthetic depth.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 52, 
            "baseAbpM": 60, 
            "baseAbpS": 76, 
            "baseBicarb": 24, 
            "baseHr": 82, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Very deeply anesthetized.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA3", 
                    "comment": "You lightened the anesthetic depth.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 3.5
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "REC1IV", 
            "whatNextMsg": "Continue decreasing the depth of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 88, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 68, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The eyes are closed. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient responds only after mild prodding.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 36, 
            "papW": 16, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 8, 
            "spontTv": 200, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "GA1IV", 
                    "comment": "You deepened the anesthetic again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC2", 
                    "comment": "The patient is continuing to recover.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }, 
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC1INH", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.4
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "op": "LT", 
                            "type": "mic", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "REC1INH", 
            "whatNextMsg": "Continue decreasing the depth of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 72, 
            "baseAbpM": 88, 
            "baseAbpS": 126, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The eyes are closed. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient responds only after mild prodding.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Deeply sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 20, 
            "spontTv": 280, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "REC1IV", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.4
                        }, 
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.6
                        }, 
                        {
                            "op": "LT", 
                            "type": "mac", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC2", 
                    "comment": "The patient is continuing to recover.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.4
                        }, 
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "GA1INH", 
                    "comment": "You deepened the anesthetic again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "REC2", 
            "whatNextMsg": "Continue decreasing the depth of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 74, 
            "baseAbpM": 92, 
            "baseAbpS": 132, 
            "baseBicarb": 24, 
            "baseHr": 78, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The eyes are glazed. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient responds only after name is called loudly. There is prominent slowing of speech.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Moderately sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 12, 
            "spontTv": 240, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "REC3", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.3
                        }, 
                        {
                            "op": "LT", 
                            "type": "nmb", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC1INH", 
                    "comment": "You deepened the anesthetic again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.4
                        }, 
                        {
                            "op": "GT", 
                            "type": "mac", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC1IV", 
                    "comment": "You deepened the anesthetic again.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.4
                        }, 
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC1IV", 
                    "comment": "The patient is emerging from anesthesia but is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.6
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "REC3", 
            "whatNextMsg": "Continue decreasing the depth of anesthesia.", 
 			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 135, 
            "baseBicarb": 24, 
            "baseHr": 75, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "There is mild ptosis. The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient has a lethargic response to voice. The patient is moving spontaneously.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is strong.", 
            "pupilsMsg": "The eyes are glazed. The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Lightly sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 14, 
            "spontTv": 300, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "REC2", 
                    "comment": "You deepened the anesthetic.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "doa", 
                            "value": 0.3
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC2", 
                    "comment": "The patient is emerging from anesthesia but is partially paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.4
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "REC4", 
                    "comment": "The patient is continuing to emerge from anesthesia.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "doa", 
                            "value": 0.2
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic.", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "REC4", 
            "whatNextMsg": "Continue post-anesthesia recovery.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 140, 
            "baseBicarb": 24, 
            "baseHr": 80, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are clear bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 0, 
            "lidReflexMsg": "The lid reflex is present.", 
            "lmaSuccessFlag": false, 
            "mentalStatusMsg": "The patient is awake and responds to voice commands. The patient is moving spontaneously.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is strong and regular.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 5, 
            "rateUo": 1.5, 
            "recordMsg": "Minimally sedated.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 320, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9
        }, 
        {
            "name": "DESATBRADY1", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 62, 
            "baseAbpS": 92, 
            "baseBicarb": 24, 
            "baseHr": 32, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and slow.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATBRADY2", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATBRADY2", 
            "whatNextMsg": "Must reverse hypoxia immediately and treat bradycardia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 50, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 22, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Very slow, regular rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 8, 
            "papM": 12, 
            "papS": 18, 
            "papW": 8, 
            "pulseMsg": "The pulse is weak and very slow.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and severely bradycardic.", 
            "rhythm": "Sinus1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DESATASYST", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DESATASYST", 
            "whatNextMsg": "CPR, epinephrine, atropine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are large.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Hypoxic and asystolic.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic with poor capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "VFIB", 
            "whatNextMsg": "Call for help.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 46, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are pinpoint.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "Cardiac arrest!", 
            "rhythm": "Vfib2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": 0, 
            "stSegV5": 0, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "DEAD", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "DEAD", 
            "whatNextMsg": "Notify the family.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 18, 
            "baseAbpM": 18, 
            "baseAbpS": 18, 
            "baseBicarb": 24, 
            "baseHr": 0, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 0.1, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": -2, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Heart sounds are absent.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
			"overdoseFlag": false,
            "papD": 18, 
            "papM": 18, 
            "papS": 18, 
            "papW": 18, 
            "pulseMsg": "The pulse is absent.", 
            "pupilsMsg": "The pupils are fixed and dilated.", 
            "rateEbl": 0, 
            "rateUo": 1.5, 
            "recordMsg": "The patient cannot be resuscitated.", 
            "rhythm": "Asystole1", 
            "skinMsg": "The skin is cyanotic.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 60, 
            "sat40": 61, 
            "sat100": 62, 
            "spSignal": 0, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.5, 
            "stSegV5": 3, 
            "temperature": 36.9
        }, 
        {
            "name": "ST1APNEA", 
            "whatNextMsg": "Assess level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 96, 
            "baseAbpS": 124, 
            "baseBicarb": 24, 
            "baseHr": 112, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, tachycardic, no spontaneous ventilation.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.4, 
            "stSegV5": -0.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST2", 
                    "comment": "Tachycardia is worsening and blood pressure is falling.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ST1BREATHE", 
            "whatNextMsg": "Assess level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 68, 
            "baseAbpM": 86, 
            "baseAbpS": 122, 
            "baseBicarb": 24, 
            "baseHr": 114, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.6, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 14, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 18, 
            "papM": 24, 
            "papS": 32, 
            "papW": 16, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are equal, round, and react to light.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Anesthetized, tachycardic, has spontaneous ventilation.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 3, 
            "spontRr": 16, 
            "spontTv": 80, 
            "sputumAmount": 0, 
            "stSegII": -0.4, 
            "stSegV5": -0.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST2", 
                    "comment": "Tachycardia is worsening and blood pressure is falling.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ST1APNEA", 
                    "comment": "Intravenous agent(s) caused respiratory depression.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "mic", 
                            "value": 0.55
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "ST1APNEA", 
                    "comment": "The patient is paralyzed.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "nmb", 
                            "value": 0.8
                        }
                    ], 
                    "points": 0
                }, 
                {
                    "nextState": "DESATBRADY1", 
                    "comment": "You allowed the patient to become severely hypoxic. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "LT", 
                            "type": "o2Sat", 
                            "value": 63
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ST2", 
            "whatNextMsg": "Assess level of anesthesia.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 64, 
            "baseAbpS": 98, 
            "baseBicarb": 24, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 28, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Mild ST depression and T wave inversion.", 
            "rhythm": "St2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -1.4, 
            "stSegV5": -1.6, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "ST3", 
                    "comment": "Myocardial ischemia is worsening.", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 20
                        }
                    ], 
                    "points": 0
                }
            ]
        }, 
        {
            "name": "ST3", 
            "whatNextMsg": "Try phenylephrine to improve coronary perfusion pressure.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 38, 
            "baseAbpM": 54, 
            "baseAbpS": 78, 
            "baseBicarb": 24, 
            "baseHr": 126, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 26, 
            "papM": 34, 
            "papS": 48, 
            "papW": 24, 
            "pulseMsg": "The pulse is weak but present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Deep ST depression.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 1, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3.2, 
            "stSegV5": -2.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHEN", 
                    "comment": "You administered an appropriate bolus of phenylephrine. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }, 
                        {
                            "drug": "Phenylephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHEN", 
                    "comment": "You started a phenylephrine infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHEN", 
                    "comment": "You started a dopamine infusion rather than phenylephrine. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHEN", 
                    "comment": "You started a norepinephrine infusion rather than phenylephrine. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "XSPHEN", 
                    "comment": "You administered an excessive bolus of phenylephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -50
                }, 
                {
                    "nextState": "NTG", 
                    "comment": "You administered nitroglycerin before raising the perfusion pressure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.3
                        }, 
                        {
                            "drug": "Nitroglycerin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1.3
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "NTG", 
                    "comment": "You started a nitroglycerin infusion before raising the perfusion pressure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "XSNTG", 
                    "comment": "You administered an excessive bolus of nitroglycerin. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.2
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You administered a bolus of esmolol before raising the perfusion pressure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 29
                        }, 
                        {
                            "drug": "Esmolol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "ESM", 
                    "comment": "You started an esmolol infusion before raising the perfusion pressure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 49
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "XSESM", 
                    "comment": "You administered an excessive bolus of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You waited too long to treat myocardial ischemia. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PHEN", 
            "whatNextMsg": "Slow the heart rate with esmolol.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 44, 
            "baseAbpM": 60, 
            "baseAbpS": 86, 
            "baseBicarb": 24, 
            "baseHr": 120, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 26, 
            "papM": 34, 
            "papS": 48, 
            "papW": 24, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Deep ST depression with improved perfusion pressure.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3, 
            "stSegV5": -2.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an appropriate dose nitroglycerin. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.3
                        }, 
                        {
                            "drug": "Nitroglycerin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1.3
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a nitroglycerin infusion. (+200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an excessive bolus of nitroglycerin. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.2
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an appropriate bolus of esmolol. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Esmolol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started an esmolol infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 49
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an excessive bolus of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "XSPHEN", 
                    "comment": "You administered the phenylephrine infusion at an excessive rate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 3
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "XSPHEN", 
                    "comment": "You administered the dopamine infusion at an excessive rate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 15
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "XSPHEN", 
                    "comment": "You administered the norepinephrine infusion at an excessive rate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.5
                        }, 
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 300
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSPHEN", 
            "whatNextMsg": "Administer nitroglycerin and esmolol.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 54, 
            "baseAbpM": 68, 
            "baseAbpS": 94, 
            "baseBicarb": 24, 
            "baseHr": 118, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 18, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 26, 
            "papM": 34, 
            "papS": 48, 
            "papW": 24, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive pressor administered.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3, 
            "stSegV5": -2.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an appropriate dose of nitroglycerin. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.3
                        }, 
                        {
                            "drug": "Nitroglycerin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1.3
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a nitroglycerin infusion appropriately. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an excessive bolus of nitroglycerin. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.2
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an appropriate bolus of esmolol. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Esmolol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an excessive bolus of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started an esmolol infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 29
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "NTG", 
            "whatNextMsg": "Raise the perfusion pressure with phenylephrine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 32, 
            "baseAbpM": 44, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 130, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 46, 
            "papW": 22, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Deep ST depression despite administration of nitroglycerin.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3, 
            "stSegV5": -2.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an appropriate bolus of phenylephrine. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }, 
                        {
                            "drug": "Phenylephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an excessive bolus of phenylephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a phenylephrine infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a dopamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a dobutamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a epinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a norepinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "XSNTG", 
                    "comment": "You administered an excessive infusion of nitroglycerin. (-200 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 3
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You should have raised the perfusion pressure with phenylephrine before administering esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Esmolol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You administered an excessive bolus of esmolol to a hypotensive patient. (-300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You should have raised the perfusion pressure with phenylephrine before administering esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 29
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSNTG", 
            "whatNextMsg": "Raise the perfusion pressure with phenylephrine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 34, 
            "baseAbpM": 48, 
            "baseAbpS": 64, 
            "baseBicarb": 24, 
            "baseHr": 132, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 46, 
            "papW": 22, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive nitroglycerin administered.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3, 
            "stSegV5": -2.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an appropriate bolus of phenylephrine. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }, 
                        {
                            "drug": "Phenylephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You administered an excessive bolus of phenylephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a phenylephrine infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a dopamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a dobutamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a epinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTG", 
                    "comment": "You started a norepinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You should have raised the perfusion pressure with phenylephrine before administering esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 29
                        }, 
                        {
                            "drug": "Esmolol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You administered an excessive dose of esmolol to a hypotensive patient. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You should have raised the perfusion pressure with phenylephrine before administering esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 49
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "ESM", 
            "whatNextMsg": "Now increase the perfusion pressure with phenylephrine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 34, 
            "baseAbpM": 48, 
            "baseAbpS": 72, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 46, 
            "papW": 22, 
            "pulseMsg": "The pulse is weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "You slowed the heart rate with esmolol.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3, 
            "stSegV5": -2.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "NTGESM", 
                    "comment": "You administered nitroglycerin to a hypotensive patient. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.3
                        }, 
                        {
                            "drug": "Nitroglycerin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1.3
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You administered an excessive bolus of nitroglycerin to a hypotensive patient. (-300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.2
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You started a nitroglycerin infusion before raising the perfusion pressure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "XSESM", 
                    "comment": "You administered an infusion of esmolol at an excessive rate. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an appropriate bolus of phenylephrine. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }, 
                        {
                            "drug": "Phenylephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an excessive bolus of phenylephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a phenylephrine infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a dopamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a dobutamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a epinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a norepinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "XSESM", 
            "whatNextMsg": "Now increase the perfusion pressure with phenylephrine.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 32, 
            "baseAbpM": 44, 
            "baseAbpS": 62, 
            "baseBicarb": 24, 
            "baseHr": 76, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 3.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 24, 
            "papM": 32, 
            "papS": 46, 
            "papW": 22, 
            "pulseMsg": "The pulse is weak.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Excessive esmolol administered.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -3, 
            "stSegV5": -2.2, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "NTGESM", 
                    "comment": "You administered nitroglycerin to a hypotensive patient. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.3
                        }, 
                        {
                            "drug": "Nitroglycerin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1.3
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You administered an excessive bolus of nitroglycerin to a hypotensive patient. (-300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.2
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "NTGESM", 
                    "comment": "You started a nitroglycerin infusion before raising the perfusion pressure. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": -300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an appropriate bolus of phenylephrine. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }, 
                        {
                            "drug": "Phenylephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You administered an excessive bolus of phenylephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a phenylephrine infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a dopamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a dobutamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a epinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENESM", 
                    "comment": "You started a norepinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PHENNTG", 
            "whatNextMsg": "Now add esmolol.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 64, 
            "baseAbpS": 84, 
            "baseBicarb": 24, 
            "baseHr": 116, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 28, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Phenylephrine and nitroglycerin administered.", 
            "rhythm": "St2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -1.4, 
            "stSegV5": -1.6, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You appropriately administered a bolus of esmolol. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 19
                        }, 
                        {
                            "drug": "Esmolol", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 51
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You administered an excessive bolus of esmolol. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 50
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You appropriately administered an infusion of esmolol. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Esmolol", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 49
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PHENESM", 
            "whatNextMsg": "Now add nitroglycerin.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 48, 
            "baseAbpM": 64, 
            "baseAbpS": 84, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 28, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Phenylephrine and esmolol administered.", 
            "rhythm": "St2", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -1.4, 
            "stSegV5": -1.6, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You administered appropriate dose of nitroglycerin. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 0.3
                        }, 
                        {
                            "drug": "Nitroglycerin", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 1.3
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You administered an excessive bolus of nitroglycerin. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 1.2
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You appropriately administered an infusion of nitroglycerin. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Nitroglycerin", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 180
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "NTGESM", 
            "whatNextMsg": "Now correct the severe hypotension.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 32, 
            "baseAbpM": 44, 
            "baseAbpS": 62, 
            "baseBicarb": 24, 
            "baseHr": 96, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 4.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 16, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 20, 
            "papM": 28, 
            "papS": 40, 
            "papW": 18, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Nitroglycerin and esmolol administered.", 
            "rhythm": "St3", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -1.4, 
            "stSegV5": -1.6, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You administered an appropriate bolus of phenylephrine. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 24
                        }, 
                        {
                            "drug": "Phenylephrine", 
                            "op": "LT", 
                            "type": "bDrug", 
                            "value": 201
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You administered an excessive bolus of phenylephrine. (Lost points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "bDrug", 
                            "value": 200
                        }
                    ], 
                    "points": -200
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You started a phenylephrine infusion. (+300 points)", 
                    "conditions": [
                        {
                            "drug": "Phenylephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 300
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You started a dopamine infusion. (+50 points)", 
                    "conditions": [
                        {
                            "drug": "Dopamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 50
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You started a dobutamine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Dobutamine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 2
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You started a epinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Epinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "PHENNTGESM", 
                    "comment": "You started a norepinephrine infusion. (+100 points)", 
                    "conditions": [
                        {
                            "drug": "Norepinephrine", 
                            "op": "GT", 
                            "type": "iDrug", 
                            "value": 0.1
                        }
                    ], 
                    "points": 100
                }, 
                {
                    "nextState": "VFIB", 
                    "comment": "You need to treat the ST depression with phenylephrine, esmolol and nitroglycerin. (-1000 points)", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 120
                        }
                    ], 
                    "points": -1000
                }
            ]
        }, 
        {
            "name": "PHENNTGESM", 
            "whatNextMsg": "Maintain the appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 112, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 0, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 20, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Myocardial ischemia has been corrected.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.4, 
            "stSegV5": -0.5, 
            "temperature": 36.9, 
            "trans": [
                {
                    "nextState": "FINAL", 
                    "comment": "", 
                    "conditions": [
                        {
                            "op": "GT", 
                            "type": "time", 
                            "value": 30
                        }
                    ], 
                    "points": 0
                }
            ]
        },
        {
            "name": "FINAL", 
            "whatNextMsg": "Maintain the appropriate level of anesthesia and monitor closely.", 
			"airwayStr": "nl",
            "aspirateCvpMsg": "10 mL blood was aspirated from the CVP catheter.", 
            "baseAbpD": 80, 
            "baseAbpM": 92, 
            "baseAbpS": 112, 
            "baseBicarb": 24, 
            "baseHr": 88, 
            "basePot": 4.2, 
            "breathSoundsMsg": "The breath sounds are equal bilaterally.", 
            "cardiacOutput": 5.2, 
            "contPip": 28, 
            "contPlateau": 26, 
            "cvp": 12, 
            "finalState": 1, 
            "glucose": 122, 
            "hct": 38, 
            "heartSoundsMsg": "Regular rate and rhythm, without murmurs.", 
            "hiCo2ProdFlag": false, 
            "laryTubeSuccess": 1, 
            "lidReflexMsg": "The lid reflex is absent.", 
            "lmaSuccessFlag": true, 
            "mentalStatusMsg": "The patient is unresponsive.", 
            "papD": 14, 
            "papM": 20, 
            "papS": 28, 
            "papW": 12, 
            "pulseMsg": "The pulse is present.", 
            "pupilsMsg": "The pupils are small.", 
            "rateEbl": 8, 
            "rateUo": 1.5, 
            "recordMsg": "Discuss with your instructor whether you would continue the case at this point.", 
            "rhythm": "St1", 
            "skinMsg": "The skin is warm and dry with normal capillary refill.", 
            "skipAheadHours": 0, 
            "skipAheadMsg": "", 
            "sodium": 142, 
            "sat20": 89, 
            "sat40": 91, 
            "sat100": 97, 
            "spSignal": 2, 
            "spontRr": 0, 
            "spontTv": 0, 
            "sputumAmount": 0, 
            "stSegII": -0.4, 
            "stSegV5": -0.5, 
            "temperature": 36.9 
		}
    ]
}