<?php
// File: case_management.php
include ($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
// include ($_SERVER['DOCUMENT_ROOT'] . '/api/pro_features.php');
include ($_SERVER['DOCUMENT_ROOT'] . '/api/case_data_handler.php');

function console_log($message) {
    // Escape any single or double quotes in the message
    $message = addslashes($message);

    // Print JavaScript console.log with the message
    echo "<script>console.log('PHP Log: " . $message . "');</script>";
}

/* 
function getCaseList() {
    $isPro = isProFeatureEnabled('additional_cases');
    $CaseData = getCaseData();
    
    $caseList = [];
    
    foreach ($CaseData as $id => $case) {
        $caseList[] = [
            'id' => $id,
            'title' => $case['title'],
            'isPro' => $case['isPro'] ?? false,
            'isAccessible' => $isPro || !($case['isPro'] ?? false)
        ];
    }
    
    return $caseList;
}
*/

function renderCaseSelector() {
    $caseList = getAvailableCases(isProFeatureEnabled('additional_cases'));
    $isPro = isProFeatureEnabled('additional_cases');
    $isDemo = isDemoUser();
    
    $output = '<div id="selectcase">';
    $output .= '<fieldset id="fieldsetCase">';
    $output .= '<legend id="legendCase">Case Library:</legend>';
    $output .= '<select id="caseList" name="caseList">';
    $output .= '<option value="defaultCase">Select a Case to Start</option>';
    
    foreach ($caseList as $case) {
        $disabled = '';
        $label = $case['title'];
        
        // Handle Pro cases
        if ($case['isPro'] && !$isPro) {
            $label .= ' (Pro Only4)';
            $disabled = ' disabled';
        }
        // Handle Demo restrictions separately
        else if (!$case['isPro'] && $isDemo && $case['id'] != 1) {
            $label .= ' (Upgrade4)';
            $disabled = ' disabled';
        }
        
        $output .= '<option value="' . $case['id'] . '"' . $disabled . '>' . htmlspecialchars($label) . '</option>';
    }
    
    $output .= '</select>';
    $output .= '</fieldset>';
    $output .= '</div>';
    $output .= '<img id="imgSplash" src="app/images/anesthSplash.jpg" alt="Splash Image">';
    
    return $output;
}

// Handle AJAX request for case selection
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['caseId'])) {
    header('Content-Type: application/json');
    $caseId = intval($_POST['caseId']);
    
    // Use getAvailableCases to check if case is accessible
    $availableCases = getAvailableCases(isProFeatureEnabled('additional_cases'));
    
    $isPro = isProFeatureEnabled('additional_cases');
    $isDemo = isDemoUser();
    
    // Check if case is actually accessible
    if (!$availableCases[$caseId]['isAccessible'] ||
        ($availableCases[$caseId]['isPro'] && !$isPro) || 
        ($isDemo && $caseId != 1)) {
        echo json_encode(['success' => false, 'error' => 'Case not available']);
        exit;
    }
    
    // Case is accessible, set it
    $_SESSION['current_case'] = $caseId;
    echo json_encode(['success' => true]);
    exit;
}