<?php
// settings.php
// Administration Bootstrap
chdir('../');
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
/* **************** HEADER FROM MAIN (REQUIRED FOR MENU) **************/
include($_SERVER['DOCUMENT_ROOT'] . '/menu.php');
$userDetails = menuUserDetails($_SESSION['front_user_id']);
/* ***************** END HEADER FROM MAIN *****************************/
include($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/header_logic.inc.php');

// current page variable
$current_page = 'settings';

// Only allow super admins
if ($_SESSION['user_type'] !== 'super') {
    header('Location: /admin/');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    
	if (isset($_POST['save_license'])) {
		header('Content-Type: application/json');
		
		try {
			$license_key = trim($_POST['license_key']);
			$feature = 'pass_feature';

			// First get current license if exists
			$stmt = $pdo->prepare("SELECT license_key FROM wp_features WHERE feature_name = ?");
			$stmt->execute([$feature]);
			$currentLicense = $stmt->fetch(PDO::FETCH_ASSOC);

			$ch = curl_init(LICENSE_URL);
			curl_setopt_array($ch, [
				CURLOPT_POST => true,
				CURLOPT_POSTFIELDS => http_build_query([
					'license_key' => $license_key,
					'domain' => $_SERVER['HTTP_HOST'],
					'feature' => $feature
				]),
				CURLOPT_RETURNTRANSFER => true
			]);
			$result = curl_exec($ch);
			curl_close($ch);
			
			if ($result === false) {
				throw new Exception('License verification failed');
			}

			$verification = json_decode($result, true);
			$status = ($verification && isset($verification['valid']) && $verification['valid']) ? 'active' : 'inactive';

			if ($currentLicense) {
				$stmt = $pdo->prepare("UPDATE wp_features 
									  SET previous_license_key = ?,
										  license_key = ?, 
										  status = ?, 
										  last_verified = CURRENT_TIMESTAMP 
									  WHERE feature_name = ?");
				$stmt->execute([$currentLicense['license_key'], $license_key, $status, $feature]);
			} else {
				$stmt = $pdo->prepare("INSERT INTO wp_features 
									  (feature_name, license_key, status, last_verified) 
									  VALUES (?, ?, ?, CURRENT_TIMESTAMP)");
				$stmt->execute([$feature, $license_key, $status]);
			}

			echo json_encode(['success' => true, 'status' => $status]);
			exit;

		} catch (Exception $e) {
			echo json_encode(['success' => false, 'error' => $e->getMessage()]);
			exit;
		}
	}

	if (isset($_POST['restore_license'])) {
		try {
			$feature = 'pass_feature';
			
			// Get current record with previous license
			$stmt = $pdo->prepare("SELECT license_key, previous_license_key FROM wp_features WHERE feature_name = ?");
			$stmt->execute([$feature]);
			$current = $stmt->fetch(PDO::FETCH_ASSOC);
			
			if (!$current || !$current['previous_license_key']) {
				throw new Exception('No previous license found');
			}
			
			// Verify previous license
			$ch = curl_init(LICENSE_URL);
			curl_setopt_array($ch, [
				CURLOPT_POST => true,
				CURLOPT_POSTFIELDS => http_build_query([
					'license_key' => $current['previous_license_key'],
					'domain' => $_SERVER['HTTP_HOST'],
					'feature' => $feature
				]),
				CURLOPT_RETURNTRANSFER => true
			]);
			$response = curl_exec($ch);
			curl_close($ch);
			
			$verification = json_decode($response, true);
			$status = ($verification && isset($verification['valid']) && $verification['valid']) ? 'active' : 'inactive';
			
			// Swap licenses
			$stmt = $pdo->prepare("UPDATE wp_features 
								  SET license_key = ?,
									  previous_license_key = ?,
									  status = ?,
									  last_verified = CURRENT_TIMESTAMP 
								  WHERE feature_name = ?");
			$stmt->execute([$current['previous_license_key'], $current['license_key'], $status, $feature]);
			
			echo json_encode(['success' => true]);
			exit;
			
		} catch (Exception $e) {
			echo json_encode(['success' => false, 'error' => $e->getMessage()]);
			exit;
		}
	}
    
    if (isset($_POST['restore_license'])) {
        try {
            $feature = 'pass_feature';
            
            // Get current record with previous license
            $stmt = $pdo->prepare("SELECT license_key, previous_license_key FROM wp_features WHERE feature_name = ?");
            $stmt->execute([$feature]);
            $current = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$current || !$current['previous_license_key']) {
                throw new Exception('No previous license found');
            }
            
            // Verify previous license
            $ch = curl_init(LICENSE_URL);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                'license_key' => $current['previous_license_key'],
                'domain' => $_SERVER['HTTP_HOST']
            ]));
            $response = curl_exec($ch);
            curl_close($ch);
            
            $verification = json_decode($response, true);
            $status = ($verification && isset($verification['valid']) && $verification['valid']) ? 'active' : 'inactive';
            
            // Swap licenses
            $stmt = $pdo->prepare("UPDATE wp_features 
                                  SET license_key = ?,
                                      previous_license_key = ?,
                                      status = ?,
                                      last_verified = CURRENT_TIMESTAMP 
                                  WHERE feature_name = ?");
            $stmt->execute([$current['previous_license_key'], $current['license_key'], $status, $feature]);
            
            echo json_encode(['success' => true]);
            exit;
            
        } catch (Exception $e) {
            echo json_encode(['success' => false, 'error' => $e->getMessage()]);
            exit;
        }
    }
}

// Get current license info
$stmt = $pdo->prepare("SELECT * FROM wp_features WHERE feature_name = 'pass_feature'");
$stmt->execute();
$current_license = $stmt->fetch(PDO::FETCH_ASSOC);

include($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');
?>

<div class="table-cont">
    <h2 class="overview-title">License Settings</h2>
    
    <div class="license-container">
        <div id="message-container" style="display: none;"></div>

        <form id="licenseForm">
            <div class="form-group">
                <label for="license_key">Password Feature License Key:</label>
                <input type="text" id="license_key" name="license_key" 
                       value="<?php echo htmlspecialchars($current_license['license_key'] ?? ''); ?>" 
                       required>
            </div>
            
            <div class="form-group">
                <label>Status:</label>
                <span class="status-badge <?php echo strtolower($current_license['status'] ?? 'inactive'); ?>">
                    <?php echo ucfirst($current_license['status'] ?? 'inactive'); ?>
                </span>
            </div>
            
            <?php if (isset($current_license['previous_license_key']) && $current_license['previous_license_key']): ?>
            <div class="form-group">
                <label>Previous License:</label>
                <span><?php echo htmlspecialchars($current_license['previous_license_key']); ?></span>
                <button type="button" id="restoreBtn" class="btn btn-secondary">Restore Previous License</button>
            </div>
            <?php endif; ?>
            
            <?php if (isset($current_license['last_verified']) && $current_license['last_verified']): ?>
            <div class="form-group">
                <label>Last Verified:</label>
                <span><?php echo date('Y-m-d H:i:s', strtotime($current_license['last_verified'])); ?></span>
            </div>
            <?php endif; ?>
            
            <button type="submit" name="save_license" class="btn btn-primary">Save License</button>
        </form>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#licenseForm').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: 'settings.php',
            method: 'POST',
            data: { 
                save_license: 1,
                license_key: $('#license_key').val()
            },
            dataType: 'json',
            success: function(response) {
                location.reload();
            },
            error: function() {
                $('#message-container')
                    .html('Error saving license')
                    .show();
            }
        });
    });

    $('#restoreBtn').on('click', function() {
        $.ajax({
            url: 'settings.php',
            method: 'POST',
            data: { restore_license: 1 },
            dataType: 'json',
            success: function(response) {
                location.reload();
            },
            error: function() {
                $('#message-container')
                    .html('Error restoring license')
                    .show();
            }
        });
    });
});
</script>

<style>
    .license-container {
        max-width: 600px;
        margin: 0 auto;
    }
    .form-group {
        margin-bottom: 20px;
        text-align: left;
    }
    .form-group label {
        display: block;
        margin-bottom: 5px;
    }
    .form-group input[type="text"] {
        width: 100%;
        padding: 8px;
    }
    .status-badge {
        padding: 5px 10px;
        border-radius: 3px;
        font-size: 14px;
        color: white;
        display: inline-block;
    }
    .status-badge.active {
        background-color: #4CAF50;
    }
    .status-badge.inactive {
        background-color: #f44336;
    }
    .status-badge.expired {
        background-color: #ff9800;
    }
</style>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>