<?php
// monitor.php
// Administration Bootstrap 
error_reporting(E_ALL);
ini_set('display_errors', 1);
//session_start();
chdir('../');
include($_SERVER['DOCUMENT_ROOT'] . '/includes/include_all.inc.php');
/* **************** HEADER FROM MAIN (REQUIRED FOR MENU) **************/
include($_SERVER['DOCUMENT_ROOT'] . '/menu.php');
$userDetails = menuUserDetails($_SESSION['front_user_id']);
/* ***************** END HEADER FROM MAIN *****************************/
// current page variable
$current_page = 'monitor';

include($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/header_logic.inc.php');

include($_SERVER['DOCUMENT_ROOT'] . '/admin/header.php');

?>

<center><h2>Monitor Demo</h2>
	<span>Animated monitor background with pure css beveled monitor frame.<br>I can adjust speed of animations or toggle them as needed.</span>
    <style>
        .monitor-container {
            --frame-color: #333;
            --frame-light: #444;
            --frame-dark: #222;
            --frame-darker: #242424;
            --frame-darkest: #1e1e1e;
            --frame-edge: #3a3a3a;
            --screen-color: #000;
            --screen-glow: #fff;
            --aspect-ratio: 16 / 9;
            --frame-width: 1.5vmin;
            --bevel-width: calc(var(--frame-width) / 2);
            
            width: 100%;
            height: 100%;
            aspect-ratio: var(--aspect-ratio);
            position: relative;
            background-color: var(--frame-color);
            border-radius: 0.5vmin;
            box-shadow: 0 0 2vmin rgba(0, 0, 0, 0.5);
            padding: var(--frame-width);
            box-sizing: border-box;
        }

        .monitor-frame {
            position: relative;
            width: 100%;
            height: 100%;
            background-color: var(--screen-color);
            border-radius: 0.25vmin;
            overflow: hidden;
        }

        .screen-effect {
            position: absolute;
            inset: 0;
            background: 
                radial-gradient(circle at center, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 35%, rgba(255, 255, 255, 0) 70%),
                repeating-linear-gradient(0deg, transparent 0px, transparent 1px, rgba(255, 255, 255, 0.05) 2px, rgba(255, 255, 255, 0.05) 3px);
            background-size: 100% 100%, 100% 6px;
            box-shadow: inset 0 0 50px rgba(255, 255, 255, 0.1);
            pointer-events: none;
            animation: flicker 1s infinite, roll 2s linear infinite;
        }

		.monitor-container .scanline {
			position: absolute;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%; 
			background: linear-gradient(to bottom, 
				transparent 0%,
				rgba(0, 0, 0, 0.2) 10%,
				rgba(0, 0, 0, 0.4) 50%,
				rgba(0, 0, 0, 0.2) 90%,
				transparent 100%);
			animation: scanline 5s infinite linear;
		}

        .screen-content {
            position: absolute;
            inset: var(--bevel-width);
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: "Courier New", monospace;
            font-size: 2.5vmin;
            color: var(--screen-glow);
            text-shadow: 0 0 5px var(--screen-glow);
            animation: textFlicker 1s infinite;
        }

        .bevel {
            position: absolute;
            inset: 0;
            pointer-events: none;
        }

        .bevel::before,
        .bevel::after,
        .bevel-left,
        .bevel-top,
        .bevel-corner-bl,
        .bevel-corner-br,
        .bevel-corner-tr,
        .bevel-corner-tl {
            content: '';
            position: absolute;
            background-color: var(--frame-color);
        }

        .bevel::before {
            right: var(--bevel-width);
            bottom: 0;
            left: var(--bevel-width);
            height: var(--bevel-width);
            background: linear-gradient(to top, var(--frame-light), var(--frame-color));
        }

        .bevel::after {
            right: 0;
            top: var(--bevel-width);
            bottom: var(--bevel-width);
            width: var(--bevel-width);
            background: linear-gradient(to left, var(--frame-light), var(--frame-color));
        }

        .bevel-left {
            left: 0;
            top: var(--bevel-width);
            bottom: var(--bevel-width);
            width: var(--bevel-width);
            background: linear-gradient(to right, var(--frame-darker), var(--frame-darkest));
        }

        .bevel-top {
            top: 0;
            right: var(--bevel-width);
            left: var(--bevel-width);
            height: var(--bevel-width);
            background: linear-gradient(to bottom, var(--frame-darker), var(--frame-darkest));
        }

        .bevel-corner-bl {
            left: 0;
            bottom: 0;
            width: var(--bevel-width);
            height: var(--bevel-width);
            background: 
                linear-gradient(135deg, var(--frame-darker) 49%, transparent 51%),
                linear-gradient(to top, var(--frame-light), var(--frame-color));
        }

        .bevel-corner-br {
            right: 0;
            bottom: 0;
            width: var(--bevel-width);
            height: var(--bevel-width);
            background: 
                linear-gradient(-135deg, var(--frame-light) 48%, var(--frame-edge) 48%, var(--frame-edge) 52%, transparent 52%),
                linear-gradient(to top, var(--frame-light), var(--frame-color));
        }

        .bevel-corner-tr {
            right: 0;
            top: 0;
            width: var(--bevel-width);
            height: var(--bevel-width);
            background: 
                linear-gradient(-45deg, var(--frame-light) 49%, transparent 51%),
                linear-gradient(to bottom, var(--frame-darker), var(--frame-darkest));
        }

        .bevel-corner-tl {
            left: 0;
            top: 0;
            width: var(--bevel-width);
            height: var(--bevel-width);
            background: linear-gradient(45deg, var(--frame-darker) 50%, var(--frame-darkest) 50%);
        }

        /* Light theme */
        .monitor-container.light-theme {
            --frame-color: #ccc;
            --frame-light: #ddd;
            --frame-dark: #aaa;
            --frame-darker: #bbb;
            --frame-darkest: #999;
            --frame-edge: #cacaca;
            --screen-color: #f0f0f0;
            --screen-glow: #333;
        }

        .monitor-container.light-theme .screen-effect {
            background: 
                radial-gradient(circle at center, rgba(0, 0, 0, 0.1) 0%, rgba(0, 0, 0, 0.05) 35%, rgba(0, 0, 0, 0) 70%),
                repeating-linear-gradient(0deg, transparent 0px, transparent 1px, rgba(0, 0, 0, 0.05) 2px, rgba(0, 0, 0, 0.05) 3px);
            box-shadow: inset 0 0 50px rgba(0, 0, 0, 0.1);
        }

		.monitor-container.light-theme .scanline {
			position: absolute;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%; /* Ensure the scanline covers the entire container */
			background: linear-gradient(to bottom, 
				transparent 0%,
				rgba(0, 0, 0, 0.02) 10%,
				rgba(0, 0, 0, 0.04) 50%,
				rgba(0, 0, 0, 0.02) 90%,
				transparent 100%);
			animation: scanline 5s infinite linear; /* Adjust duration for speed */
		}

        .monitor-container.light-theme .bevel-left {
            background: linear-gradient(to right, var(--frame-dark), var(--frame-color));
        }

        .monitor-container.light-theme .bevel-top {
            background: linear-gradient(to bottom, var(--frame-dark), var(--frame-color));
        }

        .monitor-container.light-theme .bevel-corner-bl {
            background: 
                linear-gradient(135deg, var(--frame-dark) 49%, transparent 51%),
                linear-gradient(to top, var(--frame-light), var(--frame-color));
        }

        .monitor-container.light-theme .bevel-corner-br {
            background: 
                linear-gradient(-135deg, var(--frame-light) 48%, var(--frame-edge) 48%, var(--frame-edge) 52%, transparent 52%),
                linear-gradient(to top, var(--frame-light), var(--frame-color));
        }

        .monitor-container.light-theme .bevel-corner-tr {
            background: 
                linear-gradient(-45deg, var(--frame-light) 49%, transparent 51%),
                linear-gradient(to bottom, var(--frame-dark), var(--frame-color));
        }

        .monitor-container.light-theme .bevel-corner-tl {
            background: 
                linear-gradient(45deg, var(--frame-dark) 49%, transparent 51%),
                linear-gradient(to bottom, var(--frame-dark), var(--frame-color));
        }

        /* Animations */
		
		/* faster version flicker ******
        @keyframes flicker {
            0% { opacity: 0.95; }
            5% { opacity: 0.85; }
            10% { opacity: 0.95; }
            15% { opacity: 0.9; }
            20% { opacity: 0.95; }
            25% { opacity: 0.85; }
            30% { opacity: 0.95; }
            35% { opacity: 0.9; }
            40% { opacity: 1; }
            45% { opacity: 0.95; }
            50% { opacity: 0.9; }
            55% { opacity: 0.95; }
            60% { opacity: 0.9; }
            65% { opacity: 0.95; }
            70% { opacity: 0.9; }
            75% { opacity: 1; }
            80% { opacity: 0.9; }
            85% { opacity: 0.95; }
            90% { opacity: 0.9; }
            95% { opacity: 0.95; }
            100% { opacity: 0.95; }
        }
		*/
		
		/* slower flicker */
		@keyframes flicker {
            0% { opacity: 0.95; }
            5% { opacity: 0.85; }
            10% { opacity: 0.95; }
            15% { opacity: 0.9; }
            20% { opacity: 0.95; }
            25% { opacity: 0.85; }
            30% { opacity: 0.95; }
            35% { opacity: 0.9; }
            40% { opacity: 1; }
            45% { opacity: 0.95; }
            50% { opacity: 0.9; }
            55% { opacity: 0.95; }
            60% { opacity: 0.9; }
            65% { opacity: 0.95; }
            70% { opacity: 0.9; }
            75% { opacity: 1; }
            80% { opacity: 0.9; }
            85% { opacity: 0.95; }
            90% { opacity: 0.9; }
            95% { opacity: 0.95; }
            100% { opacity: 0.95; }
		}

        @keyframes roll {
            0% { background-position: 0 0, 0 0; }
            100% { background-position: 0 0, 0 2px; }
        }

        @keyframes scanline {
            0% { transform: translateY(-100%); }
            100% { transform: translateY(100%); }
        }

        @keyframes textFlicker {
            0% { opacity: 1; }
            50% { opacity: 0.90; }
            100% { opacity: 1; }
        }
    </style>
</head>
<body>
    <div style="width: 80vw; height: 60vh; margin: 20px auto;">
        <div class="monitor-container">
            <div class="monitor-frame">
                <div class="screen-effect"></div>
                <div class="scanline"></div>
                <div class="bevel">
                    <div class="bevel-left"></div>
                    <div class="bevel-top"></div>
                    <div class="bevel-corner-bl"></div>
                    <div class="bevel-corner-br"></div>
                    <div class="bevel-corner-tr"></div>
                    <div class="bevel-corner-tl"></div>
                </div>
                <div class="screen-content">
                    ECG: 92		|	II: 0.2	V5 -0.3<br>
                    NBP: 140/80  |  2 min<br>
                    SpO2: 95	|	Temp: 36.9<br>
					Airway Pressure: PIP 0<br>
					Spirometer: TV 0 RR 0
                </div>
            </div>
        </div>
    </div>

    <div style="width: 80vw; height: 60vh; margin: 20px auto; margin-bottom: 150px;">
        <h2>Light Theme</h2>
        <div class="monitor-container light-theme">
            <div class="monitor-frame">
                <div class="screen-effect"></div>
                <div class="scanline"></div>
                <div class="bevel">
                    <div class="bevel-left"></div>
                    <div class="bevel-top"></div>
                    <div class="bevel-corner-bl"></div>
                    <div class="bevel-corner-br"></div>
                    <div class="bevel-corner-tr"></div>
                    <div class="bevel-corner-tl"></div>
                </div>
                <div class="screen-content">
                    ECG: 92		|	II: 0.2	V5 -0.3<br>
                    NBP: 140/80  |  2 min<br>
                    SpO2: 95	|	Temp: 36.9<br>
					Airway Pressure: PIP 0<br>
					Spirometer: TV 0 RR 0
                </div>
            </div>
        </div>
    </div>

</center>
<?php include($_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php'); ?>

</body>
</html>