<?php
// admin/inc/update-demo-user.php

function updateDemoUserPassword($userId, $newGroupId, $pdo) {
    // Get the new group's password details
    $stmt = $pdo->prepare("SELECT group_pass, group_pass_clear FROM wp_groups WHERE id = ?");
    $stmt->execute([$newGroupId]);
    $groupData = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$groupData) {
        return false;
    }

    // Update user's password to match the group
    $stmt = $pdo->prepare("UPDATE wp_users SET 
        user_pass = :group_pass,
        user_pass_clear = :group_pass_clear
        WHERE id = :user_id");

    return $stmt->execute([
        ':group_pass' => $groupData['group_pass'],
        ':group_pass_clear' => $groupData['group_pass_clear'],
        ':user_id' => $userId
    ]);
}
?>